program Upgrade;  { new upgrade for iniquity 2.00+  by: comatose }

(* this code got a little outa hand, i woulda made it more modular if
 i had known the extent of the upgrades that were going been needed.
 id like to do it now, but i simply dont have time.
                                                 comatose(idt:iniq); *)

uses
   Dos, Crt, Global, FastIO, Files, StrProc, Misc, Output;

type
   { a26r5 main bbs configuration structure - iniquity.dat, single record }
   tOldCfgRec = record
      bbsName          : String[40];   { name of bbs                         }
      bbsPhone         : String[13];   { bbs phone number "(xxx)xxx-xxxx"    }
      SysOpAlias       : String[36];   { sysop's handle                      }
      SysOpName        : String[36];   { sysop's real name                   }
      SystemPW         : String[20];   { sysop access password               }
      acsSysOp         : tACString;    { bbs sysop acs                       }
      acsCoSysOp       : tACString;    { bbs co-sysop acs                    }
      DirectWrites     : Boolean;      { use direct video writes?            }
      SnowChecking     : Boolean;      { check for cga snow?                 }
      OverlayToEMS     : Boolean;      { load overlays to ems if possible?   }
      RealNameSystem   : Boolean;      { use only real names on this bbs?    }
      ShowPwLocal      : Boolean;      { display password input locally?     }
      StatOnDefault    : Boolean;      { status bar on when user logs in?    }
      StatBarOn        : Boolean;      { is the status bar currently on?     }
      StatType         : Byte;         { 1 (sbBot) = bottom, 2 (sbTop) = top }
      StatBar          : Byte;         { current sb display (1-maxStatBar)   }
      StatLo           : Byte;         { status bar low color attribute      }
      StatTxt          : Byte;         { status bar normal color attrib      }
      StatHi           : Byte;         { status bar bright color attrib      }
      DefaultCol       : tColor;       { default bbs generic colors          }
      Address          : array[1..maxAddress] of tNetAddressRec;
      ESCtoExit        : Boolean;      { allow wfc termination w/ escape?    }
      OffhookLocal     : Boolean;      { offhook modem w/ local login?       }
      VgaEffects       : Boolean;      { use vga effects? soon to be gone..  }
      ScreenSaver      : Byte;         { scrn saver (1=none,2=blank,3=morph) }
      BlankSeconds     : Word;         { # secs before initiating scrn saver }
      DefWFCstat       : Byte;         { default wfc stats display (1-8)     }
      pathData         : String[40];   { path to iniquity's data files       }
      pathText         : String[40];   { path to text/infoform files         }
      pathMenu         : String[40];   { path to menu files                  }
      pathMsgs         : String[40];   { path to message area data files     }
      pathSwap         : String[40];   { path to swapfile directory          }
      pathDoor         : String[40];   { path to door *.bat & drop files     }
      pathProt         : String[40];   { path to external protocols          }
      pathTemp         : String[40];   { path to temporary work directory    }
      pathDnld         : String[40];   { download directory - future use     }
      pathLogs         : String[40];   { path to log file directory          }
      NoBBSlogging     : Boolean;      { disable all bbs logging?            }
      LogLineChat      : Boolean;      { log line chat mode text & users?    }
      LogSplitChat     : Boolean;      { log split-screen chat text/users?   }
      LogMicroDOS      : Boolean;      { log microdos activity?              }
      SwapInShell      : Boolean;      { swap out memory when shelling?      }
      SwapToEMS        : Boolean;      { use ems for swapping if available?  }
      ProtocolSwap     : Boolean;      { swap before executing protocols?    }
      BbsAccessPw      : String[20];   { pw needed to login to bbs (unused)  }
      NoBaudPW         : String[20];   { pw needed to login w/banned baud    }
      SysOpAutoLogin   : Boolean;      { auto-login as user #1 if local?     }
      MatrixLogin      : Boolean;      { use matrix.mnu as a prelogon menu?  }
      AskApply         : Boolean;      { offer unknown users chance to apply?}
      TimeLimitPerCall : Boolean;      { is time limit per/call? or per/day  }
      acsSystemPWLogin : tACString;    { acs to force user to enter sysop pw }
      CallsBirth       : Byte;         { # of calls before birthdate check   }
      CallsPhone       : Byte;         { # of calls before phone # check     }
      LoginTrys        : Byte;         { max login attempts before booting   }
      Origin           : array[1..maxOrigin] of String[75];
      NoChatPW         : String[20];   { pw needed to page sysop w/not avail }
      ChatPageNoise    : Boolean;      { use chat pager noise at all?        }
      maxPageTimes     : Byte;         { maximum page attempts p/call        }
      maxPageBeeps     : Byte;         { number of times to beep when paging }
      PwEchoChar       : Char;         { password echo character             }
      RemovePause      : Boolean;      { backspace over pause/cont? prompts? }
      AddLocalCalls    : Boolean;      { record local calls to bbs stats?    }
      numLastCalls     : Byte;         { # of calls to show in last callers  }
      acsPostEmail     : tACString;    { acs required to post email          }
      acsAnonymous     : tACString;    { acs needed to post anonymous msgs   }
      acsAnonAutoMsg   : tACString;    { acs needed to post an anon automsg  }
      acsUploadMessage : tACString;    { acs required to upload a msg        }
      acsAutoSigUse    : tACString;    { acs required to use autosigs        }
      AbortMandOk      : Boolean;      { allow quit reading mandatory msgs?  }
      AskPrivateMsg    : Boolean;      { prompt private msg when posting?    }
      AskPrivateReply  : Boolean;      { prompt private msg when replying?   }
      AskPostInArea    : Boolean;      { ask post in msgarea when reading?   }
      AskUploadReply   : Boolean;      { ask upload message when replying?   }
      AskUploadEmail   : Boolean;      { ask upload message in email?        }
      AskKillMsg       : Boolean;      { ask delete email msg after reply?   }
      AskKillAllMsg    : Boolean;      { ask delete all email after read?    }
      NewUserPW        : String[20];   { new user password                   }
      AliasFormat      : Byte;         { new user alias format type (1-8)    }
      DefaultPageLen   : Byte;         { default page length for new users   }
      NewExpert        : Boolean;      { default new user expert mode?       }
      NewYesNoBars     : Boolean;      { default new user yes/no bars?       }
      NewHotKeys       : Boolean;      { default new user hot keys?          }
      NewAskExpert     : Boolean;      { ask new user expert mode?           }
      NewAskYesNoBars  : Boolean;      { ask new user yes/no bars?           }
      NewAskHotKeys    : Boolean;      { ask new user hot keys?              }
      NewAskPageLen    : Boolean;      { ask new user page length?           }
      StartMenu        : String[8];    { default startup menu for new users  }
      Macro            : tMacros;      { bbs function key macros             }
      pathArch         : String[40];   { path to archiver programs           }
      ArchiverSwap     : Boolean;      { swap before executing archivers?    }
      NewPause         : Boolean;      { default new user screen pausing?    }
      NewQuote         : Boolean;      { default new user autoquote?         }
      NewAskPause      : Boolean;      { ask new user screen pausing?        }
      NewAskQuote      : Boolean;      { ask new user autoquote?             }
      AskAutoQuote     : Boolean;      { ask autoquote when replying?        }
      DefaultQuoteNum  : Boolean;      { use default quote #s w/no aquote?   }
      MaxQuoteLines    : Byte;         { # of lines to autoquote from msg    }
      iniqAsDoor       : Boolean;      { run iniquity as a door?             }
      pathAtch         : String[40];   { path to file attach directory       }
      acsAttachPublic  : tACString;    { acs needed to attach a file public  }
      acsAttachEmail   : tACString;    { acs req to attach a file in email   }
      confIgnoreMsg    : Boolean;      { ignore msg conf in mandatory scan?  }
      compMsgAreas     : Boolean;      { compress message listing area #s    }
      compFileAreas    : Boolean;      { compress file listing area #s       }
      RestoreChatTime  : Boolean;      { restore users time elapsed in chat? }
      kbPerFilePoint   : Word;         { 1 file point = ?? kb                }
      useFilePoints    : Boolean;      { use file point system on bbs?       }
      importDescs      : Boolean;      { import file descriptons from archs? }
      useDLlimit       : Boolean;      { use daily download limits?          }
      useDLkbLimit     : Boolean;      { use daily download-kb limits?       }
      bbsLocation      : String[40];   { bbs location (city, state/prov)     }
      qwkFilename      : String[8];    { qwk filename prefix                 }
      qwkWelcome       : String[12];   { qwk welcome textfile (in text dir)  }
      qwkNews          : String[12];   { qwk news textfile (in text dir)     }
      qwkGoodbye       : String[12];   { qwk goodbye textfile (in text dir)  }
      qwkLocalPath     : String[40];   { local qwk download path             }
      qwkIgnoreTime    : Boolean;      { ignore time remaining to xfer qwk?  }
      qwkStripSigs     : Boolean;      { strip autosigs when exporting msgs? }
      noDescLine       : String[50];   { "no file description" string        }
      waitConnect      : Word;         { # secs to wait for modem to answer  }
      modemReInit      : Word;         { # secs before re-initializing modem }
      lightChar        : Char;         { wavefile [lit] light character      }
      lightCharOk      : Char;         { light "ok" character                }
      lightCharFail    : Char;         { light "error" character             }
      virusScan        : String[50];   { virus scanner command               }
      virusOk          : Byte;         { scanner "ok" errorlevel             }
      maxFileAge       : Byte;         { oldest file in years to allow pass  }
      strictAge        : Boolean;      { use "strict" age file tester?       }
      delFile          : String[12];   { file list (data dir) to remove      }
      addFile          : String[12];   { file list (data dir) to add         }
      comFile          : String[12];   { file comment (data dir) to apply    }
      extMaint         : Boolean;      { external maintenence when testing?  }
      ulSearch         : Byte;         { upload search type (1-4)            }
      autoValidate     : Boolean;      { auto-validate uploaded files        }
      filePtsPer       : Word;         { file point return % w/uploads       }
      useUlDlratio     : Boolean;      { use upload/download ratio?          }
      useKbRatio       : Boolean;      { use upload/download-kb ratio?       }
      fileDesc1        : String[13];   { primary file description filename   }
      fileDesc2        : String[13];   { secondary file description name     }
      useTextLibs      : Boolean;      { use textfile libraries?             }
      pathLibs         : String[40];   { path to textfile libraries *.tfl    }
      echomailLev      : Byte;         { posted echomail exit errorlevel     }
      newConfig        : Boolean;      { use newuser configuration screen?   }
      newVerify        : Boolean;      { prompt newuser to proceed w/app?    }
      pmtYes           : String[30];   { default "(Y/n)" prompt              }
      pmtNo            : String[30];   { default "(y/N)" prompt              }
      pmtYesWord       : String[20];   { default "Yes" string                }
      pmtNoWord        : String[20];   { default "No" string                 }
      pmtYesBar        : String[30];   { default "[yes] no " bar prompt      }
      pmtNoBar         : String[30];   { default " yes [no]" bar prompt      }
      descWrap         : Boolean;      { wrap +1page descs to multi-page?    }
      chatStart        : String[5];    { chat avail start time (hh:mm)       }
      chatEnd          : String[5];    { chat avail end time (hh:mm)         }
      chatOverAcs      : tACString;    { acs needed to override availability }
      advFileBar       : Boolean;      { advance file listing bar w/ flag    }
      inactTime        : Boolean;      { use inactivity timeout?             }
      inactInChat      : Boolean;      { use inactivity timeout in chatmode? }
      inactSeconds     : Word;         { inactivity timeout seconds          }
      inactWarning     : Word;         { seconds before warning inact user   }
      ansiString       : String[75];   { "ansi codes detected" quote string  }
      pageAskEmail     : Boolean;      { ask leave email to sysop w/no page  }
      soundRestrict    : Boolean;      { restrict local sound to avail hours }
      inactLocal       : Boolean;      { inactivity timeout w/ local login?  }
      allowBlind       : Boolean;      { allow blind file uploads?           }
      nuvVotesYes      : Byte;         { nuv votes required to validate      }
      nuvVotesNo       : Byte;         { nuv votes required to delete        }
      nuvAccess        : tACString;    { acs for users to be voted on        }
      nuvVoteAccess    : tACString;    { acs needed to vote                  }
      nuvInitials      : Boolean;      { display initials beside comments?   }
      nuvUserLevel     : Char;         { nuv validated user level            }
      nuvValidation    : Boolean;      { use new user voting on bbs?         }
      MultiNode        : Boolean;      { is this a multinode bbs?            }
      pathIPLx         : String[40];   { path to ipl executables *.ipx       }
      askXferHangup    : Boolean;      { prompt for 'autologout after xfer'? }
      xferAutoHangup   : Byte;         { # of secs to wait before autohangup }
      ifNoAnsi         : Byte;         { no ansi? 1=hangup/2=ask/3=continue  }
      minBaud          : LongInt;      { minimum allowed connection baudrate }
      newUserLogin     : Boolean;      { auto-login new users from matrix?   }
      SysopPwCheck     : Boolean;      { check sysop pw on *? command use?   }
      SupportRIP       : Boolean;      { support remote imaging protocol     }
      SupportTextFX    : Boolean;      { allow textfx extended emulation?    }
      tfxFontTweaking  : Boolean;      { tweak textmode fonts to 8bit planar }
      tfxResetOnClear  : Boolean;      { reset console on non-TFX clear code }
      tfxFullReset     : Boolean;      { full video mode reset required? }
      pathNetmail      : string[40];
      acsSendNetmail   : tACString;
      TimeSlices       : Boolean;
      Reserved         : array[1..3890] of Byte;
end;

   tOldUserACflag = (
      acANSi,
      acAVATAR,
      acRIP,
      acYesNoBar,
      acDeleted,
      acExpert,
      acHotKey,
      acPause,
      acQuote
   );

   tOldUserRec = record
      Number             : Integer;
      UserName           : String[36];
      RealName           : String[36];
      Password           : String[20];
      PhoneNum           : String[13];
      BirthDate          : String[8];
      Location           : String[40];
      Address            : String[36];
      UserNote           : String[40];
      Sex                : Char;
      SL                 : Byte;
      DSL                : Byte;
      BaudRate           : LongInt;
      TotalCalls         : Word;
      curMsgArea         : Word;
      curFileArea        : Word;
      acFlag             : set of tUserACflag;
      Color              : tColor;
      LastCall           : String[8];
      PageLength         : Word;
      EmailWaiting       : Word;
      Level              : Char;
      timeToday          : Word;
      timePerDay         : Word;
      AutoSigLns         : Byte;
      AutoSig            : tAutoSig;
      confMsg            : Byte;
      confFile           : Byte;
      FirstCall          : String[8];
      StartMenu          : String[8];
      fileScan           : String[8];
      SysOpNote          : String[40];
      Posts              : Word;
      Email              : Word;
      oldUploads         : Word;
      oldDownloads       : Word;
      oldUploadKb        : Word;
      oldDownloadKb      : Word;
      CallsToday         : Word;
      Flag               : tUserFlags;
      filePts            : Word;
      postCall           : Word;
      limitDL            : Word;
      limitDLkb          : Word;
      todayDL            : Word;
      todayDLkb          : Word;
      lastQwkDate        : LongInt;
      uldlRatio          : Word;
      kbRatio            : Word;
      textLib            : Byte;
      zipCode            : String[10];
      voteYes            : Byte;
      voteNo             : Byte;
      Uploads            : LongInt;
      Downloads          : LongInt;
      UploadKb           : LongInt;
      DownloadKb         : LongInt;
      MaxTimeAllowed     : Word;
      MaxTimeBankDeposit : Word;
      MaxTimeBankWithdraw: Word;
      TimeInBank         : Word;
      TimeDepositToday   : Word;
      TimeWithdrawToday  : Word;
      MaxKBallowed       : Longint;
      MaxKbBankDeposit   : Longint;
      MaxKbBankWithdraw  : Longint;
      KbInBank           : Longint;
      KbDepositToday     : Longint;
      KbWithdrawToday    : Longint;
      Reserved           : array[1..328] of Byte;
   end;

   tOldtbbslistRec = record
      Name               : String[40];
      SysOp              : String[36];
      Phone              : String[13];
      Baud               : longint;
      Software           : String[12];
      Storage            : String[20];
      Info               : String[75];
      WhoAdded           : String[36];
   end;

  tstr  = array[1..maxstring] of string[255];
  tidx  = array[1..numstring] of Word;

  tOldFileDescLn = string[50];
  tOldFileDesc = array[1..100] of tOldFileDescLn;
  pOldFileDesc = ^tOldFileDesc;

var
   cfgF       : file of tCfgRec;
   cfg        : ^tCfgRec;
   oCfgF      : file of tOldCfgRec;
   oCfg       : ^tOldCfgRec;
   ch         : Char;
   b          : byte;
   x          : String;
   d          : String;
   n          : Word;
   z          : Word;
   oNumString : Word;
   oUsRec     : ^tOldUserRec;
   oUsRecF    : file of tOldUserRec;
   usRec      : ^tUserRec;
   usRecF     : file of tUserRec;
   oBbsRecF   : file of tOldtbbslistRec;
   bbsRecF    : file of tbbslistRec;
   oeF        : file of tOLDFileDescLn;
   eF         : file of tFileDescLn;
   faFile     : file of tFileRec;
   bbsRec     : ^tbbslistRec;
   oBbsRec    : ^toldtbbslistRec;
   strbf      : ^tstr;
   strbf2     : ^tstr;
   stridx     : ^tidx;
   SRec       : SearchRec;
   oFileDesc  : pOldFileDesc;
   fileDesc   : pFileDesc;
   aFile      : tFileRec;

begin
  if (not mParam('QUIET')) then
  begin;
   ioInitFastIO;
   ioTextMode;
   ioClrScr;
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($0F);
   ioWriteLn('iniqUpgrade v'+bbsVersion+'  (c)Copyright 1994-96 Mike Fricker, 1997-1998 iDT');
   ioTextAttr($08);
   ioWrite('-- ');
   ioTextAttr($07);
   ioWriteLn('Upgrades Iniquity v1.00a26r5 data files to v'+bbsVerLong+' compatibility');
   ioTextAttr($08);
   ioWrite(sRepeat('',80));
   ioTextAttr($07);
  end;

   {(help display)::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
   if mParam('HELP') or mParam('/?') then
   begin
      ioWriteLn('');
      ioWriteLn('  Command line Switches.');
      ioWriteLn('   force   - Forces upgrade to run unconditionally.');
      ioWriteLn('   users   - Runs user upgrade only. *');
      ioWriteLn('   config  - Runs configuration upgrade only.');
      ioWriteLn('   bbslist - Runs bbslist upgrade only. *');
      ioWriteLn('   strings - Runs string upgrade only. *');
      ioWriteLn('   extra   - Prints out extended upgrade info.');
      ioWriteLn('   path    - Asks for data path.');
      ioWriteLn('   file    - Runs the file system upgrade only');
      ioWriteLn('   help    - Displays this help menu.');
      ioWriteLn('');
      ioWriteLn('    *(must be in data directory)');
      ioWriteLn('    Example: upgrade.exe extra');
      Halt(255);
   end;
   {(end of help display):::::::::::::::::::::::::::::::::::::::::::::::::}


   {(path configuration)::::::::::::::::::::::::::::::::::::::::::::::::::}
   x := '';
   if mParam('PATH') then
    begin;
      WriteLn('Enter full path to Iniquity');
      Write(': ');
      ReadLn(d);
      writeln('');
      x := d[length(d)];
      if x <> '\' then d := d+'\';
    end;
    {(end of path configuration)::::::::::::::::::::::::::::::::::::::::::}



    {(version detection)::::::::::::::::::::::::::::::::::::::::::::::::::}
    if (not mParam('USERS')) and
       (not mParam('BBSLIST')) and
       (not mParam('STRINGS')) then
    begin;
    new(oCfg);
    Assign(oCfgF,d+fileConfig);
    {$I-}
    Reset(oCfgF);
    {$I+}
    if ioResult <> 0 then
     begin
       if (not mParam('QUIET')) then
       begin;
         ioWriteLn(fileConfig+' not found in current directory.');
         ioWriteLn('Please change to your Iniquity directory before executing this program');
       end;
       dispose(oCfg);
       Halt(255);
     end;
    Read(oCfgF,oCfg^);
    Close(oCfgF);

    new(cfg);
    Assign(cfgF,d+fileconfig);
    {$I-}
    reset(CfgF);
    {$I+}
    if ioResult <> 0 then exit;
    read(CfgF,cfg^);
    close(cfgF);
   end;
   {checks iniquity.dat for version }
   if (cfg^.upgradeVersion = 1)
    and (not mParam('FORCE'))
    and (not mParam('FILE'))
    and (not mParam('USERS'))
    and (not mParam('BBSLIST'))
    and (not mParam('STRINGS')) then
   begin;
      if (not mParam('QUIET')) then
      begin;
        ioWriteLn('This copy of Iniquity appears to be up to date.  An upgrade should not be');
        ioWriteLn('necessary.  If you wish to force an upgrade (a26r5 -> 2.00) then invoke this');
        ioWriteLn('program with the parameter "FORCE" ..');
      end;
      dispose(cfg);
      dispose(oCfg);
      Halt(255);
   end;
   {(end of version detection):::::::::::::::::::::::::::::::::::::::::::::}


   {(startup routine)::::::::::::::::::::::::::::::::::::::::::::::::::::::}
  if (not mparam('QUIET')) then
  begin;
   ioWriteLn('The following changes must be made for a successful upgrade from a26r5 to 2.00:');
   ioWriteLn('');
   ioWriteLn('  % All NEW Iniquity 2.00 system configuration options must be configured.');
   ioWriteLn('  % If you are forcing an upgrading on 2.00, all data will be set to default.');
   ioWriteLn('');
   ioWriteLn('This program can make these changes for you, automatically.');
   ioWrite('Do you wish to proceed with the upgrade? [y/n] ');
   repeat
      ch := upcase(ReadKey);
   until ch in [#27,'Y','N'];
   if ch = #27 then ch := 'N';
   if ch = 'N' then
   begin
      ioWriteLn('no');
      ioWriteLn('');
      ioWriteLn('Upgrade aborted.');
      dispose(cfg);
      dispose(ocfg);
      Halt(255);
   end;
   ioWriteLn('yes');
   ioWriteLn('');
   ioWriteLn('New Iniquity 2.00 config options will be set to Iniquity defaults.  Check the');
   ioWriteLn('WHATSNEW.iq2 history file for infomation on all new commands and options.');
   ioWriteLn('');
   ioWriteln('Upgrading Iniquity .. please wait.');
  end;
  {(end of startup routine)::::::::::::::::::::::::::::::::::::::::::::::::}


  {(configuration updater):::::::::::::::::::::::::::::::::::::::::::::::::}
  if (not mParam('USERS')) and
     (not mParam('FILE')) and
     (not mParam('BBSLIST')) and
     (not mParam('STRINGS')) then
  begin;
  { new 2.00 main bbs configuration structure - iniquity.dat, single record }
   with cfg^ do
    begin;
      bbsName          := oCfg^.bbsName;
      bbsLocation      := oCfg^.bbsLocation;
      bbsPhone         := oCfg^.bbsPhone;
      bbsAccessPw      := oCfg^.bbsAccessPw;
      bbsPhoneEuro     := False;

      {sysop and security settings}
      SysOpAlias       := oCfg^.SysOpAlias;
      SysOpName        := oCfg^.SysOpName;
      SystemPW         := oCfg^.SystemPW;
      NoBaudPW         := oCfg^.NoBaudPW;
      SysOpAutoLogin   := oCfg^.SysOpAutoLogin;
      SysopPwCheck     := oCfg^.SysopPwCheck;
      ShowPwLocal      := oCfg^.ShowPwLocal;
      ShowPwLogon      := True;
      seeuser          := False;
      PwEchoChar       := oCfg^.PwEchoChar;

      {access settings}
      acsSysOp         := oCfg^.acsSysOp;
      acsCoSysOp       := oCfg^.acsCoSysOp;
      acsPostEmail     := oCfg^.acsPostEmail;
      acsAnonymous     := oCfg^.acsAnonymous;
      acsAnonAutoMsg   := oCfg^.acsAnonAutoMsg;
      acsUploadMessage := oCfg^.acsUploadMessage;
      acsAutoSigUse    := oCfg^.acsAutoSigUse;
      acsSystemPWLogin := oCfg^.acsSystemPWLogin;
      acsAttachPublic  := oCfg^.acsAttachPublic;
      acsAttachEmail   := oCfg^.acsAttachEmail;
      acsSendNetmail   := oCfg^.acsSendNetmail;

      {stats system}
      StatOnDefault    := oCfg^.StatOnDefault;
      StatBarOn        := oCfg^.StatBarOn;
      StatType         := oCfg^.StatType;
      StatBar          := oCfg^.StatBar;
      StatLo           := oCfg^.StatLo;
      StatTxt          := oCfg^.StatTxt;
      StatHi           := oCfg^.StatHi;

      {path system}
      pathData         := oCfg^.pathData;
      pathText         := oCfg^.pathText;
      pathMenu         := oCfg^.pathMenu;
      pathMsgs         := oCfg^.pathMsgs;
      pathSwap         := oCfg^.pathSwap;
      pathDoor         := oCfg^.pathDoor;
      pathProt         := oCfg^.pathProt;
      pathTemp         := oCfg^.pathTemp;
      pathDnld         := oCfg^.pathDnld;
      pathLogs         := oCfg^.pathLogs;
      pathNetModem     := 'C:\NETMODEM\';
      pathWindows      := 'C:\WINDOWS\';
      pathArch         := oCfg^.pathArch;
      pathAtch         := oCfg^.pathAtch;
      pathLibs         := oCfg^.pathLibs;
      pathIPLx         := oCfg^.pathIPLx;
      pathNetmail      := oCfg^.pathNetmail;

      {logging system}
      NoBBSlogging     := oCfg^.NoBBSlogging;
      LogLineChat      := oCfg^.LogLineChat;
      LogSplitChat     := oCfg^.LogSplitChat;
      LogMicroDOS      := oCfg^.LogMicroDOS;

      {memory system}
      Include(Cfg^.LoadOVR, ovrLxms);
      ProtocolSwap     := oCfg^.ProtocolSwap;
      ArchiverSwap     := oCfg^.ArchiverSwap;
      SwapInShell      := oCfg^.SwapInShell;
      SwapToEMS        := oCfg^.SwapToEMS;
      SwapToMore       := 255;

      {chat system}
      NoChatPW         := oCfg^.NoChatPW;
      chatStart        := oCfg^.chatStart;
      chatEnd          := oCfg^.chatEnd;
      chatOverAcs      := oCfg^.chatOverAcs;
      chatPageNoise    := oCfg^.chatPageNoise;
      RestoreChatTime  := oCfg^.RestoreChatTime;
      pageAskEmail     := oCfg^.pageAskEmail;
      soundRestrict    := oCfg^.soundRestrict;
      maxPageTimes     := oCfg^.maxPageTimes;
      maxPageBeeps     := oCfg^.maxPageBeeps;


      {message system}
      AbortMandOk      := oCfg^.AbortMandOk;
      AskPrivateMsg    := oCfg^.AskPrivateMsg;
      AskPrivateReply  := oCfg^.AskPrivateReply;
      AskPostInArea    := oCfg^.AskPostInArea;
      AskUploadReply   := oCfg^.AskUploadReply;
      AskUploadEmail   := oCfg^.AskUploadEmail;
      AskKillMsg       := oCfg^.AskKillMsg;
      AskKillAllMsg    := oCfg^.AskKillAllMsg;
      AskAutoQuote     := oCfg^.AskAutoQuote;
      DefaultQuoteNum  := oCfg^.DefaultQuoteNum;
      confIgnoreMsg    := oCfg^.confIgnoreMsg;
      msgQuoteHeaders  := True;
      echomailLev      := oCfg^.echomailLev;
      MaxQuoteLines    := oCfg^.MaxQuoteLines;

      z := 1;
      for z := 1 to maxAddress do address[z] := oCfg^.address[z];
      z := 1;
      for z := 1 to maxOrigin do origin[z] := oCfg^.origin[z];


      {new user system}
      AskApply         := oCfg^.AskApply;
      NewExpert        := oCfg^.NewExpert;
      NewYesNoBars     := oCfg^.NewYesNoBars;
      NewHotKeys       := oCfg^.NewHotKeys;
      NewAskExpert     := oCfg^.NewAskExpert;
      NewAskYesNoBars  := oCfg^.NewAskYesNoBars;
      NewAskHotKeys    := oCfg^.NewAskHotKeys;
      NewAskPageLen    := oCfg^.NewAskPageLen;
      NewPause         := oCfg^.NewPause;
      NewQuote         := oCfg^.NewQuote;
      NewAskPause      := oCfg^.NewAskPause;
      NewAskQuote      := oCfg^.NewAskQuote;
      NewConfig        := oCfg^.NewConfig;
      NewVerify        := oCfg^.NewVerify;
      NewUserLogin     := oCfg^.NewUserLogin;
      NewUserPW        := oCfg^.NewUserPW;
      StartMenu        := oCfg^.StartMenu;

      {qwk system}
      qwkLocalPath     := oCfg^.qwkLocalPath;
      qwkWelcome       := oCfg^.qwkWelcome;
      qwkNews          := oCfg^.qwkNews;
      qwkGoodbye       := oCfg^.qwkGoodbye;
      qwkFilename      := oCfg^.qwkFilename;
      qwkIgnoreTime    := oCfg^.qwkIgnoreTime;
      qwkStripSigs     := oCfg^.qwkStripSigs;



      {file system}
      noDescLine       := oCfg^.noDescLine;
      virusScan        := oCfg^.virusScan;
      fileDesc1        := oCfg^.fileDesc1;
      fileDesc2        := oCfg^.fileDesc2;
      delFile          := oCfg^.delFile;
      addFile          := oCfg^.addFile;
      comFile          := oCfg^.comFile;
      extMaint         := oCfg^.extMaint;
      autoValidate     := oCfg^.autoValidate;
      strictAge        := oCfg^.strictAge;
      useUlDlratio     := oCfg^.useUlDlratio;
      useKbRatio       := oCfg^.useKbRatio;
      useFilePoints    := oCfg^.useFilePoints;
      importDescs      := oCfg^.importDescs;
      useDLlimit       := oCfg^.useDLlimit;
      useDLkbLimit     := oCfg^.useDLkbLimit;
      useUPLtimeRefund := True;
      allowBlind       := oCfg^.allowBlind;
      descWrap         := oCfg^.descWrap;
      advFileBar       := oCfg^.advFileBar;
      askXferHangup    := oCfg^.askXferHangup;
      ulSearch         := oCfg^.ulSearch;
      virusOk          := oCfg^.virusOk;
      maxFileAge       := oCfg^.maxFileAge;
      xferAutoHangup   := oCfg^.xferAutoHangup;
      filePtsPer       := oCfg^.filePtsPer;
      kbPerFilePoint   := oCfg^.kbPerFilePoint;

      {display promts}
      pmtYesBar        := oCfg^.pmtYesBar;
      pmtNoBar         := oCfg^.pmtNoBar;
      pmtYes           := oCfg^.pmtYes;
      pmtNo            := oCfg^.pmtNo;
      pmtYesWord       := oCfg^.pmtYesWord;
      pmtNoWord        := oCfg^.pmtNoWord;

      {inactivity system}
      inactLocal       := oCfg^.inactLocal;
      inactTime        := oCfg^.inactTime;
      inactInChat      := oCfg^.inactInChat;
      inactSeconds     := oCfg^.inactSeconds;
      inactWarning     := oCfg^.inactWarning;

      {new user voting system}
      nuvAccess        := oCfg^.nuvAccess;
      nuvVoteAccess    := oCfg^.nuvVoteAccess;
      nuvInitials      := oCfg^.nuvInitials;
      nuvValidation    := oCfg^.nuvValidation;
      nuvVotesYes      := oCfg^.nuvVotesYes;
      nuvVotesNo       := oCfg^.nuvVotesNo;
      nuvUserLevel     := oCfg^.nuvUserLevel;


      {emulation settings}
      ansiString       := oCfg^.ansiString;
      SupportRIP       := oCfg^.SupportRIP;
      SupportTextFX    := oCfg^.SupportTextFX;
      tfxFontTweaking  := oCfg^.tfxFontTweaking;
      tfxResetOnClear  := oCfg^.tfxResetOnClear;
      tfxFullReset     := oCfg^.tfxFullReset;
      IceColor         := False;
      EnableAnsiAborting:= True;
      ifNoAnsi         := oCfg^.ifNoAnsi;

      {external door system}
      z := 1;
      for z:= 8 downto 1 do
       begin;
         externalnames[z] := '';
         externalcmds[z] := '';
         externaldoors[z] := 0;
       end;
      externalChatCmd  := 'Cmd';
      externalChatName := 'ChatName';
      externalChat     := False;
      externalChatDrop := 0;


      {wfc settings}
      Macro            := oCfg^.Macro;
      TimeSlices       := oCfg^.TimeSlices;
      ESCtoExit        := oCfg^.ESCtoExit;
      OffhookLocal     := oCfg^.OffhookLocal;
      waitConnect      := oCfg^.waitConnect;
      modemReInit      := oCfg^.modemReInit;
      DefWFCstat       := oCfg^.DefWFCstat;


      {display settings}
      DefaultCol       := oCfg^.DefaultCol;
      useTextLibs      := oCfg^.useTextLibs;
      VgaEffects       := oCfg^.VgaEffects;
      DirectWrites     := oCfg^.DirectWrites;
      SnowChecking     := oCfg^.SnowChecking;
      RealNameSystem   := oCfg^.RealNameSystem;
      RemovePause      := oCfg^.RemovePause;
      lightChar        := oCfg^.lightChar;
      lightCharOk      := oCfg^.lightCharOk;
      lightCharFail    := oCfg^.lightCharFail;
      ScreenSaver      := oCfg^.ScreenSaver;
      BlankSeconds     := oCfg^.BlankSeconds;



      {logon settings}
      minBaud          := oCfg^.minBaud;
      iniqAsDoor       := oCfg^.iniqAsDoor;
      MatrixLogin      := oCfg^.MatrixLogin;
      TimeLimitPerCall := oCfg^.TimeLimitPerCall;
      RealDoorSys      := False;
      AddLocalCalls    := oCfg^.AddLocalCalls;
      CallsBirth       := oCfg^.CallsBirth;
      CallsPhone       := oCfg^.CallsPhone;
      LoginTrys        := oCfg^.LoginTrys;
      numLastCalls     := oCfg^.numLastCalls;
      AliasFormat      := oCfg^.AliasFormat;
      DefaultPageLen   := oCfg^.DefaultPageLen;


      {misc settings}
      MultiNode        := oCfg^.MultiNode;
      compMsgAreas     := oCfg^.compMsgAreas;
      compFileAreas    := oCfg^.compFileAreas;
      upgradeVersion   := 1;
      fileidLines      := 50;
      wfcScroll        := True;
    end;
   Assign(cfgF,fileconfig);
   Rewrite(cfgF);
   Write(cfgF,cfg^);
   Close(cfgF);
   dispose(oCfg);
   if (not mparam('QUIET')) then ioWriteln('Configuration updated');
   end;
  {(end of configuration updater)::::::::::::::::::::::::::::::::::::::::::}


  {(new upgrade data initalization)::::::::::::::::::::::::::::::::::::::::}
   {reads in cfg data to test for vesrion and get data path}
   if (not mParam('USERS')) and
      (not mParam('FILE')) and
      (not mParam('BBSLIST')) and
      (not mParam('STRINGS')) then
   begin;
    Assign(cfgF,d+fileconfig);
    {$I-}
    reset(CfgF);
    {$I+}
    if ioResult <> 0 then exit;
    read(CfgF,cfg^);
    close(cfgF);
   end;
 {(end if new upgrade data initalization)::::::::::::::::::::::::::::::::::}


 {(userlist updater):::::::::::::::::::::::::::::::::::::::::::::::::::::::}
 if (not mParam('CONFIG')) and
    (not mParam('FILE')) and
    (not mParam('BBSLIST')) and
    (not mParam('STRINGS')) then
  begin;

   if mParam('USERS') then Assign(oUsRecF,d+fileUsers) else
    Assign(oUsRecF,cfg^.pathData+fileUsers);
   {$I-}
   Reset(oUsRecF);
   {$I+}
   if ioResult <> 0 then
   begin
      if (not mparam('QUIET')) then
      begin;
        ioWriteLn(fileUsers+' not found.');
        ioWriteLn('Please change to your Iniquity DATA directory before executing this program');
      end;
      if (not mParam('USERS')) and (not mParam('BBSLIST')) and
       (not mParam('STRINGS')) and (not mParam('FILE')) then dispose(cfg);
      Halt(255);
   end;

   new(usRec);
   new(oUsRec);
   Assign(usRecF,'USERS.TMP');
   ReWrite(usRecF);
   Z := 0;
   while not Eof(oUsRecF) do
   begin
      Read(oUsRecF,oUsRec^);
      with usRec^ do
      begin
         Number             := oUsRec^.Number;
         UserName           := oUsRec^.UserName;
         RealName           := oUsRec^.RealName;
         Password           := oUsRec^.Password;
         PhoneNum           := oUsRec^.PhoneNum;
         BirthDate          := oUsRec^.BirthDate;
         Location           := oUsRec^.Location;
         Address            := oUsRec^.Address;
         UserNote           := oUsRec^.UserNote;
         Sex                := oUsRec^.Sex;
         SL                 := oUsRec^.SL;
         DSL                := oUsRec^.DSL;
         BaudRate           := oUsRec^.Baudrate;
         TotalCalls         := oUsRec^.TotalCalls;
         curMsgArea         := oUsRec^.curMsgArea;
         curFileArea        := oUsRec^.curFileArea;
         acFlag             := oUsRec^.acFlag;
         Color              := oUsRec^.Color;
         LastCall           := oUsRec^.LastCall;
         PageLength         := oUsRec^.PageLength;
         EmailWaiting       := oUsRec^.EmailWaiting;
         Level              := oUsRec^.Level;
         timeToday          := oUsRec^.TimeToday;
         timePerDay         := oUsRec^.TimePerDay;
         AutoSigLns         := oUsRec^.AutoSigLns;
         AutoSig            := oUsRec^.AutoSig;
         confMsg            := oUsRec^.confMsg;
         confFile           := oUsRec^.confFile;
         FirstCall          := oUsRec^.firstcall;
         StartMenu          := oUsRec^.startmenu;
         fileScan           := oUsRec^.filescan;
         SysOpNote          := oUsRec^.SysOpNote;
         Posts              := oUsRec^.Posts;
         Email              := oUsRec^.Email;
         CallsToday         := oUsRec^.CallsToday;
         Flag               := oUsRec^.Flag;
         filePts            := oUsRec^.filePts;
         postCall           := oUsRec^.postCall;
         limitDL            := oUsRec^.limitDL;
         limitDLkb          := oUsRec^.limitDLkb;
         todayDL            := oUsRec^.todayDL;
         todayDLkb          := oUsRec^.todayDLkb;
         lastQwkDate        := oUsRec^.lastQwkDate;
         uldlRatio          := oUsRec^.uldlRatio;
         kbRatio            := oUsRec^.kbRatio;
         textLib            := oUsRec^.textLib;
         zipCode            := oUsRec^.zipCode;
         voteYes            := oUsRec^.voteYes;
         voteNo             := oUsRec^.voteNo;
         Uploads            := oUsRec^.Uploads;
         Downloads          := oUsRec^.Downloads;
         UploadKb           := oUsRec^.UploadKb;
         DownloadKb         := oUsRec^.DownloadKb;
         MaxTimeAllowed     := oUsRec^.MaxTimeAllowed;
         MaxTimeBankDeposit := oUsRec^.MaxTimeBankDeposit;
         MaxTimeBankWithdraw:= oUsRec^.MaxTimeBankWithdraw;
         TimeInBank         := oUsRec^.TimeInBank;
         TimeDepositToday   := oUsRec^.TimeDepositToday;
         TimeWithdrawToday  := oUsRec^.TimeWithdrawToday;
         MaxKBallowed       := oUsRec^.MaxKBallowed;
         MaxKbBankDeposit   := oUsRec^.MaxKbBankDeposit;
         MaxKbBankWithdraw  := oUsRec^.MaxKbBankWithdraw;
         KbInBank           := oUsRec^.KbInBank;
         KbDepositToday     := oUsRec^.KbDepositToday;
         KbWithdrawToday    := oUsRec^.KbWithdrawToday;

         z := 1;
         for z := 1 to maxVotingQuestions do
          votingAnswers[z] := 0;

     if mParam('USERS') then FindFirst(d+fileFileArea,archive,SRec) else
      FindFirst(cfg^.pathData+fileFileArea,archive,SRec);
     FillChar(usRec^.FileScanArea,Sizeof(usRec^.FileScanArea),0);
     if Srec.Size > 0 then
      FillChar(usRec^.filescanarea,SRec.Size div Sizeof(tFileAreaRec),1);

    if mParam('USERS') then FindFirst(d+fileMsgArea,archive,SRec) else
      FindFirst(cfg^.pathData+fileMsgArea,archive,SRec);
     FillChar(usRec^.MsgScanArea,Sizeof(usRec^.MsgScanArea),0);
     if Srec.Size > 0 then
      FillChar(usRec^.msgscanarea,SRec.Size div Sizeof(tMsgAreaRec),1);

         FillChar(Reserved,SizeOf(Reserved),0);
         if mParam('USERS') or mParam('EXTRA') and (not mparam('QUIET'))
          then ioWriteLn(username+' Converted.');
      end;
    Write(usRecF,usRec^);
   end;
   dispose(oUsRec);
   dispose(usRec);
   Close(oUsRecF);
   Close(usRecF);
   erase(oUsRecF);

   if mParam('USERS') then rename(usRecF,fileUsers) else
    rename(usRecF,cfg^.pathData+fileUsers);
   if (not mparam('QUIET')) then ioWriteLn('User system updated');
  end;
  {(end of user system updater):::::::::::::::::::::::::::::::::::::::::::}


 {(file description updater):::::::::::::::::::::::::::::::::::::::::::::::}
 if (not mParam('CONFIG')) and
    (not mParam('USERS')) and
    (not mParam('BBSLIST')) and
    (not mParam('STRINGS')) then
  begin;
    if mParam('FILE') then Assign(oef,d+filefileDesc) else
     Assign(oeF,cfg^.pathData+filefileDesc);
     {$I-}
     Reset(oeF);
     {$I+}
     if ioresult <> 0 then
     begin;
      if (not mparam('QUIET')) then
        begin;
          ioWriteLn(filefileDesc+' not found.');
          ioWriteLn('Please change to your Iniquity DATA directory before executing this program');
        end;
     end else
     begin;
        Assign(eF,'FILEDESC.TMP');
        Rewrite(eF);
        new(oFileDesc);
        new(fileDesc);
        b := 1;
        while (not eof(oef)) do
        begin;
          read(oef,oFileDesc^[b]);
          FileDesc^[b] := oFileDesc^[b];
          write(ef,filedesc^[b]);
          inc(b);
        end;
        close(oef);
        close(ef);
        dispose(fileDesc);
        dispose(oFileDesc);
        erase(oeF);
        if mParam('FILE') then rename(ef,fileFileDesc) else
        rename(eF,cfg^.pathData+fileFileDesc);
        if (not mparam('QUIET')) then ioWriteLn('File system updated');
      end;
  end;


  {(bbslist updater)::::::::::::::::::::::::::::::::::::::::::::::::::::::}
  if (not mParam('CONFIG')) and
     (not mParam('FILE')) and
     (not mParam('USERS')) and
     (not mParam('STRINGS')) then
  begin;
   if mParam('BBSLIST') then Assign(oBbsRecF,d+fileBBSlist) else
    Assign(oBbsRecF,cfg^.pathData+fileBBSlist);
   {$I-}
   Reset(oBbsRecF);
   {$I+}
   if ioResult <> 0 then
   begin
      if (not mparam('QUIET')) then
      begin;
        ioWriteLn(fileBBSlist+' not found.');
        ioWriteLn('Please change to your Iniquity DATA directory before executing this program');
        dispose(Cfg);
        Halt(255);
      end;
   end;
   new(bbsRec);
   Assign(bbsRecF,'BBSLIST.TMP');
   Rewrite(bbsRecF);

   Z := 0;
   while not Eof(oBbsRecF) do
   begin
      Inc(Z,1);
      new(oBbsRec);
      Read(oBbsRecF,oBbsRec^);
      with BbsRec^ do
       begin
        str(oBbsRec^.baud, x);
        Name       := oBbsRec^.name;
        SysOp      := oBbsRec^.sysop;
        Phone      := oBbsRec^.phone;
        Baud       := x;
        Software   := oBbsRec^.software;
        Storage    := oBbsRec^.storage;
        Info       := oBbsRec^.info;
        WhoAdded   := oBbsRec^.whoadded;
        if mParam('BBSLIST') or mParam('EXTRA') then ioCwriteln(name+' Converted.');
       end;
       Write(bbsRecF,bbsRec^);
     end;
    dispose(oBbsRec);
    dispose(bbsrec);
    Close(oBbsRecF);
    Close(bbsRecF);
    erase(oBbsRecF);
    if mParam('BBSLIST') then rename(bbsRecF,fileBBSlist) else
     rename(bbsRecF,cfg^.pathData+fileBBSlist);
    if (not mparam('QUIET')) then ioWriteLn('Bbslist system updated');
   end;
  {(end of bbslist updater):::::::::::::::::::::::::::::::::::::::::::::::}



  {(string updater):::::::::::::::::::::::::::::::::::::::::::::::::::::::}
  if (not mParam('CONFIG')) and
     (not mParam('FILE')) and
     (not mParam('USERS')) and
     (not mParam('BBSLIST')) then
  begin;
   if mParam('STRINGS') then Assign(strFile,d+fileStrings) else
   Assign(strFile,cfg^.pathData+fileStrings);
   {$I-}
   Reset(strFile);
   {$I+}
   if ioResult <> 0 then
    begin
      if (not mparam('QUIET')) then
      begin;
        ioWriteLn(fileStrings+' not found.');
        ioWriteLn('Please change to your Iniquity DATA directory before executing this program');
        dispose(Cfg);
        Halt(255);
      end;
    end;

   new(strbf);
   new(strbf2);
   new(stridx);

   oNumString := 329;{a26r5 total number of strings}

        {string conversion table}
        { new         old }

        strIdx^[1]   := 1;
        strIdx^[2]   := 2;
        strIdx^[3]   := 3;
        strIdx^[4]   := 4;
        strIdx^[5]   := 5;
        strIdx^[6]   := 277;
        strIdx^[7]   := 278;
        strIdx^[8]   := 279;
        strIdx^[9]   := 300;
        strIdx^[10]  := 11;
        strIdx^[11]  := 12;
        strIdx^[12]  := 13;
        strIdx^[13]  := 14;
        strIdx^[14]  := 15;
        strIdx^[15]  := 7;
        strIdx^[16]  := 16;
        strIdx^[17]  := 17;
        strIdx^[18]  := 18;
        strIdx^[19]  := 19;
        strIdx^[20]  := 20;
        strIdx^[21]  := 21;
        strIdx^[22]  := 22;
        strIdx^[23]  := 101;
        strIdx^[24]  := 102;
        strIdx^[25]  := 103;
        strIdx^[26]  := 104;
        strIdx^[27]  := 105;
        strIdx^[28]  := 106;
        strIdx^[29]  := 326;
        strIdx^[30]  := 23;
        strIdx^[31]  := 24;
        strIdx^[32]  := 25;
        strIdx^[33]  := 26;
        strIdx^[34]  := 27;
        strIdx^[35]  := 28;
        strIdx^[36]  := 29;
        strIdx^[37]  := 30;
        strIdx^[38]  := 31;
        strIdx^[39]  := 32;
        strIdx^[40]  := 33;
        strIdx^[41]  := 34;
        strIdx^[42]  := 35;
        strIdx^[43]  := 36;
        strIdx^[44]  := 37;
        strIdx^[45]  := 38;
        strIdx^[46]  := 39;
        strIdx^[47]  := 40;
        strIdx^[48]  := 41;
        strIdx^[49]  := 42;
        strIdx^[50]  := 43;
        strIdx^[51]  := 44;
        strIdx^[52]  := 45;
        strIdx^[53]  := 92;
        strIdx^[54]  := 108;
        strIdx^[55]  := 144;
        strIdx^[56]  := 145;
        strIdx^[57]  := 232;
        strIdx^[58]  := 233;
        strIdx^[59]  := 234;
        strIdx^[60]  := 235;
        strIdx^[61]  := 46;
        strIdx^[62]  := 47;
        strIdx^[63]  := 110;
        strIdx^[64]  := 111;
        strIdx^[65]  := 112;
        strIdx^[66]  := 113;
        strIdx^[67]  := 243;
        strIdx^[68]  := 244;
        strIdx^[69]  := 245;
        strIdx^[70]  := 246;
        strIdx^[71]  := 248;
        strIdx^[72]  := 249;
        strIdx^[73]  := 50;
        strIdx^[74]  := 51;
        strIdx^[75]  := 52;
        strIdx^[76]  := 53;
        strIdx^[77]  := 329;
        strIdx^[78]  := 54;
        strIdx^[79]  := 55;
        strIdx^[80]  := 56;
        strIdx^[81]  := 57;
        strIdx^[82]  := 343;{strMsgAskSelectScan}
        strIdx^[83]  := 344;{strMsgTogglescanTrue}
        strIdx^[84]  := 345;{strMsgTogglescanFalse}
        strIdx^[85]  := 58;
        strIdx^[86]  := 59;
        strIdx^[87]  := 60;
        strIdx^[88]  := 61;
        strIdx^[89]  := 62;
        strIdx^[90]  := 63;
        strIdx^[91]  := 64;
        strIdx^[92]  := 65;
        strIdx^[93]  := 66;
        strIdx^[94]  := 67;
        strIdx^[95]  := 68;
        strIdx^[96]  := 69;
        strIdx^[97]  := 70;
        strIdx^[98]  := 71;
        strIdx^[99]  := 72;
        strIdx^[100] := 73;
        strIdx^[101] := 74;
        strIdx^[102] := 75;
        strIdx^[103] := 77;
        strIdx^[104] := 89;
        strIdx^[105] := 109;
        strIdx^[106] := 115;
        strIdx^[107] := 116;
        strIdx^[108] := 118;
        strIdx^[109] := 119;
        strIdx^[110] := 121;
        strIdx^[111] := 128;
        strIdx^[112] := 132;
        strIdx^[113] := 146;
        strIdx^[114] := 175;
        strIdx^[115] := 228;
        strIdx^[116] := 229;
        strIdx^[117] := 282;
        strIdx^[118] := 327; {strMsgCopyAskDest}
        strIdx^[119] := 328; {strMsgMoveAskDest}
        strIdx^[120] := 355; {strMsgQuoteHeader}
        strIdx^[121] := 356; {strMsgQuoteFooter}
        strIdx^[122] := 325; {strdidyoumeanUser}
        strIdx^[123] := 78;
        strIdx^[124] := 79;
        strIdx^[125] := 80;
        strIdx^[126] := 81;
        strIdx^[127] := 82;
        strIdx^[128] := 83;
        strIdx^[129] := 84;
        strIdx^[130] := 85;
        strIdx^[131] := 86;
        strIdx^[132] := 87;
        strIdx^[133] := 90;
        strIdx^[134] := 91;
        strIdx^[135] := 93;
        strIdx^[136] := 94;
        strIdx^[137] := 95;
        strIdx^[138] := 357;{strBBSisIniquity}
        strIdx^[139] := 330;{strTelnetBbs}
        strIdx^[140] := 331;{strBBSaskAddress}
        strIdx^[141] := 96;
        strIdx^[142] := 97;
        strIdx^[143] := 98;
        strIdx^[144] := 99;
        strIdx^[145] := 100;
        strIdx^[146] := 107;
        strIdx^[147] := 114;
        strIdx^[148] := 129;
        strIdx^[149] := 130;
        strIdx^[150] := 301;
        strIdx^[151] := 302;
        strIdx^[152] := 303;
        strIdx^[153] := 122;
        strIdx^[154] := 123;
        strIdx^[155] := 124;
        strIdx^[156] := 125;
        strIdx^[157] := 126;
        strIdx^[158] := 127;
        strIdx^[159] := 140;
        strIdx^[160] := 141;
        strIdx^[161] := 142;
        strIdx^[162] := 143;
        strIdx^[163] := 147;
        strIdx^[164] := 148;
        strIdx^[165] := 149;
        strIdx^[166] := 150;
        strIdx^[167] := 151;
        strIdx^[168] := 152;
        strIdx^[169] := 153;
        strIdx^[170] := 154;
        strIdx^[171] := 155;
        strIdx^[172] := 156;
        strIdx^[173] := 157;
        strIdx^[174] := 158;
        strIdx^[175] := 159;
        strIdx^[176] := 160;
        strIdx^[177] := 161;
        strIdx^[178] := 162;
        strIdx^[179] := 163;
        strIdx^[180] := 164;
        strIdx^[181] := 165;
        strIdx^[182] := 166;
        strIdx^[183] := 167;
        strIdx^[184] := 132;
        strIdx^[185] := 133;
        strIdx^[186] := 346;{strFaAskSelectScan}
        strIdx^[187] := 347;{strFaToggledScanTrue}
        strIdx^[188] := 348;{strFaToggledScanFalse}
        strIdx^[189] := 134;
        strIdx^[190] := 135;
        strIdx^[191] := 136;
        strIdx^[192] := 137;
        strIdx^[193] := 138;
        strIdx^[194] := 176;
        strIdx^[195] := 177;
        strIdx^[196] := 180;
        strIdx^[197] := 181;
        strIdx^[198] := 182;
        strIdx^[199] := 183;
        strIdx^[200] := 184;
        strIdx^[201] := 185;
        strIdx^[202] := 186;
        strIdx^[203] := 358; {strFaBatchCDROM}
        strIdx^[204] := 187;
        strIdx^[205] := 188;
        strIdx^[206] := 189;
        strIdx^[207] := 190;
        strIdx^[208] := 191;
        strIdx^[209] := 192;
        strIdx^[210] := 193;
        strIdx^[211] := 194;
        strIdx^[212] := 195;
        strIdx^[213] := 196;
        strIdx^[214] := 215;
        strIdx^[215] := 216;
        strIdx^[216] := 217;
        strIdx^[217] := 218;
        strIdx^[218] := 219;
        strIdx^[219] := 220;
        strIdx^[220] := 221;
        strIdx^[221] := 222;
        strIdx^[222] := 223;
        strIdx^[223] := 224;
        strIdx^[224] := 225;
        strIdx^[225] := 226;
        strIdx^[226] := 227;
        strIdx^[227] := 250;
        strIdx^[228] := 251;
        strIdx^[229] := 252;
        strIdx^[230] := 253;
        strIdx^[231] := 254;
        strIdx^[232] := 255;
        strIdx^[233] := 256;
        strIdx^[234] := 265;
        strIdx^[235] := 268;
        strIdx^[236] := 269;
        strIdx^[237] := 270;
        strIdx^[238] := 271;
        strIdx^[239] := 272;
        strIdx^[240] := 273;
        strIdx^[241] := 275;
        strIdx^[242] := 276;
        strIdx^[243] := 283;
        strIdx^[244] := 284;
        strIdx^[245] := 285;
        strIdx^[246] := 286;
        strIdx^[247] := 168;
        strIdx^[248] := 169;
        strIdx^[249] := 170;
        strIdx^[250] := 171;
        strIdx^[251] := 172;
        strIdx^[252] := 173;
        strIdx^[253] := 174;
        strIdx^[254] := 178;
        strIdx^[255] := 179;
        strIdx^[256] := 197;
        strIdx^[257] := 198;
        strIdx^[258] := 199;
        strIdx^[259] := 200;
        strIdx^[260] := 201;
        strIdx^[261] := 202;
        strIdx^[262] := 203;
        strIdx^[263] := 204;
        strIdx^[264] := 205;
        strIdx^[265] := 206;
        strIdx^[266] := 207;
        strIdx^[267] := 208;
        strIdx^[268] := 209;
        strIdx^[269] := 210;
        strIdx^[270] := 211;
        strIdx^[271] := 212;
        strIdx^[272] := 213;
        strIdx^[273] := 214;
        strIdx^[274] := 359;{strFaTestBadZip}
        strIdx^[275] := 236;
        strIdx^[276] := 237;
        strIdx^[277] := 238;
        strIdx^[278] := 239;
        strIdx^[279] := 240;
        strIdx^[280] := 241;
        strIdx^[281] := 242;
        strIdx^[282] := 257;
        strIdx^[283] := 258;
        strIdx^[284] := 259;
        strIdx^[285] := 260;
        strIdx^[286] := 261;
        strIdx^[287] := 262;
        strIdx^[288] := 263;
        strIdx^[289] := 264;
        strIdx^[290] := 266;
        strIdx^[291] := 287;
        strIdx^[292] := 288;
        strIdx^[293] := 289;
        strIdx^[294] := 290;
        strIdx^[295] := 349; {strMNCmsgSent}
        strIdx^[296] := 350; {strMNCusrnotfo}
        strIdx^[297] := 351; {strMNCyoumsg}
        strIdx^[298] := 352; {strMNCtheymsg}
        strIdx^[299] := 353; {strMNCmsgnotsent}
        strIdx^[300] := 354; {strMNCaction}
        strIdx^[301] := 291;
        strIdx^[302] := 292;
        strIdx^[303] := 293;
        strIdx^[304] := 294;
        strIdx^[305] := 295;
        strIdx^[306] := 296;
        strIdx^[307] := 297;
        strIdx^[308] := 298;
        strIdx^[309] := 267;
        strIdx^[310] := 304;
        strIdx^[311] := 305;
        strIdx^[312] := 306;
        strIdx^[313] := 307;
        strIdx^[314] := 308;
        strIdx^[315] := 309;
        strIdx^[316] := 310;
        strIdx^[317] := 311;
        strIdx^[318] := 312;
        strIdx^[319] := 313;
        strIdx^[320] := 314;
        strIdx^[321] := 315;
        strIdx^[322] := 316;
        strIdx^[323] := 317;
        strIdx^[324] := 318;
        strIdx^[325] := 324;
        strIdx^[326] := 319;
        strIdx^[327] := 320;
        strIdx^[328] := 321;
        strIdx^[329] := 322;
        strIdx^[330] := 323;
        strIdx^[331] := 332;{strvoteenterans}
        strIdx^[332] := 333;{strvoteaskallowwers}
        strIdx^[333] := 334;{strvoteaskok}
        strIdx^[334] := 335;{strvotetoomuchqnewans}
        strIdx^[335] := 336;{strvotepressatouestions}
        strIdx^[336] := 337;{strvoteaskviewraddanswer}
        strIdx^[337] := 338;{strvotenoquestiesults}
        strIdx^[338] := 339;{strvotealreadyvons}
        strIdx^[339] := 340;{strvoteaskchangoted}
        strIdx^[340] := 341;{strvotedelete}
        strIdx^[341] := 230;
        strIdx^[342] := 231;
        strIdx^[343] := 76;
        strIdx^[344] := 88;
        strIdx^[345] := 48;
        strIdx^[346] := 49;
        strIdx^[347] := 342;{strinusereditor}
        strIdx^[348] := 6;
        strIdx^[349] := 8;
        strIdx^[350] := 9;
        strIdx^[351] := 10;
        strIdx^[352] := 117;
        strIdx^[353] := 139;
        strIdx^[354] := 247;
        strIdx^[355] := 274;
        strIdx^[356] := 280;
        strIdx^[357] := 281;
        strIdx^[358] := 299;
        strIdx^[359] := 120;

  {loads strings.dat into memory using dual arrays}
  n := 1;
  z := 1;
  for n := 1 to oNumString*2 do
   begin;
    if n <= maxstring*2 then
     begin;
      seek(strFile,n-1);
      blockRead(strFile,strBf^[z],1);
      inc(z);
     end else
     begin;
      if z = maxstring+1 then  z := 1;
      Seek(strFile,n-1);
      BlockRead(strFile,strBf2^[z],1);
      inc(z);
     end;
    inc(n,1);
  end;


     z := z-1;
     { sets new strings to there defaults }
{330} strBf2^[z+1] := '|15|11-|03- |11I|03s |11t|03h|08is |11a t|03e|08lnet |11b|03o|08ard? |15';
{331} strBf2^[z+2] := '|15T|07e|08lnet |15a|07d|08dress: |15';
{332} strBf2^[z+3] := '|10Enter your answers - blank answer to stop adding answers';
{333} strBf2^[z+4] := '|11Allow other users to add answers? ';
{334} strBf2^[z+5] := '|10Add this question? ';
{335} strBf2^[z+6] := '|12You can''t add more voting questions';
{336} strBf2^[z+7] := '|15Press ''A'' to add an answer';
{337} strBf2^[z+8] := '|14View results? ';
{338} strBf2^[z+9] := '|12No voting questions.';
{339} strBf2^[z+10] := '|12You already answered to that question';
{340} strBf2^[z+11] := '|12You already voted to that question. Change youur vote?';
{341} strBf2^[z+12] := '|15Delete which question? (1-%s1)';
{342} strBf2^[z+13] := '|12Sysop Editing User Record';
{343} strBf2^[z+14] := 'Enter area number to toggle(0 to quit):';
{344} strBf2^[z+15] := 'Area changed will be scanned';
{345} strBf2^[z+16] := 'Area won''t be scanned';
{346} strBf2^[z+17] := 'Enter area number to toggle(0 to quit):';
{347} strBf2^[z+18] := 'Area changed will be scanned';
{348} strBf2^[z+19] := 'Area won''t be scanned';
{349} strBf2^[z+20] := '|15message sent';
{350} strBf2^[z+21] := '|15user not found';
{351} strBf2^[z+22] := '|14*%s1* %s2';
{352} strBf2^[z+23] := '|14-%s1- %s2';
{353} strBf2^[z+24] := '|15user not found';
{354} strBf2^[z+25] := '|04%s1 %s2';
{355} strBf2^[z+26] := '|15%S1 |07said this..';
{356} strBf2^[z+27] := '|15%S1 |07stopped talking';
{357} strBf2^[z+28] := '|15SWEET@!';
{358} strBf2^[z+29] := '|09Copying files from CD-ROM';
{359} strBf2^[z+30] := '|04File is corrupted!';

     strBf2^[255] := '';

   {writes old strings in new data structure format}
   n := 1;
   z := 1;
   for n := 1 to numstring*2 do
     begin
       if strIdx^[z] <= maxstring then
        begin;
         seek(strFile,n-1);
         blockWrite(strFile,strBf^[strIdx^[z]],1);
         x := strbf^[stridx^[z]];
         inc(z);
        end else
        begin;
         seek(strFile,n-1);
         blockWrite(strFile,strBf2^[strIdx^[z]-255],1);
         x := strbf2^[stridx^[z]-255];
         inc(z);
        end;
        if mParam('STRINGS') or mParam('EXTRA') and (not mParam('QUIET'))
         then ioCwriteLn(x);
        inc(n,1);
      end;
   x := '';
   {if the string total is even it needs a blank footer}
{   if (not odd(numstring)) then
    begin;
 }     seek(strfile,filesize(strfile));
      blockwrite(strfile,strBf2^[255],1);
  {  end;
   }
  dispose(strbf);
  dispose(strbf2);
  dispose(stridx);
  close(strFile);
  ioCwrite('|07');
  if (not mparam('QUIET')) then ioWriteLn('String system updated');
end;
 {(end of string update)::::::::::::::::::::::::::::::::::::::::::::::::::}


 {(exit routine)::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
  if (not mparam('QUIET')) then
  begin;
   if (not mParam('USERS')) and (not mParam('BBSLIST')) and
      (not mParam('STRINGS')) and (not mParam('FILE')) then
    begin;
      ioCwriteLn('|15Upgrade of '+cfg^.bbsName+' successful.');
      dispose(cfg);
    end else ioCwriteLn('|15Upgrade of successful.');
   ioCwriteLn('|07');
   ioWriteLn('New configurable strings will be filled in with defaults upon loading');
   ioWriteLn('Welcome to Iniquity 2.00');
  end;
end.




