{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,N-,E+}

unit Voting;

interface

uses Global;

procedure voteAddQuestion;
function voteAddAnswer(var VotingRec : tVotingRec) : boolean;
function voteListQuestions : boolean;
procedure voteListAnswers(Num : Byte; AddAnswer : Boolean);
procedure voteAnswer(Num : Byte);
procedure voteResults(Num : Byte);
procedure voteDeleteQuestion(Num : Byte);
procedure voteAllUnvoted;

implementation

uses Output, Input, StrProc, Misc, ShowFile, Logs; {added loging -comatose}

var f : file of tVotingRec;
    NumQuestions : byte;

procedure vListAnswers(Num : byte; TopFile,MidFile,BotFile : string; AddAnswer : Boolean);
var i         : integer;
    Ans       : boolean;
    Question  : tVotingRec;
    Ok        : boolean;
    PercentVoted : integer;

begin;
  NumQuestions := filesize(f);
  seek(f,Num-1);
  read(f,Question);
  PausePos := 1;

  Ans := (sfGetTextFile(TopFile,ftVotingAnswers) <> '');
  if Ans then
   begin;
   sfStr[1] := Question.Question;
   sfShowTextFile(TopFile,ftVotingAnswersTop);
   sfGotoPos(1);
   sfLoadRepeat(MidFile);
   end else oStrLn('|U1'+Question.Question);

  for i := 1 to Question.NumAnswers do
   begin;
   if Question.NumVoted = 0 then
    PercentVoted := 0 else
    PercentVoted := (Question.Answers[i].NumVoted * 100) div Question.NumVoted;
    if Ans then
     begin;
     sfStr[1] := St(i);
     sfStr[2] := Question.Answers[i].Description;
     sfStr[3] := St(Question.Answers[i].NumVoted);
     sfStr[4] := St(PercentVoted) + '%';
     sfShowRepeat(ftVotingAnswers);
     end else
       oWriteLn(' '+Resize(St(i),5)+
                ' '+Resize(Question.Answers[i].Description,65)+
                ' - '+St(PercentVoted) + '%');
   if oWhereX <> 1 then oDnLn(1);
   oUpPause(1);
   end;
   PausePos := 0;
   if AddAnswer then
     oStringLn(strVotePressAToAddAnswer);

   if Ans then sfKillRepeat;
   if Ans then sfShowTextFile(BotFile,ftNormal);
end;

procedure voteEnterAnswer(var AnswerRec : tVotingAnswerRec);
var i : integer;
begin;
oStringLn(strVoteAddChoice);
AnswerRec.Description := iReadString('',inNormal,chNormal,'',65);
AnswerRec.NumVoted := 0;
AnswerRec.MadeBy   := User^.UserName;
end;

procedure voteAddQuestion;
var Question     : string[65];
    Answers      : array[1..maxVotingAnswers] of tVotingAnswerRec;
    i            : integer;
    VotingRec    : tVotingRec;
    NumQuestions : byte;
    Ok           : boolean;
    U            : tUserRec;
    uf           : file of tUserRec;

begin;
Ok := true;
fillchar(Question,sizeof(Question),0);
assign(f,cfg^.pathData+fileVoting);
{$I-}
reset(f);
{$I+}
if (ioResult <> 0) then
 rewrite(f);

NumQuestions := fileSize(f);

if (NumQuestions >= maxVotingQuestions) then
 begin;
   close(f);
   logWrite('tried to add voting question, to many already');
   oStringLn(strVoteTooMuchQuestions);
   Ok := false;
 end;

if Ok then
 begin;
  oStringLn(strVoteEnterQuestion);
  Question := iReadString('',inNormal,chNormal,'',65);
  if Question = '' then
   Ok := false;

  if Ok then
   begin;
    oStringLn(strVoteEnterAnswers);
    i := 0;
    VotingRec.NumAnswers := 0;
    repeat
      inc(i,1);
      voteEnterAnswer(Answers[i]);
      if (Answers[i].Description <> '') then inc(VotingRec.NumAnswers,1);
       oDnLn(1);
    until (i >= MaxVotingAnswers) or (Answers[i].Description = '') or Hangup;

    oString(strVoteAskAllowNewAns);

    if iYesNo(true,true) then
     VotingRec.AddAnswerACS := '' else
     VotingRec.AddAnswerACS := Cfg^.acsCoSysop;

    oString(strVoteAskOk);
    if iYesNo(true,true) then
     begin;
       inc(NumQuestions,1);
       VotingRec.Question := Question;
       VotingRec.MadeBy  := User^.UserName;
       for i := 1 to maxVotingAnswers do
        VotingRec.Answers[i] := Answers[i];
       VotingRec.NumVoted := 0;
       seek(f,NumQuestions-1);
       write(f,VotingRec);
       logWrite('added voting question- '+question);
     end;
    oDnLn(1);
   end;
  close(f);
 end;

if Ok then
 begin;
 User^.VotingAnswers[NumQuestions] := 0;

 assign(uf,Cfg^.pathData+fileUsers);
 {$I-}
 reset(uf);
 {$I+}
 if ioResult <> 0 then Exit;
 for i := 1 to fileSize(uf) do
  begin;
  seek(uf,i-1);
  read(uf,U);
  U.VotingAnswers[NumQuestions] := 0;
   seek(uf,i-1);
  write(uf,U);
  end;
 close(uf);
 end;
end;

function voteAddAnswer(var VotingRec : tVotingRec) : boolean;
var Ok : boolean;
begin;
Ok := true;
voteAddAnswer := true;

if Ok then
 begin;
  fillchar(VotingRec.Answers[VotingRec.NumAnswers + 1],sizeof(VotingRec.Answers[1]),0);
  voteEnterAnswer(VotingRec.Answers[VotingRec.NumAnswers + 1]);
  if (VotingRec.Answers[VotingRec.NumAnswers + 1].Description <> '') then inc(VotingRec.NumAnswers,1)
   else voteAddAnswer := false;
  oDnLn(1);
 end else voteAddAnswer := false;
end;

function voteListQuestions : boolean;
var Ans      : boolean;
    i        : integer;
    Question : tVotingRec;
    Ok       : boolean;
begin;
NumQuestions := 0;
Ok := true;
voteListQuestions := true;
assign(f,cfg^.pathData+fileVoting);
{$I-}
reset(f);
{$I+}
if (ioResult <> 0) then
 begin;
 oStringLn(strVoteNoQuestions);
 voteListQuestions := false;
 Ok := false;
 end;
if Ok then if (filesize(f) = 0) then
 begin;
 oStringLn(strVoteNoQuestions);
 voteListQuestions := false;
 close(f);
 Ok := false;
 end;

if Ok then
 begin;
  seek(f,0); i := 1;
  Ans := (sfGetTextFile(txVoteQuestMid,ftVotingQuestions) <> '');
  if Ans then
   begin;
    sfShowTextFile(txVoteQuestTop,ftTopLine);
    sfGotoPos(1);
    sfLoadRepeat(txVoteQuestMid);
   end;

  NumQuestions := filesize(f);
  PausePos := 1;

  while not eof(f) do
   begin;
   read(f,Question);
    if Ans then
     begin;
     sfStr[1] := St(i);
     sfStr[2] := Question.Question;
     sfShowRepeat(ftVotingQuestions);
     end else
       oWriteLn(' '+Resize(St(i)+'.',3)+
                ' '+Resize(Question.Question,65));
   if oWhereX <> 1 then oDnLn(1);
   oUpPause(1);
   inc(i,1);
   end;
   PausePos := 0;
   if Ans then sfKillRepeat;
   if Ans then sfShowTextFile(txVoteQuestBot,ftNormal);
  logWrite('viewed voting topics');
  close(f);
 end;
end;

procedure voteListAnswers(Num : Byte;AddAnswer : boolean);
begin;
 vListAnswers(Num,txVoteAnsTop,txVoteAnsMid,txVoteAnsBot,AddAnswer);
end;

procedure voteResults(Num : Byte);
var Ok : boolean;
    QuestionNum : byte;
begin;
Ok := true;

if (Num = 0) then
 begin;
   voteListQuestions;
   if (NumQuestions = 0) then
    Ok := false;
   if Ok then
    begin;
     oString(strVoteSelectQuestion);
     QuestionNum := StrToInt(iReadString('',inUpper,chNumeric,'',2));
     if (QuestionNum < 1) or (QuestionNum > NumQuestions) then
      Ok := false;
    end;
 end else QuestionNum := Num;

if Ok then
 begin;
  Ok := true;
  assign(f,cfg^.pathData+fileVoting);
  {$I-}
  reset(f);
  {$I+}
  if (ioResult <> 0) then
   Ok := false;

  if Ok then if (fileSize(f) = 0) or (QuestionNum > fileSize(f)) then
   begin;
   close(f);
   Ok := false;
   end;

   if Ok then
   begin;
    vListAnswers(QuestionNum,txVoteResultTop,txVoteResultMid,txVoteResultBot, False);
    oPromptKey;
    close(f);
   end;
 end;
end;

procedure voteAnswer(Num : Byte);
var QuestionNum : byte;
    Question    : tVotingRec;
    AddAnswer   : boolean;
    s           : string;
    AnswerNum   : byte;
    Ok          : boolean;
    ChangeVote  : boolean;
    InChar      : tInChar;
begin;
ChangeVote := false;
Ok := true;
if (Num = 0) then
 begin;
   voteListQuestions;
   if (NumQuestions = 0) then
    Ok := false;
   if Ok then
    begin;
     oString(strVoteSelectQuestion);
     QuestionNum := StrToInt(iReadString('',inUpper,chNumeric,'',2));
     if (QuestionNum < 1) or (QuestionNum > NumQuestions) then
      Ok := false;
    end;
 end else QuestionNum := Num;

if Ok and (User^.VotingAnswers[QuestionNum] > 0) then
 begin;
 if {acsOk(Cfg^.acsChangeVote)} true then
  begin;
   oString(strVoteAskChangeVote);
   if iYesNo(false,true) then
    ChangeVote := true else
    Ok := false;
  end else
   begin;
    oStringLn(strVoteAlreadyVoted);
    Ok := false;
   end;
 end;

if Ok then
 begin;
  assign(f,cfg^.pathData+fileVoting);
  {$I-}
  reset(f);
  {$I+}
  if (ioResult <> 0) then
   begin;
    oStringLn(strVoteNoQuestions);
    Ok := false;
   end;
  if Ok then if (fileSize(f) = 0) or (QuestionNum > fileSize(f)) then
   begin;
   if fileSize(f) = 0 then
     oStringLn(strVoteNoQuestions);
   close(f);
   Ok := false;
   end;

  if Ok then
   begin;
    seek(f,QuestionNum-1);
    read(f,Question);
    AddAnswer := (Question.NumAnswers < MaxVotingAnswers) and acsOk(Question.AddAnswerACS);
    voteListAnswers(QuestionNum,AddAnswer);

    oString(strVoteSelectAnswer);

    InChar := chNumeric;

    if AddAnswer then
     InChar := InChar + ['A'];

    s := iReadString('',inUpper,InChar,'',2);

    if s = 'A' then
     begin;
     if voteAddAnswer(Question) then
      AnswerNum := Question.NumAnswers else
      AnswerNum := 0;
     end else
      if StrToInt(s) in [1..Question.NumAnswers] then
       AnswerNum := StrToInt(s) else
       AnswerNum := 0;

    if (AnswerNum <> 0) then
     begin;
      if ChangeVote then
       begin;
         dec(Question.Answers[User^.VotingAnswers[QuestionNum]].NumVoted,1);
         dec(Question.NumVoted,1);
       end;
      User^.VotingAnswers[QuestionNum] := AnswerNum;
      inc(Question.Answers[AnswerNum].NumVoted,1);
      inc(Question.NumVoted,1);
      seek(f,QuestionNum-1);
      write(f,Question);
     end;
    close(f);

    oString(strVoteAskViewResults);
    if iYesNo(true,true) then
     voteResults(QuestionNum);
   end;
 end;
end;

procedure voteDeleteQuestion(Num : Byte);
var QuestionNum : Byte;
    U           : tUserRec;
    uf          : file of tUserRec;
    i           : integer;
    VotingRec   : tVotingRec;
    Ok          : boolean;
    N           : word;  {added comatose}

begin;
Ok := true;
if (Num = 0) then
 begin;
   if voteListQuestions then
    begin;
      N := NumQuestions;  {i modded this to use a string with %S1 -coma}
      if N = 0 then exit; { configurability baby!@! =D }
      oStr(strCode(mStr(strVoteDelete),1,st(N)));
      QuestionNum := StrToInt(iReadString('',inUpper,chNumeric,'',2));
    end;
 end else
  QuestionNum := Num;

assign(f,Cfg^.pathData+fileVoting);
{$I-}
reset(f);
{$I+}
if (ioResult <> 0) then Exit;

NumQuestions := fileSize(f);
if (NumQuestions = 0) then
 begin;
  close(f);
  Ok := false;
 end;

if Ok and (QuestionNum >= 1) and (QuestionNum <= NumQuestions) then
 begin;
 if QuestionNum < NumQuestions then
  for i := QuestionNum + 1 to NumQuestions do
   begin;
    seek(f,i-1);
    read(f,VotingRec);
    seek(f,i-2);
    write(f,VotingRec);
   end;
  seek(f,NumQuestions-1);
  truncate(f);

 if QuestionNum < NumQuestions then
  begin;
   move(User^.VotingAnswers[QuestionNum],User^.VotingAnswers[QuestionNum-1],MaxVotingQuestions-QuestionNum);
   User^.VotingAnswers[NumQuestions] := 0;
   assign(uf,Cfg^.pathData+fileUsers);
   {$I-}
   reset(uf);
   {$I+}
   if ioResult <> 0 then Exit;
   for i := 1 to fileSize(uf) do
    begin;
    seek(uf,i-1);
    read(uf,U);
    move(U.VotingAnswers[QuestionNum],U.VotingAnswers[QuestionNum-1],MaxVotingQuestions-QuestionNum);
    U.VotingAnswers[NumQuestions] := 0;
    seek(uf,i-1);
    write(uf,U);
    end;
  end;
 logWrite(User^.Username+' deleted question number '+st(QuestionNum));
 close(f);
 end;
end;

procedure voteAllUnvoted;
var i : integer;
begin;
  assign(f,cfg^.pathData+fileVoting);
  {$I-}
  reset(f);
  {$I+}
  if (ioResult <> 0) then rewrite(f);
  NumQuestions := fileSize(f);
  close(f);{added comatose}
  for i := 1 to NumQuestions do
   if User^.VotingAnswers[i] = 0 then
    voteAnswer(i);
end;

end.