Unit tDoor;

Interface

(* Global constants, you can access these in your main door source          *)
(**)

Const
     tdVer      = '0.1.3';              (* tDoor version                    *)
     crlf       = #13 + #10;            (* Enter + Linefeed                 *)
     cfgLines   = 3;                    (* Number of lines in configuration *)

(* Global variables, can be used/altered in your main door source           *)
(**)

Var
   fCfg         : String[13];           (* Configuration file name          *)
   doorname     : String[30];           (* Door name                        *)
   pathDrop     : String[40];           (* Path to drop file                *)
                                        (*                                  *)
   sysopName    : String[30];           (* Sysop name                       *)
   bbsName      : String[40];           (* BBS System Name                  *)
                                        (*                                  *)
   userHandle,                          (* User handle                      *)
   userReal,                            (* User real name                   *)
   userLocation : String[30];           (* User location                    *)
   userDOB,                             (* User date of birth               *)
   userPhone    : String[13];           (* User phone number                *)
   userSL,                              (* User security level              *)
   userNumber,                          (* User number                      *)
                                        (*                                  *)
   wTemp,                               (* Temporary variable               *)
   dtimeLeft,                           (* User time left                   *)
   startH,                              (* Hour the user entered door       *)
   startM,                              (* Minute the user entered door     *)
   startS,                              (* Second the user entered door     *)
   lastTime     : Word;                 (* Internal                         *)
                                        (*                                  *)
   sLocal,                              (* Send local only                  *)
   sRemote,                             (* Send remote only                 *)
   local,                               (* Local I/O                        *)
   inLocal,                             (* Use local login                  *)
   ComOpened    : Boolean;              (* Comport opened                   *)
                                        (*                                  *)
   lockedBaud,                          (* Locked baud rate                 *)
   userBaud     : LongInt;              (* Connected baud                   *)
                                        (*                                  *)
   bCount,                              (* Generic counter variable         *)
   Node,                                (* Node number                      *)
   Port         : Byte;                 (* Com port number                  *)
                                        (*                                  *)
   sTemp        : string;               (* Temporary string variable        *)

{
  TaskRec.OS
  0 : DOS
  1 : Windows
  2 : OS/2
  3 : DESQview
  4 : TopView
  5 : PC-MOS/386
  6 : Linux DOSEMU
  7 : OS/2 Warp
  8 : Win95
  9 : European MS-DOS
 10 : DoubleDOS
}

Type
  TaskRec = record
    OS      : Word;
    Version : Word;
  end;

Const
  Task    : TaskRec = (
    OS      : 0;
    Version : 0
  );


(* Initialization procedure *)
Procedure tInit;
(* Initialization procedure *)

(* Output procedures *)
Function getPipe(S : String) : Boolean;
Procedure AnsiC(C : Byte);
Procedure oStr(S : String);
Procedure oStrLn(S : String);
Procedure oWriteChar(C : Char);
Procedure tWrite(S : String);
Procedure tWriteLn(S : String);
Procedure lWrite(S: String);
Procedure lWriteLn(S: String);
Procedure rWrite(S: String);
Procedure rWriteLn(S: String);
(* Output procedures *)

Procedure checkHangup;

(* Input procedures *)
Function tKeyPressed : Boolean;
Function tInKey : Char;
Function tReadLn(len : byte) : String;
(* Input procedures *)

(* File handling procedures *)
Function fExists(name : String) : Boolean;
Procedure fOpenTxtR(var fn : text);
Procedure fOpenTxtW(var fn : text);
Procedure fCreate(fn : string);
Procedure fDelete(fn : string);
(* File handling procedures *)

(* Miscellaneous procedures *)
Function TimeLeft: Word;
Function mCaps(S : String) : String;
Function itoa(I : LongInt) : String;
Function atoi(S: string): longint;
(* Miscellaneous procedures *)

(* Ansi parser procedures *)
Procedure cAnsi(C : Char);
(* Ansi parser procedures *)

(* Multitasker procedures *)
Procedure TimeSlice;
Procedure InitMulti;
(* Multitasker procedures *)

(* Fossil procedures *)
function fossil_Init(Baud:longint; port:byte) : Boolean;
Function fossil_Carrier : Boolean;
Function fossil_Avail : Boolean;
Function fossil_Char : Char;
Procedure fossil_DeInit;
Procedure fossil_fIn;
Procedure fossil_fOut;
Procedure fossil_Send(C : Char);
Procedure fossil_DTR(B : Boolean);
(* Fossil procedures *)

Implementation

Uses crt, Dos;

Var
   h,m,s,mss: Word;
   zh,zm,zs,zms: word;

Procedure tInit;
Var
   T    : Text;

Begin
  InitMulti;
  getTime(startH,startM,startS,wTemp);
  getTime(zh,zm,zs,zms);
  lastTime := dtimeLeft;

  (* Begin configuration reading *)
  If fExists(fCfg) = False then Begin
    WriteLn(^G'unable to find '+fCfg);
    Halt(1);
  End;

  Assign(T,fCfg);
  fopentxtr(T);

  ReadLn(T,bbsName);
  ReadLn(T,sysopName);
  ReadLn(T,pathDrop);
  Close(T);
  (* End configuration reading *)

  inlocal:=false;
  local:=false;
  Node :=1;
  bCount:=1;

  (* Parse parameters *)
  While (bCount <= ParamCount) Do Begin
    stemp:=paramstr(bcount);
    If ((stemp[1] = '/') or (stemp[1]='-')) Then Begin
      Case upcase(stemp[2]) Of
        'L' : inLocal := True;
        'P' : pathDrop := Copy(stemp,3,40);
        'N' : Node := atoi(copy(stemp,3,3));
        '?' : Begin
                WriteLn;
                lWrite('|12c|04ommand |12l|04ine |12h|04elp'+crlf);
                writeln;
                lWrite('|07usage: '+paramstr(0)+' |12[|04-l|12, |04-n#|12,|04 -p<path>|12, |04-?|12]'+crlf);
                writeln;
                lWrite('|07both - and / will work as a command line prefix'+crlf);
                writeln;
                writeln('parameters:');
                writeln;
                writeln(' /L       - local mode (disable modem i/o)');
                writeln(' /N#      - load under node #');
                writeln(' /P<path> - load door.sys from <path>');
                writeln(' /?       - show this help screen');
                writeln;
                halt;
              End;
      End;
    End;
    Inc(bCount);
  End;
  (* End parse parameters *)

  (* Local login screen *)
  If inLocal then Begin
    ClrScr;
    writeln;
    writeln('enter your name or [enter] for '+sysopname);
    write(':');
    readln(sTemp);
    if stemp <> '' then userHandle := stemp else  userHandle := sysopname;
    userNumber := 1;
    userReal := 'SysOp';
    userlocation := 'Somewhere';
    dTimeLeft := 999;
    port := 0;
    userBaud := 0;
    lockedBaud := 0;
    userPhone := '(000)000-0000';
    userDOB := '01/01/80';
    local := true;
  (* Local login screen *)
  End else Begin
    If fExists(pathDrop+'DOOR.SYS')=False then Begin
      WriteLn(^G'unable to find '+pathDrop+'DOOR.SYS');
      Halt(4);
    End;
 
    Assign(T,pathDrop+'DOOR.SYS');
    fOpenTxtR(T);

    ReadLn(T,userphone); port:=atoI(userphone);  If Port=0 then Local := True;
    ReadLn(T,userBaud);
    ReadLn(T);
    ReadLn(T,Node);
    ReadLn(T,lockedBaud);
    For bCount := 1 to 4 Do ReadLn(T);
    ReadLn(T,userHandle);
    ReadLn(T,userLocation);
    ReadLn(T,userPhone);
    For bCount := 1 to 2 Do ReadLn(T);
    ReadLn(T,userSL);
    For bCount := 1 to 3 Do ReadLn(T);
    ReadLn(T,dtimeLeft);
    For bCount := 1 to 6 Do ReadLn(T);
    If EOF(T) then begin
      close(T);
      exit;
    end;
    ReadLn(T,userNumber);
    For bCount := 1 to 5 Do ReadLn(T);
    ReadLn(T,userDOB);
    Close(T);
  End;

  If Local=False then Begin
    if not fossil_init(lockedBaud,port) then begin
      WriteLn('unable to initialize fossil driver');
      Halt(5);
    End;
    fossil_fIn;
    fossil_fOut;
    ComOpened := True;
  End;
  ClrScr;
End;

Function TimeLeft: Word;
Var
   HH,MM,SS: Word;
   H,M,S: Word;

  Procedure Elapsed(h1,m1,s1,h2,m2,s2: longint; var Hour, Min, Sec: Word);
    Var
       T1, T2, Time : LongInt;
  Begin
    If H1 < H2 Then Inc(H1,24);
    T1 := (H1 * 3600) + (M1 * 60) + S1;
    T2 := (H2 * 3600) + (M2 * 60) + S2;
    Time := T1 - T2;

    If (Time > 3599) then Begin
      Hour := Time div 3600;
      Time := Time div 3600;
    End else Hour := 0;
    If (Time > 59) then Begin
      Min := Time div 60;
      Time := Time div 60;
    End else Min := 0;
    Sec := Time;
  End;

Begin
  getTime(h,m,s,wTemp);
  elapsed(h,m,s,startH,startM,startS,HH,MM,SS);
  timeLeft := dTimeLeft - MM;
End;

(* Writes a raw string to local and remote                                  *)
(**)
Procedure oStr(S : String);
Begin
  For bCount := 1 to Length(S) Do oWriteChar(S[bCount]);
End;

(* Writes a raw string with crlf to local and remote                        *)
(**)
Procedure oStrLn(S : String);
Begin
  oStr(S+CrLf);
End;

(* Writes a character to local and remote                                   *)
(**)
Procedure oWriteChar(C : Char);
Begin
  checkHangup;
  If sLocal then cAnsi(C) else
  if sRemote then Begin If Local = False then fossil_Send(C) End
  else begin
    cAnsi(C);
    If Local = False then fossil_Send(C);
  End;
End;

Procedure lWrite(S : String);
Begin
  sLocal := True;
  tWrite(S);
  sLocal := False;
End;

Procedure lWriteLn(S : String);
Begin
  lWrite(S + crLf);
End;

Procedure rWrite(S : String);
Begin
  sRemote := True;
  tWrite(S);
  sRemote := False;
End;

Procedure rWriteLn(S : String);
Begin
  rWrite(S + crLf);
End;

Procedure tWrite(S: String);
Var
   p:byte;
Begin
  For p := 1 to Length(S) do
  Begin
    If S[P] = '|' Then Begin
      If P+2<=Length(S) Then 
      If getpipe(copy(s,p+1,2)) then Inc(p,2) else oWriteChar(s[p]);
    End Else
      oWriteChar(S[P]);
  End;
End;

(* Displays a string parsing pipe ("|") colour and ansi codes               *)
(**)
Procedure tWriteLn(S : String);
Begin
  tWrite(S + crlf);
End;

(* Changes text attributes                                                  *)
(**)
Procedure AnsiC(C : Byte);
Const Colours: Array[0..7] of Byte = (0,4,2,6,1,5,3,7);
Begin
  oStr(#27+'[');
  If ((C<=7) and (C>=0)) Then oStr('0;3'+itoa(Colours[C])) Else
  If ((C>=8) and (C<=15)) Then oStr('1;3'+itoa(Colours[C-8])) Else
  If ((C>=16) and (C<=23)) Then oStr('1;4'+itoa(Colours[C-16]));
  oWriteChar('m');
End; (* AnsiC *)


Function getPipe(S : String) : Boolean;
Begin
  getpipe:=true;
  Case UpCase(S[1]) Of
    '0' : Case S[2] Of
            '0'..'9' : AnsiC(atoI(S[2]));
            Else getPipe := False;
          End;
    '1' : Case S[2] Of
            '0'..'9' : AnsiC(atoI(S[1]+S[2]));
            Else getPipe := False;
          End;
    '2' : Case S[2] Of
            '0'..'3' : AnsiC(atoI(S[1]+S[2]));
            Else getPipe := False;
          End;
    'B' : Case S[2] Of
            '0'..'7' : AnsiC(16+atoI(S[2]));
            Else getPipe := False;
          End;
         Else getPipe := False;
  End;
End;

Procedure checkHangUp;
Begin
  If ((timeLeft = 3) and ((fossil_carrier=false) and (local=false))) then Begin
    tWriteLn('time run out');
    timeSlice;
    halt;
  End;
End;

Function tKeyPressed;
Var Key:Boolean;
Begin
  If Local=False then If fossil_Avail then key := True;
  If key = False then if keyPressed then key := true;
  tKeyPressed:=Key;
End;

Function tInKey;
Var C : Char;
keylocal:boolean;
Begin
  C:=#0;
  Repeat
    checkHangup;
    timeSlice;
  Until tKeyPressed;
  If KeyPressed then keylocal:=true;
  if keylocal then c:=readkey else
   If Local = False then C:=fossil_Char;
  tInKey := C;
End;

Function tReadLn(len : byte) : String;
Var
   S : String;
   C : Char;
   Pos : Byte;
Begin
  C := #0;
  Pos := 0;
  S := '';
  Repeat
    checkHangup;
    C := tinKey;
    If (Pos < Len) or (C = #8) Then Begin
      Case C of
        #8 : If (Pos > 0) then Begin
               S[Pos] := #0;
               Dec(Pos);
               tWrite(^H' '^H);
             End;
        #32..#255 :Begin
              Inc(Pos);
              S[Pos] := C;
              tWrite(C);
            End;
      End;
    End;
    TimeSlice;
  Until ((C = #13));
  tReadLn := S;
End;

(* File handling procedures *)
Const
     uFile  = ^G'Unable to access file!';
Var Counter : Integer;
    F       : File;

Function fExists;
Begin
  fExists := FSearch(name,'')<>'';
End;

Procedure fOpenTxtR(Var fn : text);
Begin
  FileMode := 66;
  Counter := 0;
  For Counter := 1 To 5000 Do Begin
    {$I-} Reset(FN); {$I+}
    If IOResult = 0 then Exit;
    Delay(1);
  End;
  WriteLn(uFile);
  Halt(5);
End;

Procedure fOpenTxtW(Var fn : text);
Begin
  FileMode := 66;
  Counter := 0;
  For Counter := 1 to 5000 Do Begin
    {$I-} Append(FN); {$I+}
    If IOResult = 0 then Exit;
    Delay(1);
  End;
  WriteLn(uFile);
  Halt(5);
End;

Procedure fCreate(fn : String);
Begin
  FileMode := 66;
  Counter := 0;
  Assign(F,FN);
  For Counter := 1 To 5000 Do Begin
    {$I-} Rewrite(F); {$I+}
    If IOResult = 0 then Exit;
    Delay(1);
  End;
  WriteLn(uFile);
  Halt(5);
End;

Procedure fDelete(fn : string);
Begin
  if fExists(FN)=False then Begin
    writeln(fn,' does not actually exist!');
    exit;
  end;
  FileMode := 66;
  Assign(F,fn);
  Repeat
    {$I-} Erase(F); {$I+}
    Delay(1);
  Until IOResult=0;
End;
(* File handling procedures *)

(* Miscellaneous procedures *)
Function mCaps;
Begin
  For bCount := 1 to Length(S) do S[bCount]:=UpCase(S[bCount]);
  mCaps := S;
End;

Function  atoi;
var
  Code: integer;
     I: LongInt;
begin
  I := 0;
  Val(S,i,Code);
  atoi := I;
end;

Function itoa;
Begin
  str(i,sTemp);
  itoa:=sTemp;
End;
(* Miscellaneous procedures *)

(* Ansi parser procedures *)
Var
    Buff        : String[21];            (* Buffer                          *)
    Escape,                              (* True if first character is Esc  *)
    Escape2,                             (* True if second char is [        *)
    Hi,                                  (* High intensity                  *)
    Blink       : Boolean;               (* Blink                           *)
    PosBuff,                             (* Postion in buffer               *)
    SaveX,                               (* Saved X position                *)
    SaveY       : Byte;                  (* Saved Y position                *)

Procedure cAnsi;
Const
  C_Ansi  : Set of Char = ['A','B','C','D','F','H','J','K','M','N','S','U'];
  Colours : Array[0..7] Of Byte = (0,4,2,6,1,5,3,7);

Procedure Ansi;
Var Tab              : Array [1..20] of Byte;
    Colour, Colour2,
    Nbr_Num,
    Nbr_Chifr,
    i, x             : Byte;
    XStr, YStr       : String[2];

Begin
  Nbr_Num := 0;
  Nbr_Chifr := 1;
  x := 1;
  Tab[1] := 1;
  Tab[2] := 1;

  While (x <> PosBuff) do
    Begin
      If Nbr_Num = 0 Then Inc (Nbr_Num);
      If (Buff[x] in ['0'..'9']) And (Nbr_Chifr < 3) Then Begin
        If Nbr_Chifr = 1 Then Tab [Nbr_Num] := (Ord (Buff[x]) - 48) Else
        Tab [Nbr_Num] := (Tab [Nbr_Num] * 10) + (Ord (Buff[x]) - 48);
        Inc (Nbr_Chifr);
      End Else
      If Buff[x] = ';' Then Begin
        If (Nbr_Chifr = 1) Then Tab [Nbr_Num] := 1;
        Inc (Nbr_Num);
        Nbr_Chifr := 1;
      End;
      Inc (x);
    End;  (* While *)

  Case Buff [PosBuff] of     (* Parse the commands *)
    'M' : For i := 1 to Nbr_Num do
            Case Tab [i] of
              (* All Attributes off *)
              0  : Begin
                     TextColor (7);
                     TextBackGround (0);
                     Hi := False;
                     Blink := False;
                   End;

              (* High intensity on *)
              1  : Begin
                     Hi := True;
                     Colour := (TextAttr and 15);
                     If Colour < 8 Then Colour := Colour + 8;
                     TextColor (Colour);
                   End;

              (* Blinking on *)
              5,
              6  : Blink := True;

              (* Inverse video on *)
              7  : Begin
                     Colour := (TextAttr and 15);
                     If Colour > 8 Then Dec (Colour, 8);
                     Colour2 := ((TextAttr Shr 4) and 7);
                     TextColor (Colour2);
                     TextBackGround (Colour);
                   End;

              (* Concealed on *)
              8  : Begin
                     Colour := ((TextAttr Shr 3) and 7);
                     TextColor (Colour);
                   End;

              (* Change foreground colour *)
              30..37 : Begin
                         Colour := Colours[Tab[I]-30];
                         If Hi Then Inc (Colour, 8);
                         If Blink Then Inc (Colour, 128);
                         TextColor (Colour);
                       End;

              (* Change background colour *)
              40..47: TextBackGround(Colours[Tab[I]-40]);
            End;

    (* Move cursor to x, y coordinates *)
    'H','F' : GotoXy (Tab[2], Tab[1]);

    (* Responds to a standard ANSI detect *)
    'N' : Begin
            Str (WhereX, XStr);
            Str (WhereY, YStr);
          End;

    (* Move Up x lines *)
    'A' : GotoXy (WhereX, WhereY - Tab [1]);

    (* Move Down x lines *)
    'B' : GotoXy (WhereX, WhereY + Tab [1]);

    (* Move right x cols *)
    'C' : GotoXy (WhereX + Tab [1], WhereY);

    (* Move left x cols *)
    'D' : GotoXy (WhereX - Tab [1], WhereY);

    (* Clear Screen *)
    'J' : ClrScr;

    (* Save cursor position *)
    'S' : Begin
            SaveX := WhereX;
            SaveY := WhereY;
          End;

    (* Restore saved cursor position *)
    'U' : GotoXy (SaveX,SaveY);

    (* Clear to end of line *)
    'K' : ClrEol;
  End;  (* Case of *)
End;  (* Ansi *)

Begin
  If C = '' Then Escape := True Else
  If (C = '[') and Escape Then Escape2 := True Else
  If Escape and Escape2 Then Begin
    Inc (PosBuff);
    Buff [PosBuff] := UpCase (C);
    If PosBuff < 20 Then
    Begin
      If UpCase (C) in C_Ansi Then Begin
        Ansi;
        Escape := False;
        Escape2 := False;
        PosBuff := 0;
      End;
    End Else Begin
      Escape := False;
      Escape2 := False;
      PosBuff := 0;
    End;
  End Else Write (C);
End;
(* Ansi parser procedures *)

(* Multitasker procedures *)
Procedure InitMulti; Assembler;
Asm
  mov  Task. OS, 0
  mov  Task. Version, 0
  mov  AX, 4010h
  int  2fh
  cmp  AX, 4010h
  jne  @OS2
  push BX ; push DX
  push DS ; push SI
  mov  AX, 4A33h
  int  2fh
  pop  SI ; pop  DS
  pop  DX ; pop  BX
  cmp  AX, 0
  je   @Win95
  mov  AX, 160Ah
  Int  2Fh
  cmp  AX, 0
  je   @Windows
  mov  AX, 1022h
  mov  BX, 0000h
  Int  15h
  cmp  BX, 0
  jne  @DESQview
  mov  AH, 2BH
  mov  AL, 01h
  mov  CX, 4445h
  mov  DX, 5351h
  Int  21h
  cmp  AL, $FF
  jne  @TopView
  mov  AX, 3000h
  mov  BX, 3000h
  mov  CX, 3000h
  mov  DX, 3000h
  int  21h
  cmp  AL, 3
  je   @PC_MOS
  mov  AH, 87h
  mov  AL, 0
  int  21h
  cmp  AL, 0
  jne  @European
  mov  AX, $E400
  int  21h
  cmp  AL, 0
  jne  @DoubleDOS
  mov  AH, $35
  mov  AL, $E6
  int  21h
  mov  ES, AX
  cmp  AX, $F000
  jne  @Fin
  cmp  BX, $0E60
  jne  @Fin
  mov  AX, 0
  int  $E6
  cmp  AH, $AA
  jne  @Fin
  cmp  AL, $55
  je   @Linux
  jmp  @Fin
  @Windows:
  Mov  Task. OS, 1
  Mov  Task. Version, BX
  jmp  @Fin
  @OS2:
  Mov  Task. OS, 2
  cmp  AX, 0000h
  je   @Warp
  Mov  BH, AH
  XOr  AH, AH
  Mov  CL, 10
  Div  CL
  Mov  AH, BH
  Xchg AH, AL
  jmp  @OS2_done
  @Warp:
  mov  AH, 3
  mov  AL, 0
  mov  Task. OS, 7
  @OS2_done:
  Mov  Task. Version, AX
  jmp  @Fin
  @DESQview:
  mov  Task. OS, 3
  mov  Task. Version, BX
  jmp  @Fin
  @TopView:
  mov  Task. OS, 4
  mov  Task. Version, BX
  jmp  @Fin
  @PC_MOS:
  mov  Task. OS, 5
  mov  Task. Version, AX
  jmp  @Fin
  @Linux:
  mov  AH, 12h
  mov  BX, 20
  int  $E6
  mov  Task. OS, 6
  mov  Task. Version, BX
  jmp  @Fin
  @Win95:
  mov  AX, 160Ah
  Int  2Fh
  mov  Task. OS, 8
  mov  Task. Version, BX
  jmp  @Fin
  @European:
  mov  Task. OS, 9
  mov  Task. Version, 0400
  jmp  @Fin
  @DoubleDOS:
  mov  Task. OS, 10
  mov  Task. Version, 0100
  jmp  @Fin
  @Fin:
End;

Procedure TimeSlice; Assembler;
Asm
  cmp  Task. OS, 0
  je   @Win
  cmp  Task. OS, 1
  je   @Win
  cmp  Task. OS, 2
  je   @OS2
  cmp  Task. OS, 3
  je   @DV_TV
  cmp  Task. OS, 4
  je   @DV_TV
  cmp  Task. OS, 5
  je   @PC_MOS
  cmp  Task. OS, 6
  je   @Linux
  cmp  Task. OS, 7
  je   @OS2
  cmp  Task. OS, 8
  je   @Win
  cmp  Task. OS, 9
  je   @European
  cmp  Task. OS, 10
  je   @DoubleDOS
  @DV_TV:
  mov  AX, 1000h
  Int  15h
  jmp  @Fin
  @Win:
  mov  AX, 1680h
  Int  2Fh
  jmp  @Fin
  @OS2:
  mov  ax,32
  mov  dx,0
  hlt
  db   35h, 0CAh
  jmp  @Fin
  @PC_MOS:
  int  28h
  jmp  @Fin
  @Linux:
  int  28h
  jmp  @Fin
  @European:
  mov  AH, 89h
  mov  CX, 55
  Int  2Fh
  jmp  @Fin
  @DoubleDOS:
  mov  AX, $EE01
  Int  21h
  jmp  @Fin
  @Fin:
End;
(* Multitasker procedures *)

(* Fossil procedures *)
Var
  Comm_Port: word;
  tempb: byte;

Function fossil_modemInit(baud:longint;port:byte):boolean;
var
  temp: Word;
begin
  asm
    mov ah, $04
    mov bx, $00
    mov dx, comm_Port
    int $14
    mov temp, ax
  end;
  fossil_modemInit := temp=$1954;
  Case Baud div 10 of
    30: tempb:= $43;
    60: tempb:= $63;
    120: tempb:= $83;
    240: tempb:= $A3;
    480: tempb:= $C3;
    960: tempb:= $E3;
    1920: tempb:= $03;
    3840: tempb:= $23;
  End;
  asm
    mov ah, 00
    mov al, tempb
    mov dx, Comm_Port
    int $14
  end;
end;

function  fossil_Init;
begin
  comm_port:=port-1;
  fossil_init:=fossil_modemInit(comm_port, baud);
end;

function fossil_avail;
Begin
  Asm
    mov ah, $03
    mov dx, comm_port
    int $14
    mov tempb, ah
  End;
  If (tempb And 1)=1 Then fossil_avail:=True Else fossil_avail:=False;
end;

function fossil_char;
begin
  tempb:=0;
  Asm
    mov ah, $03
    mov dx, comm_port
    int $14
    mov tempb, ah
  End;
  If (tempb And 1)=1 Then
    Begin
      Asm
        mov ah, $02
        mov dx, comm_port
        int $14
        mov tempb, al
      End;
      fossil_char:=Chr(tempb);
    End;
end;

procedure fossil_send;
begin
  tempb:=Ord(c);
  Asm
    mov al, tempb
    mov dx, comm_port
    mov ah, $01
    int $14
  End;
end;

function fossil_carrier;
begin
  Asm
    mov ah, $03
    mov dx, comm_port
    int $14
    mov tempb, al
  End;
  If (tempb And $80)<>0 Then fossil_carrier:=True Else fossil_carrier:=False;
end;

procedure fossil_deinit;
begin
  Asm
    mov ah, $05
    mov dx, comm_port
    int $14
  End;
end;

procedure fossil_fIn;
begin
  Asm
    mov ah, $0A
    mov dx, comm_port
    int $14
  End;
end;

procedure fossil_fOut;
begin
    asm
    mov ah, 9
    mov dx,comm_port;
    int $14
    end;
end;

procedure fossil_DTR;
var
   x: byte;
begin
  if b=true then x:=1 else x:=0;
  Asm
    mov dx, comm_port
    mov al, x
    mov ah, $06
    int 14h
  End;
end;
(* Fossil procedures *)

Procedure exitDoor; far;
Begin
  If ((Local=False) and (ComOpened)) then fossil_DeInit;
End;

Begin
  exitproc   := @exitdoor;
  Randomize;
  fCfg       := 'DOOR.CFG';
  DoorName   := 'think Door Kit v'+tdVer+' by Brian Zhou';
  DoorName   := 'Generic Door';
  SysOpName  := 'SysOp';
  bbsName    := 'BBS';
  ComOpened  := False;
  sLocal     := False;
  sRemote    := False;

  comm_port  := 0;
  tempb      := 0;

  (* Flush buffer *)
  FillChar (Buff, 21, ' ');

  (* Reset variables *)
  Hi := False;
  Blink := False;
  Escape := False;
  Escape2 := False;
  PosBuff := 0;
  SaveX := 1;
  SaveY := 1;
End.
