Const
  ver = '10-05 Exp';
  MAXPROTOCOLS = 120;
  MAXEVENTS = 10;
  MAXARCS = 8;
  MAXBATCHFILES = 50;
  MAXMENUCMDS = 100;
  MAXRESULTCODES = 18;
  
Type
  astr = String [160];
  Str8 = String [8];
  
  ACString = String [20];            { Access Condition String }
  acrq = '@'..'Z';                  { Access Restriction flags }
  
  uflags =
  (rlogon,                       { L - Limited to one call a day }
  rchat,                        { C - No SysOp paging }
  rvalidate,                    { V - Posts are unvalidated }
  ruserlist,                    { U - Can't list users }
  ramsg,                        { A - Can't post an auto message }
  rpostan,                      { * - Can't post anonymously }
  rpost,                        { P - Can't post }
  remail,                       { E - Can't send email }
  rvoting,                      { K - Can't use voting booth }
  rmsg,                         { M - Force email deletion }
  vt100,                        { Supports VT100 }
  hotkey,                       { hotkey input mode }
  avatar,                       { Supports Avatar }
  pause,                        { screen pausing }
  novice,                       { user requires novice help }
  ansi,                         { Supports ANSI }
  Color,                        { Supports color }
  alert,                        { Alert SysOp upon login }
  smw,                          { Short message(s) waiting }
  nomail,                       { Mailbox is closed }
  fnodlratio,                   { 1 - No UL/DL ratio }
  fnopostratio,                 { 2 - No post/call ratio }
  fnocredits,                   { 3 - No credits checking }
  fnodeletion);                 { 4 - Protected from deletion }
  
  suflags =
  (lockedout,                   { if locked out }
  deleted,                      { if deleted }
  trapactivity,                 { if trapping users activity }
  trapseparate,                 { if trap to seperate TRAP file }
  chatauto,                     { if auto chat trapping }
  chatseparate,                 { if separate chat file to trap to }
  slogseparate,                 { if separate SysOp log }
  clsmsg,                       { if clear-screens }
  RIP,                          { if RIP graphics can be used }
  fseditor,                     { if Full Screen Editor }
  AutoDetect                    { Use auto-detected emulation }
  );
  
  anontyp =
  (atno,                         { Anonymous posts not allowed }
  atyes,                        { Anonymous posts are allowed }
  atforced,                     { Force anonymous }
  atdearabby,                   { "Dear Abby" base }
  atanyname);                   { Post under any name }
  
  netattr =
  (Private,
  Crash,
  Recd,
  NSent,
  FileAttach,
  Intransit,
  Orphan,
  KillSent,
  Local,
  Hold,
  Unused,
  FileRequest,
  ReturnReceiptRequest,
  IsReturnReceipt,
  AuditRequest,
  FileUpdateRequest);
  
  NetAttribs = Set Of netattr;
  
  Colors   = Array [False..True, 0..9] Of Byte; { Color tables }
  secrange = Array [0..255] Of Integer;        { Access tables }
  
  mzscanr  = Set Of 1..250;              { Which message bases to scan }
  fzscanr  = Set Of 1..250;             { Which file bases to scan }
  mhireadr = Array [1..250] Of LongInt;   { Lastread pointers }
  
  useridxrec =                         { USERS.IDX : Sorted names listing }
  Record
    Name: String [36];                  { the user's name }
    Number,                           { user number          }
    Left,                             { Left node }
    Right: Integer;                    { Right node }
    RealName,                         { User's real name?    }
    Deleted: Boolean;                  { deleted or not       }
  End;
  
  userrec =                            { USERS.DAT : User records }
  Record
    Name: String [36];                  { system name      }
    realname: String [36];              { real name        }
    pw: String [20];                    { password         }
    ph: String [12];                    { phone #          }
    bday: String [8];                   { birthdate        }
    firston: String [8];                { first on date    }
    laston: String [8];                 { last on date     }
    street: String [30];                { street address   }
    citystate: String [30];             { city, state      }
    zipcode: String [10];               { zipcode          }
    usrdefstr: Array [1..3] Of String [35]; { definable strings }
    note: String [35];                  { SysOp note       }
    userstartmenu: String [8];          { menu to start at }
    lockedfile: String [8];             { print lockout msg}
    Flags: Set Of uflags;              { flags            }
    sflags: Set Of suflags;            { status flags     }
    ar: Set Of acrq;                   { AR flags         }
    vote: Array [1..25] Of Byte;        { voting data      }
    
    sex: Char;                         { gender           }
    ttimeon,                          { total time on    }
    uk,                               { UL k             }
    dk: LongInt;                       { DL k             }
    tltoday,                          { # min left today }
    forusr,                           { forward mail to  }
    junkfp: Integer;                   { Junk }
    
    uploads, downloads,                { # of ULs/# of DLs}
    loggedon,                         { # times on       }
    msgpost,                          { # message posts  }
    emailsent,                        { # email sent     }
    feedback,                         { # feedback sent  }
    timebank,                         { # mins in bank   }
    timebankadd,                      { # added today    }
    dlktoday,                         { # kbytes dl today}
    dltoday: Word;                     { # files dl today }
    
    waiting,                          { mail waiting     }
    linelen,                          { line length      }
    pagelen,                          { page length      }
    ontoday,                          { # times on today }
    illegal,                          { # illegal logons }
    barf,
    lastmbase,                        { # last msg base  }
    lastfbase,                        { # last file base }
    sl, dsl: Byte;                      { SL / DSL         }
    
    mhiread: mhireadr;                 { Message last read date ptrs}
    mzscan: mzscanr;                   { Which message bases to scan}
    fzscan: fzscanr;                   { Which file bases to scan}
    
    cols: Colors;                      { user colors }
    
    garbage: Byte;
    timebankwith: Word;                { amount of time withdrawn today}
    passwordchanged: Word;             { last day password changed }
    defarctype: Byte;                  { default QWK archive type }
    lastconf: Char;                    { last conference they were in }
    lastqwk: LongInt;                  { date/time of last qwk packet }
    getownqwk,                        { add own messages to qwk packet? }
    scanfilesqwk,                     { scan file bases for qwk packets? }
    privateqwk: Boolean;               { get private mail in qwk packets? }
    
    credit,                           { Amount of credit a user has }
    debit: LongInt;                    { Amount of debit a user has }
    expiration: LongInt;               { Expiration date of this user }
    expireto: Char;                    { Subscription level to expire to }
    ColorScheme: Byte;                 { User's color scheme # }
    TeleConfEcho,                     { echo Teleconf lines? }
    TeleConfInt: Boolean;              { interrupt during typing? }
  End;
  
  msgstatusr =
  (mdeleted,
  sent,
  unvalidated,
  permanent,
  allowmci,
  netmail,
  prvt,
  forwarded);
  
  mhireadrec =
  Record
    NewScan: Boolean;           { New scan this base? }
    LastRead: LongInt;          { Last message date read }
  End;
  
  fromtoinfo =                  { from/to information for mheaderrec }
  Record
    anon: Byte;
    usernum: Word;              { user number   }
    as: String [36];             { posted as     }
    Real: String [36];           { real name     }
    Name: String [36];           { system name   }
    zone,
    net,
    node,
    point: Word;
  End;
  
  mheaderrec =
  Record
    from, mto: fromtoinfo;            { message from/to info    }
    pointer: LongInt;                { starting record of text }
    textsize: Word;                  { size of text            }
    replyto: Word;                   { ORIGINAL + REPLYTO = CURRENT }
    date: LongInt;                   { date/time packed string }
    dayofweek: Byte;                 { message day of week     }
    status: Set Of msgstatusr;       { message status flags    }
    replies: Word;                   { times replied to        }
    subject: String [40];             { subject of message      }
    origindate: String [19];          { date of echo/group msgs }
    fileattached: Byte;              { 0=No, 1=Yes&Del, 2=Yes&Save }
    netattribute: NetAttribs;        { Netmail attributes }
    res: Array [1..2] Of Byte;        { reserved }
  End;
  
  
  historyrec =                     { HISTORY.DAT : Summary logs }
  Record
    date: String [8];
    userbaud: Array [0..4] Of Word;
    active, callers, newusers, posts, email, feedback,
    errors, uploads, downloads: Word;
    uk, dk: LongInt;
  End;
  
  filearcinforec =                 { Archive configuration records }
  Record
    active: Boolean;               { active or not  }
    ext: String [3];                { file extension }
    listline,                     { /x for internal;
    x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline    }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline }
    cmtline: String [25];           { comment cmdline        }
    succlevel: Integer;            { success ERRORLEVEL, -1=ignore results }
  End;
  
  fstringrec =                     { STRING.DAT }
  Record
    anonymous: String [80];             { "[Anonymous]" string }
    note: Array [1..2] Of String [80];   { Logon notes (L #1-2) }
    lprompt: String [80];               { Logon prompt (L #3) }
    echoc: Char;                       { Echo char for PWs }
    yourpassword,                     { "Your password:" }
    yourphonenumber,                  { "Your phone number:" }
    engage,                           { "Engage Chat" }
    endchat,                          { "End Chat" }
    wait,                             { "SysOp Working" }
    pause,                            { "Pause" }
    entermsg1,                        { "Enter Message" line #1 }
    entermsg2,                        { "Enter Message" line #2 }
    newscan1,                         { "NewScan begin" }
    newscan2,                         { "NewScan done" }
    scanmessage,                      { Message scanning prompt }
    automsgt: String [80];              { Auto-Message title }
    autom: Char;                       { Auto-Message border characters }
    
    shelldos1,                        { " >> SysOp shelling to DOS ..." }
    shelldos2,                        { " ... thank you for waiting." }
    chatcall1,                        { "Paging SysOp, please wait..." }
    chatcall2,                        { ">>><*><<<" }
    shuttleprompt,                    { "Enter your user name or number : " }
    namenotfound,                     { "Name NOT found in user list." }
    bulletinline,                     { Bulletin line }
    protocolp,                        { "Protocol (?=List) :" }
    
    listline,                         { "List files - P to pause" }
    newline,                          { "Search for new files -" }
    searchline,                       { "Search all dirs for file mask" }
    findline1,                        { "Search for descriptions... " }
    findline2,                        { "Enter the string to search for.." }
    downloadline,                     { "Download - " }
    uploadline,                       { "Upload - " }
    viewline,                         { "View interior files - " }
    nofilecredits,                    { "Insufficient file credits." }
    unbalance,                        { "Your UL/DL ratio is unbalanced" }
    
    pninfo,                           { "P to Pause, N for next dir" }
    gfnline1,                         { "[Enter]=All files" }
    gfnline2,                         { "File mask: " }
    batchadd,                         { "File added to batch queue." }
    addbatch,                         { "Batch download flagging - " }
    readq,                            { "Begin reading at [1-54] (Q=Quit): " }
    scanq,                            { "Begin scanning at [1-54] (Q=Quit): " }
    default,                          { "Press [Enter] to use defaults" }
    newscanall,                       { ")[ Newscan All ](" }
    newscandone,                      { ")[ Newscan Done ](" }
    chatreason: String [80];            { 'Give me a good reason to chat' }
    quote_line: Array [1..2] Of String [80]; { Quoting so and so to so and so }
    userdefques: Array [1..3] Of String [80]; { user defined question 1...3}
    userdefed: Array [1..3] Of String [10];  { user def'd q, user editor strings}
    continue: String [80];              { Continue? }
  End;
  
  ModemFlags =         { MODEM.DAT status flags }
  (
  lockedport,       { COM port locked at constant rate }
  xonxoff,          { XON/XOFF (software) flow control }
  ctsrts,           { CTS/RTS (hardware) flow control }
  DigiBoard         { This line uses a Digiboard }
  );
  
  linerec =
  Record
    InitBaud: LongInt;                 { initialization baud }
    ComPort: Byte;                     { COM port number }
    MFlags: Set Of ModemFlags;         { status flags }
    Init,                             { init string }
    Answer,                           { answer string or blank }
    Hangup,                           { hangup string }
    Offhook: String [30];               { phone off-hook string }
    DoorPath,                         { door drop files written to }
    TeleConfNormal,
    TeleConfAnon,                     { Teleconferencing strings }
    TeleConfGlobal,
    TeleConfPrivate: String [40];
    OK,
    RING,
    RELIABLE,
    CALLERID,
    NOCARRIER: String [20];
    CONNECT: Array [1..22] Of String [20];
    { 300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
    21600, 24000, 26400, 28800, 38400, 57600, 115200 + 4 extra }
    UseCallerID: Boolean;              { Insert Caller ID into sysop note? }
    LogonACS: ACString;                { ACS string to logon this node }
    IRQ,
    Address: String [10];               { used only for functional MCI codes
    %C = Comport address
    %E = IRQ
    }
    AnswerOnRing: Byte;                { Answer after how many rings? }
    MultiRing: Boolean;                { Answer Ringmaster or some other type
    of multiple-ring system ONLY }
  End;
  
  validationrec = Record
                    description: String [25];           { description }
                    newsl,                            { new SL }
                    newdsl: Byte;                      { new DSL }
                    newar: Set Of acrq;                { new AR }
                    newac: Set Of uflags;              { new AC }
                    newfp: Integer;                    { nothing }
                    newcredit: LongInt;                { new credit (added) }
                    expiration: Word;                  { days until expiration }
                    expireto: Char;                    { validation level to expire to }
                    softar: Boolean;                   { TRUE=AR added to current, else replaces }
                    softac: Boolean;                   { TRUE=AC    "   "   "       "      "  }
                    newmenu: String [8];                { User start out menu }
                  End;
  
  generalrec =
  Record
    datapath: String [40];              { DATA path }
    miscpath: String [40];              { MISC path }
    menupath: String [40];              { MENU path }
    logspath: String [40];              { LOGS path }
    msgpath: String [40];               { MSGS path }
    nodepath: String [40];              { NODE list path }
    temppath: String [40];              { TEMP path }
    protpath: String [40];              { PROT path }
    arcspath: String [40];              { ARCS path }
    
    bbsname: String [40];               { BBS name }
    bbsphone: String [12];              { BBS phone number }
    sysopname: String [30];             { SysOp's name }
    
    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime,                         { ..and end }
    minbaudlowtime,                   { minimum baud calling hours begin.. }
    minbaudhitime,                    { ..and end }
    minbauddllowtime,                 { minimum baud downloading hours begin.. }
    minbauddlhitime: Integer;          { ..and end }
    
    minimumbaud,                      { minimum baud rate to logon }
    minimumdlbaud: LongInt;            { minimum baud rate to download }
    
    shuttlelog,                       { Use Shuttle Logon? }
    closedsystem,                     { Allow new users? }
    swapshell: Boolean;                { Swap on shell? }
    
    sysoppw,                          { SysOp password }
    newuserpw,                        { newuser password }
    minbaudoverride,                  { override minimum baud rate }
    qwknetworkACS: ACString;           { QWK network REP ACS }
    
    crapola2: String [8];               { }
    
    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    seepw,                            { see SysOp PWs remotely  }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilecredits,                    { no file credits checking }
    ulvalreq,                         { uploads require validation }
    TeleConfMCI,                      { ACS access for MCI codes while teleconfin' }
    overridechat: ACString;            { override chat hours }
    
    maxprivpost,                      { max email can send per call }
    maxfback,                         { max feedback per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max sysop pages per call }
    maxwaiting,                       { max mail waiting }
    csmaxwaiting,                     { max mail waiting for Co-SysOp + }
    junk1,                            { ------------------------------- }
    junk2,                            { ------------------------------- }
    maxlogontries,                    { tries allowed for PW's at logon }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor: Byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum drive space left to post }
    minspaceforupload: Integer;        { minimum drive space left to upload }
    
    backsysoplogs,                    { days to keep SYSOP##.LOG }
    eventwarningtime,                 { minutes before event to warn user }
    wfcblanktime: Byte;                { minutes before blanking WFC menu }
    
    allowalias,                       { allow handles? }
    phonepw,                          { phone number password in logon? }
    localsec,                         { use local security? }
    globaltrap,                       { trap everyone's activity? }
    autochatopen,                     { automatically open chat buffer? }
    autominlogon,                     { Auto-Message at logon? }
    bullinlogon,                      { bulletins at logon? }
    lcallinlogon,                     { "Last Few Callers" list at logon? }
    yourinfoinlogon,                  { "Your Info" at logon? }
    offhooklocallogon,                { phone off-hook for local logons? }
    forcevoting,                      { manditory voting? }
    compressbases,                    { "compress" file/msg base numbers? }
    searchdup: Boolean;                { search for dupes files when UL? }
    slogtype: Byte;                    { log type: File/Printer/Both }
    stripclog: Boolean;                { strip colors from SysOp log? }
    newapp,                           { send new user application to # }
    timeoutbell,                      { minutes before timeout beep }
    timeout: Integer;                  { minutes before timeout }
    useems: Boolean;                   { use EMS for overlay }
    usebios: Boolean;                  { use BIOS for video output }
    useiemsi: Boolean;                 { use iemsi }
    alertbeep: Integer;                { time between alert beeps }
    
    filearcinfo:
    Array [1..maxarcs] Of filearcinforec;           { archive specs }
    filearccomment:
    Array [1..3] Of String [40];    { BBS comment files for archives }
    uldlratio,                        { use UL/DL ratios? }
    filecreditratio: Boolean;          { use auto file-credit compensation? }
    filecreditcomp,                   { file credit compensation ratio }
    filecreditcompbasesize,           { file credit base compensation size }
    ulrefund,                         { percent of time to refund on ULs }
    tosysopdir: Byte;                  { SysOp file base }
    validateallfiles: Boolean;         { validate files automatically? }
    maxintemp,                        { max K allowed in TEMP }
    minresume: Integer;                { min K to allow resume-later }
    
    filediz: Boolean;                  { Search/Import file_id.diz }
    
    maxqwktotal,                      { max msgs in a packet, period }
    maxqwkbase: Word;                  { max msgs in a base }
    
    CreditMinute,                     { Credits per minute }
    CreditPost,                       { Credits per post }
    CreditEmail: Integer;              { Credits per Email sent }
    
    sysoppword: Boolean;               { check for sysop password? }
    
    CreditFreeTime: Integer;           { Amount of "Free" time given to user at logon }
    
    TrapTeleConf: Boolean;             { Trap teleconferencing to ROOMx.TRP? }
    
    RES98: Array [1..6] Of Byte;
    
    allstartmenu: String [8];           { logon menu to start users on }
    bulletprefix: String [8];           { default bulletins filename }
    
    timeallow,                        { time allowance }
    callallow,                        { call allowance }
    dlratio,                          { # ULs/# DLs ratios }
    dlkratio,                         { DLk/ULk ratios }
    postratio,                        { posts per call ratio }
    dloneday,                         { Max number of dload files in one day}
    dlkoneday: secrange;               { Max k downloaded in one day}
    
    lastdate: String [8];               { last system date }
    curwindow: Byte;                   { type of SysOp window in use }
    istopwindow: Boolean;              { is window at top of screen? }
    callernum: LongInt;                { system caller number }
    numusers: Integer;                 { number of users }
    
    multpath: String [40];              { MULT path }
    
    junkola: Array [1..3] Of Byte;     { -= NOT USED =- }
    
    recompress: Boolean;               { recompress like archives? }
    
    rewardsystem: Boolean;             { use file rewarding system? }
    
    passwordchange: Word;              { change password at least every x days }
    
    netmailpath: String [40];           { path to netmail }
    netmailACS: ACString;              { do they have access to netmail? }
    
    rewardratio: Integer;              { % of file points to reward back }
    
    birthdatecheck: Byte;              { check user's birthdate every xx logons }
    
    Invisible: ACString;                 { Invisible mode? }
    
    fileattachpath: String [40];        { directory for file attaches }
    
    fileattachACS: ACString;           { ACS to attach files to messages }
    changevote: ACString;              { ACS to change their vote }
    
    trapgroup: Boolean;                { record group chats? }
    
    qwktimeignore: Boolean;            { ignore time remaining for qwk download? }
    
    networkmode: Boolean;              { Network mode ? }
    
    SwapTo: Byte;                      { Swap where?    }
    
    res: Array [1..23] Of Byte;         { bleah }
    
    windowon: Boolean;                 { is the sysop window on? }
    regnumber: LongInt;                { registration number }
    
    chatcall: Boolean;                 { Whether system keeps beeping after chat}
    
    packetname: String [8];             { QWK packet name }
    qwkwelcome: String [50];            { QWK welcome file name }
    qwknews: String [50];               { QWK news file name }
    qwkgoodbye: String [50];            { QWK goodbye file name }
    qwklocalpath: String [40];          { QWK path for local usage }
    
    dailylimits: Boolean;              { Daily file limits on/off }
    multinode: Boolean;                { enable multinode support }
    daysonline: Word;                  { days online }
    totalcalls: LongInt;               { incase different from callernum }
    totalusage: LongInt;               { total usage in minutes }
    totalposts: LongInt;               { total number of posts }
    totaldloads: LongInt;              { total number of dloads }
    totaluloads: LongInt;              { total number of uloads }
    
    percall: Boolean;                  { time limits are per call or per day?}
    testuploads: Boolean;              { perform integrity tests on uploads? }
    Origin: String [50];                { Default Origin line }
    Text_Color,                       { color of standard text }
    Quote_Color,                      { color of quoted text }
    Tear_Color,                       { color of tear line }
    Origin_Color: Byte;                { color of origin line }
    SKludge,                          { show kludge lines? }
    SSeenby,                          { show SEEN-BY lines? }
    SOrigin,                          { show origin line? }
    AddTear: Boolean;                  { show tear line? }
    Netattribute: NetAttribs;          { default netmail attribute }
    Aka: Array [0..20] Of Record        { 20 Addresses }
                            zone,                           { 21st is for UUCP address }
                            net,
                            node,
                            point: Word;
                          End;
    DefEchoPath: String [40];           { default echomail path }
    CreditInternetMail: Integer;       { cost for Internet mail }
    crap5: Array [1..372] Of Byte;
    validation: Array ['A'..'Z'] Of
    validationrec;         { Validation records A - Z }
    
    macro: Array [0..9] Of String [100]; { sysop macros }
  End;
  
  smr =                            { SHORTMSG.DAT : One-line messages }
  Record
    msg: astr;
    destin: Integer;
  End;
  
  votingr =                        { VOTING.DAT : Voting records }
  Record
    description: String [65];       { voting question }
    ACS: ACString;                 { ACS required to vote on this }
    choicenumber: Word;            { number of choices }
    numvoted: Word;                { number of votes on it }
    madeby: String [35];            { who created it }
    addchoicesACS: ACString;       { ACS required to add choices }
    choices: Array [1..25] Of
    Record
      description: String [65];     { answer description }
      description2: String [65];    { answer description #2 }
      numvoted: Integer;           { # user's who picked this answer }
    End;
  End;
  
  mbflags =
  (mbunhidden,                   { whether *VISIBLE* to users w/o access }
  mbrealname,                   { whether real names are forced }
  mbcrap,                       { }
  mbinternet,                   { if internet message base }
  mbfilter,                     { whether to filter ANSI/8-bit ASCII }
  mbskludge,                    { strip IFNA kludge lines }
  mbsseenby,                    { strip SEEN-BY lines }
  mbsorigin,                    { strip origin lines }
  mbprivate,                    { allow private messages }
  mbforceread,                  { force the reading of this base }
  mbScanOut,                    { Needs to be scanned out by renemail }
  mbaddtear,                    { add tear/origin lines }
  mbtopstar);                   { whether Top Star for GroupMail base }
  
  boardrec =                       { MBASES.DAT : Message base records }
  Record
    Name: String [40];              { message base description }
    filename: String [8];           { HDR/DAT data filename }
    msgpath: String [40];           { messages pathname   }
    ACS,                          { access requirement }
    postACS,                      { post access requirement }
    mciACS,                       { MCI usage requirement }
    sysopACS: ACString;            { Message base sysop requirement }
    maxmsgs: Word;                 { max message count }
    anonymous: anontyp;            { anonymous type }
    password: String [20];          { base password }
    mbstat: Set Of mbflags;        { message base status vars }
    mbtype: Integer;               { base type (0=Local,1=Echo,2=Group) }
    origin: String [50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color: Byte;            { color of origin line }
    aka: Byte;                     { alternate address }
    QWKIndex: Word;                { QWK indexing number }
    res: Array [1..11] Of Byte;      { RESERVED }
  End;
  
  fbflags =
  (fbnoratio,                    { if <No Ratio> active }
  fbunhidden,                   { whether *VISIBLE* to users w/o access }
  fbdirdlpath,                  { if *.DIR file stored in DLPATH }
  fbshowname,                   { show uploaders in listings }
  fbusegifspecs,                { whether to use GifSpecs }
  fbcdrom,                      { base is read only, no sorting or ul scanning }
  fbshowdate);                  { show date uploaded in listings }
  
  ulrec =                          { FBASES.DAT  : File base records }
  Record
    Name: String [40];              { area description  }
    filename: String [12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath: String [40];            { upload path       }
    maxfiles: Word;                { max files allowed }
    password: String [20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype: Byte;                 { wanted comment type (1..3,0=inactive) }
    res1: Integer;                 { not used }
    fbstat: Set Of fbflags;        { file base status vars }
    ACS,                          { access requirements }
    ulACS,                        { upload requirements }
    dlACS: ACString;               { download requirements }
    res: Array [1..10] Of Byte;     { RESERVED }
  End;
  
  filstat =
  (notval,                       { if file is NOT validated }
  isrequest,                    { if file is REQUEST }
  resumelater,                  { if file is RESUME-LATER }
  hatched);                     { has file been hatched? }
  
  ulfrec =                         { *.DIR : File records }
  Record
    filename: String [12];          { Filename }
    description: String [60];       { File description }
    credits: Integer;              { File points }
    downloaded: Word;              { Number DLs }
    sizemod: Byte;                 { # chars over last 128 byte block }
    blocks: Word;                  { # 128 byte blks }
    owner: Word;                   { ULer of file }
    stowner: String [36];           { ULer's name }
    date: String [8];               { Date ULed }
    daten: Word;                   { Numeric date ULed }
    vpointer: LongInt;             { Pointer to verbose descr, -1 if none }
    filestat: Set Of filstat;      { File status }
    res: Array [1..10] Of Byte;     { RESERVED }
  End;
  
  verbrec =                        { EXTENDED.DAT: Extendeddescriptions }
  Record
    descr: Array [1..4] Of String [50];
  End;
  
  lcallers =                       { LASTON.DAT : Last few callers records }
  Record
    callernum: LongInt;            { system caller number }
    Name: String [36];              { user name of caller }
    number: Word;                  { user number of caller }
    citystate: String [30];         { city/state of caller }
    baud: String [5];               { baud of caller }
    timeon: String [8];             { time logged on }
    daynum: Word;                  { day num logged on }
    wasnew: Boolean;               { was it a new user? }
  End;
  
  eventrec =                       { EVENTS.DAT : Event records }
  Record
    active: Boolean;               { whether active }
    description: String [30];       { event description }
    etype: Char;                   { ACS,Chat,Dos,External,Pack Msgs,Sort Files }
    execdata: String [20];          { errorlevel if "E", commandline if "D" }
    softevent,                    { event runs whenever "convenient" }
    missed,                       { run even even if missed }
    monthly,                      { monthly event? }
    busyduring: Boolean;           { busy phone DURING event? }
    exectime,                     { time of execution }
    durationorlastday: Integer;    { length of time event takes }
    offhooktime,                  { off-hook time before; 0 if none }
    Enode,                        { node number to execute on (0 = all) }
    execdays: Byte;                { bitwise execution days or day of month if monthly }
  End;
  
  mnuflags =
  (clrscrbefore,                 { C: clear screen before menu display }
  dontcenter,                   { D: don't center the menu titles! }
  nomenuprompt,                 { N: no menu prompt whatsoever? }
  forcepause,                   { P: force a pause before menu display? }
  autotime,                     { T: is time displayed automatically? }
  forceline,                    { F: Force full line input }
  NoGenericAnsi,                { 1: DO NOT generate generic prompt if ANSI }
  NoGenericAvatar,              { 2: DO NOT generate generic prompt if AVT  }
  NoGenericRIP,                 { 3: DO NOT generate generic prompt if RIP  }
  NoGlobalDisplayed,            { 4: DO NOT display the global commands!    }
  NoGlobalUsed);                { 5: DO NOT use global commands!            }
  
  menurec =                        { *.MNU : Menu records }
  Record
    menuname: Array [1..3] Of String [100]; { menu name }
    directive,                           { help file displayed }
    longmenu: String [12];                 { displayed in place of long menu }
    menuprompt: String [120];              { menu prompt }
    ACS: ACString;                        { access requirements }
    password: String [15];                 { password required }
    fallback: String [8];                  { fallback menu }
    forcehelplevel: Byte;                 { forced help level for menu }
    gencols: Byte;                        { generic menus: # of columns }
    gcol: Array [1..3] Of Byte;            { generic menus: colors }
    menuflags: Set Of mnuflags;           { menu status variables }
  End;
  
  cmdflags =
  (Hidden,                       { H: is command ALWAYS hidden? }
  unhidden);                    { U: is command ALWAYS visible? }
  
  commandrec =                       { *.MNU : Command records }
  Record
    ldesc: String [70];               { long command description }
    sdesc: String [35];               { short command description }
    ckeys: String [14];               { command-execution keys }
    ACS: ACString;                   { access requirements }
    cmdkeys: String [2];              { command keys: type of command }
    options: String [50];             { MString: command data }
    commandflags: Set Of cmdflags;   { command status variables }
  End;
  
  xbflags =
  (xbactive,
  xbisbatch,
  xbisresume,
  xbxferokcode,
  xbbidirectional,
  xbreliable);
  
  protrec =                          { PROTOCOL.DAT records }
  Record
    xbstat: Set Of xbflags;                       { protocol flags }
    ckeys: String [14];                            { command keys }
    descr: String [40];                            { description }
    ACS: ACString;                                { access string }
    templog: String [25];                          { temp. log file }
    uloadlog, dloadlog: String [25];                { permanent log files }
    ulcmd, dlcmd: String [78];                      { UL/DL commandlines }
    ulcode, dlcode: Array [1..6] Of String [6];     { UL/DL codes }
    envcmd: String [60];                           { environment setup cmd }
    dlflist: String [25];                          { DL file lists }
    maxchrs: Integer;                             { max chrs in cmdline }
    logpf, logps: Integer;                         { pos in log file for data }
    res: Array [1..15] Of Byte;                    { RESERVED }
  End;
  
  confrec =            { CONFRENC.DAT : Conference data }
  Record
    conference: Array ['@'..'Z'] Of
    Record
      ACS: ACString;       { access requirement }
      Name: String [40];    { name of conference }
    End;
  End;
  
  nodeflags =
  (NActive,                 { Is this node active?               }
  NAvail,                  { Is this node's user available?     }
  NUpdate,                 { This node should re-read it's user }
  NHangup,                 { Hangup on this node                }
  NRecycle,                { Recycle this node to the OS        }
  NInvisible);             { This node is Invisible             }
  
  noderec =                         { MULTNODE.DAT }
  Record
    User: Word;                                 { What user number     }
    UserName: String [36];                       { User's name }
    CityState: String [30];                      { User's location }
    Sex: Char;                                  { User's sex }
    Age: Byte;                                  { User's age }
    LogonTime: LongInt;                         { What time they logged on }
    Activity: Byte;                             { What are they doing? }
    Description: String [20];                    { Optional string }
    Status: Set Of nodeflags;
    Room: Byte;                                 { What room are they in?      }
    Channel: Word;                              { What channel are they in?   }
    Invited: Array [0..31] Of Set Of 0..7;       { Have they been invited ?    }
    Booted: Array [0..31] Of Set Of 0..7;        { Have they been kicked off ? }
    Forget: Array [0..31] Of Set Of 0..7;        { Who are they forgetting?    }
  End;
  
  RoomRec =                         { ROOM.DAT }
  Record
    Topic: String [40];            { Set by a /T or something    }
    Anonymous: Boolean;           { Is Room anonymous ?         }
    Private: Boolean;             { Is Room private ?           }
    Moderator: Word;              { Who's the moderator?        }
    People: Byte;                 { Number of people in Room    }
  End;
  
  scanrec =                         { *.SCN files }
  Record
    NewScan: Boolean;             { Scan this base? }
    LastRead: LongInt;            { Last date read  }
  End;
  
  SchemeRec =                       { Scheme.dat }
  Record
    Description: String [30];       { Description of the color scheme }
    Color: Array [1..200] Of Byte;  { Colors in scheme }
  End;
  
  { 1 - 10 system colors
  11 -   file list colors
  28 -   msg list colors
  45 -   file area list colors
  55 -   msg area list colors
  65 -   user list colors
  80 -   who's online colors
  100-   last on colors
  115-   qwk colors
  135-   email colors
  }
  
  