/* The following makes MD default to MD5 if it has not already been
  defined with C compiler flags.
 */
#ifndef MD
#define MD 5
#endif

#include <stdio.h>
#include <time.h>
#include <string.h>
#include "global.h"
#include "md5.h"

static void parseKey PROTO_LIST ((char *));
static void printMD5 PROTO_LIST ((unsigned char [16]));

unsigned char key[16];
unsigned int keylen;
unsigned char mstci_table[8192];

/*
 * Usage: mstci 0x1234567890abcdef1234567890abcdef
 *
 * the single argument is taken to be a hex string for the key value.
 * the 0x is expected to appear in the hex string
 */
int main (argc, argv)
int argc;
char *argv[];
{
  int i;
  unsigned char digest[16];

  keylen = 0; 

  if (argc > 1) {
      for (i = 1; i < argc; i++) {
       if (argv[i][0] == '0' && argv[i][1] == 'x')
	 parseKey (argv[i] + 2);
       }
  } 

  /*
   * All VIDs Mapped to the CIST.  NOTE: first and last entry are set to 0
   */
  for (i=0;i<4096;++i) {
	mstci_table[i*2] = 0;
	mstci_table[i*2+1] = 0;
  }

  hmac_md5(mstci_table, 8192, key, keylen, &digest);
  printf("digest =   ");
  printMD5(digest);
  printf("\n");

  /*
   * ALl VIDs Mapped to MSTID 1.  NOTE: first and last entry left at 0
   */
  for (i=1;i<4095;++i) {
	mstci_table[i*2] = 0;
	mstci_table[i*2+1] = 1;
  } 

  hmac_md5(mstci_table, 8192, key, keylen, &digest);
  printf("digest =   ");
  printMD5(digest);
  printf("\n");

  /*
   * Every VID Maps to MSTID equal to (VID modulo 32) + 1
   */
  for (i=1;i<4095;++i) {
	mstci_table[i*2] = ((i % 32) + 1) >> 8;
	mstci_table[i*2+1] = ((i % 32) + 1) & 0xff;
  }

  hmac_md5(mstci_table, 8192, key, keylen, &digest);
  printf("digest =   ");
  printMD5(digest);
  printf("\n");

  return (0);
}

/* Digests a key and its length
 */
static void parseKey (string)
char *string;
{
  int i;
  char *sp;
  char b;
  unsigned char oct;

  keylen = strlen (string) >> 1;
  sp = string;

  for (i=0;i<keylen;++i) {
	b = (char)toupper(*sp++);
	if ( (b >= 'A') && (b <= 'F') )
		oct = (unsigned char)(b - 55);
	else if ( (b >= '0' ) && (b <= '9') )
		oct = (unsigned char)(b - 48);
	else {
		printf("\nBad Input\n");
		oct = 0;
	}
	oct <<= 4;
	b = (char)toupper(*sp++);
	if ( (b >= 'A') && (b <= 'F') )
		oct |= (unsigned char)(b - 55);
	else if ( (b >= '0' ) && (b <= '9') )
		oct |= (unsigned char)(b - 48);
	else {
		printf("\nBad Input\n");
		oct = 0;
	}
	key[i] = oct;
    }

  printf("\n"); 
  printf("Key len = %d, Key = ", keylen);
  printMD5(key);
  printf("\n\n");
}

/* 
 * Prints a message digest in hexadecimal.
 */
static void printMD5 (digest)
unsigned char digest[16];
{
    unsigned int i;

    for (i = 0; i < 16; i++)
	printf ("%02x", digest[i]);
}
