/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Optics.POWER_MAX_VALUE;
import cerent.cms.idl.Optics.POWER_MIN_VALUE;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sParameterValue;
import cerent.cms.model.ANS.ANSValue;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RamanModuleModel;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.EMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeANS
implements POWER_MIN_VALUE,
POWER_MAX_VALUE {
    public static final String FILE_VERSION_PARAM = "dwdm.version";
    public static final int FILE_VERSION_VAL = 3;
    public static final String FILE_VERSION_STR_VAL = "3.0";
    private static Map<eParamType, ANSParamDetails> typemap = new HashMap<eParamType, ANSParamDetails>();
    private static Map<String, ANSParamDetails> mpnamemap = new HashMap<String, ANSParamDetails>();
    private static Set<Attribute> spectrumGranularities;

    public static synchronized Attribute[] getAllParamTypes() {
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        for (eParamType eParamType2 : typemap.keySet()) {
            ANSParamDetails aNSParamDetails = typemap.get(eParamType2);
            if (!aNSParamDetails.isManageable) continue;
            hashSet.add(new Attribute(aNSParamDetails.getCTCName(), eParamType2.value()));
        }
        return hashSet.toArray(new Attribute[0]);
    }

    public static synchronized ANSParamDetails getANSParamDetails(eParamType eParamType2) {
        return typemap.get(eParamType2);
    }

    public static synchronized ANSParamDetails getANSParamDetails(sParameterKey sParameterKey2) {
        return typemap.get(sParameterKey2.type);
    }

    public static synchronized ANSParamDetails getANSParamDetails(String string) {
        return mpnamemap.get(string);
    }

    public static synchronized Attribute[] getAllSpectrumGranularities() {
        return spectrumGranularities.toArray(new Attribute[0]);
    }

    static {
        new ANSParamDetails(eParamType.TY_NETWORKTYPE, "Network Type", "NetworkType", new ANSEnumValue(new String[]{"Metro-Core", "Not-DWDM"}, 1), true, false);
        new ANSParamDetails(eParamType.TY_WXC_DITHER_VALUE, "WXC Dithering", "Dithering", new ANSIntegerRangeValue(0, 33), true, true);
        new ANSParamDetails(eParamType.TY_MINEXPSPANLOSS, "Min Expected Span Loss", "MinExpSpanLoss", (ANSValue)new ANSDBFloatValue(0.0f, 60.0f), new LineInFilter());
        new ANSParamDetails(eParamType.TY_MAXEXPSPANLOSS, "Max Expected Span Loss", "MaxExpSpanLoss", (ANSValue)new ANSDBFloatValue(0.0f, 60.0f), new LineInFilter());
        new ANSParamDetails(eParamType.TY_WRKMODE, "Amplifier Working Mode", "WkgMode", (ANSValue)new ANSEnumValue(new String[]{"Control Power", "Control Gain"}), new AmplPortFilter());
        new ANSParamDetails(eParamType.TY_CHPWR, "Power", "ChPwr", (ANSValue)new ANSDBmFloatValue(-30.0f, 50.0f));
        new ANSParamDetails(eParamType.TY_GAIN, "Amplifier Gain", "Gain", (ANSValue)new ANSDBFloatValue(0.0f, 40.0f), new GainPortFilter());
        new ANSParamDetails(eParamType.TY_TILT, "Amplifier Tilt", "Tilt", (ANSValue)new ANSDBFloatValue(-15.0f, 15.0f), new OTSPortFilter());
        new ANSParamDetails(eParamType.TY_OSCLOSS, "OSC LOS Threshold", "OscLossTh", (ANSValue)new ANSDBmFloatValue(-50.0f, 30.0f), new OSCThPortFilter());
        new ANSParamDetails(eParamType.TY_OSC, "OSC Power", "OscPower", (ANSValue)new ANSDBmFloatValue(-24.0f, 0.0f), new OSCPowerPortFilter());
        new ANSParamDetails(eParamType.TY_CHLOSS, "Channel LOS Threshold", "ChLossTh", (ANSValue)new ANSDBmFloatValue(-50.0f, 30.0f));
        new ANSParamDetails(eParamType.TY_VOA, "VOA Attenuation", "VoaAttenuation", (ANSValue)new ANSDBFloatValue(0.0f, 30.0f), new VOAPortFilter());
        new ANSParamDetails(eParamType.TY_RATIO, "Raman Ratio", "Ratio", (ANSValue)new ANSPercentageValue(), new RamanPortFilter());
        new ANSParamDetails(eParamType.TY_TOTAL_PWR, "Raman Total Power", "RamanTotalPower", (ANSValue)new ANSmWFloatValue(), new RamanPortFilter());
        spectrumGranularities = new HashSet<Attribute>();
        spectrumGranularities.add(new Attribute("OTS", 1));
        spectrumGranularities.add(new Attribute("OCH", 3));
    }

    public static class ANSParamDetails {
        private final eParamType type;
        private final String ctcName;
        private final String mpName;
        private final ANSValue value;
        private final boolean isNode;
        private final boolean hasGranularity;
        private final boolean isManageable;
        private final IntPatchHelper.PortFilter filter;

        private ANSParamDetails(eParamType eParamType2, String string, String string2, ANSValue aNSValue, boolean bl, boolean bl2, boolean bl3, IntPatchHelper.PortFilter portFilter) {
            this.type = eParamType2;
            this.ctcName = string;
            this.mpName = string2;
            this.value = aNSValue;
            this.isNode = bl;
            this.hasGranularity = bl2;
            this.isManageable = bl3;
            this.filter = portFilter;
            typemap.put(eParamType2, this);
            mpnamemap.put(string2, this);
        }

        private ANSParamDetails(eParamType eParamType2, String string, String string2, ANSValue aNSValue, boolean bl, boolean bl2) {
            this(eParamType2, string, string2, aNSValue, bl, false, bl2, new OpticalPortFilter());
        }

        private ANSParamDetails(eParamType eParamType2, String string, String string2, ANSValue aNSValue, boolean bl, IntPatchHelper.PortFilter portFilter) {
            this(eParamType2, string, string2, aNSValue, false, bl, true, portFilter);
        }

        private ANSParamDetails(eParamType eParamType2, String string, String string2, ANSValue aNSValue, IntPatchHelper.PortFilter portFilter) {
            this(eParamType2, string, string2, aNSValue, false, portFilter);
        }

        private ANSParamDetails(eParamType eParamType2, String string, String string2, ANSValue aNSValue) {
            this(eParamType2, string, string2, aNSValue, true, new OpticalPortFilter());
        }

        public ANSValue getDefaultANSValue() {
            return this.value.cloneValue();
        }

        public ANSValue getANSValue(sParameterValue sParameterValue2) {
            ANSValue aNSValue = this.value.cloneValue();
            aNSValue.setValue(sParameterValue2);
            return aNSValue;
        }

        public ANSValue getANSValue(String string) throws ProvisionError {
            ANSValue aNSValue = this.value.cloneValue();
            aNSValue.setValue(string);
            return aNSValue;
        }

        public eParamType getParamType() {
            return this.type;
        }

        public String getCTCName() {
            return this.ctcName;
        }

        public String[] getCTCFullPath(INodeModel iNodeModel, sParameterKey sParameterKey2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (sParameterKey2.paramLocation != 0) {
                try {
                    IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(sParameterKey2.paramLocation);
                    arrayList.addAll(new EntityCellRenderer().getFullPortStringPath(iEntityModel, false, false));
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.hasGranularity() && (sParameterKey2.spectrum.equals(eSpectrumGranularity.SP_OCH) || !sParameterKey2.spectrum.equals(eSpectrumGranularity.SP_UNKNOWN) && !sParameterKey2.spectrum.equals(this.getDefaultGranularityForPort(iNodeModel, sParameterKey2.paramLocation)))) {
                arrayList.add("WL " + Wavelength.getWavelengthStringFromWavelength(sParameterKey2.spectrumIndex));
            }
            arrayList.add(this.ctcName);
            return arrayList.toArray(new String[0]);
        }

        public String getPMName() {
            return this.mpName;
        }

        public boolean isNodeParam() {
            return this.isNode;
        }

        public boolean isPortParam() {
            return !this.isNode;
        }

        public boolean hasGranularity() {
            return this.hasGranularity;
        }

        public boolean hasGranularity(IEntityModel iEntityModel) {
            if (this.hasGranularity) {
                int n = iEntityModel.getEqType();
                switch (n) {
                    case 304: 
                    case 305: {
                        try {
                            OpticalPortType opticalPortType = ((OpticsPortModel)iEntityModel).getOptPortType();
                            return !opticalPortType.equals(OpticalPortType.OUT_OSC) && !opticalPortType.equals(OpticalPortType.IN_OSC);
                        }
                        catch (Exception exception) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    case 307: {
                        return true;
                    }
                    case 306: {
                        return false;
                    }
                }
            }
            return false;
        }

        private eSpectrumGranularity getDefaultGranularityForPort(INodeModel iNodeModel, int n) {
            try {
                return this.getDefaultGranularityForPort(iNodeModel.getEntityTable().getEntityModelByIndex(n));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return eSpectrumGranularity.SP_UNKNOWN;
            }
        }

        public eSpectrumGranularity getDefaultGranularityForPort(IEntityModel iEntityModel) {
            int n = iEntityModel.getEqType();
            eSpectrumGranularity eSpectrumGranularity2 = eSpectrumGranularity.SP_UNKNOWN;
            switch (n) {
                case 304: 
                case 305: 
                case 307: {
                    eSpectrumGranularity2 = eSpectrumGranularity.SP_OTS;
                    break;
                }
                case 306: {
                    eSpectrumGranularity2 = eSpectrumGranularity.SP_OCH;
                }
            }
            return eSpectrumGranularity2;
        }

        public eSpectrumGranularity getDefaultGranularity(INodeModel iNodeModel, int n) {
            if (n != 0) {
                return this.getDefaultGranularityForPort(iNodeModel, n);
            }
            return eSpectrumGranularity.SP_UNKNOWN;
        }

        public int getDefaultSpectrumIndex(INodeModel iNodeModel, int n) {
            if (n != 0) {
                try {
                    return this.getDefaultSpectrumIndex(iNodeModel.getEntityTable().getEntityModelByIndex(n));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return 0;
        }

        public int getDefaultSpectrumIndex(IEntityModel iEntityModel) {
            eSpectrumGranularity eSpectrumGranularity2 = this.getDefaultGranularityForPort(iEntityModel);
            if (eSpectrumGranularity2.equals(eSpectrumGranularity.SP_OCH)) {
                try {
                    return ((IOpticsPortModel)iEntityModel).getWaveLength();
                }
                catch (WrongPortType wrongPortType) {
                    SDebug.printStackTrace((Throwable)wrongPortType);
                }
            }
            return 0;
        }

        public IEntityModel[] getOpticalPorts(INodeModel iNodeModel) {
            return IntPatchHelper.getOpticalPorts(iNodeModel, this.filter);
        }

        public String toString() {
            return this.ctcName + ", value=[" + this.value + "]";
        }
    }

    private static class VOAPortFilter
    extends OpticalPortFilter {
        VOAPortFilter() {
            this.porttype.add(eEqType.OCH_PORT);
            this.porttype.add(eEqType.OMS_PORT);
            this.features = 1;
            this.or.add(new OTSPortFilter());
        }
    }

    private static class LineInFilter
    extends OTSPortFilter {
        LineInFilter() {
            this.rxonly = true;
            this.optype.add(OpticalPortType.IN_LINE);
            this.optype.add(OpticalPortType.IN_COM);
            this.notOfEqtype.add(eEqType.PSM_LINE_CARD);
            OpticalPortFilter opticalPortFilter = new OpticalPortFilter();
            opticalPortFilter.rxonly = true;
            opticalPortFilter.optype.add(OpticalPortType.IN_WRK);
            opticalPortFilter.optype.add(OpticalPortType.IN_PROT);
            opticalPortFilter.eqtype.add(eEqType.PSM_LINE_CARD);
            this.or.add(opticalPortFilter);
        }
    }

    private static class RamanTxPortFilter
    extends OTSPortFilter {
        RamanTxPortFilter() {
            this.parentClass = RamanModuleModel.class;
            this.optype.add(OpticalPortType.OUT_RAMAN);
        }
    }

    private static class RamanPortFilter
    extends OTSPortFilter {
        RamanPortFilter() {
            this.optype.add(OpticalPortType.IN_RAMAN);
            this.optype.add(OpticalPortType.OUT_RAMAN);
        }
    }

    private static class OSCThPortFilter
    extends OTSPortFilter {
        OSCThPortFilter() {
            this.rxonly = true;
            this.optype.add(OpticalPortType.IN_LINE);
            this.optype.add(OpticalPortType.IN_COM);
            this.notOfEqtype.add(eEqType.PSM_LINE_CARD);
        }
    }

    private static class OSCPowerPortFilter
    extends OTSPortFilter {
        OSCPowerPortFilter() {
            this.features = 262144;
        }
    }

    private static class OTSPortFilter
    extends OpticalPortFilter {
        OTSPortFilter() {
            this.porttype.add(eEqType.AOTS_PORT);
            this.porttype.add(eEqType.OTS_PORT);
        }
    }

    private static class GainPortFilter
    extends OpticalPortFilter {
        GainPortFilter() {
            this.parentNotOfClass = RamanModuleModel.class;
            this.porttype.add(eEqType.AOTS_PORT);
            this.or.add(new RamanTxPortFilter());
        }
    }

    private static class AmplPortFilter
    extends OpticalPortFilter {
        AmplPortFilter() {
            this.porttype.add(eEqType.AOTS_PORT);
        }
    }

    private static class OpticalPortFilter
    extends IntPatchHelper.PortFilter {
        OpticalPortFilter() {
            this.parentNotOfClass = PassiveModuleModel.class;
        }
    }

    private static class ANSmWFloatValue
    extends ANSFloatValue {
        ANSmWFloatValue() {
            this(100, 450);
        }

        ANSmWFloatValue(int n, int n2) {
            super("mW", n, (float)n2);
        }
    }

    private static class ANSIntegerRangeValue
    extends ANSIntegerValue {
        ANSIntegerRangeValue(int n, int n2) {
            this("", n, n2);
        }

        ANSIntegerRangeValue(String string, int n, int n2) {
            super(string, n, n2, 3);
        }

        public ANSValue cloneValue() {
            return new ANSIntegerRangeValue(this.getUnits(), this.low, this.high);
        }

        public String[] getValidEnumValues() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = this.low; i <= this.high; ++i) {
                arrayList.add(Integer.toString(i));
            }
            return arrayList.toArray(new String[0]);
        }
    }

    private static class ANSIntegerValue
    extends ANSValue {
        protected int low;
        protected int high;

        ANSIntegerValue(int n, int n2) {
            this("", n, n2);
        }

        ANSIntegerValue(String string, int n, int n2) {
            this(string, n, n2, 6);
        }

        protected ANSIntegerValue(String string, int n, int n2, int n3) {
            super(Integer.toString(n), string, n3);
            if (n < n2) {
                this.low = n;
                this.high = n2;
            } else {
                this.low = n2;
                this.high = n;
            }
        }

        public void checkValue(String string) throws ProvisionError {
            try {
                int n = Integer.parseInt(string);
                if (n < this.low || n > this.high) {
                    throw new ProvisionError(EMC.EID_OUT_OF_RANGE_VALUE_PARAM_3, new Object[]{string, Integer.toString(this.low), Integer.toString(this.high)});
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(EMC.EID_MUST_BE_INTEGER_RANGE_PARAM_3, new Object[]{string, Integer.toString(this.low), Integer.toString(this.high)});
            }
        }

        public int getIntValue() {
            return Integer.parseInt(this.getValue());
        }

        public ANSValue cloneValue() {
            return new ANSIntegerValue(this.getUnits(), this.low, this.high);
        }

        public String getValidRange() {
            return Integer.toString(this.low) + ".." + Integer.toString(this.high);
        }

        public void setValue(sParameterValue sParameterValue2) {
            this.initValue(Integer.toString(sParameterValue2.currentValue));
            this.low = sParameterValue2.range.lowValue;
            this.high = sParameterValue2.range.hiValue;
        }
    }

    private static class ANSEnumValue
    extends ANSValue {
        private final List<String> validEnumValues;
        private final int offset;

        ANSEnumValue(String[] stringArray) {
            this(stringArray, 0);
        }

        ANSEnumValue(String[] stringArray, int n) {
            super(stringArray[0], "", 2);
            this.validEnumValues = Arrays.asList(stringArray);
            this.offset = n;
        }

        public void checkValue(String string) throws ProvisionError {
            if (this.validEnumValues.indexOf(string) > -1) {
                return;
            }
            throw new ProvisionError(EMC.EID_NOT_ENUM_VALUE_PARAM_1, new Object[]{string});
        }

        public int getIntValue() {
            return this.validEnumValues.indexOf(this.getValue()) + this.offset;
        }

        public ANSValue cloneValue() {
            return new ANSEnumValue(this.validEnumValues.toArray(new String[0]), this.offset);
        }

        public String[] getValidEnumValues() {
            return this.validEnumValues.toArray(new String[0]);
        }

        public void setValue(sParameterValue sParameterValue2) {
            this.initValue(this.validEnumValues.get(sParameterValue2.currentValue - this.offset));
        }
    }

    private static class ANSPercentageValue
    extends ANSFloatValue {
        ANSPercentageValue() {
            super("%", 0.0f, 100.0f);
        }
    }

    private static class ANSDBFloatValue
    extends ANSFloatValue {
        ANSDBFloatValue() {
            super("dB", 0.0f, 50.0f);
        }

        ANSDBFloatValue(float f, float f2) {
            super("dB", f, f2);
        }
    }

    private static class ANSDBmFloatValue
    extends ANSFloatValue {
        ANSDBmFloatValue() {
            super("dBm", -50.0f, 50.0f);
        }

        ANSDBmFloatValue(float f, float f2) {
            super("dBm", f, f2);
        }
    }

    private static class ANSFloatValue
    extends ANSValue {
        private float loval;
        private float hival;

        ANSFloatValue(String string, float f, float f2) {
            super("0.0", string, 0);
            this.loval = f;
            this.hival = f2;
        }

        public void checkValue(String string) throws ProvisionError {
            try {
                float f = Float.parseFloat(string);
                if (f < this.loval || f > this.hival) {
                    throw new ProvisionError(EMC.EID_OUT_OF_RANGE_VALUE_PARAM_3, new Object[]{string, Float.toString(this.loval), Float.toString(this.hival)});
                }
                if (!this.checkdecimalNum(f)) {
                    throw new ProvisionError(EMC.EID_TOO_MANY_DECIMAL_DIGITS_PARAM_1, new Object[]{string});
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(EMC.EID_MUST_BE_FLOAT_RANGE_PARAM_3, new Object[]{string, Float.toString(this.loval), Float.toString(this.hival)});
            }
        }

        public int getIntValue() {
            return (int)(Float.parseFloat(this.getValue()) * 10.0f);
        }

        public ANSValue cloneValue() {
            return new ANSFloatValue(this.getUnits(), this.loval, this.hival);
        }

        public String getValidRange() {
            return Float.toString(this.loval) + ".." + Float.toString(this.hival);
        }

        public void setValue(sParameterValue sParameterValue2) {
            super.initValue(Float.toString((float)sParameterValue2.currentValue / 10.0f));
            this.loval = sParameterValue2.range.lowValue / 10;
            this.hival = sParameterValue2.range.hiValue / 10;
        }

        private boolean checkdecimalNum(float f) {
            if (f < 0.0f || f > 0.0f) {
                return f * 10.0f % (float)((int)(f * 10.0f)) == 0.0f;
            }
            return true;
        }
    }
}

