/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.EntityTable;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.idl.Equipment.xInvalidData;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IChassisModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ShelfInfo;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.omg.CORBA.UserException;

public class ChassisModels
extends Model
implements IChassisModels {
    public static final short MAX_RACKS = 12;
    public static final short MAX_BAYS = 49;
    private NodeModelDelegate nmd;
    private Object chassisMapLock = new Object();
    private HashMap<Integer, IChassisModel> chassisMap;
    private HashMap<Integer, IShelfViewModel> allChassisMap;
    private EventDispatcher dispatcher;
    private ShelfInfoList shelfInfoList;
    private ObservableManager observableManager;
    private final MsLayoutMgr layoutMgr;
    private ChassisIndex chassisIndex = new ChassisIndex();
    private static NodeSingletonFactory<ChassisModels> sfactory = new NodeSingletonFactory<ChassisModels>(ChassisModels.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChassisModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(ChassisModels.class, ChassisModelsDebug.class, this));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        Object object = this.chassisMapLock;
        synchronized (object) {
            this.chassisMap = new HashMap(12);
            this.allChassisMap = new HashMap(12);
        }
        this.shelfInfoList = new ShelfInfoList(this.nmd, "ChassisModels.shelfInfoList");
        this.observableManager = new ObservableManager(this, false);
        this.observableManager.setPassing(true);
        this.layoutMgr = new MsLayoutMgr(this);
    }

    public static ChassisModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    protected void updateLocal() {
        this.db.fine("updateLocal() ");
        Exception exception = this.updateCV(this.shelfInfoList);
        if (exception != null) {
            this.db.severe("updateLocal caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        int n;
        this.db.fine("Got update from = " + observable + " arg = " + object);
        int n2 = -1;
        if (object instanceof IObjectMessageInfo) {
            IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
            n = iObjectMessageInfo.getUpdateType();
            n2 = iObjectMessageInfo.getChildIndex();
        } else {
            n = (Integer)object;
        }
        switch (n) {
            case 2: {
                if (observable instanceof IShelfViewModel) break;
                this.addChassis(n2);
                break;
            }
            case 0: {
                try {
                    if (!(observable instanceof IShelfViewModel)) break;
                    this.removeChassis((IShelfViewModel)((Object)observable));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.warning("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in update.");
                }
                break;
            }
            case 1: {
                this.updateLocal();
                break;
            }
            default: {
                this.db.warning("Unknown update type: " + n);
            }
        }
    }

    public void init() {
        super.init0();
        this.observableManager.setActive(true);
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectChassisList, 1, (Observer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Exception exception;
        this.observableManager.reset();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectChassisList, 1, (Observer)this);
        }
        if ((exception = this.disposeCV(this.shelfInfoList)) != null) {
            this.db.severe("dispose caught " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        Object object = this.chassisMapLock;
        synchronized (object) {
            this.allChassisMap.clear();
            this.chassisMap.clear();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChassis(IShelfViewModel iShelfViewModel) {
        Integer n = new Integer(iShelfViewModel.getShelfId());
        Object object = this.chassisMapLock;
        synchronized (object) {
            IShelfViewModel iShelfViewModel2 = this.allChassisMap.get(n);
            if (iShelfViewModel2 != null && iShelfViewModel2 != iShelfViewModel) {
                this.db.warning("WARNING: Chassis with shelf ID " + n + " already exists!");
                this.observableManager.removeObservable((Observable)((Object)((Model)((Object)iShelfViewModel2))));
            } else if (iShelfViewModel2 == null) {
                this.db.fine("Adding " + iShelfViewModel + " #" + n);
                this.allChassisMap.put(n, iShelfViewModel);
                if (iShelfViewModel instanceof IChassisModel) {
                    this.chassisMap.put(n, (IChassisModel)iShelfViewModel);
                }
                this.observableManager.addObservable((Observable)((Object)((Model)((Object)iShelfViewModel))));
            } else {
                this.db.fine("No op: " + iShelfViewModel2 + " == " + iShelfViewModel);
            }
        }
        this.updateCV(this.shelfInfoList);
        object = iShelfViewModel.getShelfInfo();
        if (object != null) {
            this.setChanged();
            this.notifyObservers(new ChassisModelUpdate(iShelfViewModel, 2, ((ShelfInfo)object).getRackNum(), ((ShelfInfo)object).getRackPos()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChassis(IShelfViewModel iShelfViewModel) throws AbstractCmsNoSuchEntityException {
        Integer n = new Integer(iShelfViewModel.getShelfId());
        Object object = this.chassisMapLock;
        synchronized (object) {
            Model model = (Model)((Object)this.allChassisMap.remove(n));
            this.chassisMap.remove(n);
            this.db.fine("Removing " + model);
            if (model == null) {
                throw new CmsNoSuchEntityException("No chassis with the shelf ID " + n + " exists.");
            }
            this.observableManager.removeObservable((Observable)((Object)model));
        }
        this.updateCV(this.shelfInfoList);
    }

    private void addChassis(int n) {
        block12: {
            this.db.fine("--------- addChassis entry -----------");
            try {
                ChassisModel chassisModel;
                EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
                long l = System.currentTimeMillis();
                EntityTableModel entityTableModel2 = new EntityTableModel(this.nmd);
                entityTableModel2.discoverEntityTableByChassis(n);
                try {
                    chassisModel = (ChassisModel)entityTableModel.getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    chassisModel = null;
                }
                List list = entityTableModel2.getEntityModelsByClass(eClass.CHASSIS);
                if (chassisModel != null) {
                    if (this.db.isFineEnabled()) {
                        this.db.fine("undelete chassis: index=0x" + Integer.toHexString(n));
                    }
                    chassisModel.updateStructure(entityTableModel2, l);
                    this.addChassis(chassisModel);
                } else {
                    if (this.db.isFineEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("adding chassis: index=0x");
                        stringBuffer.append(Integer.toHexString(n));
                        stringBuffer.append(" length=");
                        stringBuffer.append(list.size());
                        for (ChassisModel chassisModel2 : list) {
                            stringBuffer.append(" 0x");
                            stringBuffer.append(Integer.toHexString(chassisModel2.getIndex()));
                        }
                        this.db.fine(stringBuffer.toString());
                    }
                    for (Object object : list) {
                        ((EntityModel)object).updateStructure(entityTableModel2, l);
                        this.addChassis((IShelfViewModel)object);
                        l = System.currentTimeMillis();
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.db.severe("Caught " + illegalStateException + " in addChassis.");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                this.db.severe("Caught " + nullPointerException + " in addChassis");
                if (!this.db.on()) break block12;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChassisModel[] getChassisModelsArray() {
        Collection<IChassisModel> collection;
        Object object = this.chassisMapLock;
        synchronized (object) {
            collection = this.chassisMap.values();
        }
        return collection.toArray(new IChassisModel[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IShelfViewModel[] getShelfViewModels() {
        Collection<IShelfViewModel> collection;
        Object object = this.chassisMapLock;
        synchronized (object) {
            collection = this.allChassisMap.values();
        }
        return collection.toArray(new IShelfViewModel[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IShelfViewModel getShelfViewByShelfId(int n) {
        IShelfViewModel iShelfViewModel;
        Object object = this.chassisMapLock;
        synchronized (object) {
            iShelfViewModel = this.allChassisMap.get(new Integer(n));
        }
        return iShelfViewModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChassisModel getChassisByShelfId(int n) {
        IChassisModel iChassisModel;
        Object object = this.chassisMapLock;
        synchronized (object) {
            iChassisModel = this.chassisMap.get(new Integer(n));
        }
        return iChassisModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IShelfViewModel getChassisByIndex(int n) {
        Object object = this.chassisMapLock;
        synchronized (object) {
            for (Integer n2 : this.allChassisMap.keySet()) {
                IShelfViewModel iShelfViewModel = this.allChassisMap.get(n2);
                if (iShelfViewModel.getShelfIndex() != n) continue;
                return iShelfViewModel;
            }
        }
        return null;
    }

    public IShelfViewModel getChassisByPosition(short s, short s2) {
        if (this.getNodeModel().isMultishelf()) {
            short s3;
            IShelfViewModel iShelfViewModel = this.layoutMgr.get(s, s2);
            if (iShelfViewModel != null && ((s3 = iShelfViewModel.getRackPosition()) == s2 || s3 == s2 - 100 || s3 == s2 - 200)) {
                return iShelfViewModel;
            }
        } else if (s == 1 && s2 == 1) {
            return this.getShelfViewByShelfId(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShelfIdByChassisIndex(int n) {
        int n2 = -1;
        Object object = this.chassisMapLock;
        synchronized (object) {
            for (Integer n3 : this.chassisMap.keySet()) {
                ChassisModel chassisModel = (ChassisModel)this.chassisMap.get(n3);
                if (chassisModel.getEntityIndex() != n) continue;
                n2 = n3;
                break;
            }
        }
        return n2;
    }

    private EntityTable getEntityTableRef() {
        return this.nmd.getIorRepository().getEntityTableRef();
    }

    private sShelfInfoSubset[] getShelfInfoList() {
        try {
            return (sShelfInfoSubset[])this.shelfInfoList.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "ChassisModel.getShelfInfoList", userException);
        }
    }

    protected sShelfInfoSubset getShelfInfoForChassis(IShelfViewModel iShelfViewModel) throws AbstractCmsNoSuchEntityException {
        if (this.getNodeModel().isMultishelf()) {
            sShelfInfoSubset sShelfInfoSubset2 = this.layoutMgr.getUpdatedShelfInfo(iShelfViewModel);
            if (sShelfInfoSubset2 != null) {
                return sShelfInfoSubset2;
            }
        } else {
            return new sShelfInfoSubset(iShelfViewModel.getShelfIndex(), new sShelfPosition(1, 1));
        }
        throw new CmsNoSuchEntityException("No shelf information for " + iShelfViewModel);
    }

    private void setShelfInfoList(sShelfInfoSubset[] sShelfInfoSubsetArray) throws InvalidData, ProvisionError {
        try {
            this.shelfInfoList.set(sShelfInfoSubsetArray);
        }
        catch (xInvalidData xInvalidData2) {
            throw new InvalidData((UserException)xInvalidData2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "ChassisModel.setShelfInfoList", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelfInfo[] getShelfPositions() {
        HashSet<ShelfInfo> hashSet = new HashSet<ShelfInfo>(12);
        Object object = this.chassisMapLock;
        synchronized (object) {
            for (IChassisModel iChassisModel : this.chassisMap.values()) {
                ShelfInfo shelfInfo = iChassisModel.getShelfInfo();
                if (shelfInfo == null) continue;
                shelfInfo.setRackPos(this.layoutMgr.convertToOldPosition(iChassisModel));
                hashSet.add(shelfInfo);
            }
        }
        return hashSet.toArray(new ShelfInfo[0]);
    }

    public void setShelfPositions(ShelfInfo[] shelfInfoArray) throws Exception {
        sShelfInfoSubset[] sShelfInfoSubsetArray = new sShelfInfoSubset[shelfInfoArray.length];
        for (int i = 0; i < shelfInfoArray.length; ++i) {
            IShelfViewModel iShelfViewModel = this.getShelfViewByShelfId(shelfInfoArray[i].getShelfId());
            sShelfInfoSubsetArray[i] = new sShelfInfoSubset(iShelfViewModel.getShelfIndex(), new sShelfPosition(shelfInfoArray[i].getRackNum(), shelfInfoArray[i].getRackPos()));
        }
        this.setShelfInfoList(sShelfInfoSubsetArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelfInfo[] getShelfInfos() {
        HashSet<ShelfInfo> hashSet = new HashSet<ShelfInfo>(12);
        Object object = this.chassisMapLock;
        synchronized (object) {
            for (IShelfViewModel iShelfViewModel : this.allChassisMap.values()) {
                hashSet.add(iShelfViewModel.getShelfInfo());
            }
        }
        return hashSet.toArray(new ShelfInfo[0]);
    }

    public void setShelfInfos(ShelfInfo[] shelfInfoArray) throws Exception {
        sShelfInfoSubset[] sShelfInfoSubsetArray = new sShelfInfoSubset[shelfInfoArray.length];
        for (int i = 0; i < shelfInfoArray.length; ++i) {
            IShelfViewModel iShelfViewModel = this.getShelfViewByShelfId(shelfInfoArray[i].getShelfId());
            sShelfInfoSubsetArray[i] = new sShelfInfoSubset(iShelfViewModel.getShelfIndex(), new sShelfPosition(shelfInfoArray[i].getRackNum(), shelfInfoArray[i].getRackPos()));
        }
        this.layoutMgr.checkAndSaveNewPositions(sShelfInfoSubsetArray);
    }

    public boolean swapChassisPositions(IShelfViewModel iShelfViewModel, short s, short s2) throws InvalidData, ProvisionError {
        return this.layoutMgr.swapPositions(iShelfViewModel, s, s2);
    }

    private int[] getUsedShelfIds() {
        IChassisModel[] iChassisModelArray = this.getChassisModelsArray();
        int[] nArray = new int[iChassisModelArray.length];
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            IChassisModel iChassisModel = iChassisModelArray[i];
            nArray[i] = iChassisModel.getShelfId();
        }
        return nArray;
    }

    public Integer[] getAvailableShelfIds(eEqType eEqType2) {
        if (eEqType2 == eEqType.PASSIVE_CHASSIS || PassiveModuleModel.isEqTypeSupported(eEqType2)) {
            return new Integer[]{0};
        }
        int[] nArray = this.getUsedShelfIds();
        boolean[] blArray = new boolean[12];
        int n = 0;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            blArray[nArray[n] - 1] = true;
        }
        Integer[] integerArray = new Integer[12 - nArray.length];
        for (n = 0; n < 12; ++n) {
            if (blArray[n]) continue;
            integerArray[n2++] = new Integer(n + 1);
        }
        return integerArray;
    }

    public void provisionShelf(short s, short s2, short s3, short s4, short s5, short s6, eEqType eEqType2) throws InvalidData, ProvisionError, NotSupportedOnEquipment, ResourceInUse {
        this.provisionShelf(s, s2, s3, s4, s5, s6, eEqType2, false);
    }

    public void provisionShelf(short s, short s2, short s3, short s4, short s5, eEqType eEqType2) throws InvalidData, ProvisionError, NotSupportedOnEquipment, ResourceInUse {
        this.provisionShelf(s, s2, s3, s4, (short)0, s5, eEqType2, false);
    }

    public void provisionShelf(short s, short s2, short s3, eEqType eEqType2, boolean bl) throws InvalidData, ProvisionError, NotSupportedOnEquipment, ResourceInUse {
        this.provisionShelf(s, s2, s3, (short)0, (short)0, (short)1, eEqType2, bl);
    }

    private void provisionShelf(short s, short s2, short s3, short s4, short s5, short s6, eEqType eEqType2, boolean bl) throws InvalidData, ProvisionError, NotSupportedOnEquipment, ResourceInUse {
        if (s3 != 0 && s3 < 100) {
            s3 = (short)(s3 + (bl ? 200 : 100));
        }
        this.db.fine("Provision shelf #" + s + "/" + eEqType2.value() + " @ " + s2 + "/" + s3 + "/" + s5 + "/" + s4 + "/" + s6);
        if (eEqType2 == eEqType.CHASSIS_454 || eEqType2 == eEqType.CHASSIS_454SDH) {
            this.nmd.getEntityTableModel().provisionShelf(s, s2, s3);
        } else if (eEqType2 == eEqType.PASSIVE_CHASSIS) {
            IShelfViewModel iShelfViewModel = this.getChassisByPosition(s2, s3);
            if (iShelfViewModel != null) {
                this.db.warning("Duplicated chassis, found " + iShelfViewModel.toString());
                throw new InvalidData("Duplicated chassis, found " + iShelfViewModel.toString());
            }
            short s7 = this.chassisIndex.nextIndex(s);
            if (this.getChassisByIndex(s7) != null) {
                this.db.warning("Duplicated chassis index " + s7);
                throw new InvalidData("Duplicated chassis index " + s7);
            }
            iShelfViewModel = new PassiveChassisModel(this.nmd, s7, s2, s3, s4, s6);
            this.addChassis(iShelfViewModel);
        } else if (PassiveModuleModel.isEqTypeSupported(eEqType2)) {
            this.nmd.getEntityTableModel().provisionPassiveModule(0, eEqType2, "", s2, s3, s5);
        } else {
            this.db.warning("Chassis type " + eEqType2.value() + " not supported");
            throw new NotSupportedOnEquipment("Chassis type " + eEqType2.value() + " not supported");
        }
    }

    public static short getChassisHeight(eEqType eEqType2) {
        if (eEqType2 == eEqType.CHASSIS_454) {
            return 12;
        }
        if (eEqType2 == eEqType.CHASSIS_454SDH) {
            return 15;
        }
        if (PassiveModuleModel.isEqTypeSupported(eEqType2)) {
            return PassiveChassisModel.getRUOccupied(eEqType2);
        }
        return 1;
    }

    public static short getMaxRUOccupied(eEqType eEqType2) {
        if (eEqType2 == eEqType.PASSIVE_CHASSIS) {
            return 2;
        }
        return ChassisModels.getChassisHeight(eEqType2);
    }

    public static short convertToRelativeRackPosition(short s) {
        if (s < 100) {
            return (short)(s + 200);
        }
        return s;
    }

    public static short convertToRUPosition(short s) {
        if (s < 100) {
            return (short)(s + 100);
        }
        return s;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntityModel getEntityByShelfId(int n) {
        IShelfViewModel iShelfViewModel;
        Object object = this.chassisMapLock;
        synchronized (object) {
            iShelfViewModel = this.chassisMap.get(new Integer(n));
        }
        return iShelfViewModel instanceof IEntityModel ? (IEntityModel)iShelfViewModel : null;
    }

    private class ChassisIndex {
        private static final short MIN = 1000;
        private static final short MAX = 2000;
        private short nextChassisIndex = (short)1000;

        private ChassisIndex() {
        }

        short nextIndex(short s) {
            if (s == 0) {
                int n = 0;
                while (true) {
                    if (this.nextChassisIndex < 2000 && ChassisModels.this.getChassisByIndex(this.nextChassisIndex) != null) {
                        this.nextChassisIndex = (short)(this.nextChassisIndex + 1);
                        continue;
                    }
                    if (this.nextChassisIndex < 2000) {
                        return this.nextChassisIndex;
                    }
                    this.nextChassisIndex = (short)1000;
                    if (++n >= 2) break;
                }
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MsLayoutMgr {
        private static final short ABS_BAY_OFFSET = 100;
        private static final short REL_BAY_OFFSET = 200;
        private List<sShelfInfoSubset> sis = new ArrayList<sShelfInfoSubset>();
        private final ChassisModels cms;
        private SortedMap<Integer, ShelfPosition[]> abs_pos = new TreeMap<Integer, ShelfPosition[]>();
        private Map<Integer, ShelfPosition[]> rel_pos = new HashMap<Integer, ShelfPosition[]>();
        private Map<IShelfViewModel, ShelfPosition> cm_map = new HashMap<IShelfViewModel, ShelfPosition>();
        private boolean incomplete;
        private int updating = 0;
        private final int[] map_15454 = new int[]{0, 12, 24, 36};
        private final int[] map_15454SDH = new int[]{0, 17, 34};

        MsLayoutMgr(ChassisModels chassisModels2) {
            this.cms = chassisModels2;
        }

        MsLayoutMgr(ChassisModels chassisModels2, sShelfInfoSubset[] sShelfInfoSubsetArray) {
            this.cms = chassisModels2;
            this.sis.addAll(Arrays.asList(sShelfInfoSubsetArray));
        }

        private void load() {
            ShelfPosition[] shelfPositionArray;
            Object object;
            ChassisModels.this.db.finest("Entered MsLayoutMgr.load()");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (sShelfInfoSubset object2 : this.sis) {
                int n;
                object = this.cms.getChassisByIndex(object2.chassisIndex);
                if (object == null) {
                    ChassisModels.this.db.warning("Chassis " + object2.chassisIndex + " ignored. Layout incomplete");
                    this.incomplete = true;
                    continue;
                }
                shelfPositionArray = new ShelfPosition(object2, (IShelfViewModel)object);
                if (((ShelfPosition)shelfPositionArray).rack == 0 || ((ShelfPosition)shelfPositionArray).bay == 0) {
                    ChassisModels.this.db.info("Strinded chassis: " + ((ShelfPosition)shelfPositionArray).cm);
                    arrayList.add(shelfPositionArray);
                    continue;
                }
                ShelfPosition[] shelfPositionArray2 = this.abs_get((ShelfPosition)shelfPositionArray);
                ShelfPosition[] shelfPositionArray3 = this.rel_get((ShelfPosition)shelfPositionArray);
                if (shelfPositionArray2 == null) {
                    ChassisModels.this.db.info("New rack found: " + ((ShelfPosition)shelfPositionArray).cm);
                    shelfPositionArray2 = new ShelfPosition[49];
                    this.abs_put((ShelfPosition)shelfPositionArray, shelfPositionArray2);
                    shelfPositionArray3 = new ShelfPosition[49];
                    this.rel_put((ShelfPosition)shelfPositionArray, shelfPositionArray3);
                }
                if (((ShelfPosition)shelfPositionArray).bay > 200) {
                    n = ((ShelfPosition)shelfPositionArray).bay - 200 - 1;
                    if (n < 0 || n >= shelfPositionArray3.length) {
                        ChassisModels.this.db.warning("Got invalid position <" + n + "> for chassis: " + ((ShelfPosition)shelfPositionArray).cm);
                        ((ShelfPosition)shelfPositionArray).bay = (short)0;
                        arrayList.add(0, shelfPositionArray);
                        continue;
                    }
                    if (shelfPositionArray3[n] != null) {
                        ChassisModels.this.db.warning("Position <" + n + "> occupied for chassis: " + ((ShelfPosition)shelfPositionArray).cm);
                        arrayList.add(0, shelfPositionArray);
                        continue;
                    }
                    ChassisModels.this.db.info("Free bay @ " + n);
                    shelfPositionArray3[n] = shelfPositionArray;
                    continue;
                }
                int n2 = n = ((ShelfPosition)shelfPositionArray).bay > 100 ? ((ShelfPosition)shelfPositionArray).bay - 100 - 1 : this.convertOldPosition((ShelfPosition)shelfPositionArray);
                if (((ShelfPosition)shelfPositionArray).height <= this.countFreePositionsAfter(n, shelfPositionArray2)) {
                    ChassisModels.this.db.info("Chassis <" + ((ShelfPosition)shelfPositionArray).cm + "> positioned @ " + n);
                    this.fillBays(n, shelfPositionArray2, (ShelfPosition)shelfPositionArray);
                    continue;
                }
                ChassisModels.this.db.warning("invalid/overlap position <" + n + "> for chassis: " + ((ShelfPosition)shelfPositionArray).cm);
                arrayList.add(0, shelfPositionArray);
            }
            for (Integer n : this.get_all_racks()) {
                object = this.abs_get(n);
                for (ShelfPosition shelfPosition : shelfPositionArray = this.rel_get(n)) {
                    if (shelfPosition == null) continue;
                    int n3 = this.getApproxAbsPosition(shelfPosition.bay - 200, (ShelfPosition[])object);
                    int n4 = this.getBayPosition(n3, (ShelfPosition[])object, shelfPosition);
                    if (n4 != -1) {
                        ChassisModels.this.db.info("Round 2: chassis: " + shelfPosition.cm + " found absolute position @ " + n4);
                        this.fillBays(n4, (ShelfPosition[])object, shelfPosition);
                        continue;
                    }
                    ChassisModels.this.db.warning("Round 2: no space to add this chassis: " + shelfPosition.cm);
                    arrayList.add(0, shelfPosition);
                }
            }
            for (ShelfPosition shelfPosition : arrayList) {
                if (shelfPosition.rack > 0) {
                    object = this.abs_get(shelfPosition);
                    if (object == null || shelfPosition.height > this.countFreePositions((ShelfPosition[])object)) {
                        shelfPosition.rack = (short)0;
                    } else {
                        int n = this.getBayPosition(0, (ShelfPosition[])object, shelfPosition);
                        ChassisModels.this.db.info("Round 3: chassis <" + shelfPosition.cm + "> found free bay @ " + n);
                        this.fillBays(n, (ShelfPosition[])object, shelfPosition);
                    }
                }
                if (shelfPosition.rack != 0) continue;
                object = this.findFreeBayInRack(shelfPosition);
                if (object == null) {
                    ChassisModels.this.db.info("need a new rack to accommodate chassis: " + shelfPosition.cm);
                    object = this.addNewRack();
                }
                ShelfPosition[] shelfPositionArray4 = this.abs_get((Integer)object);
                int n = this.getBayPosition(0, shelfPositionArray4, shelfPosition);
                ChassisModels.this.db.info("Round 3: chassis <" + shelfPosition.cm + "> found free bay @ " + n);
                this.fillBays(n, shelfPositionArray4, shelfPosition);
                shelfPosition.rack = object.shortValue();
            }
            ChassisModels.this.db.finest("MsLayoutMgr.load() exausted. incomplete=" + this.incomplete);
        }

        private List<ShelfPosition> getAllShelves() {
            ArrayList<ShelfPosition> arrayList = new ArrayList<ShelfPosition>();
            for (Integer n : this.get_all_racks()) {
                ShelfPosition[] shelfPositionArray = this.abs_get(n);
                for (int i = 0; i < shelfPositionArray.length; ++i) {
                    if (shelfPositionArray[i] == null || i != 0 && shelfPositionArray[i] == shelfPositionArray[i - 1]) continue;
                    arrayList.add(shelfPositionArray[i]);
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IShelfViewModel get(short s, short s2) {
            this.update();
            Object object = ChassisModels.this.chassisMapLock;
            synchronized (object) {
                ShelfPosition[] shelfPositionArray = this.abs_get(s);
                if (shelfPositionArray != null) {
                    if (s2 > 200) {
                        ShelfPosition[] shelfPositionArray2 = this.rel_get(s);
                        if (shelfPositionArray2 != null && s2 - 200 - 1 < shelfPositionArray2.length && shelfPositionArray2[s2 - 200 - 1] != null) {
                            return shelfPositionArray2[s2 - 200 - 1].cm;
                        }
                        short s3 = (short)this.getApproxAbsPosition(s2 - 200, shelfPositionArray);
                        if (s3 < shelfPositionArray.length && shelfPositionArray[s3] != null) {
                            return shelfPositionArray[s3].cm;
                        }
                    } else if (s2 > 100 && s2 - 100 - 1 < shelfPositionArray.length && shelfPositionArray[s2 - 100 - 1] != null) {
                        return shelfPositionArray[s2 - 100 - 1].cm;
                    }
                    if (s2 > 0 && s2 - 1 < shelfPositionArray.length && shelfPositionArray[s2 - 1] != null) {
                        return shelfPositionArray[s2 - 1].cm;
                    }
                }
            }
            return null;
        }

        private ShelfPosition get(IShelfViewModel iShelfViewModel) {
            this.update();
            return this.cm_map.get(iShelfViewModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private sShelfInfoSubset getUpdatedShelfInfo(IShelfViewModel iShelfViewModel) {
            this.update();
            Object object = ChassisModels.this.chassisMapLock;
            synchronized (object) {
                ShelfPosition shelfPosition = this.get(iShelfViewModel);
                if (shelfPosition != null) {
                    return shelfPosition.getUpdatedSI();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean swapPositions(IShelfViewModel iShelfViewModel, short s, short s2) {
            Object object = ChassisModels.this.chassisMapLock;
            synchronized (object) {
                ChassisModels.this.db.fine("swapPositions() <" + Thread.currentThread().getName() + ">");
                ShelfPosition shelfPosition = this.cm_map.get(iShelfViewModel);
                if (shelfPosition == null) {
                    ChassisModels.this.db.warning("Source chassis to swap not found " + iShelfViewModel.toString());
                    return false;
                }
                ShelfPosition[] shelfPositionArray = this.abs_get(shelfPosition.getRackNumber());
                if (shelfPositionArray == null) {
                    ChassisModels.this.db.warning("Source rack to swap not found " + iShelfViewModel.toString());
                    return false;
                }
                ShelfPosition[] shelfPositionArray2 = this.abs_get(s);
                if (shelfPositionArray2 == null) {
                    ChassisModels.this.db.fine("Destination rack to swap not found " + s);
                    if (s < 1 || s > 12 || s2 < 1 || s2 > 49) {
                        ChassisModels.this.db.warning("Wrong destination rack num <" + s + "> & position <" + s2 + "> specified ");
                        return false;
                    }
                    this.setUpdate();
                    shelfPositionArray2 = new ShelfPosition[49];
                    this.abs_put(s, shelfPositionArray2);
                    this.clearBays(shelfPosition.getBayNumber() - 1, shelfPosition.height, shelfPositionArray);
                    this.fillBays(s2 - 1, s, shelfPositionArray2, shelfPosition);
                    this.save();
                    this.cleanUpdate();
                    return true;
                }
                IShelfViewModel iShelfViewModel2 = this.get(s, s2);
                if (iShelfViewModel2 != null) {
                    ShelfPosition shelfPosition2 = this.cm_map.get(iShelfViewModel2);
                    if (shelfPosition2 == null) {
                        ChassisModels.this.db.warning("Destination chassis to swap not found " + iShelfViewModel2.toString());
                        return false;
                    }
                    if (shelfPosition.height == shelfPosition2.height) {
                        ChassisModels.this.db.fine("this can be swap since there is the same space [" + shelfPosition.height + "] in both positions");
                        this.setUpdate();
                        this.fillBays(shelfPosition.getBayNumber() - 1, shelfPosition.rack, shelfPositionArray, shelfPosition2);
                        this.fillBays(s2 - 1, s, shelfPositionArray2, shelfPosition);
                        this.save();
                        this.cleanUpdate();
                        return true;
                    }
                    if (shelfPosition.height > shelfPosition2.height) {
                        int n = this.getFirstFreeAfter(s2 - 1, shelfPositionArray2);
                        if (n != -1) {
                            int n2 = this.countFreePositionsAfter(n, shelfPositionArray2);
                            if (shelfPosition.height > shelfPosition2.height + n2) {
                                ChassisModels.this.db.warning("No space left at destination " + iShelfViewModel2.toString());
                                return false;
                            }
                            ChassisModels.this.db.fine("can swap fromSP.height(" + shelfPosition.height + ") > toSP.height(" + shelfPosition2.height + ")");
                            ChassisModels.this.db.fine("can swap fromSP.pos(" + shelfPosition.getBayNumber() + ") > toSP.pos(" + s2 + ")");
                            this.setUpdate();
                            this.clearBays(shelfPosition.getBayNumber() - 1, shelfPosition.height, shelfPositionArray);
                            this.fillBays(shelfPosition.getBayNumber() - 1, shelfPosition.rack, shelfPositionArray, shelfPosition2);
                            this.fillBays(s2 - 1, s, shelfPositionArray2, shelfPosition);
                            this.save();
                            this.cleanUpdate();
                            return true;
                        }
                    } else {
                        ChassisModels.this.db.fine("from height(" + shelfPosition.height + ") is less then destination chassis. need to verify if there is enough space at source");
                        int n = this.getFirstFreeAfter(shelfPosition.getBayNumber() - 1, shelfPositionArray);
                        if (n != -1) {
                            int n3 = this.countFreePositionsAfter(n, shelfPositionArray);
                            if (shelfPosition2.height > shelfPosition.height + n3 && shelfPosition.getBayNumber() + shelfPosition.height + n3 != s2) {
                                ChassisModels.this.db.warning("No space left at source " + iShelfViewModel.toString());
                                return false;
                            }
                            if (shelfPosition.getBayNumber() + shelfPosition2.height > s2) {
                                s2 = (short)(s2 + (shelfPosition2.height - shelfPosition.height));
                            }
                            ChassisModels.this.db.fine("can swap @ " + (s2 - 1));
                            this.setUpdate();
                            this.clearBays(s2 - 1, shelfPosition2.height, shelfPositionArray2);
                            this.fillBays(shelfPosition.getBayNumber() - 1, shelfPosition.rack, shelfPositionArray, shelfPosition2);
                            this.fillBays(s2 - 1, s, shelfPositionArray2, shelfPosition);
                            this.save();
                            this.cleanUpdate();
                            return true;
                        }
                    }
                } else {
                    ChassisModels.this.db.fine("destination is not occupied, check if there is enough space");
                    this.setUpdate();
                    int n = this.countFreePositionsAfter(s2 - 1, shelfPositionArray2);
                    boolean bl = false;
                    if (shelfPosition.height <= n) {
                        ChassisModels.this.db.fine("Height(" + shelfPosition.height + ") < than free(" + n + ")");
                        bl = true;
                    } else if (shelfPosition.rack == s) {
                        if (s2 < shelfPosition.getBayNumber()) {
                            ChassisModels.this.db.fine("moved UP. Have " + n + " bay(s) free");
                            bl = s2 + n == shelfPosition.getBayNumber();
                        } else if (s2 < shelfPosition.getBayNumber() + shelfPosition.height) {
                            n = this.countFreePositionsAfter(shelfPosition.getBayNumber() + shelfPosition.height, shelfPositionArray2);
                            bl = n + s2 - shelfPosition.getBayNumber() >= shelfPosition.height;
                        } else {
                            n = this.countFreePositionsBefore(s2 - 1, shelfPositionArray2);
                            ChassisModels.this.db.fine("moved DOWN. Have " + n + " bay(s) free");
                            bl = s2 == shelfPosition.getBayNumber() + shelfPosition.height + n - 1;
                            s2 = (short)(shelfPosition.getBayNumber() + n);
                        }
                    }
                    if (!bl) {
                        ChassisModels.this.db.warning("No space left at destination. Free bays count: " + n);
                        this.cleanUpdate();
                        return false;
                    }
                    ChassisModels.this.db.fine("can swap @ " + (s2 - 1));
                    this.clearBays(shelfPosition.getBayNumber() - 1, shelfPosition.height, shelfPositionArray);
                    this.fillBays(s2 - 1, s, shelfPositionArray2, shelfPosition);
                    this.save();
                    this.cleanUpdate();
                    return true;
                }
                ChassisModels.this.db.info("No space left to swap chassis");
            }
            return false;
        }

        private void checkAndSaveNewPositions(sShelfInfoSubset[] sShelfInfoSubsetArray) throws Exception {
            try {
                ChassisModels.this.db.finer("Update Positions (" + sShelfInfoSubsetArray.length + ") <" + Thread.currentThread().getName() + ">");
                MsLayoutMgr msLayoutMgr = new MsLayoutMgr(this.cms, sShelfInfoSubsetArray);
                msLayoutMgr.sanityCheck();
                this.setUpdate();
                ChassisModels.this.db.finer("update passive shelves <" + Thread.currentThread().getName() + ">");
                for (ShelfPosition shelfPosition : msLayoutMgr.cm_map.values()) {
                    if (!(shelfPosition.cm instanceof PassiveChassisModel)) continue;
                    ((PassiveChassisModel)shelfPosition.cm).setInternalPosition(shelfPosition.getPosition());
                }
                ChassisModels.this.db.finer("update chassis info list <" + Thread.currentThread().getName() + ">");
                ChassisModels.this.setShelfInfoList(msLayoutMgr.getActiveChassisUpdatedSis());
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                this.cleanUpdate();
            }
        }

        private void sanityCheck() throws Exception {
            ChassisModels.this.db.finer("doing sanityCheck(" + this.sis.size() + ") <" + Thread.currentThread().getName() + ">");
            for (sShelfInfoSubset sShelfInfoSubset2 : this.sis) {
                IShelfViewModel iShelfViewModel;
                IShelfViewModel iShelfViewModel2 = this.cms.getChassisByIndex(sShelfInfoSubset2.chassisIndex);
                if (iShelfViewModel2 == null) {
                    ChassisModels.this.db.warning("Chassis " + sShelfInfoSubset2.chassisIndex + " not found");
                    throw new Exception("Chassis " + sShelfInfoSubset2.chassisIndex + " not found");
                }
                ShelfPosition shelfPosition = new ShelfPosition(sShelfInfoSubset2, iShelfViewModel2);
                ShelfPosition[] shelfPositionArray = this.abs_get(shelfPosition);
                if (shelfPositionArray == null) {
                    shelfPositionArray = new ShelfPosition[49];
                    this.abs_put(shelfPosition, shelfPositionArray);
                }
                if (shelfPosition.height <= this.countFreePositionsAfter(shelfPosition.bay - 1, shelfPositionArray)) {
                    ChassisModels.this.db.finer("Shelf added: " + shelfPosition.toString());
                    this.fillBays(shelfPosition.bay - 1, shelfPositionArray, shelfPosition);
                    continue;
                }
                int n = this.getFirstOccupiedAfter(shelfPosition.bay - 1, shelfPositionArray);
                if (n != -1 && (iShelfViewModel = this.get(shelfPosition.rack, (short)n)) != null) {
                    ChassisModels.this.db.warning("The positions for Shelf " + shelfPosition.cm.getShelfId() + " cannot overlap or be identical to shelf " + iShelfViewModel.getShelfId());
                    ChassisModels.this.db.finer("Shelf is: " + shelfPosition.toString());
                    ChassisModels.this.db.finer("Overlapped Shelf is: " + iShelfViewModel.toString());
                    ChassisModels.this.db.finer(this.toString());
                    throw new Exception("The positions for Shelf " + shelfPosition.cm.getShelfId() + " cannot overlap or be identical to shelf " + iShelfViewModel.getShelfId());
                }
                ChassisModels.this.db.warning("The positions for Shelf " + shelfPosition.cm.getShelfId() + " cannot overlap or be identical to other shelf posistion.");
                ChassisModels.this.db.finer("Shelf is: " + shelfPosition.toString());
                ChassisModels.this.db.finer(this.toString());
                throw new Exception("The positions for Shelf " + shelfPosition.cm.getShelfId() + " cannot overlap or be identical to other shelf posistion.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            Object object = ChassisModels.this.chassisMapLock;
            synchronized (object) {
                if (this.isUpdating()) {
                    ChassisModels.this.db.finer("layout is changing... return later <" + Thread.currentThread().getName() + ">");
                    return;
                }
                if (this.cms.shelfInfoList.isClean()) {
                    ChassisModels.this.db.finer("layout already updated <" + Thread.currentThread().getName() + ">");
                    return;
                }
                ChassisModels.this.db.finer("Enter LayoutMgr.update() <" + Thread.currentThread().getName() + ">");
                try {
                    this.setUpdate();
                    this.sis.clear();
                    this.sis.addAll(Arrays.asList(this.cms.getShelfInfoList()));
                    for (IShelfViewModel iShelfViewModel : this.cms.getShelfViewModels()) {
                        if (!(iShelfViewModel instanceof PassiveChassisModel)) continue;
                        sShelfInfoSubset sShelfInfoSubset2 = new sShelfInfoSubset(iShelfViewModel.getShelfIndex(), ((PassiveChassisModel)iShelfViewModel).getInternalPosition());
                        this.sis.add(sShelfInfoSubset2);
                    }
                    this.abs_pos.clear();
                    this.rel_pos.clear();
                    this.cm_map.clear();
                    this.incomplete = false;
                    this.load();
                    if (!this.incomplete && this.changed()) {
                        this.save();
                    } else if (this.incomplete) {
                        ChassisModels.this.db.fine("Incomplete layout... run again.");
                    } else {
                        ChassisModels.this.db.fine("Layout unchanged. Not saved.");
                    }
                }
                finally {
                    this.cleanUpdate();
                }
            }
        }

        private void save() {
            block4: {
                ChassisModels.this.db.finer("LayoutMgr.save() required");
                try {
                    this.cms.setShelfInfoList(this.getActiveChassisUpdatedSis());
                    for (ShelfPosition shelfPosition : this.cm_map.values()) {
                        if (!(shelfPosition.cm instanceof PassiveChassisModel)) continue;
                        ((PassiveChassisModel)shelfPosition.cm).setInternalPosition(shelfPosition.getPosition());
                    }
                }
                catch (Exception exception) {
                    ChassisModels.this.db.fine("Caught " + exception + " in save shelf positions");
                    if (!ChassisModels.this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                    for (ShelfPosition shelfPosition : this.getAllShelves()) {
                        ChassisModels.this.db.println(shelfPosition.toString());
                    }
                }
            }
        }

        private sShelfInfoSubset[] getActiveChassisUpdatedSis() {
            ArrayList<sShelfInfoSubset> arrayList = new ArrayList<sShelfInfoSubset>();
            for (ShelfPosition shelfPosition : this.cm_map.values()) {
                if (shelfPosition.cm instanceof PassiveChassisModel) continue;
                arrayList.add(shelfPosition.getSI());
            }
            return arrayList.toArray(new sShelfInfoSubset[0]);
        }

        private boolean changed() {
            for (ShelfPosition shelfPosition : this.cm_map.values()) {
                if (shelfPosition.check()) continue;
                return true;
            }
            return false;
        }

        private Set<Integer> get_all_racks() {
            return this.abs_pos.keySet();
        }

        private ShelfPosition[] abs_get(short s) {
            return (ShelfPosition[])this.abs_pos.get(new Integer(s));
        }

        private ShelfPosition[] abs_get(Integer n) {
            return (ShelfPosition[])this.abs_pos.get(n);
        }

        private ShelfPosition[] abs_get(ShelfPosition shelfPosition) {
            return (ShelfPosition[])this.abs_pos.get(new Integer(shelfPosition.rack));
        }

        private void abs_put(ShelfPosition shelfPosition, ShelfPosition[] shelfPositionArray) {
            this.abs_pos.put(new Integer(shelfPosition.rack), shelfPositionArray);
        }

        private void abs_put(Integer n, ShelfPosition[] shelfPositionArray) {
            this.abs_pos.put(n, shelfPositionArray);
        }

        private void abs_put(short s, ShelfPosition[] shelfPositionArray) {
            this.abs_pos.put(new Integer(s), shelfPositionArray);
        }

        private ShelfPosition[] rel_get(short s) {
            return this.rel_pos.get(new Integer(s));
        }

        private ShelfPosition[] rel_get(Integer n) {
            return this.rel_pos.get(n);
        }

        private ShelfPosition[] rel_get(ShelfPosition shelfPosition) {
            return this.rel_pos.get(new Integer(shelfPosition.rack));
        }

        private void rel_put(ShelfPosition shelfPosition, ShelfPosition[] shelfPositionArray) {
            this.rel_pos.put(new Integer(shelfPosition.rack), shelfPositionArray);
        }

        private Integer findFreeBayInRack(ShelfPosition shelfPosition) {
            for (Integer n : this.get_all_racks()) {
                if (shelfPosition.height > this.countFreePositions(this.abs_get(n))) continue;
                return n;
            }
            return null;
        }

        private Integer addNewRack() {
            for (int i = 1; i <= 12; ++i) {
                if (this.abs_get(i) != null) continue;
                this.abs_put(i, new ShelfPosition[49]);
                return i;
            }
            return null;
        }

        private void fillBays(int n, short s, ShelfPosition[] shelfPositionArray, ShelfPosition shelfPosition) {
            shelfPosition.rack = s;
            this.fillBays(n, shelfPositionArray, shelfPosition);
        }

        private void fillBays(int n, ShelfPosition[] shelfPositionArray, ShelfPosition shelfPosition) {
            int n2 = n + shelfPosition.height;
            shelfPosition.bay = (short)(n + 100 + 1);
            while (n < n2) {
                shelfPositionArray[n++] = shelfPosition;
            }
        }

        private void clearBays(int n, int n2, ShelfPosition[] shelfPositionArray) {
            int n3 = n + n2;
            while (n < n3) {
                shelfPositionArray[n++] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short convertToOldPosition(IShelfViewModel iShelfViewModel) {
            Object object = ChassisModels.this.chassisMapLock;
            synchronized (object) {
                short s = iShelfViewModel.getRackPosition();
                if (iShelfViewModel.getShelfType() == 20) {
                    for (int i = 0; i < this.map_15454.length; ++i) {
                        if (s >= this.map_15454[i]) continue;
                        return (short)i;
                    }
                    return (short)this.map_15454.length;
                }
                if (iShelfViewModel.getShelfType() == 71) {
                    for (int i = 0; i < this.map_15454SDH.length; ++i) {
                        if (s >= this.map_15454SDH[i]) continue;
                        return (short)i;
                    }
                    return (short)this.map_15454SDH.length;
                }
                return iShelfViewModel.getRackPosition();
            }
        }

        private int convertOldPosition(ShelfPosition shelfPosition) {
            if (shelfPosition.cm.getShelfType() == 20) {
                if (shelfPosition.bay > 0 && shelfPosition.bay < 5) {
                    return this.map_15454[shelfPosition.bay - 1];
                }
            } else if (shelfPosition.cm.getShelfType() == 71 && shelfPosition.bay > 0 && shelfPosition.bay < 4) {
                return this.map_15454SDH[shelfPosition.bay - 1];
            }
            return shelfPosition.bay;
        }

        private int getApproxAbsPosition(int n, ShelfPosition[] shelfPositionArray) {
            int n2 = 0;
            for (int i = 1; i < n && n2 < shelfPositionArray.length; ++i) {
                if (shelfPositionArray[n2] != null) {
                    n2 += shelfPositionArray[n2].height;
                    continue;
                }
                ++n2;
            }
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int getBayPosition(int n, ShelfPosition[] shelfPositionArray, ShelfPosition shelfPosition) {
            int n2 = this.countFreePositionsAfter(n, shelfPositionArray);
            if (shelfPosition.height <= n2) {
                ChassisModels.this.db.fine("found enough space, add here and fill all positions @ " + n);
                return n;
            }
            ChassisModels.this.db.fine("check if there is enough space before (" + shelfPosition.height + " > " + n2 + ")");
            int n3 = this.countFreePositionsBefore(n, shelfPositionArray);
            if (shelfPosition.height <= n2 + n3 - 1) {
                ChassisModels.this.db.fine("move some bay before this and save: " + (n + n2));
                return n + n2 - shelfPosition.height;
            }
            int n4 = this.countFreePositions(shelfPositionArray);
            if (shelfPosition.height <= n4) {
                ChassisModels.this.db.fine("compact shelves below this position (" + shelfPosition.height + " <= " + n4 + ")");
                int n5 = this.getFirstFreeBefore(n - 1, shelfPositionArray);
                if (n5 >= 0 && this.reserveSpaceBefore(n5, shelfPosition.height, shelfPositionArray)) {
                    return n5;
                }
                ChassisModels.this.db.fine("no space above, search first free below @ " + n);
                n5 = this.getFirstFreeAfter(n, shelfPositionArray);
                if (n5 >= 0) {
                    n2 = this.countFreePositionsAfter(n5, shelfPositionArray);
                    if (shelfPosition.height <= n2 || this.reserveSpaceAfter(n5, shelfPosition.height, shelfPositionArray)) {
                        ChassisModels.this.db.fine("found enough space from here (" + shelfPosition.height + " <= " + n2 + ")");
                        return n5;
                    }
                }
            }
            ChassisModels.this.db.fine("no space to add");
            return -1;
        }

        private int getFirstFreeBefore(int n, ShelfPosition[] shelfPositionArray) {
            while (n >= 0 && shelfPositionArray[n] != null) {
                --n;
            }
            return n;
        }

        private int getFirstFreeAfter(int n, ShelfPosition[] shelfPositionArray) {
            while (n < shelfPositionArray.length && shelfPositionArray[n] != null) {
                ++n;
            }
            return n < shelfPositionArray.length ? n : -1;
        }

        private int getFirstOccupiedAfter(int n, ShelfPosition[] shelfPositionArray) {
            while (n < shelfPositionArray.length && shelfPositionArray[n] == null) {
                ++n;
            }
            return n < shelfPositionArray.length ? n : -1;
        }

        private int countFreePositions(ShelfPosition[] shelfPositionArray) {
            int n = 0;
            for (int i = 0; i < shelfPositionArray.length; ++i) {
                if (shelfPositionArray[i] != null) continue;
                ++n;
            }
            return n;
        }

        private int countFreePositionsBefore(int n, ShelfPosition[] shelfPositionArray) {
            int n2;
            for (n2 = n; n2 >= 0 && shelfPositionArray[n2] == null; --n2) {
            }
            return n - n2;
        }

        private int countFreePositionsAfter(int n, ShelfPosition[] shelfPositionArray) {
            int n2;
            for (n2 = n; n2 < shelfPositionArray.length && shelfPositionArray[n2] == null; ++n2) {
            }
            return n2 - n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean reserveSpaceAfter(int n, int n2, ShelfPosition[] shelfPositionArray) {
            int n3 = 0;
            int n4 = n;
            while (true) {
                if (n3 < n2 && n4 < shelfPositionArray.length && shelfPositionArray[n4] == null) {
                    ++n3;
                    ++n4;
                    continue;
                }
                if (n3 >= n2) {
                    ChassisModels.this.db.fine("space recovered");
                    return true;
                }
                ChassisModels.this.db.fine("move to first unused (" + n3 + " < " + n2 + ")");
                while (n4 < shelfPositionArray.length && shelfPositionArray[n4] != null) {
                    ++n4;
                }
                if (n4 >= shelfPositionArray.length) {
                    ChassisModels.this.db.fine("no space left (" + n4 + ")");
                    return false;
                }
                ChassisModels.this.db.fine("move down used (" + n4 + " < " + shelfPositionArray.length + ")");
                do {
                    shelfPositionArray[n4] = shelfPositionArray[n4 - 1];
                } while (shelfPositionArray[--n4] != null);
                shelfPositionArray[n4 + 2].bay = (short)(100 + n4 + 3);
                ChassisModels.this.db.fine("reset and recover further space @ " + n);
                n3 = 0;
                n4 = n;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean reserveSpaceBefore(int n, int n2, ShelfPosition[] shelfPositionArray) {
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n3 < n2 && n4 >= 0 && shelfPositionArray[n4] == null) {
                    ++n3;
                    --n4;
                    continue;
                }
                if (n3 >= n2) {
                    ChassisModels.this.db.fine("space recovered");
                    return true;
                }
                ChassisModels.this.db.fine("move to first unused (" + n3 + " < " + n2 + ")");
                while (n4 >= 0 && shelfPositionArray[n4] != null) {
                    --n4;
                }
                if (n4 < 0) {
                    ChassisModels.this.db.fine("no space left");
                    return false;
                }
                ChassisModels.this.db.fine("move up used (" + n4 + " >= 0)");
                shelfPositionArray[n4 + 1].bay = (short)(100 + n4 + 1);
                do {
                    shelfPositionArray[n4] = shelfPositionArray[n4 + 1];
                } while (shelfPositionArray[++n4] != null);
                ChassisModels.this.db.fine("reset and recover further space @ " + n);
                n3 = 0;
                n4 = n;
            }
        }

        private void setUpdate() {
            ++this.updating;
        }

        private void cleanUpdate() {
            if (this.updating > 0) {
                --this.updating;
            }
        }

        private boolean isUpdating() {
            return this.updating > 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  Layout positions: (incomplete=");
            stringBuilder.append(this.incomplete);
            stringBuilder.append(", updating=");
            stringBuilder.append(this.updating);
            stringBuilder.append(")");
            for (ShelfPosition shelfPosition : this.cm_map.values()) {
                stringBuilder.append("\n\t");
                stringBuilder.append(shelfPosition.toString());
            }
            return stringBuilder.toString();
        }

        class ShelfPosition {
            private final sShelfInfoSubset si;
            private short rack;
            private short bay;
            private final short height;
            private final IShelfViewModel cm;

            ShelfPosition(sShelfInfoSubset sShelfInfoSubset2, IShelfViewModel iShelfViewModel) {
                this.si = sShelfInfoSubset2;
                this.rack = sShelfInfoSubset2.position.rackNumber;
                this.bay = sShelfInfoSubset2.position.positionInRack;
                this.cm = iShelfViewModel;
                this.height = this.cm.getRUOccupied();
                MsLayoutMgr.this.cm_map.put(this.cm, this);
            }

            public sShelfInfoSubset getUpdatedSI() {
                sShelfPosition sShelfPosition2 = new sShelfPosition(this.getRackNumber(), this.getBayNumber());
                return new sShelfInfoSubset(this.si.chassisIndex, sShelfPosition2);
            }

            public sShelfInfoSubset getSI() {
                sShelfPosition sShelfPosition2 = new sShelfPosition(this.rack, this.bay);
                return new sShelfInfoSubset(this.si.chassisIndex, sShelfPosition2);
            }

            public sShelfPosition getPosition() {
                return new sShelfPosition(this.rack, this.bay);
            }

            public short getRackNumber() {
                return this.rack;
            }

            public short getBayNumber() {
                if (this.bay > 100) {
                    return (short)(this.bay - 100);
                }
                return this.bay;
            }

            public IShelfViewModel getChassis() {
                return this.cm;
            }

            public short getBayHeight() {
                return this.height;
            }

            boolean check() {
                return this.si.position.rackNumber == this.rack && this.si.position.positionInRack == this.bay;
            }

            public String toString() {
                return Integer.toHexString(this.si.chassisIndex) + " -> [r" + this.rack + "/b" + this.bay + "] h" + this.height;
            }
        }
    }

    private class ShelfInfoList
    extends CachedValue {
        public ShelfInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            ChassisModels.this.db.fine("ShelfInfoList.getValue()");
            sShelfInfoSubset[] sShelfInfoSubsetArray = ChassisModels.this.getEntityTableRef().getShelfInfo();
            return sShelfInfoSubsetArray;
        }

        protected void setValue(Object object) throws xInvalidData, xProvisionError {
            ChassisModels.this.db.fine("ShelfInfoList.setValue()");
            sShelfInfoSubset[] sShelfInfoSubsetArray = (sShelfInfoSubset[])object;
            ChassisModels.this.getEntityTableRef().setShelfInfo(sShelfInfoSubsetArray);
        }
    }

    public class ChassisModelsDebug
    extends SDebug {
        public ChassisModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n  ChassisMap contents:");
            ShelfInfo[] shelfInfoArray = ChassisModels.this.chassisMapLock;
            synchronized (shelfInfoArray) {
                for (Integer n : ChassisModels.this.allChassisMap.keySet()) {
                    IShelfViewModel object = (IShelfViewModel)ChassisModels.this.allChassisMap.get(n);
                    stringBuilder.append("\n\t");
                    stringBuilder.append(n);
                    stringBuilder.append(" -> ");
                    stringBuilder.append(object);
                }
            }
            stringBuilder.append("\n");
            stringBuilder.append(ChassisModels.this.layoutMgr.toString());
            stringBuilder.append("\n  CTM positions:");
            for (ShelfInfo shelfInfo : ChassisModels.this.getShelfPositions()) {
                stringBuilder.append("\n\t");
                stringBuilder.append(shelfInfo);
            }
            ChassisModels.this.db.println(stringBuilder.toString());
        }
    }
}

