/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CtcTimeZone;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CtcTimeZoneFactory {
    private static final int millisPerHour = 3600000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int TZ_ID = 0;
    private static final int TZ_MENUTEXT = 1;
    private static final int TZ_OFFSET = 2;
    private static final int DST_OFFSET = 3;
    private static final int TZ_STD_ABBREV = 4;
    private static final int TZ_DST_ABBREV = 5;
    private static final int DST_NAME = 6;
    private static final int MAX_NUM_TZINFO_ITEMS = 8;
    private static final int DST_STRT_M0NTH = 0;
    private static final int DST_STRT_DATE = 1;
    private static final int DST_STRT_DOW = 2;
    private static final int DST_STRT_HOUR = 3;
    private static final int DST_END_M0NTH = 4;
    private static final int DST_END_DATE = 5;
    private static final int DST_END_DOW = 6;
    private static final int DST_END_HOUR = 7;
    private static final SDebug db = new SDebug("CtcTimeZoneFactory");
    private static final String[] timezoneIDs = new String[]{"SST|Samoa Standard Time", "HST|Hawaii Standard Time", "AKST|Alaska Standard Time", "AKDT|Alaska Daylight Time", "PST|Pacific Standard Time", "PDT|Pacific Daylight Time", "MST|Mountain Standard Time", "MDT|Mountain Daylight Time", "MST_2|Mountain Standard Time", "MST_3|Mexico Daylight Time", "MDT_3|Mexico Standard Time", "CST|Central Standard Time", "CDT|Central Daylight Time", "CST_1|Central Standard Time", "CDT_1|Central Daylight Time", "CST_2|Central Standard Time", "CST_3|Central Standard Time", "EST|Eastern Standard Time", "EDT|Eastern Daylight Time", "CST_5|Cuba Standard Time", "CDT_5|Cuba Daylight Time", "EST_1|Eastern Standard Time", "PYT|Paraguay Time", "PYST|Paraguay Summer Time", "AST|Atlantic Standard Time", "AST_1|Atlantic Standard Time", "AST_2|Atlantic Standard Time", "ADT_2|Atlantic Daylight Time", "AST_4|Atlantic Standard Time", "ADT_4|Atlantic Daylight Time", "CLT|Chile Time", "CLST|Chile Summer Time", "NST|Newfoundland Standard Time", "NDT|Newfoundland Daylight Time", "BRT|Brasilia Time", "BRST|Brasilia Summer Time", "ART|Argentina Time", "WGT|Western Greenland Time", "WGST|Western Greenland Summer Time", "FNT|Fernando de Noronha", "EGT|Eastern Greenland Time", "EGST|Eastern Greenland Summer Time", "CVT|Cape Verde Time", "GMT_0|GMT-00:00", "GMT|Greenwich Mean Time", "WET_2|Western Europe Time", "WET|Western Europe Time", "WEST|Western Europe Summer Time", "CET|Central Europe Time", "CEST|Central Europe Summer Time", "CET_1|Central Europe Time", "CEST_1|Central Europe Summer Time", "CET_2|Central Europe Time", "CEST_2|Central Europe Summer Time", "CET_3|Central Europe Time", "CEST_3|Central Europe Summer Time", "WAT|West Africa Time", "WAST|West Africa Summer Time", "WAT_2|West Africa Time", "EET|Eastern Europe Time", "EEST|Eastern Europe Summer Time", "EET_1|Eastern Europe Time", "EEST_1|Eastern Europe Summer Time", "EET_2|Eastern Europe Time", "EEST_2|Eastern Europe Summer Time", "EET_3|Eastern Europe Time", "EEST_3|Eastern Europe Summer Time", "EET_4|Eastern Europe Time", "EEST_4|Eastern Europe Summer Time", "EET_5|Eastern Europe Time", "EEST_5|Eastern Europe Summer Time", "SAT|South Africa Time", "IST|Israel Standard Time", "IDT|Israel Daylight Time", "EAT|East Africa Time", "AST_3|Arabia Standard Time", "ADT_3|Arabia Daylight Time", "MSK|Moscow Standard Time", "MSD|Moscow Summer Time", "IRT|Iran Time", "IRST|Iran Summer Time", "GST|Gulf Standard Time", "AQTT|Aqtau Time", "AQTST|Aqtau Summer Time", "AZT|Azerbaijan Time", "AZST|Azerbaijan Summer Time", "SAMT|Samara Time", "SAMST|Samara Summer Time", "AFT|Afghanistan Time", "YEKT|Yekaterinburg Standard Time", "YEKST|Yekaterinburg Summer Time", "PKT|Pakistan Time", "IST_2|India Standard Time", "NPT|Nepal Time", "ALMT|Alma-Ata Standard Time", "ALMST|Alma-Ata Summer Time", "BST|Bangladesh Standard Time", "NOVT|Novosibirsk Standard Time", "NOVST|Novosibirsk Summer Time", "CCT|Cocos Islands Time", "ICT|Indochina Time", "KRAT|Krasnoyarsk Standard Time", "KRAST|Krasnoyarsk Summer Time", "CST_8|China Standard Time", "WST|Western Australia Standard Time", "SGT|Singapore Time", "YAKT|Yakutsk Standard Time", "YAKST|Yakutsk Summer Time", "JST|Japan Standard Time", "KST|Korea Standard Time", "ACT|Australia Central Time", "ACST|Australia Central Summer Time", "ACT_9|Australia Central Time", "AET_10|Australia Eastern Time", "AET|Australia Eastern Time", "AEST|Australia Eastern Summer Time", "AET_11|Australia Eastern Time", "AEST_11|Australia Eastern Summer Time", "VLAT|Vladivostok Standard Time", "VLAST|Vladivostok Summer Time", "LHST|Lord Howe Standard Time", "LHDT|Lord Howe Daylight Time", "MAGT|Magadan Standard Time", "MAGST|Magadan Summer Time", "NFT|Norfolk Island Time", "ANAT|Anadyr Time", "ANAST|Anadyr Summer Time", "NZST|New Zealand Standard Time", "NZDT|New Zealand Daylight Time", "MHT|Marshall Islands Time", "FJT|Fiji Time", "FJST|Fiji Summer Time", "CHST|Chatham Standard Time", "CHDT|Chatham Daylight Time", "TOT|Tonga Island Time", "TOST|Tonga Island Summer Time", "PHOT|Phoenix Island Time", "LINT|Line Island Time", "NCT|New Caledonia Time", "IRKT|Irkutsk Time", "IRKST|Irkutsk Summer Time", "SLST|Sri Lanka Standard Time"};
    private static final String N_AMERICA_DST = "N America DST";
    private static final int[] N_AMERICA_TIMES = new int[]{2, 8, -1, 0x6DDD00, 10, 1, 1, 0x6DDD00};
    private static final String GODTHAB_DST = "Godthab DST";
    private static final int[] GODTHAB_TIMES = new int[]{2, -1, 1, 79200000, 9, -1, 1, 82800000};
    private static final String AZORES_DST = "Azores DST";
    private static final int[] AZORES_TIMES = new int[]{2, -1, 1, 0, 9, -1, 1, 3600000};
    private static final String EUROPE_DST_AT1 = "Europe DST1";
    private static final int[] EUROPE_TIMES1 = new int[]{2, -1, 1, 3600000, 9, -1, 1, 3600000};
    private static final String EUROPE_DST_AT0 = "Europe DST0";
    private static final int[] EUROPE_TIMES0 = new int[]{2, -1, 1, 0, 9, -1, 1, 0};
    private static final String RUSSIA_DST = "Russia DST";
    private static final int[] RUSSIA_TIMES = new int[]{2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000};
    private static final String HAVANA_DST = "Havana DST";
    private static final int[] HAVANA_TIMES = new int[]{3, 1, 0, 0, 9, -1, 1, 3600000};
    private static final String BRAZIL_DST = "Brazil DST";
    private static final int[] BRAZIL_TIMES = new int[]{9, 8, -1, 0, 1, 15, -1, 0};
    private static final String CHILE_DST = "Chile DST";
    private static final int[] CHILE_TIMES = new int[]{9, 9, -1, 0, 2, 9, -1, 0};
    private static final String PARAGUAY_DST = "Paraguay DST";
    private static final int[] PARAGUAY_TIMES = new int[]{9, 1, -1, 0, 1, -1, 7, 0};
    private static final String W_AFRICA_DST = "W Africa DST";
    private static final int[] W_AFRICA_TIMES = new int[]{8, 1, -1, 0x6DDD00, 3, 1, -1, 0x6DDD00};
    private static final String CAIRO_DST = "Cairo DST";
    private static final int[] CAIRO_TIMES = new int[]{3, 22, -6, 0, 8, -1, 5, 0};
    private static final String ATHENS_DST = "Athens DST";
    private static final int[] ATHENS_TIMES = new int[]{2, -1, 1, 10800000, 9, -1, 1, 14400000};
    private static final String MINSK_DST = "Minsk DST";
    private static final int[] MINSK_TIMES = new int[]{2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000};
    private static final String LEBANON_DST = "Lebanon DST";
    private static final int[] LEBANON_TIMES = new int[]{2, -1, 1, 0, 9, -1, 1, 0};
    private static final String ISRAEL_DST = "Israel DST";
    private static final int[] ISRAEL_TIMES = new int[]{3, 1, -6, 0x6DDD00, 8, 1, -6, 0x6DDD00};
    private static final String JORDAN_DST = "Jordan DST";
    private static final int[] JORDAN_TIMES = new int[]{2, -1, 5, 0, 8, -1, 5, 3600000};
    private static final String IRAQ_DST = "Iraq DST";
    private static final int[] IRAQ_TIMES = new int[]{3, 1, 0, 10800000, 9, 1, 0, 14400000};
    private static final String IRAN_DST = "Iran DST";
    private static final int[] IRAN_TIMES = new int[]{2, 21, 0, 0, 8, 23, 0, 0};
    private static final String AUSTRALIA_DST = "Australia DST";
    private static final int[] AUSTRALIA_TIMES = new int[]{9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000};
    private static final String LORDHOWE_DST = "Lord Howe DST";
    private static final int[] LORDHOWE_TIMES = new int[]{9, -1, 1, 0x6DDD00, 2, -1, 1, 9000000};
    private static final String ANADYR_DST = "Anadyr DST";
    private static final int[] ANADYR_TIMES = new int[]{2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00};
    private static final String NZ_DST = "New Zealand DST";
    private static final int[] NZ_TIMES = new int[]{8, -1, 1, 0x6DDD00, 3, 1, 1, 10800000};
    private static final String FIJI_DST = "Fiji DST";
    private static final int[] FIJI_TIMES = new int[]{10, 1, -1, 0x6DDD00, 1, -1, 1, 10800000};
    private static final String CHATHAM_DST = "Chatham DST";
    private static final int[] CHATHAM_TIMES = new int[]{9, 1, -1, 9900000, 2, 15, -1, 13500000};
    private static final String TONGA_DST = "Tonga DST";
    private static final int[] TONGA_TIMES = new int[]{9, 1, -7, 0x6DDD00, 3, 15, -7, 10800000};
    private static final String MEXICO_DST = "Mexico DST";
    private static final int[] MEXICO_TIMES = new int[]{3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00};
    private static HashMap DstTimesMap = new HashMap();
    private static String[] WorldTimezoneInfo;
    private static final int NUM_OF_TIMEZONES = 87;
    private HashMap abbrvToDefMap;
    private HashMap tzIdToTZMap;
    private HashMap stdAbbrvToTZMap;
    private HashMap dstAbbrvToTZMap;
    private ArrayList ctcTimeZoneList = new ArrayList(87);
    private static String[] timezoneInfo;
    private boolean inWorld;

    public CtcTimeZoneFactory() {
        timezoneInfo = WorldTimezoneInfo;
        this.inWorld = true;
        this.setupMaps(timezoneInfo);
        this.createTimeZones();
    }

    public CtcTimeZone getCtcTimeZone(int n) {
        return (CtcTimeZone)this.ctcTimeZoneList.get(n);
    }

    private void createTimeZones() {
        for (int i = 0; i < timezoneInfo.length; ++i) {
            Object object;
            String string = timezoneInfo[i];
            if (db.on()) {
                db.println("tzInfoStr = " + string + "\n");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String[] stringArray = new String[8];
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && n < stringArray.length) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            float f = Float.parseFloat(stringArray[2]);
            CtcTimeZone ctcTimeZone = new CtcTimeZone((int)(f * 3600000.0f), stringArray[0]);
            ctcTimeZone.setStdTzAbbreviation(stringArray[4]);
            String string2 = (String)this.abbrvToDefMap.get(stringArray[4]);
            if (string2 != null && string2.length() != 0) {
                ctcTimeZone.setStdTzAbbrevDef(string2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMenuPrefix(stringArray[2], stringArray[0]));
            stringBuffer.append(stringArray[1]);
            ctcTimeZone.setMenuText(stringBuffer.toString());
            ctcTimeZone.setDstTzAbbreviation(stringArray[5]);
            String string3 = (String)this.abbrvToDefMap.get(stringArray[5]);
            if (string3 != null && string3.length() != 0) {
                ctcTimeZone.setDstTzAbbrevDef(string3);
                if (Float.parseFloat(stringArray[3]) > 0.0f) {
                    object = (int[])DstTimesMap.get(stringArray[6]);
                    ctcTimeZone.setStartRule((int)object[0], (int)object[1], (int)object[2], (int)object[3]);
                    ctcTimeZone.setEndRule((int)object[4], (int)object[5], (int)object[6], (int)object[7]);
                    float f2 = Float.parseFloat(stringArray[3]);
                    ctcTimeZone.setDSTSavings((int)(f2 * 3600000.0f));
                }
            }
            this.tzIdToTZMap.put(stringArray[0], ctcTimeZone);
            this.stdAbbrvToTZMap.put(stringArray[4], ctcTimeZone);
            object = stringArray[5];
            if (this.stdAbbrvToTZMap.get(object) == null) {
                this.dstAbbrvToTZMap.put(object, ctcTimeZone);
            }
            if (db.on()) {
                db.println("Just added " + stringArray[0] + "to tzIdtoTZMap\n");
            }
            if (db.on()) {
                db.println("Just added " + stringArray[4] + "to stdAbbrvToTZMap\n");
            }
            ctcTimeZone.initDateFormatSymbols();
            this.ctcTimeZoneList.add(i, ctcTimeZone);
        }
    }

    public CtcTimeZone getCtcTimeZoneFromAbbrev(String string, boolean bl) {
        if (bl) {
            return (CtcTimeZone)this.dstAbbrvToTZMap.get(string);
        }
        return (CtcTimeZone)this.stdAbbrvToTZMap.get(string);
    }

    public CtcTimeZone getCtcTimeZoneFromAbbrev(String string) {
        CtcTimeZone ctcTimeZone = null;
        ctcTimeZone = (CtcTimeZone)this.stdAbbrvToTZMap.get(string);
        if (ctcTimeZone == null) {
            if (db.on()) {
                db.println(" Time Zone NOT found using PST.");
            }
            ctcTimeZone = (CtcTimeZone)this.stdAbbrvToTZMap.get("PST");
        }
        if (db.on()) {
            db.println(" Time Zone is:" + ctcTimeZone);
        }
        return ctcTimeZone;
    }

    public CtcTimeZone getCtcTimeZoneFromID(String string) {
        CtcTimeZone ctcTimeZone = null;
        ctcTimeZone = (CtcTimeZone)this.tzIdToTZMap.get(string);
        if (ctcTimeZone == null) {
            ctcTimeZone = (CtcTimeZone)this.tzIdToTZMap.get("America/Los_Angeles");
        }
        return ctcTimeZone;
    }

    public int getNumberofTimeZones() {
        int n = timezoneInfo.length;
        return n;
    }

    private String getMenuPrefix(String string, String string2) {
        if (string2.equals("GMT")) {
            return "(GMT) ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        float f = Float.parseFloat(string);
        int n = (int)(f * 100.0f);
        if (n == 0) {
            stringBuffer.append("(GMT ");
        } else if (n > 0) {
            stringBuffer.append("(GMT+");
        } else {
            stringBuffer.append("(GMT-");
        }
        int n2 = Math.abs(n) / 100;
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        String string3 = Integer.toString(n2);
        stringBuffer.append(string3);
        int n3 = Math.abs(n) % 100;
        if (n3 == 0) {
            stringBuffer.append(":00) ");
        } else if (n3 / 25 == 1) {
            stringBuffer.append(":15) ");
        } else if (n3 / 25 == 2) {
            stringBuffer.append(":30) ");
        } else if (n3 / 25 == 3) {
            stringBuffer.append(":45) ");
        } else {
            stringBuffer.append(":00) ");
        }
        return stringBuffer.toString();
    }

    private void setupMaps(String[] stringArray) {
        this.tzIdToTZMap = new HashMap(timezoneIDs.length);
        this.stdAbbrvToTZMap = new HashMap(timezoneIDs.length);
        this.dstAbbrvToTZMap = new HashMap();
        this.abbrvToDefMap = new HashMap(timezoneIDs.length);
        for (int i = 0; i < timezoneIDs.length; ++i) {
            String string = timezoneIDs[i];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.abbrvToDefMap.put(string2, string3);
        }
    }

    public void dispose() {
        this.ctcTimeZoneList.clear();
        this.tzIdToTZMap.clear();
        this.abbrvToDefMap.clear();
        this.stdAbbrvToTZMap.clear();
    }

    static {
        DstTimesMap.put(N_AMERICA_DST, N_AMERICA_TIMES);
        DstTimesMap.put(GODTHAB_DST, GODTHAB_TIMES);
        DstTimesMap.put(AZORES_DST, AZORES_TIMES);
        DstTimesMap.put(HAVANA_DST, HAVANA_TIMES);
        DstTimesMap.put(BRAZIL_DST, BRAZIL_TIMES);
        DstTimesMap.put(CHILE_DST, CHILE_TIMES);
        DstTimesMap.put(PARAGUAY_DST, PARAGUAY_TIMES);
        DstTimesMap.put(EUROPE_DST_AT1, EUROPE_TIMES1);
        DstTimesMap.put(EUROPE_DST_AT0, EUROPE_TIMES0);
        DstTimesMap.put(RUSSIA_DST, RUSSIA_TIMES);
        DstTimesMap.put(W_AFRICA_DST, W_AFRICA_TIMES);
        DstTimesMap.put(CAIRO_DST, CAIRO_TIMES);
        DstTimesMap.put(ATHENS_DST, ATHENS_TIMES);
        DstTimesMap.put(MINSK_DST, MINSK_TIMES);
        DstTimesMap.put(LEBANON_DST, LEBANON_TIMES);
        DstTimesMap.put(IRAQ_DST, IRAQ_TIMES);
        DstTimesMap.put(IRAN_DST, IRAN_TIMES);
        DstTimesMap.put(ISRAEL_DST, ISRAEL_TIMES);
        DstTimesMap.put(JORDAN_DST, JORDAN_TIMES);
        DstTimesMap.put(AUSTRALIA_DST, AUSTRALIA_TIMES);
        DstTimesMap.put(LORDHOWE_DST, LORDHOWE_TIMES);
        DstTimesMap.put(ANADYR_DST, ANADYR_TIMES);
        DstTimesMap.put(NZ_DST, NZ_TIMES);
        DstTimesMap.put(FIJI_DST, FIJI_TIMES);
        DstTimesMap.put(CHATHAM_DST, CHATHAM_TIMES);
        DstTimesMap.put(TONGA_DST, TONGA_TIMES);
        DstTimesMap.put(MEXICO_DST, MEXICO_TIMES);
        WorldTimezoneInfo = new String[]{"Pacific/Apia|Midway Islands, Samoa|-11|0|SST|SST", "Pacific/Honolulu|Hawaiian Islands, Tahiti|-10|0|HST|HST", "America/Anchorage|Anchorage - Alaska|-9|1|AKST|AKDT|N America DST", "America/Los_Angeles|Pacific Time (US & Canada), Tijuana|-8|1|PST|PDT|N America DST", "America/Denver|Mountain Time (US & Canada)|-7|1|MST|MDT|N America DST", "America/Phoenix|Phoenix - Arizona|-7|0|MST_2|MST_2", "America/Chicago|Central Time (US & Canada)|-6|1|CST|CDT|N America DST", "America/Mexico_City|Mexico City|-6|1|MST_3|MDT_3|Mexico DST", "America/Guatemala|Costa Rica, Managua, San Salvador|-6|0|CST_1|CST_1", "America/Saskatchewan|Saskatchewan|-6|0|CST_2|CST_2|", "America/Lima|Bogota, Lima, Quito|-5|0|CST_3|CST_3", "America/New_York|Eastern Time (US & Canada)|-5|1|EST|EDT|N America DST", "America/Havana|Havana|-5|1|CST_5|CDT_5|Havana DST", "America/Indianapolis, Nunavut|Indiana (US)|-5|0|EST_1|EST_1", "America/Asuncion|Asuncion|-4|1|PYT|PYST|Paraguay DST", "America/Caracas|Caracas, La Paz, San Juan|-4|0|AST|AST", "America/Halifax|Atlantic Time (Canada), Halifax, Saint John, Charlottetown|-4|1|AST_4|ADT_4|N America DST", "America/Santiago|Santiago|-4|1|CLT|CLST|Chile DST", "America/Thule|Thule (Qaanaaq)|-4|1|AST_2|ADT_2|N America DST", "America/St_Johns|St. John's - Newfoundland|-3.5|1|NST|NDT|N America DST", "America/Sao_Paulo|Brasilia, Rio de Janeiro, Sao Paulo|-3|1|BRT|BRST|Brazil DST", "America/Buenos_Aires|Buenos Aires, Georgetown|-3|0|ART|ART", "America/Godthab|Godthab (Nuuk) - Greenland|-3|1|WGT|WGST|Godthab DST", "America/Noronha|Mid-Atlantic|-2|0|FNT|FNT", "Atlantic/Azores|Azores, Scoresbysund|-1|1|EGT|EGST|Azores DST", "Atlantic/Cape_Verde|Praia - Cape Verde|-1|0|CVT|CVT", "Africa/Casablanca|Casablanca, Reykjavik, Monrovia|0|0|GMT_0|GMT_0", "GMT|Greenwich Mean Time|0|0|GMT|GMT", "Europe/London|Dublin, Edinburgh, London, Lisbon|0|1|WET|WEST|Europe DST1", "Europe/Paris|Amsterdam, Berlin, Rome, Stockholm, Paris|1|1|CET|CEST|Europe DST1", "Europe/Belgrade|Belgrade, Bratislava, Budapest, Ljubljana, Prague|1|1|CET_1|CEST_1|Europe DST1", "Europe/Brussels|Brussels, Copenhagen, Madrid, Vienna|1|1|CET_2|CEST_2|Europe DST1", "Europe/Sarajevo|Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb|1|1|CET_3|CEST_3|Europe DST1", "Africa/Lagos|West Central Africa, Algiers, Lagos, Luanda|1|0|WAT_2|WAT_2", "Africa/Windhoek|Windhoek (Namibia)|1|1|WAT|WAST|W Africa DST", "Africa/Cairo|Al Jizah, Alexandria, Cairo|2|1|EET|EEST|Cairo DST", "Asia/Amman|Amman|2|1|EET_1|EEST_1|Jordan DST", "Europe/Istanbul|Athens, Bucharest, Istanbul|2|1|EET_2|EEST_2|Athens DST", "Asia/Beirut|Beirut|2|1|EET_3|EEST_3|Lebanon DST", "Africa/Harare|Cape Town, Harare, Johannesburg, Pretoria|2|0|SAT|SAT", "Asia/Jerusalem|Jerusalem|2|1|IST|IDT|Israel DST", "Europe/Minsk|Kaliningrad, Minsk|2|1|EET_4|EEST_4|Minsk DST", "Africa/Nairobi|Aden, Antananarivo, Khartoum, Nairobi|3|0|EAT|EAT", "Asia/Baghdad|Baghdad|3|1|AST_3|ADT_3|Iraq DST", "Asia/Kuwait|Kuwait, Riyadh|3|0|AST_1|AST_1", "Europe/Moscow|Moscow, St. Petersburg, Novgorod|3|1|MSK|MSD|Russia DST", "Asia/Tehran|Tehran|3.5|1|IRT|IRST|Iran DST", "Asia/Muscat|Abu Dhabi, Mauritius, Muscat|4|0|GST|GST", "Asia/Aqtau|Aqtau, T'bilisi|4|1|AQTT|AQTST|Europe DST0", "Asia/Baku|Baku|4|1|AZT|AZST|Europe DST1", "Asia/Yerevan|Yerevan, Samara|4|1|SAMT|SAMST|Russia DST", "Asia/Kabul|Kabul|4.5|0|AFT|AFT", "Asia/Yekaterinburg|Chelyabinsk, Prem, Yekaterinburg, Ufa|5|1|YEKT|YEKST|Russia DST", "Asia/Karachi|Islamabad, Karachi, Tashkent|5|0|PKT|PKT", "Asia/Calcutta|Calcutta, Mumbai, New Delhi, Chennai|5.5|0|IST_2|IST_2", "Asia/Katmandu|Kathmandu|5.75|0|NPT|NPT", "Asia/Almaty|Almaty|6|1|ALMT|ALMST|Europe DST0", "Asia/Colombo|Colombo, Dhaka, Astana|6|0|BST|BST", "Asia/Novosibirsk|Novosibirsk, Omsk|6|1|NOVT|NOVST|Russia DST", "Indian/Cocos|Cocos, Rangoon|6.5|0|CCT|CCT", "Asia/Bangkok|Bangkok, Hanoi, Jakarta|7|0|ICT|ICT", "Asia/Krasnoyarsk|Krasnoyarsk, Norilsk, Novokuznetsk|7|1|KRAT|KRAST|Russia DST", "Asia/Irkutsk|Irkutsk, Ulaan Bataar|8|1|IRKT|IRKST|Russia DST", "Asia/Shanghai|Beijing, Shanghai, Hong Kong, Urumqi|8|0|CST_8|CST_8", "Australia/Perth|Perth|8|0|WST|WST", "Asia/Singapore|Singapore, Manila, Taipei, Kuala Lumpur|8|0|SGT|SGT", "Asia/Yakutsk|Chita, Yakutsk|9|1|YAKT|YAKST|Russia DST", "Asia/Tokyo|Osaka, Sapporo, Tokyo|9|0|JST|JST", "Asia/Seoul|Palau, Pyongyang, Seoul|9|0|KST|KST", "Australia/Adelaide|Adelaide, Broken Hill|9.5|1|ACT|ACST|Australia DST", "Australia/Darwin|Darwin|9.5|0|ACT_9|ACT_9", "Australia/Brisbane|Brisbane, Port Moresby, Guam|10|0|AET_10|AET_10", "Australia/Sydney|Canberra, Melbourne, Sydney|10|1|AET|AEST|Australia DST", "Australia/Hobart|Hobart|10|1|AET_11|AEST_11|Australia DST", "Asia/Vladivostok|Khabarovsk, Vladivostok|10|1|VLAT|VLAST|Russia DST", "Australia/Lord_Howe|Lord Howe Island|10.5|0.5|LHST|LHDT|Lord Howe DST", "Asia/Magadan|Honiara, Magadan, Soloman Islands|11|1|MAGT|MAGST|Russia DST", "Pacific/Noumea|Noumea - New Caledonia|11|0|NCT|NCT|", "Pacific/Norfolk|Kingston - Norfolk Island|11.5|0|NFT|NFT", "Asia/Kamchatka|Andyra, Kamchatka|12|1|ANAT|ANAST|Anadyr DST", "Pacific/Auckland|Auckland, Wellington|12|1|NZST|NZDT|New Zealand DST", "Pacific/Majuro|Marshall Islands, Eniwetok|12|0|MHT|MHT", "Pacific/Fiji|Suva - Fiji|12|1|FJT|FJST|Fiji DST", "Pacific/Chatham|Chatham Island|12.75|1|CHST|CHDT|Chatham DST", "Pacific/Tongatapu|Nuku'alofa - Tonga|13|1|TOT|TOST|Tonga DST", "Pacific/Enderbury|Rawaki, Phoenix Islands|13|0|PHOT|PHOT", "Pacific/Kiritimati|Line Islands, Kiritimati - Kiribati|14|0|LINT|LINT"};
    }
}

