/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.HoLoFactory;
import cerent.util.ILoNum;

public class Ds123PortModel
extends PortModel {
    public Ds123PortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(Ds123PortModel.class));
    }

    public void init() {
        super.init();
    }

    public Ds123LineModel getDs123LineModel() {
        return (Ds123LineModel)this.getInterfaceModel();
    }

    public int getMaxVt() {
        IModuleModel iModuleModel = this.getModuleModel();
        if (iModuleModel.getEqType() == 47) {
            return iModuleModel.getDescendantsOfEqType(34).size();
        }
        return super.getMaxVt();
    }

    public ILoNum getMaxLo(int n) {
        IModuleModel iModuleModel = this.getModuleModel();
        switch (iModuleModel.getEqType()) {
            case 47: 
            case 157: {
                int n2 = iModuleModel.getDescendantsOfEqType(34).size();
                if (n2 == 0) break;
                int n3 = ((ModuleModel)iModuleModel).calcFramingTypeForLo();
                ILoNum iLoNum = HoLoFactory.createFirstLoNum(n3, n);
                return HoLoFactory.addGroupOffset(iLoNum, n2 - 1);
            }
            case 233: 
            case 234: {
                int n4;
                if (this.getEqType() != 68 || (n4 = iModuleModel.getDescendantsOfEqType(68).size()) == 0) break;
                int n5 = ((ModuleModel)iModuleModel).calcFramingTypeForLo();
                ILoNum iLoNum = HoLoFactory.createFirstLoNum(n5, n);
                return HoLoFactory.addGroupOffset(iLoNum, n4 - 1);
            }
            case 248: {
                return iModuleModel.getMaxLo(n);
            }
        }
        return null;
    }

    public String toString() {
        return "Ds123" + super.toString();
    }

    public boolean isInLoopback() {
        return this.getDs123LineModel().getLoopbackAsInt() != 0;
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        this.db.info("Ds123PortModel.maybeSetAdminState()");
        if (n2 == 2) {
            if (n3 == 1 && this.getEqType() == 34) {
                n3 = 0;
            } else if (n3 == 12 && this.getEqType() == 34) {
                n3 = 9;
            } else if (n3 == 12 && this.getEqType() == 68) {
                n3 = 10;
            }
        }
        return super.maybeSetAdminState(n, n2, n3);
    }
}

