/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eBackPlaneRate;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SlotModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UserException;

public class Ds3xmModuleModel
extends Ds123ModuleModel {
    private BackplaneRate backplaneRate;

    public Ds3xmModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.backplaneRate = new BackplaneRate(this.node, "Ds3xmModuleModel.backplaneRate");
    }

    public Ds123LineModel[] getFilteredDs3Lines() {
        Ds123LineModel[] ds123LineModelArray = (Ds123LineModel[])this.getLineModels();
        if (this.getEqType() == 8) {
            return ds123LineModelArray;
        }
        int n = ds123LineModelArray.length != 36 ? 18 : 24;
        Ds123LineModel[] ds123LineModelArray2 = new Ds123LineModel[n];
        int n2 = 0;
        for (int i = 0; i < ds123LineModelArray.length; ++i) {
            if (i >= 12 && (i <= 11 || i % 2 != 1)) continue;
            ds123LineModelArray2[n2] = ds123LineModelArray[i];
            ++n2;
        }
        return ds123LineModelArray2;
    }

    public Ds123LineModel[] getPortedDs3Lines() {
        Ds123LineModel[] ds123LineModelArray = (Ds123LineModel[])this.getLineModels();
        if (this.getEqType() == 8) {
            return ds123LineModelArray;
        }
        Ds123LineModel[] ds123LineModelArray2 = new Ds123LineModel[12];
        System.arraycopy(ds123LineModelArray, 0, ds123LineModelArray2, 0, ds123LineModelArray2.length);
        return ds123LineModelArray2;
    }

    public Ds123LineModel[] getDs1Lines() {
        Collection collection = InterfaceModel.getHigherLayerModels(this.getLineModels(), 1, this);
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        for (InterfaceModel interfaceModel : collection) {
            if (!(interfaceModel instanceof Ds123LineModel)) continue;
            arrayList.add(interfaceModel);
        }
        return arrayList.toArray(new Ds123LineModel[arrayList.size()]);
    }

    public eBackPlaneRate getBackplaneRate() {
        eBackPlaneRate eBackPlaneRate2 = eBackPlaneRate.BACKPLANE_RATE_DEFAULT;
        if (this.getEqType() == 145) {
            try {
                eBackPlaneRate2 = (eBackPlaneRate)this.backplaneRate.get();
                if (this.db.on()) {
                    this.db.println("getBackplaneRate(): " + eBackPlaneRate2);
                }
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                if (this.db.on()) {
                    this.db.println("NE doesn't support getBackplaneRate operation");
                }
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
        return eBackPlaneRate2;
    }

    public void setBackplaneRate(eBackPlaneRate eBackPlaneRate2) throws ProvisionError, UnsupportedOperation {
        if (this.getEqType() == 145) {
            try {
                this.backplaneRate.set(eBackPlaneRate2);
            }
            catch (xProvisionError xProvisionError2) {
                boolean bl;
                ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
                SlotModel slotModel = (SlotModel)this.getParent();
                AbstractSlotPolicy abstractSlotPolicy = this.getNodeModelDelegate().getSlotPolicy();
                boolean bl2 = bl = abstractSlotPolicy.hasEqType(slotModel, eEqType.XCVT_CARD) || abstractSlotPolicy.hasEqType(slotModel, eEqType.XC_CARD);
                if (protectionGroupModel == null) {
                    if (bl && (this.getSlotNum() >= 1 && this.getSlotNum() <= 4 || this.getSlotNum() >= 14 && this.getSlotNum() <= 17)) {
                        throw this.doUnknown("Backplane rate can only be STS12C for \nthis card/slot/crossconnect combination \n", xProvisionError2);
                    }
                    throw this.doUnknown("Unknown error, backplane rates of STS12C \nand STS48C are valid for this configuration.", xProvisionError2);
                }
                if (this.isProtectModule()) {
                    if (bl) {
                        throw this.doUnknown("Backplane rate for the protect card can only be STS12C \nbecause the cross connect card is an XC or XCVT \n", xProvisionError2);
                    }
                    throw this.doUnknown("Unknown error, backplane rates of STS12C \nand STS48C are valid for this configuration.", xProvisionError2);
                }
                Ds3xmModuleModel ds3xmModuleModel = (Ds3xmModuleModel)this.getProtectionGroupModel().getProtectedModuleModel();
                if (ds3xmModuleModel.getBackplaneRate() == eBackPlaneRate.STS12) {
                    throw this.doUnknown("Working card cannot be upgraded because \nthe protect card backplane rate is STS12C", xProvisionError2);
                }
                throw this.doUnknown("Unknown error, backplane rates of STS12C \nand STS48C are valid for this configuration", xProvisionError2);
            }
            catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
                throw this.doUnknown("setBackPlaneRate. \nChanging Backplane rate is not supported \n", xNotSupportedOnEquipment2);
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public boolean supportsHighSpeedBackplaneRate() {
        int n = this.getSlot();
        SlotModel slotModel = (SlotModel)this.getParent();
        AbstractSlotPolicy abstractSlotPolicy = this.getNodeModelDelegate().getSlotPolicy();
        boolean bl = abstractSlotPolicy.hasEqType(slotModel, eEqType.XC192_CARD) || !abstractSlotPolicy.hasEqType(slotModel, eEqType.XCVT_CARD) && !abstractSlotPolicy.hasEqType(slotModel, eEqType.XC_CARD);
        return bl || abstractSlotPolicy.isHighSpeedSlot(n);
    }

    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        return null;
    }

    protected IPortModel getPortModelForHoPath(IEntityModel iEntityModel, IHoNum iHoNum) {
        return null;
    }

    public boolean isOneForNProtectModule() {
        return this.isProtectModule() && this.getProtectionGroupModel().getProtectType() == eProtectionType.ONE_FOR_N;
    }

    public boolean isOneForOneProtectModule() {
        return this.isProtectModule() && this.getProtectionGroupModel().getProtectType() == eProtectionType.ONE_FOR_ONE;
    }

    protected void updateLocal() {
        this.backplaneRate.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        this.backplaneRate.dispose();
        super.dispose();
    }

    private class BackplaneRate
    extends CachedValue {
        public BackplaneRate(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            return Ds3xmModuleModel.this.getCardModuleRef().getBackPlaneRate(Ds3xmModuleModel.this.entityIndex);
        }

        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Ds3xmModuleModel.this.getCardModuleRef().setBackPlaneRate(Ds3xmModuleModel.this.entityIndex, (eBackPlaneRate)object);
        }

        public Object outer() {
            return Ds3xmModuleModel.this;
        }
    }
}

