/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eOpticalDirection;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.OpticsTopology.eTopologyDirection;
import cerent.cms.idl.OpticsTopology.eTopologyMask;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTerms;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwdmPortModel
extends PortModel
implements IDwdmPortModel {
    public DwdmPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(DwdmPortModel.class));
        this.index = n;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public boolean isOptical() {
        return true;
    }

    @Override
    public boolean hasOpticalProtection() {
        return false;
    }

    public int getOptChannel() {
        int n = 0;
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
            try {
                n = ((DwdmTrkLineModel)abstractDwdmLineModel).getWavelength();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return n;
    }

    public boolean hasYCableProtection() {
        boolean bl = false;
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                bl = true;
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return bl;
    }

    public int getYCableWorkingEntityIndex() {
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                return ((YCableModel)elementModel).getMainEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return -1;
    }

    @Override
    public int getMediumType() {
        int n = 1;
        try {
            if (this.getDwdmLineModel().getFramingType() == 1) {
                n = 0;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return n;
    }

    public int getYCableProtectEntityIndex() {
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                return ((YCableModel)elementModel).getProtectEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return -1;
    }

    public IElementModel getElementModel() throws AbstractCmsNoSuchElementException {
        return this.getDwdmLineModel().getElementModel();
    }

    @Override
    public boolean isClientPort() {
        try {
            if (this.getModuleModel().getEqType() == 293 || this.getModuleModel().getEqType() == 300 || this.getModuleModel().getEqType() == 301) {
                return this.getDwdmLineModel().isClient();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            wrongInterfaceType.printStackTrace();
        }
        return 122 == this.getEqType();
    }

    public boolean isPortRateISC() {
        return this.getDwdmLineModel().isDataRateISC();
    }

    @Override
    public boolean isSpecial() {
        return !this.isClientPort();
    }

    public AbstractDwdmLineModel getDwdmLineModel() {
        return (AbstractDwdmLineModel)this.getInterfaceModel();
    }

    public boolean isSonetDccTermination() {
        OhTerms ohTerms = this.getChassis().getOhConnectionModels().getOhTerms();
        boolean bl = ohTerms.isChannelInUse(this.entityIndex, OhChannelType.SDCC_OBJ) || ohTerms.isChannelInUse(this.entityIndex, OhChannelType.LDCC_OBJ);
        return bl;
    }

    public boolean isGccTermination() {
        OhTerms ohTerms;
        boolean bl = false;
        if (!this.isClientPort() && (ohTerms = this.getChassis().getOhConnectionModels().getOhTerms()).isChannelInUse(this.entityIndex, OhChannelType.GCC_OBJ)) {
            bl = true;
        }
        return bl;
    }

    public boolean isPortIS() {
        try {
            return this.getDwdmLineModel().getAdminStateEnum() == eAdminState.ADMIN_IS;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return false;
        }
    }

    public void setPortOOS() {
        try {
            this.getDwdmLineModel().setAdminState(eAdminState.ADMIN_OOS_DSBLD);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (LoopbackActive loopbackActive) {
            SDebug.printStackTrace((Throwable)loopbackActive);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
        }
        catch (SyncProvError syncProvError) {
            SDebug.printStackTrace((Throwable)syncProvError);
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
        }
    }

    public void setPortIS() {
        try {
            this.getDwdmLineModel().setAdminState(eAdminState.ADMIN_IS);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (LoopbackActive loopbackActive) {
            SDebug.printStackTrace((Throwable)loopbackActive);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
        }
        catch (SyncProvError syncProvError) {
            SDebug.printStackTrace((Throwable)syncProvError);
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
        }
    }

    private boolean isPayloadCompatible() {
        boolean bl = true;
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        try {
            switch (abstractDwdmLineModel.getPayloadType()) {
                case 2: 
                case 3: 
                case 5: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.db.severe("Failed retrieving payload type!");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        this.db.fine("DwdmPortModel.maybeSetAdminState()");
        boolean bl = false;
        boolean bl2 = true;
        int n4 = this.getAdminState();
        if (n4 != 1 && n != 0 && n4 != n) {
            bl2 = !this.isPayloadCompatible() ? n != 3 : true;
            if (!bl2) {
                n = -1;
                this.db.fine("Overwrite targetAdminState! due to failure or payload type is not SONET/SDH!");
            } else {
                boolean bl3 = bl2 = !this.isTimingSource() && !this.hasOhChannel() && !this.inProhibitiveOpticalProtectionGroup();
                if (bl2 && n == 1 && n2 != 1 && this.isSonetDccTermination()) {
                    this.db.fine("Skipping SonetDccTermination");
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            bl = super.maybeSetAdminState(n, n2, n3);
        } else {
            this.db.info("Skipping because TDM level services provided by port");
        }
        return bl;
    }

    private boolean inProhibitiveOpticalProtectionGroup() throws NoSuchInterface {
        boolean bl = false;
        if (this.hasYCableProtection()) {
            int n = this.getYCableWorkingEntityIndex();
            if (n != this.getIndex()) {
                IEntityModel iEntityModel = null;
                try {
                    iEntityModel = this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.severe(abstractCmsNoSuchEntityException.toString());
                }
                if (iEntityModel instanceof DwdmPortModel) {
                    DwdmPortModel dwdmPortModel = (DwdmPortModel)iEntityModel;
                    bl = dwdmPortModel.hasOhChannel() || dwdmPortModel.isTimingSource();
                }
            }
        } else if (this.hasOpticalProtection()) {
            bl = true;
        }
        return bl;
    }

    public boolean hasOhChannel() {
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        Iterator iterator = OhChannelType.getAllOhChannelTypes().iterator();
        while (iterator.hasNext()) {
            if (!ohConnectionModelsDelegate.isChannelInUse(this.entityIndex, (OhChannelType)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInLoopback() {
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        try {
            return abstractDwdmLineModel != null && abstractDwdmLineModel.getLoopbackAsInt() != 0;
        }
        catch (Exception exception) {
            this.db.println("Ignoring Exceptions and returning NO LOOPBACK");
            return false;
        }
    }

    @Override
    public String toString() {
        return "Dwdm" + super.toString();
    }

    public boolean isDistExtensionEnabled() {
        block3: {
            try {
                return this.getDwdmLineModel().getFcmrLineModel().isDistExtensionEnabled();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) break block3;
                this.db.println("no such interface in isDistExtensionEnabled");
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public int getPortGroupMode() {
        boolean bl = this.getPort() <= 4;
        switch (((ModuleModel)this.getModuleModel()).getCardOperMode().value()) {
            case 13: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 14: {
                return bl ? 0 : 1;
            }
            case 15: {
                return bl ? 1 : 0;
            }
        }
        return -1;
    }

    public IEntityModel getRegenPeerLineModel() {
        IEntityModel iEntityModel = null;
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
            try {
                iEntityModel = ((DwdmTrkLineModel)abstractDwdmLineModel).getRegenPeerLine();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return iEntityModel;
    }

    @Override
    public List<IPortModel> getNextLogicalPorts() {
        return this.getPortTopology(eOpticalDirection.TX, eWavelength.from_int(this.getOptChannel()), eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getNextPhysicalPorts() {
        return this.getPortTopology(eOpticalDirection.TX, eWavelength.from_int(this.getOptChannel()), eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_OPTICAL);
    }

    @Override
    public List<IPortModel> getPrevLogicalPorts() {
        return this.getPortTopology(eOpticalDirection.RX, eWavelength.from_int(this.getOptChannel()), eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getPrevPhysicalPorts() {
        return this.getPortTopology(eOpticalDirection.RX, eWavelength.from_int(this.getOptChannel()), eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_OPTICAL);
    }
}

