/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplicateDccNum;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import java.util.Set;

public class GccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType GCC_TERM_CHANNEL_TYPE = OhChannelType.GCC_OBJ;
    private static NodeSingletonFactory<GccTermConnectionModel> sfactory = new NodeSingletonFactory<GccTermConnectionModel>(GccTermConnectionModel.class);

    public static GccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private GccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        GccTermConnectionModel gccTermConnectionModel = (GccTermConnectionModel)nodeModelDelegate.getGccTermConnectionModel();
        gccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        Set set = this.nonClientPorts(elementModelsDelegate.getNonProtectDwdmEntities());
        set.removeAll(this.nonOTNPorts(set));
        set.removeAll(this.dwdmUnframedPorts(set));
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        set.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(GCC_TERM_CHANNEL_TYPE));
        Set set2 = this.excludeUcpTerms(set);
        return set2.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return "GCC";
    }

    public void createTermination(IEntityModel iEntityModel, eGccRate eGccRate2, boolean bl) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, ProvisionError, DuplicateDccNum {
        this.createTermination(iEntityModel, bl, false, eGccRate2);
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return GCC_TERM_CHANNEL_TYPE;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

