/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.EtherMedia.sIngressQOSInfo;
import cerent.cms.idl.EtherMedia.sL1AdminInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.HoPathTraceModel;
import cerent.cms.model.IHdGeLineModel;
import cerent.cms.model.IPathTraceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PoolModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class HdGeLineModel
extends EtherLineModel
implements IHdGeLineModel {
    private StatsLastCleared statsLastCleared;
    private HoPathTraceModel hoPathTraceModel = null;
    private EtherL1Info etherL1Info;
    private EtherL1AdminInfo etherL1AdminInfo;

    public HdGeLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.index = n;
        this.statsLastCleared = new StatsLastCleared(nodeModelDelegate, "HdGeLineModel.statsLastCleared");
        this.etherL1Info = new EtherL1Info(nodeModelDelegate, "EtherL1Info.etherL1Info");
        this.etherL1AdminInfo = new EtherL1AdminInfo(nodeModelDelegate, "HdGeLineModel.etherL1AdminInfo");
    }

    public List getConnectionsList() {
        PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getIndex());
        if (poolModel != null) {
            return poolModel.getConnectionsList();
        }
        return new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoopbackAsInt() {
        int n = 0;
        Throwable throwable = null;
        try {
            n = this.getGmacLineAdminInfo_4_01().loopback.value();
        }
        catch (NoSuchInterface noSuchInterface) {
            throwable = noSuchInterface;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            throwable = wrongInterfaceType;
        }
        finally {
            if (throwable != null && this.db.on()) {
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
        return n;
    }

    protected void updateLocal(long l) {
        this.etherL1Info.update();
        this.etherL1AdminInfo.update();
        this.setChanged();
        super.updateLocal(l);
    }

    public void dispose() {
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.dispose();
        }
        this.etherL1Info.dispose();
        this.etherL1AdminInfo.dispose();
        super.dispose();
    }

    public void destroy() {
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.destroy();
        }
        super.destroy();
    }

    public int getLineLastClearedStats() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (Integer)this.statsLastCleared.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface("Attempted to access non-existant interface [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType("Attempted an operation that cannot be performed for this interface type [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new UnsupportedOperation("Attempted an operation that cannot be performed for this interface type [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public int getPathTraceMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getPathTraceMode() not supported");
    }

    public void setPathTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setPathTraceMode() not supported");
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        throw new FeatureNotSupported("getCurrentPayloadLabel() not supported");
    }

    public String getSendPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getSendPathTrace() not supported");
    }

    public void setSendPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setSendPathTrace() not supported");
    }

    public char[] getExpectedPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getExpectedPathTrace() not supported");
    }

    public void setExpectedPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setExpectedPathTrace() not supported");
    }

    public char[] getReceivedPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getReceivedPathTrace() not supported");
    }

    public int getPathTraceFormat() {
        throw new FeatureNotSupported("getPathTraceFormat() not supported");
    }

    public void setPathTraceFormat(int n) {
        throw new FeatureNotSupported("setPathTraceFormat() not supported");
    }

    public synchronized IPathTraceModel getHoPathTraceModel() {
        if (this.hoPathTraceModel == null) {
            this.hoPathTraceModel = new HoPathTraceModel(this);
        }
        return this.hoPathTraceModel;
    }

    public boolean isTransponder() {
        boolean bl = false;
        try {
            bl = this.getGmacLineAdminInfo_4_01().mode.value() != 0;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return bl;
    }

    public sL1Info getEtherL1Info() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::getEtherL1Info");
        }
        try {
            return (sL1Info)this.etherL1Info.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xWrongInterfaceType2));
            }
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            }
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getEtherL1Info", userException);
        }
    }

    public void setEtherL1Info(sL1Info sL1Info2) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ConfigError {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::setEtherL1Info");
        }
        try {
            this.etherL1Info.set(sL1Info2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("setEtherL1Info", userException);
        }
    }

    public sL1AdminInfo getEtherL1AdminInfo() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::getEtherL1AdminInfo");
        }
        try {
            return (sL1AdminInfo)this.etherL1AdminInfo.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xWrongInterfaceType2));
            }
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            }
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getEtherL1AdminInfo", userException);
        }
    }

    class StatsLastCleared
    extends NonCachedValue {
        public StatsLastCleared(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(HdGeLineModel.this.getEtherMediaRef().getStatsLineLastClearedTime(HdGeLineModel.this.getIndex()));
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }

    private class EtherL1AdminInfo
    extends CachedValue {
        public EtherL1AdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xNotSupportedOnEquipment {
            return HdGeLineModel.this.getEtherMediaRef().getL1AdminInfo(HdGeLineModel.this.getIndex());
        }

        protected Object cloneValue() {
            sL1AdminInfo sL1AdminInfo2 = (sL1AdminInfo)this.value;
            sL1AdminInfo sL1AdminInfo3 = new sL1AdminInfo(sL1AdminInfo2.duplex, sL1AdminInfo2.speed, sL1AdminInfo2.flowControl);
            return sL1AdminInfo3;
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }

    private class EtherL1Info
    extends CachedValue {
        public EtherL1Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            HdGeLineModel.this.getEtherMediaRef().setL1Info(HdGeLineModel.this.getIndex(), (sL1Info)object);
        }

        protected Object getValue() throws UserException {
            return HdGeLineModel.this.getEtherMediaRef().getL1Info(HdGeLineModel.this.getIndex());
        }

        protected Object cloneValue() {
            sL1Info sL1Info2 = (sL1Info)this.value;
            sL1Info sL1Info3 = new sL1Info(sL1Info2.duplex, sL1Info2.speed, sL1Info2.flowControl, new sIngressQOSInfo(sL1Info2.ingressQos.committedInfoRate, sL1Info2.ingressQos.committedBurstSize, sL1Info2.ingressQos.excOrPeakBurstSize, sL1Info2.ingressQos.peakInfoRate, sL1Info2.ingressQos.couplingFlag, sL1Info2.ingressQos.colorMode), sL1Info2.mtu, sL1Info2.mappingMode, sL1Info2.etherMode);
            return sL1Info3;
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }
}

