/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.SonetTopology.StsCircuitPart;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.sStsConnectionItem;
import cerent.cms.idl.SonetTopology.sVtAditItem;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoCircuitPartModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.event.AttributeValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import org.omg.CORBA.UserException;

public abstract class HoCircuitPartModel
extends ConnectionModel
implements IHoCircuitPartModel {
    protected AdminState adminState;
    protected ServiceState serviceState;
    protected ConnectionName connectionName;
    protected CircuitId circuitId;
    protected ConnectionType connectionType;
    protected PathWidth pathWidth;
    protected ObjIndex objIndex;
    protected ValidAdminStateTransitions validAdminStateTransitions;
    private String myString;

    public HoCircuitPartModel(NodeModelDelegate nodeModelDelegate, Connections connections) {
        this(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(HoCircuitPartModel.class));
    }

    public HoCircuitPartModel(NodeModelDelegate nodeModelDelegate, Connections connections, SDebug sDebug) {
        super(nodeModelDelegate, connections, sDebug);
        this.adminState = new AdminState(nodeModelDelegate, "HoCircuitPart.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "HoCircuitPart.serviceState");
        this.connectionName = new ConnectionName(nodeModelDelegate, "HoCircuitPart.adminState");
        this.circuitId = new CircuitId(nodeModelDelegate, "HoCircuitPart.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "HoCircuitPart.connectionType");
        this.objIndex = new ObjIndex(nodeModelDelegate, "HoCircuitPart.objIndex");
        this.pathWidth = new PathWidth(nodeModelDelegate, "HoCircuitPart.pathWidth");
        this.validAdminStateTransitions = new ValidAdminStateTransitions(nodeModelDelegate, "HoCircuitPart.validAdminStateTransitions");
        this.myString = null;
    }

    protected abstract StsCircuitPart getCircuitPart();

    public void init() {
        super.init();
    }

    public void dispose() {
        this.adminState.dispose();
        this.serviceState.dispose();
        this.connectionName.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.pathWidth.dispose();
        this.validAdminStateTransitions.dispose();
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    protected void updateLocal() {
        if (this.db.on) {
            this.db.println("HoCircuitPartModel.updateLocal()");
        }
        this.adminState.update();
        this.serviceState.update();
        this.connectionName.update();
        this.circuitId.update();
        this.connectionType.update();
        this.pathWidth.update();
        this.validAdminStateTransitions.update();
        this.setChanged();
        super.updateLocal();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectStsConnection;
    }

    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("HoCircuitPartModel.getCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("HoCircuitPartModel.setCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("HoCircuitPartModel.getConnectionType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public short getPathWidth() {
        try {
            return (Short)this.pathWidth.get();
        }
        catch (UserException userException) {
            this.db.println("HoCircuitPartModel.getPathWidth(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int calcFramingType() {
        if (this.getNodeModel().getTdmProtocolTypeObj().isSonet()) {
            return 0;
        }
        return this.getPathWidth() == 1 ? 2 : 1;
    }

    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("HoCircuitPartModel.getObjIndex(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getShelfId() {
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(this.getObjIndex());
            return iEntityModel.getShelfId();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.fine("no such entity for " + this.getObjIndex());
            return 1;
        }
    }

    public void setAttributes(sStsConnectionItem sStsConnectionItem2) {
        this.adminState.setValueExternally(sStsConnectionItem2.adminState);
        this.serviceState.setValueExternally(sStsConnectionItem2.serviceState);
        this.circuitId.setValueExternally(sStsConnectionItem2.circuitId);
        this.connectionName.setValueExternally(sStsConnectionItem2.name);
        this.connectionType.setValueExternally(sStsConnectionItem2.connectionType);
        this.objIndex.setValueExternally(new Integer(sStsConnectionItem2.objIndex));
        this.pathWidth.setValueExternally(new Short(sStsConnectionItem2.pathWidth));
    }

    public void setAttributes(sVtAditItem sVtAditItem2) {
        this.adminState.setValueExternally(sVtAditItem2.adminState);
        this.serviceState.setValueExternally(sVtAditItem2.serviceState);
        this.circuitId.setValueExternally(sVtAditItem2.circuitId);
        this.objIndex.setValueExternally(new Integer(sVtAditItem2.objIndex));
    }

    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public Boolean validateNewAdminStateEnum(eAdminState eAdminState2) throws AbstractCmsIOException {
        eAdminState[] eAdminStateArray;
        try {
            eAdminStateArray = (eAdminState[])this.validAdminStateTransitions.get();
        }
        catch (UserException userException) {
            this.db.severe("StsCircuitPartModel: user exception in validateNewAdminStateEnum");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        if (eAdminStateArray != null) {
            for (int i = 0; i < eAdminStateArray.length; ++i) {
                if (!eAdminState2.equals(eAdminStateArray[i])) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        Boolean bl = this.validateNewAdminStateEnum(eAdminState.from_int(n));
        return bl == null ? false : bl;
    }

    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("StsCircuitPartModel: user exception in getAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("HoCircuitPartModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("StsCircuitPartModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("StsCircuitPartModel: user exception in getServiceState");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    protected void printString(SDebug sDebug) {
        sDebug.println("Connection Type " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()]);
        sDebug.println("Connection Index " + this.getIndex());
        sDebug.println("CktName =  " + this.getConnectionName());
        sDebug.println("CktId= " + this.prettyString(this.getCircuitId()));
        sDebug.println("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Info on Connection: \nConnection Index = " + this.getIndex() + "\n" + "Connection Type = " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()] + "\n" + "Connection Name =  " + this.getConnectionName() + "\n";
            }
            catch (Exception exception) {
                return "HoCircuitPartModel";
            }
        }
        return this.myString;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("HoLoConnectionModel update(): this CHANGED");
                    }
                    ArrayList arrayList = ((ObjectMessageInfo)object).getChangedValues();
                    this.updateLocal();
                    for (AttributeValue attributeValue : arrayList) {
                        switch (attributeValue.getName()) {
                            case 0: {
                                this.serviceState.setValueExternally(attributeValue.getValue());
                            }
                        }
                    }
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                default: {
                    super.update(observable, object);
                }
            }
        }
    }

    private class PathWidth
    extends CachedValue {
        public PathWidth(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(HoCircuitPartModel.this.getCircuitPart().pathWidth());
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return HoCircuitPartModel.this;
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoCircuitPartModel.this.getCircuitPart().connectionType();
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return HoCircuitPartModel.this;
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            int n = HoCircuitPartModel.this.getCircuitPart().objIndex();
            return new Integer(n);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return HoCircuitPartModel.this;
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (HoCircuitPartModel.this.db.on) {
                HoCircuitPartModel.this.db.println("Making CORBA call to get circuitId");
            }
            return HoCircuitPartModel.this.getCircuitPart().circuitId();
        }

        protected void setValue(Object object) throws UserException {
            HoCircuitPartModel.this.getCircuitPart().circuitId((sCircuitId)object);
        }

        public Object outer() {
            return HoCircuitPartModel.this;
        }
    }

    class ValidAdminStateTransitions
    extends CachedValue {
        public ValidAdminStateTransitions(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoCircuitPartModel.this.getCircuitPart().validStates();
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState[])this.value);
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoCircuitPartModel.this.getCircuitPart().getConnectionName();
        }

        protected void setValue(Object object) throws UserException {
            HoCircuitPartModel.this.getCircuitPart().setConnectionName((String)object);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (HoCircuitPartModel.this.db.on) {
                HoCircuitPartModel.this.db.println("Making CORBA call to get serviceState");
            }
            return HoCircuitPartModel.this.getCircuitPart().getServiceState();
        }

        protected void setValue(Object object) {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoCircuitPartModel.this.getCircuitPart().adminState();
        }

        protected void setValue(Object object) throws UserException {
            HoCircuitPartModel.this.getCircuitPart().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }
}

