/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetMedia.eDriNodeType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.VtConnection;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.idl.SonetTopology.eTopologyUpgradeState;
import cerent.cms.idl.SonetTopology.eTopologyUpgradeType;
import cerent.cms.idl.SonetTopology.sConnCreateAttrs;
import cerent.cms.idl.SonetTopology.sVtConnectionItem;
import cerent.cms.idl.SonetTopology.sVtDef;
import cerent.cms.idl.SonetTopology.sVtTopologyUpgradeItem;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionHasFarendLoopback;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xConnectionInRoll;
import cerent.cms.idl.SonetTopology.xConnectionInTestAccess;
import cerent.cms.idl.SonetTopology.xConnectionInTopologyUpgrade;
import cerent.cms.idl.SonetTopology.xConnectionTypeError;
import cerent.cms.idl.SonetTopology.xDeleteInstead;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xInvalidProtectionOp;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.idl.SonetTopology.xPathInUse;
import cerent.cms.idl.SonetTopology.xPathListIncomplete;
import cerent.cms.idl.SonetTopology.xPathNotSupported;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.idl.SonetTopology.xTopologyUpgradeNotAllowed;
import cerent.cms.idl.SonetTopology.xVcatMemberInvalidState;
import cerent.cms.idl.SonetTopology.xVcatMemberNotOutOfGroup;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnCreateAttrsFactory;
import cerent.cms.model.ConnectionConversionFactory;
import cerent.cms.model.ConnectionConversionModel;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Connections;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPmStat;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoAditModel;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.LoTapModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.PmStatFactory;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.AttributeValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class LoConnectionModel
extends ConnectionModel
implements ILoConnectionModel {
    private UpsrSdBerLevel upsrSdBerLevel;
    private UpsrSfBerLevel upsrSfBerLevel;
    private ReverseUpsrSdBerLevel reverseUpsrSdBerLevel;
    private ReverseUpsrSfBerLevel reverseUpsrSfBerLevel;
    private ActivePaths activePaths = null;
    private AdminState adminState = null;
    private ServiceState serviceState = null;
    private ConnectionName connectionName = null;
    private CircuitId circuitId = null;
    private ConnectionType connectionType = null;
    private ObjIndex objIndex = null;
    private Paths paths = null;
    private ProtectionOp protectionOp = null;
    private ReverseProtectionOp reverseProtectionOp = null;
    private HoldoffTime holdoffTime = null;
    private ReverseHoldoffTime reverseHoldoffTime = null;
    private HoldoffTimeForPath holdoffTimeForPath = null;
    private UpsrReversion upsrReversion = null;
    private GetReverseUpsrReversion getReverseUpsrReversion = null;
    private SetReverseUpsrReversion setReverseUpsrReversion = null;
    private UpsrSwitchOnPdiP upsrSwitchOnPdiP = null;
    private GetReverseUpsrSwitchOnPdiP getReverseUpsrSwitchOnPdiP = null;
    private SetReverseUpsrSwitchOnPdiP setReverseUpsrSwitchOnPdiP = null;
    private ValidAdminStateTransitions validAdminStateTransitions = null;
    private TopologyUpgrade topologyUpgrade = null;
    private IsInTopologyUpgrade isInTopologyUpgrade = null;
    private UpsrSdBerLevelForPath upsrSdBerLevelForPath = null;
    private UpsrSfBerLevelForPath upsrSfBerLevelForPath = null;
    private AddOutput addOutput = null;
    private ChangeIntendedType changeIntendedType = null;
    private Destroy destroy = null;
    private GetSwitchCount getSwitchCount = null;
    private GetReverseSwitchCount getReverseSwitchCount = null;
    private ClearSwitchCount clearSwitchCount = null;
    private RemoveOutput removeOutput = null;
    private SetProtectionOp setProtectionOp = null;
    private SetReverseProtectionOp setReverseProtectionOp = null;
    private VtConnection vtConnRef = null;
    private PathEntities pathEntities = null;
    private PortEntities portEntities = null;
    private DriNodeType driNodeType = null;
    private String myString;
    private InRoll inRoll = null;
    private HasMonitor hasMonitor = null;

    public LoConnectionModel(NodeModelDelegate nodeModelDelegate, sVtConnectionItem sVtConnectionItem2, Connections connections) {
        this(nodeModelDelegate, sVtConnectionItem2.vtConn, connections);
        this.setAttributes(sVtConnectionItem2);
    }

    public LoConnectionModel(NodeModelDelegate nodeModelDelegate, VtConnection vtConnection, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(LoConnectionModel.class));
        this.vtConnRef = vtConnection;
        this.upsrSdBerLevel = new UpsrSdBerLevel(nodeModelDelegate, "LoConnectionModel.upsrSdBerLevel");
        this.upsrSfBerLevel = new UpsrSfBerLevel(nodeModelDelegate, "LoConnectionModel.upsrSfBerLevel");
        this.reverseUpsrSdBerLevel = new ReverseUpsrSdBerLevel(nodeModelDelegate, "LoConnectionModel.reverseUpsrBerLevel");
        this.reverseUpsrSfBerLevel = new ReverseUpsrSfBerLevel(nodeModelDelegate, "LoConnectionModel.reverseUpsrSfBerLevel");
        this.upsrSdBerLevelForPath = new UpsrSdBerLevelForPath(nodeModelDelegate, "LoConnectionModel.upsrSdBerLevelForPath");
        this.upsrSfBerLevelForPath = new UpsrSfBerLevelForPath(nodeModelDelegate, "LoConnectionModel.upsrSfBerLevelForPath");
        this.activePaths = new ActivePaths(nodeModelDelegate, "LoConnectionModel.activePaths");
        this.addOutput = new AddOutput(nodeModelDelegate, "LoConnectionModel.addOutput");
        this.adminState = new AdminState(nodeModelDelegate, "LoConnectionModel.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "LoConnectionModel.serviceState");
        this.connectionName = new ConnectionName(nodeModelDelegate, "LoConnectionModel.connectionName");
        this.changeIntendedType = new ChangeIntendedType(nodeModelDelegate, "LoConnectionModel.changeIntendedType");
        this.circuitId = new CircuitId(nodeModelDelegate, "LoConnectionModel.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "LoConnectionModel.connectionType");
        this.destroy = new Destroy(nodeModelDelegate, "LoConnectionModel.destroy");
        this.getSwitchCount = new GetSwitchCount(nodeModelDelegate, "LoConnectionModel.getSwitchCount");
        this.getReverseSwitchCount = new GetReverseSwitchCount(nodeModelDelegate, "VtConnectionModel.getReverseSwitchCount");
        this.clearSwitchCount = new ClearSwitchCount(nodeModelDelegate, "LoConnectionModel.clearSwitchCount");
        this.objIndex = new ObjIndex(nodeModelDelegate, "LoConnectionModel.objIndex");
        this.paths = new Paths(nodeModelDelegate, "LoConnectionModel.paths");
        this.pathEntities = new PathEntities(nodeModelDelegate, "LoConnectionModel.pathEntities");
        this.protectionOp = new ProtectionOp(nodeModelDelegate, "LoConnectionModel.protectionOp");
        this.reverseProtectionOp = new ReverseProtectionOp(nodeModelDelegate, "LoConnectionModel.reverseProtectionOp");
        this.holdoffTime = new HoldoffTime(nodeModelDelegate, "LoConnectionModel.holdoffTime");
        this.reverseHoldoffTime = new ReverseHoldoffTime(nodeModelDelegate, "LoConnectionModel.reverseHoldoffTime");
        this.holdoffTimeForPath = new HoldoffTimeForPath(nodeModelDelegate, "LoConnectionModel.holdoffTimeForPath");
        this.removeOutput = new RemoveOutput(nodeModelDelegate, "LoConnectionModel.removeOutput");
        this.setProtectionOp = new SetProtectionOp(nodeModelDelegate, "LoConnectionModel.setProtectioOp");
        this.setReverseProtectionOp = new SetReverseProtectionOp(nodeModelDelegate, "LoConnectionModel.setReverseProtectioOp");
        this.upsrReversion = new UpsrReversion(nodeModelDelegate, "LoConnectionModel.upsrReversion");
        this.getReverseUpsrReversion = new GetReverseUpsrReversion(nodeModelDelegate, "LoConnectionModel.getReverseUpsrReversion");
        this.setReverseUpsrReversion = new SetReverseUpsrReversion(nodeModelDelegate, "LoConnectionModel.setReverseUpsrReversion");
        this.upsrSwitchOnPdiP = new UpsrSwitchOnPdiP(nodeModelDelegate, "LoConnectionModel.upsrSwitchOnPdiP");
        this.getReverseUpsrSwitchOnPdiP = new GetReverseUpsrSwitchOnPdiP(nodeModelDelegate, "LoConnectionModel.getReverseUpsrSwitchOnPdiP");
        this.setReverseUpsrSwitchOnPdiP = new SetReverseUpsrSwitchOnPdiP(nodeModelDelegate, "LoConnectionModel.setReverseUpsrSwitchOnPdiP");
        this.pathEntities = new PathEntities(nodeModelDelegate, "LoConnectionModel.pathEntities");
        this.portEntities = new PortEntities(nodeModelDelegate, "LoConnectionModel.getPortModels");
        this.validAdminStateTransitions = new ValidAdminStateTransitions(nodeModelDelegate, "LoConnectionModel.validAdminStateTransitions");
        this.inRoll = new InRoll(nodeModelDelegate, "LoConnectionModel.inRoll");
        this.hasMonitor = new HasMonitor(nodeModelDelegate, "LoConnectionModel.hasMonitor");
        this.driNodeType = new DriNodeType(nodeModelDelegate, "LoConnectionModel.driNodeType");
        this.topologyUpgrade = new TopologyUpgrade(nodeModelDelegate, "LoConnectionModel.topologyUpgrade");
        this.isInTopologyUpgrade = new IsInTopologyUpgrade(nodeModelDelegate, "LoConnectionModel.isInTopologyUpgrade");
        this.myString = null;
    }

    public VtConnection getVtConnectionRef() {
        if (this.vtConnRef == null) {
            throw new CmsObjectNotExistException("An attempt was made to access a VT connection that has been destroyed.");
        }
        return this.vtConnRef;
    }

    public void init() {
        super.init();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectVtConnection;
    }

    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getObjIndex");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    protected void updateLocal() {
        this.upsrSdBerLevel.update();
        this.upsrSfBerLevel.update();
        this.reverseUpsrSdBerLevel.update();
        this.reverseUpsrSfBerLevel.update();
        this.activePaths.update();
        this.adminState.update();
        this.serviceState.update();
        this.connectionName.update();
        this.circuitId.update();
        this.connectionType.update();
        this.paths.update();
        this.protectionOp.update();
        this.reverseProtectionOp.update();
        this.holdoffTime.update();
        this.reverseHoldoffTime.update();
        this.driNodeType.update();
        this.upsrReversion.update();
        this.upsrSwitchOnPdiP.update();
        this.pathEntities.update();
        this.portEntities.update();
        this.validAdminStateTransitions.update();
        this.inRoll.update();
        this.hasMonitor.update();
        this.topologyUpgrade.update();
        this.isInTopologyUpgrade.update();
        this.setChanged();
        this.ccm = null;
        super.updateLocal();
    }

    public void dispose() {
        this.upsrSdBerLevel.dispose();
        this.upsrSfBerLevel.dispose();
        this.reverseUpsrSdBerLevel.dispose();
        this.reverseUpsrSfBerLevel.dispose();
        this.activePaths.dispose();
        this.adminState.dispose();
        this.serviceState.dispose();
        this.connectionName.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.paths.dispose();
        this.protectionOp.dispose();
        this.reverseProtectionOp.dispose();
        this.holdoffTime.dispose();
        this.reverseHoldoffTime.dispose();
        this.upsrReversion.dispose();
        this.upsrSwitchOnPdiP.dispose();
        this.inRoll.dispose();
        this.hasMonitor.dispose();
        this.pathEntities.dispose();
        this.portEntities.dispose();
        this.validAdminStateTransitions.dispose();
        this.driNodeType.dispose();
        this.topologyUpgrade.dispose();
        this.isInTopologyUpgrade.dispose();
        this.myString = null;
        this.ccm = null;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.vtConnRef = null;
    }

    public boolean inRoll() {
        try {
            return (Boolean)this.inRoll.get();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.inRoll(): caught CORBA UserException");
            return false;
        }
    }

    public boolean hasMonitor() {
        try {
            return (Boolean)this.hasMonitor.get();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.hasMonitor(): caught CORBA UserException");
            return false;
        }
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public short getUpsrSfBerLevel() {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
                return (Short)this.upsrSfBerLevel.get();
            }
            if ((iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                return (Short)this.upsrSfBerLevel.get();
            }
            throw new UnsupportedOperationException("This platform does not support SF BER thresholds on the VT path selector.");
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getUpsrSfBerLevel", userException);
        }
    }

    public void setUpsrSfBerLevel(short s) {
        block4: {
            try {
                IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
                if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
                    this.upsrSfBerLevel.set(new Short(s));
                    break block4;
                }
                if ((iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                    this.upsrSfBerLevel.set(new Short(s));
                    break block4;
                }
                throw new UnsupportedOperationException("This platform does not support SF BER thresholds on the VT path selector.");
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "setUpsrSfBerLevel", userException);
            }
        }
    }

    public short getUpsrSdBerLevel() {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
                return (Short)this.upsrSdBerLevel.get();
            }
            if ((iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                return (Short)this.upsrSdBerLevel.get();
            }
            throw new UnsupportedOperationException("This platform does not support SD BER thresholds on the VT path selector.");
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getUpsrSdBerLevel", userException);
        }
    }

    public void setUpsrSdBerLevel(short s) {
        block4: {
            try {
                IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
                if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
                    this.upsrSdBerLevel.set(new Short(s));
                    break block4;
                }
                if ((iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                    this.upsrSdBerLevel.set(new Short(s));
                    break block4;
                }
                throw new UnsupportedOperationException("This platform does not support SD BER thresholds on the VT path selector.");
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "setUpsrSdBerLevel", userException);
            }
        }
    }

    public ILoDefModel[] getActivePaths() {
        try {
            return (ILoDefModel[])this.activePaths.get();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getActivePaths");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public List getActivePathList() {
        return Arrays.asList(this.getActivePaths());
    }

    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getCircuitId");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in setCircuitId");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getConnectionType");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public ILoDefModel[] getPaths() throws CmsObjectNotExistException {
        try {
            return (ILoDefModel[])this.paths.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getPaths", userException);
        }
    }

    protected void markAditsDirty() {
        try {
            ILoDefModel[] iLoDefModelArray = this.getPaths();
            for (int i = 0; i < iLoDefModelArray.length; ++i) {
                ((LoAditModel)iLoDefModelArray[i].getLoAdit()).updateLocal();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
    }

    public sVtDef[] getPathDefs() {
        try {
            ILoDefModel[] iLoDefModelArray = (ILoDefModel[])this.paths.get();
            return LoDefModelFactory.getVtDefArray(iLoDefModelArray);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getPathDefs");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IEntityModel[] getPathEntities() {
        try {
            return (EntityModel[])this.pathEntities.get();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getPathEntities");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getShelfId() {
        IEntityModel[] iEntityModelArray = this.getPathEntities();
        if (iEntityModelArray != null && iEntityModelArray.length > 0) {
            return iEntityModelArray[0].getShelfId();
        }
        return 1;
    }

    public List getPathList() {
        return Arrays.asList(this.getPaths());
    }

    public List getPortModels() {
        try {
            return new LinkedList(((HashMap)this.portEntities.get()).keySet());
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return new LinkedList();
        }
    }

    public boolean hasLoopback() {
        block13: {
            try {
                HashMap hashMap = (HashMap)this.portEntities.get();
                for (Map.Entry entry : hashMap.entrySet()) {
                    List list = (List)entry.getValue();
                    IPortModel iPortModel = (IPortModel)entry.getKey();
                    if (list != null) {
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            if (((IDs123LineModel)list.get(i)).getLoopbackAsInt() == 0) continue;
                            return true;
                        }
                        continue;
                    }
                    if (iPortModel != null && (iPortModel.getModuleModel().getEqType() == 233 || iPortModel.getModuleModel().getEqType() == 234)) {
                        List list2 = this.getActivePathList();
                        for (ILoDefModel iLoDefModel : list2) {
                            ILoNum iLoNum;
                            IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
                            PoolModel poolModel = (PoolModel)iHoPathDefModel.getPool();
                            IEntityModel iEntityModel = poolModel.getEntityModel();
                            IModuleModel iModuleModel = iEntityModel.getModuleModel();
                            IPortModel iPortModel2 = iModuleModel.getPortModelForPath(iEntityModel, iLoNum = iLoDefModel.getLoNum(), iHoPathDefModel.getStartingHo());
                            ITdmLoModel iTdmLoModel = iPortModel2.getTdmLoModel(iLoNum);
                            IDs123LineModel iDs123LineModel = (IDs123LineModel)iTdmLoModel.getLineInterfaceModel();
                            if (iDs123LineModel.getLoopbackAsInt() == 0) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!((IPortModel)entry.getKey()).isInLoopback()) continue;
                    return true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)userException);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block13;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return false;
    }

    public int getProtectionOp() {
        try {
            eProtectionOp eProtectionOp2 = (eProtectionOp)this.protectionOp.get();
            return eProtectionOp2.value();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getProtectionOp");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getReverseProtectionOp() {
        try {
            eProtectionOp eProtectionOp2 = (eProtectionOp)this.reverseProtectionOp.get();
            return eProtectionOp2.value();
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getReverseProtectionOp");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getHoldoffTime() {
        try {
            Integer n = (Integer)this.holdoffTime.get();
            return n;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.getHoldoffTime(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getReverseHoldoffTime() {
        try {
            Integer n = (Integer)this.reverseHoldoffTime.get();
            return n;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.getReverseHoldoffTime(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public short getReverseUpsrSdBerLevel() throws ConnectionTypeError {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH() || (iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                return (Short)this.reverseUpsrSdBerLevel.get();
            }
            throw new UnsupportedOperationException("This platform does not support SD BER thresholds on the VT path selector.");
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReverseUpsrSdBerLevel (LoConn)", userException);
        }
    }

    public short getReverseUpsrSfBerLevel() throws ConnectionTypeError {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH() || (iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable()) {
                return (Short)this.reverseUpsrSfBerLevel.get();
            }
            throw new UnsupportedOperationException("This platform does not support SF BER thresholds on the VT path selector.");
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReverseUpsrSfBerLevel (LoConn)", userException);
        }
    }

    public void setReverseUpsrSdBerLevel(short s) throws ConnectionTypeError {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (!(iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH() || (iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable())) {
                throw new UnsupportedOperationException("This platform does not support SD BER thresholds on the VT path selector.");
            }
            this.reverseUpsrSdBerLevel.set(new Short(s));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setReverseUpsrSdBerLevel (LoConn)", userException);
        }
    }

    public void setReverseUpsrSfBerLevel(short s) throws ConnectionTypeError {
        try {
            IPlatform iPlatform = this.getNodeModelDelegate().getPlatform();
            if (!(iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH() || (iPlatform.is454() || iPlatform.is455()) && this.getNodeModelDelegate().isXCVXCCapable())) {
                throw new UnsupportedOperationException("This platform does not support SF BER thresholds on the VT path selector.");
            }
            this.reverseUpsrSfBerLevel.set(new Short(s));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setReverseUpsrSfBerLevel (LoConn)", userException);
        }
    }

    public short getUpsrSdBerLevelForPath(ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError, ProvisionError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Short s = (Short)this.upsrSdBerLevelForPath.get(sVtDef2);
            return s;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getUpsrSdBerLevelForPath (LoConn)", userException);
        }
    }

    public void setUpsrSdBerLevelForPath(short s, ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError, ProvisionError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Object[] objectArray = new Object[]{new Short(s), sVtDef2};
            this.upsrSdBerLevelForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setUpsrSdBerLevelForPath (LoConn)", userException);
        }
    }

    public short getUpsrSfBerLevelForPath(ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError, ProvisionError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Short s = (Short)this.upsrSfBerLevelForPath.get(sVtDef2);
            return s;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getUpsrSfBerLevelForPath (LoConn)", userException);
        }
    }

    public void setUpsrSfBerLevelForPath(short s, ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError, ProvisionError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Object[] objectArray = new Object[]{new Short(s), sVtDef2};
            this.upsrSfBerLevelForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setUpsrSfBerLevelForPath (LoConn)", userException);
        }
    }

    public int getHoldoffTimeForPath(ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Integer n = (Integer)this.holdoffTimeForPath.get(sVtDef2);
            return n;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        try {
            sRevertiveBehavior sRevertiveBehavior2 = (sRevertiveBehavior)this.upsrReversion.get();
            return RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getUpsrReversion");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IRevertiveBehavior getReverseUpsrReversion() throws ConnectionTypeError {
        try {
            sRevertiveBehavior sRevertiveBehavior2 = (sRevertiveBehavior)this.getReverseUpsrReversion.get();
            return RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.getReverseUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        try {
            sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
            this.upsrReversion.set(sRevertiveBehavior2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in setUpsrReversion");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseUpsrReversion(IRevertiveBehavior iRevertiveBehavior) throws ConnectionTypeError {
        try {
            this.setReverseUpsrReversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.setReverseUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getUpsrSwitchOnPdiP() throws ConnectionTypeError {
        try {
            return (Boolean)this.upsrSwitchOnPdiP.get();
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.getUpsrSwichOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean getReverseUpsrSwitchOnPdiP() throws ConnectionTypeError, InvalidPath {
        try {
            return (Boolean)this.getReverseUpsrSwitchOnPdiP.get();
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.getReverseUpsrSwichOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError {
        try {
            this.upsrSwitchOnPdiP.set(new Boolean(bl));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.setUpsrSwitchOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError, InvalidPath {
        try {
            this.setReverseUpsrSwitchOnPdiP.set(new Boolean(bl));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel.setReverseUpsrSwitchOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void addOutput(ILoDefModel iLoDefModel) throws InvalidPath, PathInUse, ConnectionTypeError, PathNotSupported, CTCUserException {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Object[] objectArray = new Object[]{sVtDef2};
            this.addOutput.get(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xPathNotSupported xPathNotSupported2) {
            throw new PathNotSupported((UserException)xPathNotSupported2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in addOutput");
            SDebug.printStackTrace((Throwable)userException);
            throw new CTCUserException(userException);
        }
    }

    public void changeIntendedType(int n) throws ConnectionTypeError {
        try {
            Object[] objectArray = new Object[]{eConnectionType.from_int(n)};
            this.changeIntendedType.get(objectArray);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in changeIntendedType");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void localDestroy() throws Busy {
    }

    public void localDestroy(boolean bl) throws Busy, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, ConnectionHasFarendLoopback {
        this.markAditsDirty();
        try {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.destroy.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xConnectionInTopologyUpgrade xConnectionInTopologyUpgrade2) {
            throw new ConnectionInTopologyUpgrade((UserException)xConnectionInTopologyUpgrade2);
        }
        catch (xConnectionHasFarendLoopback xConnectionHasFarendLoopback2) {
            throw new ConnectionHasFarendLoopback((UserException)xConnectionHasFarendLoopback2);
        }
        catch (xVcatMemberNotOutOfGroup xVcatMemberNotOutOfGroup2) {
            throw new VcatMemberNotOutOfGroup((UserException)xVcatMemberNotOutOfGroup2);
        }
        catch (xVcatMemberInvalidState xVcatMemberInvalidState2) {
            throw new VcatMemberInvalidState((UserException)xVcatMemberInvalidState2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in destroy");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void clearSwitchCountStat(int n) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n)};
            this.clearSwitchCount.set(objectArray);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in clearSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IPmStat getSwitchCountStat(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            sPmStat sPmStat2 = (sPmStat)this.getSwitchCount.get(objectArray);
            return PmStatFactory.getIPmStat(sPmStat2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            this.db.println("StsConnectionModel.getSwitchCountStat(): caught CORBA xConnection");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (xInternalCommError xInternalCommError2) {
            this.db.println("StsConnectionModel.getSwitchCountStat(): caught CORBA xInternalComm");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
            return PmStatFactory.NULL_PMSTAT;
        }
    }

    public int getSwitchCount(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getSwitchCount.get((Object)objectArray)).cnt;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getSwitchCountValidity(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getSwitchCount.get((Object)objectArray)).valid;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getSwitchCountValidity");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public IPmStat getReverseSwitchCountStat(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            sPmStat sPmStat2 = (sPmStat)this.getReverseSwitchCount.get(objectArray);
            return PmStatFactory.getIPmStat(sPmStat2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            this.db.println("LoConnectionModel.getReverseSwitchCountStat(): caught CORBA xConnection");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (xInternalCommError xInternalCommError2) {
            this.db.println("LoConnectionModel.getReverseSwitchCountStat(): caught CORBA xInternalComm");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getReverseSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
            return PmStatFactory.NULL_PMSTAT;
        }
    }

    public int getReverseSwitchCount(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getReverseSwitchCount.get((Object)objectArray)).cnt;
        }
        catch (UserException userException) {
            this.db.println("VtConnectionModel: user exception in getReverseSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getReverseSwitchCountValidity(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getReverseSwitchCount.get((Object)objectArray)).valid;
        }
        catch (UserException userException) {
            this.db.println("VtConnectionModel: user exception in getReverseSwitchCountValidity");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void removeOutput(ILoDefModel iLoDefModel) throws InvalidPath, DeleteInstead, ConnectionTypeError, CTCUserException {
        try {
            Object[] objectArray = new Object[]{LoDefModelFactory.getVtDef(iLoDefModel)};
            this.removeOutput.get(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xDeleteInstead xDeleteInstead2) {
            throw new DeleteInstead((UserException)xDeleteInstead2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in removeOutput");
            SDebug.printStackTrace((Throwable)userException);
            throw new CTCUserException(userException);
        }
    }

    public void setProtectionOp(int n) throws InvalidProtectionOp, InternalCommError, ConnectionTypeError {
        try {
            Object[] objectArray = new Object[]{eProtectionOp.from_int(n)};
            this.setProtectionOp.get(objectArray);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setProtectionOp", userException);
        }
    }

    public void setReverseProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eProtectionOp.from_int(n)};
            this.setReverseProtectionOp.get(objectArray);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in setReverseProtectionOp");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        try {
            this.holdoffTime.set(new Integer(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        try {
            this.reverseHoldoffTime.set(new Integer(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setHoldoffTimeForPath(int n, ILoDefModel iLoDefModel) throws InvalidPath, ConnectionTypeError, InvalidRange {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            Object[] objectArray = new Object[]{new Integer(n), sVtDef2};
            this.holdoffTimeForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setAttributes(sVtConnectionItem sVtConnectionItem2) {
        this.objIndex.setValueExternally(new Integer(sVtConnectionItem2.objIndex));
        this.activePaths.setValueExternally(sVtConnectionItem2.activePaths);
        this.adminState.setValueExternally(sVtConnectionItem2.adminState);
        this.serviceState.setValueExternally(sVtConnectionItem2.serviceState);
        this.circuitId.setValueExternally(sVtConnectionItem2.circuitId);
        this.connectionName.setValueExternally(sVtConnectionItem2.name);
        this.connectionType.setValueExternally(sVtConnectionItem2.connectionType);
        this.paths.setValueExternally(sVtConnectionItem2.paths);
        this.inRoll.setValueExternally(sVtConnectionItem2.inRoll);
        this.hasMonitor.setValueExternally(sVtConnectionItem2.hasMonitor);
        this.isInTopologyUpgrade.setValueExternally(new Boolean(sVtConnectionItem2.inTopologyUpgrade));
        this.driNodeType.setValueExternally(sVtConnectionItem2.driNodeType);
    }

    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public String getName() {
        return ((ConnectionModelsDelegate)this.nmd.getConnectionModels()).getCircuitName(this.getCircuitId());
    }

    protected void printString(SDebug sDebug) {
        sDebug.println("VT Connection Type " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()]);
        sDebug.println("Connection Index " + this.getIndex());
        sDebug.println("Circuit Name " + this.getConnectionName());
        sDebug.println("CktId = " + this.prettyString(this.getCircuitId()));
        sDebug.println("Paths ");
        ILoDefModel[] iLoDefModelArray = this.getPaths();
        for (int i = 0; i < iLoDefModelArray.length; ++i) {
            sDebug.println("        Path " + i + " = " + iLoDefModelArray[i]);
        }
        sDebug.println("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Info on Connection: \nConnection Index = " + this.getIndex() + "\n" + "Connection Type = " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()] + "\n" + "Connection Name =  " + this.getConnectionName() + "\n";
            }
            catch (Exception exception) {
                return "LoConnectionModel";
            }
        }
        return this.myString;
    }

    public Boolean validateNewAdminStateEnum(eAdminState eAdminState2) throws AbstractCmsIOException {
        eAdminState[] eAdminStateArray = null;
        try {
            eAdminStateArray = (eAdminState[])this.validAdminStateTransitions.get();
        }
        catch (UserException userException) {
            this.db.severe("LoConnectionModel: user exception in validateNewAdminStateEnum");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        if (eAdminStateArray != null) {
            for (int i = 0; i < eAdminStateArray.length; ++i) {
                if (!eAdminState2.equals(eAdminStateArray[i])) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        Boolean bl = this.validateNewAdminStateEnum(eAdminState.from_int(n));
        return bl == null ? false : bl;
    }

    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("VtConnectionModel: user exception in getAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("LoConnectionModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("VtConnectionModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected void markDirty() {
        this.isInTopologyUpgrade.update();
        this.paths.update();
        this.connectionType.update();
    }

    public IConnectionConversionModel createConnectionConversionModel(List list, int n, ICircuitId iCircuitId, List list2, int n2, IConnCreateAttrs iConnCreateAttrs, int n3, boolean bl, boolean bl2) throws NoSuchConnection, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, PathInUse {
        Object[] objectArray = new Object[9];
        ILoDefModel[] iLoDefModelArray = new ILoDefModel[]{};
        iLoDefModelArray = list.toArray(iLoDefModelArray);
        ICircuitId[] iCircuitIdArray = new ICircuitId[]{};
        iCircuitIdArray = list2.toArray(iCircuitIdArray);
        objectArray[0] = LoDefModelFactory.getVtDefArray(iLoDefModelArray);
        objectArray[1] = eTopologyUpgradeType.from_int(n);
        objectArray[2] = CircuitIdFactory.getCircuitId(iCircuitId);
        objectArray[3] = CircuitIdFactory.getCircuitId(iCircuitIdArray);
        objectArray[4] = eConnectionType.from_int(n2);
        objectArray[5] = ConnCreateAttrsFactory.getConnCreateAttrs(iConnCreateAttrs);
        objectArray[6] = eTopologyUpgradeState.from_int(n3);
        objectArray[7] = new Boolean(bl);
        objectArray[8] = new Boolean(bl2);
        if (this.db.on()) {
            this.db.println("createConnectionConversionModel: creating new conn conv model, conn type => " + EnumStrings.getString(IConnectionType.class, (int)n2));
        }
        try {
            this.topologyUpgrade.set(objectArray);
            if (this.db.on()) {
                this.db.println("createConnectionConversionModel: creation was successful");
            }
            this.markDirty();
            return this.getConnectionConversionModel();
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw new NoSuchConnection((UserException)xNoSuchConnection2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xPathListIncomplete xPathListIncomplete2) {
            throw new PathListIncomplete((UserException)xPathListIncomplete2);
        }
        catch (xConnectionInRoll xConnectionInRoll2) {
            throw new ConnectionInRoll((UserException)xConnectionInRoll2);
        }
        catch (xConnectionInTopologyUpgrade xConnectionInTopologyUpgrade2) {
            throw new ConnectionInTopologyUpgrade((UserException)xConnectionInTopologyUpgrade2);
        }
        catch (xConnectionInTestAccess xConnectionInTestAccess2) {
            throw new ConnectionInTestAccess((UserException)xConnectionInTestAccess2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xTopologyUpgradeNotAllowed xTopologyUpgradeNotAllowed2) {
            throw new TopologyUpgradeNotAllowed((UserException)xTopologyUpgradeNotAllowed2);
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createConnectionConversionModel", userException);
        }
    }

    public boolean inConnectionConversion() {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = (Boolean)this.isInTopologyUpgrade.get();
            }
            catch (UserException userException) {
                if (!this.db.on) break block2;
                this.db.println("Could not retrieve IsInTopologyUpgrade");
            }
        }
        return bl;
    }

    public boolean isBlsrDri() {
        return this.getDriNodeType() != 0;
    }

    public IConnectionConversionModel getConnectionConversionModel() {
        if (this.inConnectionConversion()) {
            if (this.ccm == null) {
                try {
                    this.ccm = (ConnectionConversionModel)ConnectionConversionFactory.getIConnectionConversionModel((sVtTopologyUpgradeItem)this.topologyUpgrade.get(), this.getNodeModelDelegate(), this);
                }
                catch (UserException userException) {
                    if (this.db.on) {
                        this.db.println("Failed to retrieve Topology Upgrade");
                    }
                }
            }
        } else {
            this.ccm = null;
        }
        return this.ccm;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetFactoryRef();
    }

    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("VtConnectionModel: user exception in getServiceState");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    public boolean hasTestAccess() {
        ILoDefModel[] iLoDefModelArray = this.getPaths();
        if (iLoDefModelArray == null) {
            return false;
        }
        LoTapModel[] loTapModelArray = this.getNodeModelDelegate().getTapModels().getLoTapModels().getLoTapModels();
        for (int i = 0; i < loTapModelArray.length; ++i) {
            for (int j = 0; j < iLoDefModelArray.length; ++j) {
                if (!iLoDefModelArray[j].equals(loTapModelArray[i].getPathE()) && !iLoDefModelArray[j].equals(loTapModelArray[i].getPathF())) continue;
                return true;
            }
        }
        return false;
    }

    public int getDriNodeType() {
        if (this.db.on()) {
            this.db.print("In LoConnectionModel::getDriNodeType  ");
        }
        try {
            int n = ((eDriNodeType)this.driNodeType.get()).value();
            if (this.db.on()) {
                this.db.println("returning DriNodeType = " + EnumStrings.getStrings(eDriNodeType.class)[n]);
            }
            return n;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("LoConnectionModel: i/0 exception in getDriNodeType");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return -1;
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in getDriNodeType");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setDriNodeType(int n) throws ConnectionTypeError {
        if (this.db.on()) {
            this.db.print("In LoConnectionModel::setDriNodeType   ");
        }
        if (this.db.on()) {
            this.db.println("setting DriNodeType = " + EnumStrings.getStrings(eDriNodeType.class)[n]);
        }
        try {
            this.driNodeType.set(eDriNodeType.from_int(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("LoConnectionModel: i/0 exception in setDriNodeType");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            this.db.println("LoConnectionModel: user exception in setDriNodeType");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public HashMap getDs1s() {
        HashMap hashMap;
        block2: {
            hashMap = null;
            try {
                hashMap = (HashMap)this.portEntities.get();
            }
            catch (Exception exception) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return hashMap;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("HoLoConnectionModel update(): this CHANGED");
                    }
                    ArrayList arrayList = ((ObjectMessageInfo)object).getChangedValues();
                    this.updateLocal();
                    for (AttributeValue attributeValue : arrayList) {
                        switch (attributeValue.getName()) {
                            case 0: {
                                this.serviceState.setValueExternally(attributeValue.getValue());
                            }
                        }
                    }
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                default: {
                    super.update(observable, object);
                }
            }
        }
    }

    private class TopologyUpgrade
    extends CachedValue {
        public TopologyUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchConnection {
            return LoConnectionModel.this.getSonetFactoryRef().getVtTopologyUpgrade(LoConnectionModel.this.getIndex());
        }

        protected void setValue(Object object) throws xNoSuchConnection, xBusy, xPathListIncomplete, xConnectionInRoll, xConnectionInTopologyUpgrade, xConnectionInTestAccess, xConnectionInLoopback, xTopologyUpgradeNotAllowed, xPathInUse {
            Object[] objectArray = (Object[])object;
            sVtDef[] sVtDefArray = (sVtDef[])objectArray[0];
            int n = LoConnectionModel.this.getIndex();
            eTopologyUpgradeType eTopologyUpgradeType2 = (eTopologyUpgradeType)objectArray[1];
            sCircuitId sCircuitId2 = (sCircuitId)objectArray[2];
            sCircuitId[] sCircuitIdArray = (sCircuitId[])objectArray[3];
            eConnectionType eConnectionType2 = (eConnectionType)objectArray[4];
            sConnCreateAttrs sConnCreateAttrs2 = (sConnCreateAttrs)objectArray[5];
            eTopologyUpgradeState eTopologyUpgradeState2 = (eTopologyUpgradeState)objectArray[6];
            boolean bl = (Boolean)objectArray[7];
            boolean bl2 = (Boolean)objectArray[8];
            LoConnectionModel.this.getSonetFactoryRef().createVtTopologyUpgrade(sVtDefArray, n, eTopologyUpgradeType2, sCircuitIdArray, eConnectionType2, sConnCreateAttrs2, eTopologyUpgradeState2, bl2, bl);
        }
    }

    private class IsInTopologyUpgrade
    extends CachedValue {
        public IsInTopologyUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(LoConnectionModel.this.getVtConnectionRef().isInTopologyUpgrade());
        }

        public void setValueExternally(Object object) {
            super.setValueExternally((Boolean)object);
        }
    }

    private class UpsrSfBerLevelForPath
    extends NonCachedValue {
        public UpsrSfBerLevelForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidPath, xConnectionTypeError, xProvisionError {
            return new Short(LoConnectionModel.this.getVtConnectionRef().getUpsrSfBerLevelForPath((sVtDef)object));
        }

        protected void setValue(Object object) throws xInvalidPath, xConnectionTypeError, xProvisionError {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[0];
            sVtDef sVtDef2 = (sVtDef)objectArray[1];
            LoConnectionModel.this.getVtConnectionRef().setUpsrSfBerLevelForPath(s, sVtDef2);
        }
    }

    private class UpsrSdBerLevelForPath
    extends NonCachedValue {
        public UpsrSdBerLevelForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidPath, xConnectionTypeError, xProvisionError {
            return new Short(LoConnectionModel.this.getVtConnectionRef().getUpsrSdBerLevelForPath((sVtDef)object));
        }

        protected void setValue(Object object) throws xInvalidPath, xConnectionTypeError, xProvisionError {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[0];
            sVtDef sVtDef2 = (sVtDef)objectArray[1];
            LoConnectionModel.this.getVtConnectionRef().setUpsrSdBerLevelForPath(s, sVtDef2);
        }
    }

    private class ReverseUpsrSfBerLevel
    extends CachedValue {
        public ReverseUpsrSfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Short(LoConnectionModel.this.getVtConnectionRef().getReverseUpsrSfBerLevel());
        }

        protected void setValue(Object object) throws xConnectionTypeError, xProvisionError {
            LoConnectionModel.this.getVtConnectionRef().setReverseUpsrSfBerLevel((Short)object);
        }
    }

    private class ReverseUpsrSdBerLevel
    extends CachedValue {
        public ReverseUpsrSdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Short(LoConnectionModel.this.getVtConnectionRef().getReverseUpsrSdBerLevel());
        }

        protected void setValue(Object object) throws xConnectionTypeError, xProvisionError {
            LoConnectionModel.this.getVtConnectionRef().setReverseUpsrSdBerLevel((Short)object);
        }
    }

    private class DriNodeType
    extends CachedValue {
        public DriNodeType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().getDriNodeType();
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setDriNodeType((eDriNodeType)object);
        }
    }

    private class PortEntities
    extends CachedValue {
        public PortEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            ILoDefModel[] iLoDefModelArray = null;
            HashMap hashMap = new HashMap();
            try {
                iLoDefModelArray = LoConnectionModel.this.getPaths();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (LoConnectionModel.this.db.on()) {
                    SDebug cfr_ignored_0 = LoConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
                return hashMap;
            }
            if (iLoDefModelArray != null) {
                for (int i = 0; i < iLoDefModelArray.length; ++i) {
                    try {
                        IPortModel iPortModel;
                        if (iLoDefModelArray[i] == null || iLoDefModelArray[i].getLoAdit() == null || iLoDefModelArray[i].getLoAdit().getHo() == null) continue;
                        IHoPathDefModel iHoPathDefModel = iLoDefModelArray[i].getLoAdit().getHo();
                        PoolModel poolModel = (PoolModel)iHoPathDefModel.getPool();
                        List list = poolModel.getPortModels();
                        IEntityModel iEntityModel = poolModel.getEntityModel();
                        IModuleModel iModuleModel = iEntityModel.getModuleModel();
                        ILoNum iLoNum = iLoDefModelArray[i].getLoNum();
                        if (list.size() > 1 && list.contains(iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoPathDefModel.getStartingHo()))) {
                            hashMap.put(iPortModel, null);
                            continue;
                        }
                        iPortModel = list.iterator();
                        boolean bl = iModuleModel instanceof Ds3xmModuleModel;
                        while (iPortModel.hasNext()) {
                            LinkedList<IInterfaceModel> linkedList;
                            IPortModel iPortModel2;
                            block14: {
                                iPortModel2 = (IPortModel)iPortModel.next();
                                linkedList = null;
                                if (bl) {
                                    linkedList = (LinkedList<IInterfaceModel>)hashMap.get(iPortModel2);
                                    if (linkedList == null) {
                                        linkedList = new LinkedList<IInterfaceModel>();
                                    }
                                    try {
                                        ITdmLoModel iTdmLoModel = iPortModel2.getTdmLoModel(iLoNum);
                                        if (iTdmLoModel != null) {
                                            linkedList.add(iTdmLoModel.getLineInterfaceModel());
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (!LoConnectionModel.this.db.on()) break block14;
                                        SDebug cfr_ignored_1 = LoConnectionModel.this.db;
                                        SDebug.printStackTrace((Throwable)exception);
                                    }
                                }
                            }
                            hashMap.put(iPortModel2, linkedList);
                        }
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!LoConnectionModel.this.db.on()) continue;
                        SDebug cfr_ignored_2 = LoConnectionModel.this.db;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            return hashMap;
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class PathEntities
    extends CachedValue {
        public PathEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            try {
                return this.getPathEntityModels();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (LoConnectionModel.this.db.on()) {
                    LoConnectionModel.this.db.println("no such entity in PathEntities.getValue");
                    SDebug cfr_ignored_0 = LoConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return new EntityModel[0];
            }
        }

        protected void setValue(Object object) throws UserException {
        }

        public IEntityModel[] getPathEntityModels() throws AbstractCmsNoSuchEntityException {
            sVtDef[] sVtDefArray = LoConnectionModel.this.getPathDefs();
            IEntityModel[] iEntityModelArray = new EntityModel[]{};
            if (LoConnectionModel.this.paths == null) {
                return iEntityModelArray;
            }
            iEntityModelArray = new EntityModel[sVtDefArray.length];
            for (int i = 0; i < sVtDefArray.length; ++i) {
                iEntityModelArray[i] = this.getEntityModelForPathDef(sVtDefArray[i]);
                if (iEntityModelArray[i] != null) continue;
                throw new CmsNoSuchEntityException("The entity for the StsPathDef cannot be found.");
            }
            return iEntityModelArray;
        }

        protected IEntityModel getEntityModelForPathDef(sVtDef sVtDef2) throws AbstractCmsNoSuchEntityException {
            IEntityModel iEntityModel = null;
            PoolModel poolModel = ((PoolModelsDelegate)LoConnectionModel.this.nmd.getPoolModels()).find(sVtDef2.adit.a().stsPool);
            if (poolModel == null) {
                if (LoConnectionModel.this.db.on()) {
                    LoConnectionModel.this.db.println("PoolM is null \nindex = " + sVtDef2.adit.a().stsPool.objIndex());
                }
                return null;
            }
            iEntityModel = poolModel.getEntityModel();
            return iEntityModel;
        }
    }

    private class HoldoffTimeForPath
    extends NonCachedValue {
        public HoldoffTimeForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Integer(LoConnectionModel.this.getVtConnectionRef().getHoldoffTimeForPath((sVtDef)object));
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            sVtDef sVtDef2 = (sVtDef)objectArray[1];
            LoConnectionModel.this.getVtConnectionRef().setHoldoffTimeForPath(n, sVtDef2);
        }
    }

    private class ReverseHoldoffTime
    extends CachedValue {
        public ReverseHoldoffTime(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(LoConnectionModel.this.getVtConnectionRef().getReverseHoldoffTime());
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setReverseHoldoffTime((Integer)object);
        }
    }

    private class HoldoffTime
    extends CachedValue {
        public HoldoffTime(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(LoConnectionModel.this.getVtConnectionRef().getHoldoffTime());
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setHoldoffTime((Integer)object);
        }
    }

    private class SetReverseProtectionOp
    extends NonCachedValue {
        public SetReverseProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().setReverseProtectionOp((eProtectionOp)objectArray[0]);
            return null;
        }
    }

    private class SetProtectionOp
    extends NonCachedValue {
        public SetProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidProtectionOp, xInternalCommError, xConnectionTypeError {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().setProtectionOp((eProtectionOp)objectArray[0]);
            return null;
        }
    }

    private class RemoveOutput
    extends NonCachedValue {
        public RemoveOutput(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().removeOutput((sVtDef)objectArray[0]);
            return null;
        }
    }

    private class ClearSwitchCount
    extends NonCachedValue {
        public ClearSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().clearSwitchCount((eIntervalType)objectArray[0]);
        }
    }

    private class GetReverseSwitchCount
    extends NonCachedValue {
        public GetReverseSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return LoConnectionModel.this.getVtConnectionRef().getReverseSwitchCount((eIntervalType)objectArray[0], (Short)objectArray[1]);
        }
    }

    private class GetSwitchCount
    extends NonCachedValue {
        public GetSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return LoConnectionModel.this.getVtConnectionRef().getSwitchCount((eIntervalType)objectArray[0], (Short)objectArray[1]);
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().destroy((Boolean)objectArray[0]);
            return null;
        }
    }

    private class HasMonitor
    extends CachedValue {
        public HasMonitor(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(LoConnectionModel.this.getVtConnectionRef().hasMonitor());
        }
    }

    private class InRoll
    extends CachedValue {
        public InRoll(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(LoConnectionModel.this.getVtConnectionRef().inRoll());
        }

        public void setValueExternally(boolean bl) {
            super.setValueExternally(new Boolean(bl));
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class ChangeIntendedType
    extends NonCachedValue {
        public ChangeIntendedType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().changeIntendedType((eConnectionType)objectArray[0]);
            return null;
        }
    }

    private class AddOutput
    extends NonCachedValue {
        public AddOutput(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            LoConnectionModel.this.getVtConnectionRef().addOutput((sVtDef)objectArray[0]);
            return null;
        }
    }

    private class SetReverseUpsrSwitchOnPdiP
    extends NonCachedValue {
        public SetReverseUpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setReverseUpsrSwitchOnPdiP((Boolean)object);
        }
    }

    private class GetReverseUpsrSwitchOnPdiP
    extends NonCachedValue {
        public GetReverseUpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(LoConnectionModel.this.getVtConnectionRef().getReverseUpsrSwitchOnPdiP());
        }

        public Object outer() {
            return LoConnectionModel.this;
        }
    }

    private class UpsrSwitchOnPdiP
    extends CachedValue {
        public UpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Boolean(LoConnectionModel.this.getVtConnectionRef().getUpsrSwitchOnPdiP());
        }

        protected void setValue(Object object) throws xConnectionTypeError {
            LoConnectionModel.this.getVtConnectionRef().setUpsrSwitchOnPdiP((Boolean)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Boolean)this.value);
        }
    }

    private class SetReverseUpsrReversion
    extends NonCachedValue {
        public SetReverseUpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setReverseUpsrReversion((sRevertiveBehavior)object);
        }
    }

    private class GetReverseUpsrReversion
    extends NonCachedValue {
        public GetReverseUpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().getReverseUpsrReversion();
        }

        public Object outer() {
            return LoConnectionModel.this;
        }
    }

    private class UpsrReversion
    extends CachedValue {
        public UpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().upsrReversion();
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().upsrReversion((sRevertiveBehavior)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sRevertiveBehavior)this.value);
        }
    }

    private class ReverseProtectionOp
    extends CachedValue {
        public ReverseProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().reverseProtectionOp();
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eProtectionOp)this.value);
        }
    }

    private class ProtectionOp
    extends CachedValue {
        public ProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().protectionOp();
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eProtectionOp)this.value);
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            sVtDef[] sVtDefArray = LoConnectionModel.this.getVtConnectionRef().paths();
            return LoDefModelFactory.getILoDefModelArray(this.node, sVtDefArray);
        }

        protected void setValue(Object object) throws UserException {
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(LoDefModelFactory.getILoDefModelArray(this.node, (sVtDef[])object));
        }

        protected Object cloneValue() {
            return CloneHelper.clone((ILoDefModel[])this.value);
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().connectionType();
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eConnectionType)this.value);
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (LoConnectionModel.this.db.on) {
                LoConnectionModel.this.db.println("Making CORBA call for circuitId");
            }
            return LoConnectionModel.this.getVtConnectionRef().circuitId();
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().circuitId((sCircuitId)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sCircuitId)this.value);
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            int n = LoConnectionModel.this.getVtConnectionRef().objIndex();
            return new Integer(n);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Integer)this.value);
        }
    }

    class ValidAdminStateTransitions
    extends CachedValue {
        public ValidAdminStateTransitions(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().validStates();
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState[])this.value);
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().getConnectionName();
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setConnectionName((String)object);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (LoConnectionModel.this.db.on) {
                LoConnectionModel.this.db.println("Making CORBA call to get serviceState");
            }
            return LoConnectionModel.this.getVtConnectionRef().getServiceState();
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnectionModel.this.getVtConnectionRef().adminState();
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }

    private class ActivePaths
    extends CachedValue {
        public ActivePaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sVtDef[] sVtDefArray = null;
            sVtDefArray = LoConnectionModel.this.getVtConnectionRef().activePaths();
            return LoDefModelFactory.getILoDefModelArray(this.node, sVtDefArray);
        }

        protected void setValue(Object object) throws UserException {
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(LoDefModelFactory.getILoDefModelArray(this.node, (sVtDef[])object));
        }

        protected Object cloneValue() {
            if (this.value == null) {
                return null;
            }
            return CloneHelper.clone((ILoDefModel[])this.value);
        }
    }

    private class UpsrSfBerLevel
    extends CachedValue {
        public UpsrSfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(LoConnectionModel.this.getVtConnectionRef().upsrSfBerLevel());
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().upsrSfBerLevel((Short)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Short)this.value);
        }
    }

    private class UpsrSdBerLevel
    extends CachedValue {
        public UpsrSdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(LoConnectionModel.this.getVtConnectionRef().upsrSdBerLevel());
        }

        protected void setValue(Object object) throws UserException {
            LoConnectionModel.this.getVtConnectionRef().upsrSdBerLevel((Short)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Short)this.value);
        }
    }
}

