/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.VtConnection;
import cerent.cms.idl.SonetTopology.sVtConnectionItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.LoConnectionModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LoConnections
extends Connections
implements Observer {
    private static final String MY_DEBUG_KEY = "LoConnections";
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetVtConnections getVtConnections;
    GetConnectionObjIndex getConnectionObjIndex;
    GetVtConnectionList getVtConnectionList;
    GetVtConnectionIndexes getVtConnectionIndexes;
    GetVtConnectionItem getVtConnectionItem;
    private EventDispatcher dispatcher;
    private boolean isInitedRealState;
    private LoConnDebug db;

    public LoConnections(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new LoConnDebug(this.node.db);
        this.getVtConnections = new GetVtConnections(this.node, "LoConnections.getVtConnections");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "LoConnections.getConnectionObjIndex");
        this.getVtConnectionList = new GetVtConnectionList(this.node, "LoConnections.getVtConnectionList");
        this.getVtConnectionIndexes = new GetVtConnectionIndexes(this.node, "LoConnections.getVtConnectionIndexes");
        this.getVtConnectionItem = new GetVtConnectionItem(this.node, "LoConnections.getVtConnectionItem");
        this.dispatcher = null;
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectVtConnectionList, 0, (Observer)this);
        }
    }

    private synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.connectionModels);
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            ((LoConnectionModel)iterator.next()).init();
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectVtConnectionList, 0, (Observer)this);
        }
        this.isInitedRealState = false;
        super.dispose();
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    public Collection getConnectionModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.connectionModels.values();
    }

    protected boolean updateStructure() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.updateVtStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoConnectionModel add(VtConnection vtConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        LoConnectionModel loConnectionModel = null;
        if (vtConnection == null) {
            return null;
        }
        LoConnections loConnections = this;
        synchronized (loConnections) {
            block14: {
                loConnectionModel = this.findLoConnectionModel(vtConnection);
                if (loConnectionModel == null) {
                    try {
                        Integer n;
                        block13: {
                            loConnectionModel = new LoConnectionModel(this.node, vtConnection, (Connections)this);
                            n = new Integer(loConnectionModel.getObjIndex());
                            try {
                                loConnectionModel.setAttributes(this.getVtConnectionItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block13;
                                this.db.println("Caught noSuchConnection ");
                                LoConnDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        loConnectionModel.init();
                        this.connectionModels.put(n, loConnectionModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception occured in add-vtConn " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (loConnectionModel == null) break block14;
                        loConnectionModel.dispose();
                        loConnectionModel = null;
                    }
                }
            }
            if (loConnectionModel != null) {
                if (this.db.on) {
                    this.db.println("marking adits dirty");
                }
                loConnectionModel.markAditsDirty();
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return loConnectionModel;
    }

    private synchronized void discover(Map map) {
        sVtConnectionItem[] sVtConnectionItemArray = this.getVtConnectionItems();
        if (sVtConnectionItemArray == null) {
            this.db.println("Error in getting VtConnections (null) ConnectionModels::discoverVtConnections");
            return;
        }
        for (int i = 0; i < sVtConnectionItemArray.length; ++i) {
            if (sVtConnectionItemArray[i] == null) continue;
            Integer n = new Integer(sVtConnectionItemArray[i].objIndex);
            map.put(n, new LoConnectionModel(this.node, sVtConnectionItemArray[i], (Connections)this));
        }
    }

    private void discoverVtConnectionItems(HashMap hashMap) {
        sVtConnectionItem[] sVtConnectionItemArray = this.getVtConnectionItems();
        if (sVtConnectionItemArray == null) {
            return;
        }
        for (int i = 0; i < sVtConnectionItemArray.length; ++i) {
            hashMap.put(new Integer(sVtConnectionItemArray[i].objIndex), sVtConnectionItemArray[i]);
        }
    }

    private sVtConnectionItem[] getVtConnectionItems() {
        sVtConnectionItem[] sVtConnectionItemArray;
        try {
            sVtConnectionItemArray = (sVtConnectionItem[])this.getVtConnectionList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting VtConnections " + (Object)((Object)abstractCmsIOException));
            LoConnDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            LoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sVtConnectionItemArray;
    }

    public synchronized LoConnectionModel findLoConnectionModel(sCircuitId sCircuitId2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return (LoConnectionModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoConnectionModel findLoConnectionModel(VtConnection vtConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        if (vtConnection != null) {
            try {
                LoConnections loConnections = this;
                synchronized (loConnections) {
                    Integer n = (Integer)this.getConnectionObjIndex.get(vtConnection);
                    var2_2 = this.connectionModels.get(n);
                }
            }
            catch (UserException userException) {
                LoConnDebug.printStackTrace((Throwable)userException);
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the VtConnModel in the cache ");
        }
        return var2_2;
    }

    private synchronized boolean updateVtStructure() {
        Serializable serializable;
        Object object;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateVtStructure");
        }
        Collection collection = null;
        boolean bl = false;
        collection = this.getVtConnectionIndexes();
        if (collection == null) {
            this.db.println("Could not find VtConnection Indexes returning ..");
            return false;
        }
        Collection collection2 = LoConnections.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("New vt found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object = null;
                serializable = (Integer)iterator.next();
                if (this.db.on) {
                    this.db.println("Adding Vt # " + serializable + " to List");
                }
                try {
                    object = this.getVtConnectionItem((Integer)serializable);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught NoSuchConnection for Vt " + serializable);
                    continue;
                }
                LoConnectionModel loConnectionModel = new LoConnectionModel(this.node, (sVtConnectionItem)object, (Connections)this);
                loConnectionModel.init();
                this.connectionModels.put(serializable, loConnectionModel);
            }
            bl = true;
        }
        if ((object = LoConnections.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            iterator = object.iterator();
            bl = true;
            if (this.db.on()) {
                this.db.println("Vt Deleted found # " + object.size());
            }
            while (iterator.hasNext()) {
                serializable = (LoConnectionModel)this.connectionModels.get(iterator.next());
                ((ConnectionModel)serializable).delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateVtStructure");
        }
        return bl;
    }

    public synchronized void remove(LoConnectionModel loConnectionModel) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            this.connectionModels.remove(this.getConnectionObjIndex.getValue(loConnectionModel.getVtConnectionRef()));
        }
        catch (UserException userException) {
            this.db.println("Unexpected User Exception " + (Object)((Object)userException));
            LoConnDebug.printStackTrace((Throwable)userException);
        }
    }

    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a Changed Message for VtConns");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an UpdateStructure Message for VtConns");
                }
                if (!this.updateVtStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on VtConnections";
                this.db.println(string);
                LoConnDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    private Collection getVtConnectionIndexes() {
        try {
            return this.toCollection((int[])this.getVtConnectionIndexes.get());
        }
        catch (UserException userException) {
            LoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sVtConnectionItem getVtConnectionItem(Integer n) throws xNoSuchConnection {
        try {
            return (sVtConnectionItem)this.getVtConnectionItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            LoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private class GetVtConnectionItem
    extends NonCachedValue {
        public GetVtConnectionItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return LoConnections.this.getSonetFactoryRef().getVtConnectionItem((Integer)object);
        }

        public Object outer() {
            return LoConnections.this;
        }
    }

    private class GetVtConnectionIndexes
    extends NonCachedValue {
        public GetVtConnectionIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (((LoConnections)LoConnections.this).db.on) {
                LoConnections.this.db.println("Calling getVtConnectionIndexes");
            }
            return LoConnections.this.getSonetFactoryRef().getVtConnectionIndexes();
        }

        public Object outer() {
            return LoConnections.this;
        }
    }

    public class LoConnDebug
    extends SDebug {
        LoConnDebug(SDebug sDebug) {
            super((KDebug)sDebug, LoConnections.MY_DEBUG_KEY);
        }

        public final void update() {
            LoConnections.this.updateVtStructure();
        }

        public final void printConnections() {
            LoConnections.this.db.println("Printing List of LO Connections \n");
            LoConnections.this.printConnectionString(this);
        }
    }

    private class GetVtConnectionList
    extends NonCachedValue {
        public GetVtConnectionList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws UserException {
            return LoConnections.this.getSonetFactoryRef().getVtConnectionList();
        }

        public Object outer() {
            return LoConnections.this;
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((VtConnection)object).objIndex();
            return new Integer(n);
        }

        public Object outer() {
            return LoConnections.this;
        }
    }

    private class GetVtConnections
    extends NonCachedValue {
        public GetVtConnections(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoConnections.this.getSonetFactoryRef().getVtConnections();
        }

        public Object outer() {
            return LoConnections.this;
        }
    }
}

