/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IFTGDelegator;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IVtAditModel;
import cerent.cms.model.IVtDefModel;
import cerent.cms.model.Model;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;

public class LoDefModel
implements ILoDefModel,
IVtDefModel {
    public INodeModel node = null;
    protected ILoNum loNum;
    protected ILoAditModel adit = null;
    protected IVtAditModel vtadit;
    protected short pathIdentifier;
    protected int portIndex;
    private int pathWidth = -1;

    public LoDefModel(INodeModel iNodeModel, ILoAditModel iLoAditModel, ILoNum iLoNum, int n, short s, int n2) {
        this.pathWidth = n;
        this.init(iNodeModel, iLoAditModel, iLoNum);
        this.pathIdentifier = s;
        this.portIndex = n2;
    }

    private void init(INodeModel iNodeModel, ILoAditModel iLoAditModel, ILoNum iLoNum) {
        this.adit = iLoAditModel;
        this.node = iNodeModel;
        this.vtadit = null;
        if (iLoAditModel != null && iLoAditModel instanceof IFTGDelegator) {
            this.vtadit = (IVtAditModel)((IFTGDelegator)iLoAditModel).getDeleg();
        }
        this.setLoNum(iLoNum);
    }

    public ILoNum getLoNum() {
        return this.loNum;
    }

    public short getVtGroupNum() {
        return this.loNum == null ? (short)0 : (this.loNum.getFramingType() == 1 ? HoLoFactory.getPreFTGSdhGroupNum(this.loNum) : this.loNum.getIdlGroupNum());
    }

    public short getVtNum() {
        return this.loNum == null ? (short)0 : (this.loNum.getFramingType() == 1 ? HoLoFactory.getPreFTGSdhNumInGroup(this.loNum) : this.loNum.getIdlNumInGroup());
    }

    public int getPathWidth() {
        if (this.loNum != null) {
            return this.loNum.getLoPathWidth();
        }
        if (this.pathWidth == -1) {
            throw new IllegalStateException("The path width is invalid.");
        }
        return this.pathWidth;
    }

    public void setPathWidth(int n) {
        throw new DeprecatedMethodCalled("FTG deprecated LoDefModel.setPathWidth(int)");
    }

    public int getLoPathWidth() {
        return this.getPathWidth();
    }

    public ILoAditModel getLoAdit() {
        return this.adit;
    }

    public IVtAditModel getVtAdit() {
        return this.vtadit;
    }

    public void setLoNum(ILoNum iLoNum) {
        if (this.pathWidth != -1 && iLoNum != null && iLoNum.getLoPathWidth() != this.pathWidth) {
            throw new IllegalStateException("The LO number is invalid.");
        }
        this.loNum = iLoNum;
    }

    public void setLoAdit(ILoAditModel iLoAditModel) {
        this.adit = iLoAditModel;
    }

    public boolean equals(Object object) {
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return iLoDefModel.getLoAdit().getNodeModel().getNodeId() == this.node.getNodeId() && iLoDefModel.getLoAdit().equals(this.adit) && iLoDefModel.getLoNum().equals(this.getLoNum()) && iLoDefModel.getPathIdentifier() == this.pathIdentifier && iLoDefModel.getPortIndex() == this.portIndex;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.loNum.hashCode();
        n = 37 * n + this.adit.hashCode();
        n = 37 * n + this.node.getNodeId();
        n = 37 * n + this.pathIdentifier;
        n = 37 * n + this.portIndex;
        return n;
    }

    public static IHoNum physicalHo(ILoDefModel iLoDefModel) {
        if (iLoDefModel.getLoAdit() != null) {
            return HoPathDefModel.physicalHo(iLoDefModel.getLoAdit().getHo());
        }
        return null;
    }

    public static IHoNum physicalHo(IHoPathDefModel iHoPathDefModel) {
        return HoPathDefModel.physicalHo(iHoPathDefModel);
    }

    public static IHoNum physicalHo(ILoAditModel iLoAditModel) {
        return HoPathDefModel.physicalHo(iLoAditModel.getHo());
    }

    public short getPathIdentifier() {
        return this.pathIdentifier;
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    public void setPathIdentifier(short s) {
        this.pathIdentifier = s;
    }

    public void setPortIndex(int n) {
        this.portIndex = n;
    }

    public String toString() {
        IHoPathDefModel iHoPathDefModel = this.adit.getHo();
        IPoolModel iPoolModel = this.adit.getHo().getPool();
        if (iPoolModel instanceof Model) {
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            Model model = (Model)iPoolModel;
            return "LoDefModel[Pool index=" + Integer.toHexString(model.getIndex()) + " : " + model + "; Port index=" + Integer.toHexString(this.getPortIndex()) + "; LoNum=" + this.getLoNum() + "]" + "; HoNum=" + iHoNum;
        }
        return "LoDefModel in " + this.adit.getClass().getName() + " [Pool index=" + Integer.toHexString(iPoolModel.getIndex()) + " : " + iPoolModel + "; Port index=" + Integer.toHexString(this.getPortIndex()) + "; LoNum=" + this.getLoNum() + "]";
    }
}

