/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.VtRoll;
import cerent.cms.idl.SonetTopology.sVtRollItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.LoRollModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.Rolls;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LoRolls
extends Rolls
implements Observer {
    private ConnectionModelsDelegate container;
    private GetLoRollItems getLoRollItems;
    private GetLoRollItem getLoRollItem;
    private GetConnectionIndex getConnectionIndex;
    private EventDispatcher dispatcher;
    protected static SDebug db = new SDebug("LoRolls");

    public LoRolls(ConnectionModelsDelegate connectionModelsDelegate) {
        super(connectionModelsDelegate.node);
        this.container = connectionModelsDelegate;
        this.getLoRollItems = new GetLoRollItems(this.node, "LoRolls::getLoRollItems");
        this.getLoRollItem = new GetLoRollItem(this.node, "LoRolls::getLoRollItem");
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRollList, 0, (Observer)this);
        }
        LoRolls loRolls = this;
        synchronized (loRolls) {
            block7: {
                try {
                    this.discover(this.rollModels);
                    Iterator iterator = this.rollModels.values().iterator();
                    while (iterator.hasNext()) {
                        ((LoRollModel)iterator.next()).init();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block7;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    protected void discoverRollItems(HashMap hashMap) {
        sVtRollItem[] sVtRollItemArray = this.getLoRollItems();
        if (sVtRollItemArray == null) {
            return;
        }
        for (int i = 0; i < sVtRollItemArray.length; ++i) {
            hashMap.put(new Integer(sVtRollItemArray[i].connectionIndex), sVtRollItemArray[i]);
        }
    }

    private synchronized void discover(Map map) {
        sVtRollItem[] sVtRollItemArray = null;
        sVtRollItemArray = this.getLoRollItems();
        if (sVtRollItemArray == null) {
            db.println("Error in getting LoRolls (null) LoRolls::discover");
            return;
        }
        for (int i = 0; i < sVtRollItemArray.length; ++i) {
            if (sVtRollItemArray[i] == null) continue;
            Integer n = new Integer(sVtRollItemArray[i].connectionIndex);
            map.put(n, new LoRollModel(this.node, this, sVtRollItemArray[i]));
        }
    }

    private sVtRollItem getLoRollItem(int n) {
        sVtRollItem sVtRollItem2;
        try {
            sVtRollItem2 = (sVtRollItem)this.getLoRollItem.get(new Integer(n));
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("Error in getting loRollItem " + (Object)((Object)abstractCmsIOException));
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return null;
        }
        catch (UserException userException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
        return sVtRollItem2;
    }

    private sVtRollItem[] getLoRollItems() {
        sVtRollItem[] sVtRollItemArray = new sVtRollItem[]{};
        try {
            sVtRollItemArray = (sVtRollItem[])this.getLoRollItems.get();
            if (db.on()) {
                db.println("Found " + sVtRollItemArray.length + " rolls");
                for (int i = 0; i < sVtRollItemArray.length; ++i) {
                    db.println("Roll[" + i + "]" + " with connection Index " + sVtRollItemArray[i].connectionIndex + " and roll mode " + sVtRollItemArray[i].rollMode);
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("Error in getting vtRolls " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
        return sVtRollItemArray;
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRollList, 0, (Observer)this);
        }
        super.dispose();
    }

    public synchronized LoRollModel getRollModel(int n) throws NoSuchConnection {
        return (LoRollModel)this.rollModels.get(new Integer(n));
    }

    public synchronized ILoRollModel[] getRollModels() {
        return this.rollModels.values().toArray(new ILoRollModel[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoRollModel findLoRollModel(sVtRollItem sVtRollItem2) {
        Object var2_2 = null;
        if (sVtRollItem2 != null) {
            LoRolls loRolls = this;
            synchronized (loRolls) {
                var2_2 = this.rollModels.get(new Integer(sVtRollItem2.connectionIndex));
            }
        }
        if (var2_2 == null) {
            // empty if block
        }
        return var2_2;
    }

    protected LoRollModel add(VtRoll vtRoll) {
        sVtRollItem sVtRollItem2 = this.getLoRollItem(vtRoll.connectionIndex());
        return this.add(sVtRollItem2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoRollModel add(sVtRollItem sVtRollItem2) {
        LoRollModel loRollModel = null;
        if (sVtRollItem2 == null) {
            return null;
        }
        LoRolls loRolls = this;
        synchronized (loRolls) {
            loRollModel = this.findLoRollModel(sVtRollItem2);
            if (loRollModel == null) {
                try {
                    loRollModel = new LoRollModel(this.node, this, sVtRollItem2);
                    loRollModel.init();
                    Integer n = new Integer(loRollModel.getConnectionIndex());
                    this.rollModels.put(n, loRollModel);
                    this.setChanged();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        db.println("Exception in add-LoRoll " + (Object)((Object)abstractCmsIOException));
                        this.printStackTrace((Exception)((Object)abstractCmsIOException));
                    }
                    if (loRollModel != null) {
                        loRollModel.dispose();
                        loRollModel = null;
                    }
                    return null;
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return loRollModel;
    }

    private void discoverLoRollItems(HashMap hashMap) {
        sVtRollItem[] sVtRollItemArray = this.getLoRollItems();
        if (sVtRollItemArray == null) {
            return;
        }
        for (int i = 0; i < sVtRollItemArray.length; ++i) {
            hashMap.put(new Integer(sVtRollItemArray[i].connectionIndex), sVtRollItemArray[i]);
        }
    }

    private synchronized boolean updateLoRollStructure() {
        LoRollModel loRollModel;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverLoRollItems(hashMap);
        Collection collection = LoRolls.getAddedObjects(hashMap.keySet(), this.rollModels.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (db.on()) {
                    db.println("New lo found # " + collection.size());
                }
                if (db.on()) {
                    db.println(" lo # " + object2);
                }
                object = (sVtRollItem)hashMap.get(object2);
                loRollModel = new LoRollModel(this.node, this, (sVtRollItem)object);
                this.rollModels.put(object2, loRollModel);
                loRollModel.init();
            }
            bl = true;
        }
        if ((object2 = LoRolls.getDeletedObjects(hashMap.keySet(), this.rollModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (db.on()) {
                    db.println("Deleted lo found # " + object2.size());
                }
                if (db.on()) {
                    db.println("Deleted lo index " + object);
                }
                if ((loRollModel = (LoRollModel)this.rollModels.get(object)) == null) continue;
                loRollModel.delete();
            }
        }
        if (db.on()) {
            db.println("Exit:: LoRolls::updateLoRollStructure()");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        if (n == 1) {
            if (LoRolls.db.on) {
                db.println("Got a changed Message for VtConn");
            }
            this.container.updateLocal();
        } else if (n == 2) {
            if (LoRolls.db.on) {
                db.println("Got an update Structure Message");
            }
            if (this.updateLoRollStructure()) {
                if (LoRolls.db.on) {
                    db.println("Going to Update Structure");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
            }
        } else {
            db.println("Unknown update type in LoRolls");
        }
    }

    protected class GetLoRollItem
    extends NonCachedValue {
        public GetLoRollItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws xNoSuchConnection {
            return LoRolls.this.getSonetFactoryRef().getVtRoll((Integer)object);
        }
    }

    protected class GetLoRollItems
    extends NonCachedValue {
        public GetLoRollItems(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws UserException {
            return LoRolls.this.getSonetFactoryRef().getVtRolls();
        }
    }

    private class GetConnectionIndex
    extends NonCachedValue {
        public GetConnectionIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((VtRoll)object).connectionIndex();
            return new Integer(n);
        }
    }
}

