/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.SonetTopology.VtVcatTerm;
import cerent.cms.idl.SonetTopology.eVcatMemStatus;
import cerent.cms.idl.SonetTopology.sStatusVtConn;
import cerent.cms.idl.SonetTopology.sVtDef;
import cerent.cms.idl.SonetTopology.sVtVcatTermItem;
import cerent.cms.idl.SonetTopology.xInvalidParms;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xInvalidStatus;
import cerent.cms.model.AbstractVcatTermsMap;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidStatus;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.LoVcatTermsMap;
import cerent.cms.model.NoSuchVcat;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VcatTermMember;
import cerent.cms.model.VcatTermMemberFactory;
import cerent.cms.model.VcatTermModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class LoVcatTermModel
extends VcatTermModel
implements ILoVcatTermModel {
    private int portIndex = -1;
    private MembersOfTheVcatTerm membersOfTheVcatTerm = null;
    private MemberStatus memberStatus = null;
    private VtVcatTermItemCV vtVcatTermItemCV = null;

    public LoVcatTermModel(NodeModelDelegate nodeModelDelegate, sVtVcatTermItem sVtVcatTermItem2, AbstractVcatTermsMap abstractVcatTermsMap) {
        super(nodeModelDelegate, sVtVcatTermItem2.vcatTerm, abstractVcatTermsMap, nodeModelDelegate.getChildDebug(LoVcatTermModel.class));
        this.index = sVtVcatTermItem2.objIndex;
        this.portIndex = sVtVcatTermItem2.portIndex;
        this.vtVcatTermItemCV = new VtVcatTermItemCV(nodeModelDelegate, "LoVcatTermModel.VtVcatTermItem");
        this.membersOfTheVcatTerm = new MembersOfTheVcatTerm(nodeModelDelegate, "LoVcatTermModel.MembersOfTheVcatTerm");
        this.memberStatus = new MemberStatus(nodeModelDelegate, "LoVcatTermModel.MemberStatus");
        this.setAttributes(sVtVcatTermItem2);
    }

    public void init() {
        super.init();
    }

    public void setAttributes(sVtVcatTermItem sVtVcatTermItem2) {
        this.vtVcatTermItemCV.setValueExternally(sVtVcatTermItem2);
    }

    public int getMemberStatus(ILoDefModel iLoDefModel) throws InvalidPath {
        sVtDef sVtDef2 = LoDefModelFactory.getVtDef(iLoDefModel);
        try {
            eVcatMemStatus eVcatMemStatus2 = (eVcatMemStatus)this.memberStatus.get(sVtDef2);
            return eVcatMemStatus2.value();
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("LoVcatTermModel: user exception in MemberStatus");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setMemberStatus(ILoDefModel iLoDefModel, int n) throws InvalidPath, InvalidStatus {
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = LoDefModelFactory.getVtDef(iLoDefModel);
            objectArray[2] = eVcatMemStatus.from_int(n);
            this.memberStatus.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xInvalidStatus xInvalidStatus2) {
            throw new InvalidStatus((UserException)xInvalidStatus2);
        }
        catch (UserException userException) {
            this.db.println("LoVcatTermModel: user exception in MemberStatus");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IVcatTermMember[] getMembersOfTheVcatTerm(int n) throws InvalidParms {
        try {
            sStatusVtConn[] sStatusVtConnArray = (sStatusVtConn[])this.membersOfTheVcatTerm.get(eTrafficDirection.from_int(n));
            return VcatTermMemberFactory.getILoVcatTermMemberArray(this.nmd, sStatusVtConnArray);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParms((UserException)xInvalidParms2);
        }
        catch (UserException userException) {
            this.db.println("HoVcatTermModel: user exception in getMembersOfTheVcatTerm");
            SDebug.printStackTrace((Throwable)userException);
            return new VcatTermMember[0];
        }
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    private sVtVcatTermItem getVtVcatTermItem() {
        try {
            return (sVtVcatTermItem)this.vtVcatTermItemCV.get();
        }
        catch (UserException userException) {
            this.db.println("LoVcatTermModel: user exception in getVtVcatTermItem");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public ICircuitId getCircuitId() {
        return CircuitIdFactory.getICircuitId(this.getVtVcatTermItem().vcatCirId);
    }

    public String getVcatName() {
        return this.getVtVcatTermItem().name;
    }

    public short getNumberOfMembers(int n) throws InvalidParms {
        if (n == 0) {
            return this.getVtVcatTermItem().vcatTermAttributes.numOfRxMems;
        }
        if (n == 1) {
            return this.getVtVcatTermItem().vcatTermAttributes.numOfTxMems;
        }
        if (n == 2) {
            return this.getVtVcatTermItem().vcatTermAttributes.numOfTxMems;
        }
        throw new InvalidParms("The traffic direction is invalid.");
    }

    public int getLcasMode() {
        return this.getVtVcatTermItem().vcatTermAttributes.mode.value();
    }

    public void setLcasMode(int n) throws CTCUserException {
        throw new CTCUserException("LCAS mode support has not been implemented.");
    }

    public int getDirection() {
        return this.getVtVcatTermItem().vcatTermAttributes.direction.value();
    }

    public boolean getExtBuffer() {
        return this.getVtVcatTermItem().vcatTermAttributes.extBuffer;
    }

    public int getLoPathWidth() {
        return this.getVtVcatTermItem().memPathWidth.value();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectVtVcatTerm;
    }

    protected void updateLocal() {
        this.vtVcatTermItemCV.update();
        super.updateLocal();
    }

    public void dispose() {
        super.dispose();
    }

    private class MembersOfTheVcatTerm
    extends NonCachedValue {
        public MembersOfTheVcatTerm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((VtVcatTerm)LoVcatTermModel.this.getVcatTermRef()).getMembersOfTheVcatTerm((eTrafficDirection)object);
        }
    }

    private class MemberStatus
    extends NonCachedValue {
        public MemberStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((VtVcatTerm)LoVcatTermModel.this.getVcatTermRef()).getMemberStatus((sVtDef)object);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            ((VtVcatTerm)LoVcatTermModel.this.getVcatTermRef()).setMemberStatus((sVtDef)objectArray[0], (eVcatMemStatus)objectArray[1]);
        }
    }

    private class VtVcatTermItemCV
    extends CachedValue {
        public VtVcatTermItemCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            try {
                return ((LoVcatTermsMap)LoVcatTermModel.this.parent).getVtVcatTermItemFromPort(new Integer(LoVcatTermModel.this.getPortIndex()));
            }
            catch (NoSuchVcat noSuchVcat) {
                throw new CmsObjectNotExistException("The VCAT termination for Port " + Integer.toHexString(LoVcatTermModel.this.getPortIndex()) + " does not exist.");
            }
        }

        protected void setValue(Object object) throws UserException {
        }
    }
}

