/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.OpticsTopology.OchncCircuits;
import cerent.cms.idl.SonetTopology.OchncConnection;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.sOchncConnectionItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchncConnectionModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OchncConnections
extends Connections
implements Observer {
    private static final String MY_DEBUG_KEY = "OchncConnections";
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetOchncConnectionsFromPort getOchncConnectionsFromPort;
    GetConnectionObjIndex getConnectionObjIndex;
    GetOchncConnectionsList getOchncConnectionsList;
    GetOchncConnectionIndexes getOchncConnectionIndexes;
    GetOchncConnectionItem getOchncConnectionItem;
    private boolean isInitedRealState;
    private EventDispatcher dispatcher;
    private OchncConnDebug db;

    public OchncConnections(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new OchncConnDebug(this.node.db);
        this.getOchncConnectionsFromPort = new GetOchncConnectionsFromPort(this.node, "OchncConnections.getOchncConnectionsFromPort");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "OchncConnections.getConnectionObjIndex");
        this.getOchncConnectionsList = new GetOchncConnectionsList(this.node, "OchncConnections.getOchncConnectionsList");
        this.getOchncConnectionIndexes = new GetOchncConnectionIndexes(this.node, "OchncConnections.getOchncConnectionIndexes");
        this.getOchncConnectionItem = new GetOchncConnectionItem(this.node, "OchncConnections.getOchncConnectionItem");
        this.dispatcher = null;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    private OchncCircuits getOchncCircuitsRef() {
        return this.container.getOchncCircuitsRef();
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOchncConnectionList, 0, (Observer)this);
        }
    }

    private synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.connectionModels);
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            ((OchncConnectionModel)iterator.next()).init();
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOchncConnectionList, 0, (Observer)this);
        }
        this.isInitedRealState = false;
        super.dispose();
    }

    public Collection getConnectionModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.connectionModels.values();
    }

    public List getConnectionModels(int n) {
        ArrayList arrayList = new ArrayList();
        if (!this.isInitedRealState) {
            this.initReal();
        }
        try {
            OchncConnection[] ochncConnectionArray = new OchncConnection[]{};
            ochncConnectionArray = (OchncConnection[])this.getOchncConnectionsFromPort.get(new Integer(n));
            for (int i = 0; i < ochncConnectionArray.length; ++i) {
                arrayList.add(this.connectionModels.get(new Integer(ochncConnectionArray[i].objIndex())));
            }
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            OchncConnDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            OchncConnDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
        }
        catch (UserException userException) {
            OchncConnDebug.printStackTrace((Throwable)userException);
        }
        return arrayList;
    }

    protected boolean updateStructure() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.updateOchncStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OchncConnectionModel add(OchncConnection ochncConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        OchncConnectionModel ochncConnectionModel = null;
        if (ochncConnection == null) {
            return null;
        }
        OchncConnections ochncConnections = this;
        synchronized (ochncConnections) {
            block12: {
                ochncConnectionModel = this.findOchncConnectionModel(ochncConnection);
                if (ochncConnectionModel == null) {
                    try {
                        Integer n;
                        block11: {
                            ochncConnectionModel = new OchncConnectionModel(this.node, ochncConnection, (Connections)this);
                            n = new Integer(ochncConnectionModel.getObjIndex());
                            try {
                                ochncConnectionModel.setAttributes(this.getOchncConnectionItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block11;
                                this.db.println("Caught noSuchConnection for index " + n);
                                OchncConnDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        ochncConnectionModel.init();
                        this.connectionModels.put(n, ochncConnectionModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception in add-OchncConn " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (ochncConnectionModel == null) break block12;
                        ochncConnectionModel.dispose();
                        ochncConnectionModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return ochncConnectionModel;
    }

    public synchronized OchncConnectionModel findOchncConnectionModel(sCircuitId sCircuitId2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return (OchncConnectionModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OchncConnectionModel findOchncConnectionModel(OchncConnection ochncConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        if (ochncConnection != null) {
            OchncConnections ochncConnections = this;
            synchronized (ochncConnections) {
                var2_2 = this.connectionModels.get(new Integer(ochncConnection.objIndex()));
                try {
                    Integer n = (Integer)this.getConnectionObjIndex.get(ochncConnection);
                    var2_2 = this.connectionModels.get(n);
                }
                catch (UserException userException) {
                    OchncConnDebug.printStackTrace((Throwable)userException);
                }
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the OchncConnection in the cache ");
        }
        return var2_2;
    }

    private synchronized void discover(Map map) {
        sOchncConnectionItem[] sOchncConnectionItemArray = null;
        sOchncConnectionItemArray = this.getOchncConnectionItems();
        if (sOchncConnectionItemArray == null) {
            this.db.println("Error in getting OchncConnections (null) OchncConnections::discover");
            return;
        }
        for (int i = 0; i < sOchncConnectionItemArray.length; ++i) {
            if (sOchncConnectionItemArray[i] == null) continue;
            Integer n = new Integer(sOchncConnectionItemArray[i].objIndex);
            map.put(n, new OchncConnectionModel(this.node, sOchncConnectionItemArray[i], (Connections)this));
        }
    }

    private sOchncConnectionItem[] getOchncConnectionItems() {
        sOchncConnectionItem[] sOchncConnectionItemArray = new sOchncConnectionItem[]{};
        try {
            sOchncConnectionItemArray = (sOchncConnectionItem[])this.getOchncConnectionsList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting ochncConnections " + (Object)((Object)abstractCmsIOException));
            OchncConnDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            OchncConnDebug.printStackTrace((Throwable)userException);
        }
        return sOchncConnectionItemArray;
    }

    private void discoverOchncConnectionItems(HashMap hashMap) {
        sOchncConnectionItem[] sOchncConnectionItemArray = this.getOchncConnectionItems();
        if (sOchncConnectionItemArray == null) {
            return;
        }
        for (int i = 0; i < sOchncConnectionItemArray.length; ++i) {
            hashMap.put(new Integer(sOchncConnectionItemArray[i].objIndex), sOchncConnectionItemArray[i]);
        }
    }

    private synchronized boolean updateOchncStructure() {
        OchncConnectionModel ochncConnectionModel;
        Object object;
        Object object2;
        Collection collection;
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateOchncStructure()");
        }
        if ((collection = this.getOchncConnectionIndexes()) == null) {
            this.db.println("Cannot get OchncConnections from NE cannot process updateOchncStructure");
            return bl;
        }
        Collection collection2 = OchncConnections.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("New ho found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println(" Ochnc # " + object2);
                }
                try {
                    object = this.getOchncConnectionItem((Integer)object2);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught NoSuch Connection for Ochnc " + object2);
                    this.db.println("Continuing ...");
                    continue;
                }
                ochncConnectionModel = new OchncConnectionModel(this.node, (sOchncConnectionItem)object, (Connections)this);
                this.connectionModels.put(object2, ochncConnectionModel);
                ochncConnectionModel.init();
            }
            bl = true;
        }
        if ((object2 = OchncConnections.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("Deleted ochnc found # " + object2.size());
                }
                if (this.db.on()) {
                    this.db.println("Deleted ochnc index " + object);
                }
                if ((ochncConnectionModel = (OchncConnectionModel)this.connectionModels.get(object)) == null) continue;
                ochncConnectionModel.delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateOchncStructure()");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a changed Message for OchncConn");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an update Structure Message");
                }
                if (!this.updateOchncStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on OchncConnections";
                this.db.println(string);
                OchncConnDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    private Collection getOchncConnectionIndexes() {
        try {
            return this.toCollection((int[])this.getOchncConnectionIndexes.get());
        }
        catch (UserException userException) {
            OchncConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sOchncConnectionItem getOchncConnectionItem(Integer n) throws xNoSuchConnection {
        try {
            return (sOchncConnectionItem)this.getOchncConnectionItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            OchncConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public class OchncConnDebug
    extends SDebug {
        OchncConnDebug(KDebug kDebug) {
            super(kDebug, OchncConnections.MY_DEBUG_KEY);
        }

        public final void update() {
            OchncConnections.this.updateOchncStructure();
            OchncConnections.this.setChanged();
            OchncConnections.this.notifyObservers(ModelUpdateType.ADDED);
        }

        public final void printConnections() {
            OchncConnections.this.db.println("Printing List of OCHNC Connections \n");
            OchncConnections.this.printConnectionString(this);
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((OchncConnection)object).objIndex();
            return new Integer(n);
        }

        public Object outer() {
            return OchncConnections.this;
        }
    }

    private class GetOchncConnectionsList
    extends NonCachedValue {
        public GetOchncConnectionsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OchncConnections.this.getSonetFactoryRef().getOchncConnectionList();
        }

        public Object outer() {
            return OchncConnections.this;
        }
    }

    private class GetOchncConnectionItem
    extends NonCachedValue {
        public GetOchncConnectionItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return OchncConnections.this.getSonetFactoryRef().getOchncConnectionItem((Integer)object);
        }

        public Object outer() {
            return OchncConnections.this;
        }
    }

    private class GetOchncConnectionIndexes
    extends NonCachedValue {
        public GetOchncConnectionIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (((OchncConnections)OchncConnections.this).db.on) {
                OchncConnections.this.db.println("Calling getOchncConnectionIndexes");
            }
            return OchncConnections.this.getSonetFactoryRef().getOchncConnectionIndexes();
        }

        public Object outer() {
            return OchncConnections.this;
        }
    }

    private class GetOchncConnectionsFromPort
    extends NonCachedValue {
        public GetOchncConnectionsFromPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return OchncConnections.this.getOchncCircuitsRef().getAllOchncConnectionListFromPort((Integer)object);
        }

        public Object outer() {
            return OchncConnections.this;
        }
    }
}

