/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.SonetMedia.sOverheadXcon;
import cerent.cms.idl.SonetTopology.OverheadXConnection;
import cerent.cms.idl.SonetTopology.sOverheadXconItem;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOhXcon;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhXconFactory;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OhXconModel
extends ConnectionModel
implements IOhXconModel {
    private CircuitId circuitId = null;
    private ObjIndex objIndex = null;
    private OhXcon ohXcon = null;
    private OverheadXConnection ohXconnectionRef = null;
    private Destroy destroy = null;
    private IEntityModel inputPortModel;
    private IEntityModel outputPortModel;
    private String myString;

    public OhXconModel(NodeModelDelegate nodeModelDelegate, sOverheadXconItem sOverheadXconItem2, Connections connections) {
        this(nodeModelDelegate, sOverheadXconItem2.xconnection, connections);
        this.setAttributes(sOverheadXconItem2);
    }

    public OhXconModel(NodeModelDelegate nodeModelDelegate, OverheadXConnection overheadXConnection, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(OhXconModel.class));
        this.ohXconnectionRef = overheadXConnection;
        this.circuitId = new CircuitId(nodeModelDelegate, "OhXconModel.circuitId");
        this.objIndex = new ObjIndex(nodeModelDelegate, "OhXconModel.objIndex");
        this.ohXcon = new OhXcon(nodeModelDelegate, "OhXconModel.ohXcon");
        this.destroy = new Destroy(nodeModelDelegate, "OhXconModel.destroy");
        this.myString = null;
    }

    public OverheadXConnection getOhXconRef() {
        return this.ohXconnectionRef;
    }

    public void init() {
        super.init();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectOverheadXcon;
    }

    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in getObjIndex");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    protected void updateLocal() {
        this.circuitId.update();
        this.ohXcon.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        this.circuitId.dispose();
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in getCircuitId");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in setCircuitId");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IOhXcon getOhXcon() {
        try {
            sOverheadXcon sOverheadXcon2 = (sOverheadXcon)this.ohXcon.get();
            return OhXconFactory.getIOhXcon(sOverheadXcon2);
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in getOhXcon");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setOhXcon(IOhXcon iOhXcon) {
        try {
            this.ohXcon.set(OhXconFactory.getOhXcon(iOhXcon));
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in setOhXcon");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void localDestroy() throws Busy {
        try {
            this.destroy.get();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            this.db.severe("OhXconModel: user exception in destroy");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setAttributes(sOverheadXconItem sOverheadXconItem2) {
        this.objIndex.setValueExternally(new Integer(sOverheadXconItem2.objIndex));
        this.circuitId.setValueExternally(sOverheadXconItem2.circuitId);
        this.ohXcon.setValueExternally(sOverheadXconItem2.xcon);
    }

    public String getName() {
        return ((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).getCircuitName(this.getCircuitId());
    }

    protected void printString(SDebug sDebug) {
        sDebug.fine("OhXcon : " + this.getOhXcon());
        sDebug.fine("Circuit Name " + this.getName());
        sDebug.fine("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Info on Overhead Cross Connection: NodeId=" + Integer.toHexString(this.getNodeModel().getNodeId()) + " OhXcon=" + this.getOhXcon() + " CircuitName=" + this.getName();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                return "DELETED";
            }
        }
        return this.myString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OhXconModel)) {
            return false;
        }
        OhXconModel ohXconModel = (OhXconModel)object;
        return this.getNodeModel().equals(ohXconModel.getNodeModel()) && this.getIndex() == ohXconModel.getIndex();
    }

    public int getCircuitType() {
        return OhChannelType.getOhChannelTypeObj((int)this.getInputChannelType()).getCorrespondingCircuitType().getIndex();
    }

    public int getInputPortIndex() {
        return this.getOhXcon().getA().getPortIndex();
    }

    public int getInputChannelType() {
        return this.getOhXcon().getA().getType();
    }

    public int getOutputPortIndex() {
        return this.getOhXcon().getB().getPortIndex();
    }

    public int getOutputChannelType() {
        return this.getOhXcon().getB().getType();
    }

    public IEntityModel getInputPortModel() {
        if (this.inputPortModel == null) {
            try {
                this.inputPortModel = this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getInputPortIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.inputPortModel;
    }

    public IEntityModel getOutputPortModel() {
        if (this.outputPortModel == null) {
            try {
                this.outputPortModel = this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getOutputPortIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.outputPortModel;
    }

    public int getShelfId() {
        if (this.getInputPortModel() != null) {
            return this.inputPortModel.getShelfId();
        }
        if (this.getOutputPortModel() != null) {
            return this.outputPortModel.getShelfId();
        }
        return 1;
    }

    public boolean usingEntity(int n) {
        return this.getInputPortIndex() == n || this.getOutputPortIndex() == n;
    }

    public boolean usingEntity(int n, int n2) {
        if (this.getNodeModel() == null) {
            return false;
        }
        if (this.getNodeModel().getNodeId() == n) {
            return true;
        }
        return this.usingEntity(n2);
    }

    public int[] getUsedOpticalPorts() {
        return new int[]{this.getInputPortIndex(), this.getOutputPortIndex()};
    }

    public int[] getUsedOpticalPorts(OhChannelType ohChannelType) {
        if (this.getInputChannelType() == ohChannelType.getIndex()) {
            if (this.getOhXcon().getB().getType() == ohChannelType.getIndex()) {
                return new int[]{this.getInputPortIndex(), this.getOutputPortIndex()};
            }
            return new int[]{this.getInputPortIndex()};
        }
        if (this.getOutputChannelType() == ohChannelType.getIndex()) {
            return new int[]{this.getOutputPortIndex()};
        }
        return null;
    }

    public boolean usedChannel(int n, OhChannelType ohChannelType) {
        if (this.getInputPortIndex() == n && this.getInputChannelType() == ohChannelType.getIndex()) {
            return true;
        }
        return this.getOutputPortIndex() == n && this.getOutputChannelType() == ohChannelType.getIndex();
    }

    public boolean inRoll() {
        return false;
    }

    public int getConnectionType() {
        return -1;
    }

    public List getPortModels() {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        arrayList.add(this.getInputPortModel());
        arrayList.add(this.getOutputPortModel());
        return arrayList;
    }

    public boolean validateNewAdminState(int n) {
        return false;
    }

    public eAdminState getAdminStateEnum() {
        return eAdminState.ADMIN_IS;
    }

    public void setAdminState(eAdminState eAdminState2) {
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            OhXconModel.this.getOhXconRef().destroy();
            return null;
        }
    }

    private class OhXcon
    extends CachedValue {
        public OhXcon(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (OhXconModel.this.db.on()) {
                OhXconModel.this.db.finer("Making CORBA call for overhead xconination");
            }
            return OhXconModel.this.getOhXconRef().xcon();
        }

        protected void setValue(Object object) throws UserException {
            throw new IllegalStateException("Should not be called");
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (OhXconModel.this.db.on()) {
                OhXconModel.this.db.finer("Making CORBA call for circuitId");
            }
            return OhXconModel.this.getOhXconRef().circuitId();
        }

        protected void setValue(Object object) throws UserException {
            OhXconModel.this.getOhXconRef().circuitId((sCircuitId)object);
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            int n = OhXconModel.this.getOhXconRef().objIndex();
            return new Integer(n);
        }

        protected void setValue(Object object) throws UserException {
            throw new IllegalStateException("Should not be called");
        }
    }
}

