/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvOpticalPatchCordModel;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.OpticalPatchCord;
import cerent.cms.idl.OpticsTopology.eConnectionPortsType;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCordMeasure;
import cerent.cms.idl.OpticsTopology.xBusy;
import cerent.cms.idl.OpticsTopology.xDuplicatedPatchCord;
import cerent.cms.idl.OpticsTopology.xEndPointInUse;
import cerent.cms.idl.OpticsTopology.xEndPointIncompatible;
import cerent.cms.idl.OpticsTopology.xNoSuchPatchCord;
import cerent.cms.idl.OpticsTopology.xWavelengthIncompatible;
import cerent.cms.idl.OpticsTopology.xWavelengthNotSupported;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicatedPatchCord;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.EndPointIncompatible;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IOpticalPatchCordModel;
import cerent.cms.model.MPOLinkModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WavelengthIncompatible;
import cerent.cms.model.WavelengthNotSupported;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OpticalPatchCordModel
extends Model
implements IOpticalPatchCordModel,
IFvOpticalPatchCordModel {
    private AddPatchCord addPatchCordRef;
    private ReversePort reversePort;
    private DelPatchCord delPatchCordRef;
    private GetPatchCord getPatchCordRef;
    private GetPatchCordByCard getPatchCordByCardRef;
    private GetPatchCordByIndex getPatchCordByIndex;
    private InUsePatchCord inUsePatchCordRef;
    private GetAllPatchCords getAllPatchCordsRef;
    private GetAllPatchCordsBetweenCard getAllPatchCordsBetweenCardsRef;
    private OpticalPatchCordMeasure opticalPatchCordMeasure;
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<OpticalPatchCordModel> sfactory = new NodeSingletonFactory<OpticalPatchCordModel>(OpticalPatchCordModel.class);
    private EventDispatcher dispatcher;
    private Hashtable<Integer, OptLinkModel> patchTable;
    private List<MPOLinkModel> mpoList;

    private OpticalPatchCordModel(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(OpticalPatchCordModel.class, OptPatchDebug.class, this));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.addPatchCordRef = new AddPatchCord(this.nmd, "OpticalPatchCordModel::AddPatchCord");
        this.delPatchCordRef = new DelPatchCord(this.nmd, "OpticalPatchCordModel::DelPatchCord");
        this.getPatchCordRef = new GetPatchCord(this.nmd, "OpticalPatchCordModel::GetPatchCord");
        this.getPatchCordByIndex = new GetPatchCordByIndex(this.nmd, "OpticalPatchCordModel::GetPatchCordByIndex");
        this.reversePort = new ReversePort(this.nmd, "OpticalPatchCordModel::ReversePort");
        this.getPatchCordByCardRef = new GetPatchCordByCard(this.nmd, "OpticalPatchCordModel::GetPatchCordByCard");
        this.inUsePatchCordRef = new InUsePatchCord(this.nmd, "OpticalPatchCordModel::InUsePatchCord");
        this.getAllPatchCordsRef = new GetAllPatchCords(this.nmd, "OpticalPatchCordModel::GetAllPatchCords");
        this.getAllPatchCordsBetweenCardsRef = new GetAllPatchCordsBetweenCard(this.nmd, "OpticalPatchCordModel::GetAllPatchCordsBetweenCard");
        this.opticalPatchCordMeasure = new OpticalPatchCordMeasure(this.nmd, "OpticalPatchCordModel::OpticalPatchCordMeasure");
        this.patchTable = new Hashtable();
        this.mpoList = new LinkedList<MPOLinkModel>();
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOpticalPatchCordList, (Observer)this);
        }
        this.initOptLinkList();
    }

    public static OpticalPatchCordModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 2: {
                    if (this.db.on()) {
                        this.db.println("Object added.");
                    }
                    this.addNewPatchCord();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                    break;
                }
                default: {
                    if (this.db.on()) {
                        this.db.println("Event not handled.");
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public void addOpticalLink(int n, int n2, eConnectionPortsType eConnectionPortsType2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, EndPointIncompatible, DuplicatedPatchCord, WavelengthIncompatible, WavelengthNotSupported {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), eConnectionPortsType2};
            this.addPatchCordRef.set(objectArray);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xEndPointInUse xEndPointInUse2) {
            throw new EndPointInUse((UserException)xEndPointInUse2);
        }
        catch (xEndPointIncompatible xEndPointIncompatible2) {
            throw new EndPointIncompatible((UserException)xEndPointIncompatible2);
        }
        catch (xDuplicatedPatchCord xDuplicatedPatchCord2) {
            throw new DuplicatedPatchCord((UserException)xDuplicatedPatchCord2);
        }
        catch (xWavelengthIncompatible xWavelengthIncompatible2) {
            throw new WavelengthIncompatible((UserException)xWavelengthIncompatible2);
        }
        catch (xWavelengthNotSupported xWavelengthNotSupported2) {
            throw new WavelengthNotSupported((UserException)xWavelengthNotSupported2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "addOpticalLink", userException);
        }
    }

    public void addOpticalLink(int n, int n2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, EndPointIncompatible, DuplicatedPatchCord, WavelengthIncompatible, WavelengthNotSupported {
        this.addOpticalLink(n, n2, eConnectionPortsType.SINGLE_PORT);
    }

    public void addOpticalLink(PortModel portModel, PortModel portModel2, eConnectionPortsType eConnectionPortsType2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, EndPointIncompatible, DuplicatedPatchCord, WavelengthIncompatible, WavelengthNotSupported {
        this.addOpticalLink(portModel.getIndex(), portModel2.getIndex(), eConnectionPortsType2);
    }

    public void addOpticalLink(PortModel portModel, PortModel portModel2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, EndPointIncompatible, DuplicatedPatchCord, WavelengthIncompatible, WavelengthNotSupported {
        this.addOpticalLink(portModel.getIndex(), portModel2.getIndex(), eConnectionPortsType.SINGLE_PORT);
    }

    public void deleteOpticalLink(int n, int n2) throws FeatureUnsupported, NoSuchEquipment, Busy, NoSuchPatchCord {
        try {
            this.delPatchCordRef.set(new int[]{n, n2});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xNoSuchPatchCord xNoSuchPatchCord2) {
            throw new NoSuchPatchCord((UserException)xNoSuchPatchCord2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteOpticalLink", userException);
        }
    }

    public void deleteOpticalLink(PortModel portModel, PortModel portModel2) throws FeatureUnsupported, NoSuchEquipment, Busy, NoSuchPatchCord {
        this.deleteOpticalLink(portModel.getIndex(), portModel2.getIndex());
    }

    public void deleteOpticalLink(sOpticalPatchCord sOpticalPatchCord2) throws FeatureUnsupported, NoSuchEquipment, Busy, NoSuchPatchCord {
        this.deleteOpticalLink(sOpticalPatchCord2.to, sOpticalPatchCord2.from);
    }

    public sOpticalPatchCord getOpticalLink(int n, int n2) throws FeatureUnsupported, NoSuchInterface, NoSuchPatchCord {
        try {
            return (sOpticalPatchCord)this.getPatchCordRef.get(new Integer[]{new Integer(n), new Integer(n2)});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xNoSuchPatchCord xNoSuchPatchCord2) {
            throw new NoSuchPatchCord((UserException)xNoSuchPatchCord2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOpticalLink", userException);
        }
    }

    public sOpticalPatchCord getOpticalLink(PortModel portModel, PortModel portModel2) throws FeatureUnsupported, NoSuchInterface, NoSuchPatchCord {
        return this.getOpticalLink(portModel.getIndex(), portModel2.getIndex());
    }

    public boolean opticalLinkInUse(int n, int n2) throws FeatureUnsupported, NoSuchInterface, NoSuchPatchCord {
        try {
            return (Boolean)this.inUsePatchCordRef.get(new int[]{n, n2});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xNoSuchPatchCord xNoSuchPatchCord2) {
            throw new NoSuchPatchCord((UserException)xNoSuchPatchCord2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "opticalLinkInUse", userException);
        }
    }

    public int[] getReversePort(int n) throws NoSuchEquipment, WrongPortType {
        try {
            return (int[])this.reversePort.get(n);
        }
        catch (xWrongEquipmentType xWrongEquipmentType2) {
            throw new WrongPortType((UserException)xWrongEquipmentType2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getReversePort", userException);
        }
    }

    public boolean opticalLinkInUse(PortModel portModel, PortModel portModel2) throws FeatureUnsupported, NoSuchInterface, NoSuchPatchCord {
        return this.opticalLinkInUse(portModel.getIndex(), portModel2.getIndex());
    }

    private sOpticalPatchCord[] getAllOpticalLink() throws FeatureUnsupported {
        try {
            return (sOpticalPatchCord[])this.getAllPatchCordsRef.get();
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAllOpticalLink", userException);
        }
    }

    private void initOptLinkList() {
        block3: {
            try {
                sOpticalPatchCord[] sOpticalPatchCordArray = this.getAllOpticalLink();
                this.patchTable.clear();
                for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
                    OptLinkModel optLinkModel = new OptLinkModel(this, sOpticalPatchCordArray[i]);
                    optLinkModel.init();
                    this.patchTable.put(sOpticalPatchCordArray[i].index, optLinkModel);
                    this.updateMPOList(optLinkModel);
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (!this.db.on()) break block3;
                this.db.println("Feature unsupported");
            }
        }
    }

    private void addNewPatchCord() {
        block4: {
            try {
                sOpticalPatchCord[] sOpticalPatchCordArray = this.getAllOpticalLink();
                for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
                    if (!this.patchTable.containsKey(sOpticalPatchCordArray[i].index)) {
                        OptLinkModel optLinkModel = new OptLinkModel(this, sOpticalPatchCordArray[i]);
                        this.patchTable.put(sOpticalPatchCordArray[i].index, optLinkModel);
                        optLinkModel.init();
                        this.updateMPOList(optLinkModel);
                        if (!this.db.on()) continue;
                        this.db.println("Patch index: " + sOpticalPatchCordArray[i].index);
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("Patch already present index: " + sOpticalPatchCordArray[i].index);
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (!this.db.on()) break block4;
                this.db.println("Feature unsupported");
            }
        }
    }

    public OptLinkModel[] getAllOptLinkModel() {
        return this.patchTable.values().toArray(new OptLinkModel[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOptLinkModel[] getAllOptLinkModel(boolean bl) {
        if (!bl) {
            return this.getAllOptLinkModel();
        }
        ArrayList<Model> arrayList = new ArrayList<Model>();
        Hashtable<Integer, OptLinkModel> hashtable = this.patchTable;
        synchronized (hashtable) {
            for (OptLinkModel optLinkModel : this.patchTable.values()) {
                if (optLinkModel.getParentMPO() != null) continue;
                arrayList.add(optLinkModel);
            }
        }
        arrayList.addAll(this.mpoList);
        return arrayList.toArray(new IOptLinkModel[0]);
    }

    public IOptLinkModel[] getIOptLinkModels() throws FeatureUnsupported {
        return this.getAllOptLinkModel();
    }

    public OptLinkModel getOptLinkModelByIndex(int n) throws FeatureUnsupported, NoSuchPatchCord {
        if (this.patchTable.containsKey(n)) {
            return this.patchTable.get(n);
        }
        throw new NoSuchPatchCord((UserException)new xNoSuchPatchCord());
    }

    public sOpticalPatchCord[] getOptLinkModelByCard(Object object) throws FeatureUnsupported, NoSuchInterface {
        try {
            return (sOpticalPatchCord[])this.getPatchCordByCardRef.get(object);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOptLinkModelByCard", userException);
        }
    }

    public boolean hasCardDWDMOpticalPatch(int n) {
        block5: {
            try {
                if (this.getOptLinkModelByCard(new Integer(n)).length != 0) {
                    return true;
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)featureUnsupported);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public sOpticalPatchCord getOptLinkByIndex(int n) throws FeatureUnsupported, NoSuchPatchCord {
        try {
            return (sOpticalPatchCord)this.getPatchCordByIndex.get(n);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchPatchCord xNoSuchPatchCord2) {
            throw new NoSuchPatchCord((UserException)xNoSuchPatchCord2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "addOpticalLink", userException);
        }
    }

    public void createAutomaticOpticalLinks() throws FeatureUnsupported, CannotPerform {
        throw new FeatureUnsupported("Deprecated");
    }

    public OptLinkModel[] getOptLinksBetweenCards(IModuleModel iModuleModel, IModuleModel iModuleModel2) throws NoSuchEquipment {
        ArrayList<OptLinkModel> arrayList = new ArrayList<OptLinkModel>();
        try {
            sOpticalPatchCord[] sOpticalPatchCordArray;
            for (sOpticalPatchCord sOpticalPatchCord2 : sOpticalPatchCordArray = (sOpticalPatchCord[])this.getAllPatchCordsBetweenCardsRef.get(new Integer[]{new Integer(iModuleModel.getEntityIndex()), new Integer(iModuleModel2.getEntityIndex())})) {
                arrayList.add(new OptLinkModel(this, sOpticalPatchCord2));
            }
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "addOpticalLink", userException);
        }
        return arrayList.toArray(new OptLinkModel[0]);
    }

    public sOpticalPatchCordMeasure[] measureInsertionLoss(int[] nArray) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        try {
            return (sOpticalPatchCordMeasure[])this.opticalPatchCordMeasure.getValue(nArray);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
    }

    public IEntityModel[] getOtsPorts(boolean bl) {
        return IntPatchHelper.getOtsPorts(this.nmd, IntPatchHelper.getFilter(bl));
    }

    public IEntityModel[] getOchTxpPorts(int n) {
        return IntPatchHelper.getOchTxpPorts(this.nmd, n, null);
    }

    public IEntityModel[] getTrkL2Ports() {
        return IntPatchHelper.getTrkL2Ports(this.nmd, null);
    }

    public IEntityModel[] getOchPorts(boolean bl, int n) {
        return IntPatchHelper.getOchPorts(this.nmd, IntPatchHelper.getFilter(bl, n));
    }

    void removeLink(int n) {
        if (this.patchTable.containsKey(n)) {
            OptLinkModel optLinkModel = this.patchTable.get(n);
            this.patchTable.remove(n);
            optLinkModel.dispose();
            if (this.db.on()) {
                this.db.println("Patchcord not found index:" + n);
            }
        }
    }

    void removeMPO(MPOLinkModel mPOLinkModel) {
        int n = this.mpoList.indexOf(mPOLinkModel);
        if (n >= 0) {
            if (this.db.on()) {
                this.db.println("MPO removed: " + mPOLinkModel.getPrettyString());
            }
            this.mpoList.remove(n);
            mPOLinkModel.dispose();
        }
    }

    synchronized void updateMPOList(OptLinkModel optLinkModel) {
        if (MPOLinkModel.isPartOfMPO(optLinkModel)) {
            for (MPOLinkModel mPOLinkModel : this.mpoList) {
                if (!mPOLinkModel.canBePartOfThisMPO(optLinkModel)) continue;
                mPOLinkModel.addChild(optLinkModel);
                return;
            }
            try {
                MPOLinkModel mPOLinkModel = new MPOLinkModel(optLinkModel, this);
                this.mpoList.add(mPOLinkModel);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOpticalPatchCordList, 1, (Observer)this);
        }
        if (this.patchTable != null) {
            for (OptLinkModel optLinkModel : this.patchTable.values()) {
                optLinkModel.dispose();
            }
            this.patchTable.clear();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        if (this.patchTable != null) {
            this.patchTable.clear();
        }
        this.patchTable = null;
        if (this.mpoList != null) {
            this.mpoList.clear();
        }
        this.mpoList = null;
    }

    private OpticalPatchCord getOpticalPatchCordRef() {
        return this.nmd.getIorRepository().getOpticalPatchCordRef();
    }

    public class OptPatchDebug
    extends SDebug {
        public OptPatchDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            OpticalPatchCordModel.this.db.println("Patch list contents:");
            OptLinkModel[] optLinkModelArray = OpticalPatchCordModel.this.getAllOptLinkModel();
            for (int i = 0; i < optLinkModelArray.length; ++i) {
                OpticalPatchCordModel.this.db.println("patch index " + optLinkModelArray[i].getIndex() + " " + optLinkModelArray[i]);
            }
            List list = OpticalPatchCordModel.this.mpoList;
            synchronized (list) {
                OpticalPatchCordModel.this.db.println("MPO list contents:");
                for (MPOLinkModel mPOLinkModel : OpticalPatchCordModel.this.mpoList) {
                    OpticalPatchCordModel.this.db.println(mPOLinkModel.toString());
                }
            }
        }
    }

    private class OpticalPatchCordMeasure
    extends NonCachedValue {
        public OpticalPatchCordMeasure(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xFeatureUnsupported, xNoSuchInterface, xWrongInterfaceType {
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().measureInsertionLoss((int[])object);
        }
    }

    private class GetAllPatchCordsBetweenCard
    extends NonCachedValue {
        public GetAllPatchCordsBetweenCard(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().getPossiblePatchCordsOnBoards(n, n2);
        }
    }

    private class GetAllPatchCords
    extends NonCachedValue {
        public GetAllPatchCords(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws xFeatureUnsupported {
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().getAllOpticalLinks();
        }
    }

    private class InUsePatchCord
    extends NonCachedValue {
        public InUsePatchCord(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchPatchCord, xNoSuchEquipment, xFeatureUnsupported {
            int[] nArray = (int[])object;
            return new Boolean(OpticalPatchCordModel.this.getOpticalPatchCordRef().inUse(nArray[0], nArray[1]));
        }
    }

    private class GetPatchCordByCard
    extends NonCachedValue {
        public GetPatchCordByCard(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xFeatureUnsupported, xNoSuchInterface {
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().getOpticalLinksByCard((Integer)object);
        }
    }

    private class GetPatchCordByIndex
    extends NonCachedValue {
        public GetPatchCordByIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xFeatureUnsupported, xNoSuchInterface, xNoSuchPatchCord {
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().getByIndex((Integer)object);
        }
    }

    private class GetPatchCord
    extends NonCachedValue {
        public GetPatchCord(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchPatchCord, xNoSuchEquipment, xFeatureUnsupported {
            Integer[] integerArray = (Integer[])object;
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().get(integerArray[0], integerArray[1]);
        }
    }

    private class DelPatchCord
    extends NonCachedValue {
        public DelPatchCord(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBusy, xNoSuchPatchCord, xNoSuchEquipment, xFeatureUnsupported {
            int[] nArray = (int[])object;
            OpticalPatchCordModel.this.getOpticalPatchCordRef().remove(nArray[0], nArray[1]);
        }
    }

    private class AddPatchCord
    extends NonCachedValue {
        public AddPatchCord(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWavelengthIncompatible, xEndPointIncompatible, xDuplicatedPatchCord, xWavelengthNotSupported, xNoSuchEquipment, xFeatureUnsupported, xEndPointInUse {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            eConnectionPortsType eConnectionPortsType2 = (eConnectionPortsType)objectArray[2];
            OpticalPatchCordModel.this.getOpticalPatchCordRef().add(n, n2, eConnectionPortsType2);
        }
    }

    private class ReversePort
    extends NonCachedValue {
        public ReversePort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongEquipmentType, xNoSuchEquipment {
            return OpticalPatchCordModel.this.getOpticalPatchCordRef().getReversePort((Integer)object);
        }
    }
}

