/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.Node.xInvalidMask;
import cerent.cms.idl.OSI.General;
import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.idl.OSI.eOsiMode;
import cerent.cms.idl.OSI.sGreTunnel;
import cerent.cms.idl.OSI.xDuplicateGreTunnel;
import cerent.cms.idl.OSI.xInvalidGreTunnelDefaultRouteMask;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToAllOnes;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToBroadcast;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassA;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassB;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassC;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassDE;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToInternalNet;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToLocalNet;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToSelf;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToSelfSubnet;
import cerent.cms.idl.OSI.xInvalidStaticRouteOrGateway;
import cerent.cms.idl.OSI.xLspSizeExceedsMtu;
import cerent.cms.idl.OSI.xMaxGreTunnels;
import cerent.cms.idl.OSI.xNoSuchGreTunnel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DupGRETunnel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.LspSizeExceedsMtu;
import cerent.cms.model.MaxGRETunnels;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchGRETunnel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OsiModel
extends Model {
    private NodeModelDelegate nodeModel;
    private CreateGreTunnel createGreTunnel;
    private HasGreTunnel hasGreTunnel;
    private RemoveGreTunnel removeGreTunnel;
    private PartitionRepair partitionRepair;
    private SystemNSAP systemNsap;
    private RoutingMode routingMode;
    private IsIsMetricForLink isIsMetricForLink;
    private L1LspBufferSize l1LspBufferSize;
    private L2LspBufferSize l2LspBufferSize;
    private GreTunnelList greTunnelList;
    private ValidNSELs validNSELs;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<OsiModel> sfactory = new NodeSingletonFactory<OsiModel>(OsiModel.class);

    public static OsiModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private OsiModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(OsiModel.class));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
        this.systemNsap = new SystemNSAP(nodeModelDelegate, "OsiModel::systemNSAP");
        this.routingMode = new RoutingMode(nodeModelDelegate, "OsiModel::routingMode");
        this.l1LspBufferSize = new L1LspBufferSize(nodeModelDelegate, "OsiModel::l1LspBufferSize");
        this.l2LspBufferSize = new L2LspBufferSize(nodeModelDelegate, "OsiModel::l1LspBufferSize");
        this.isIsMetricForLink = new IsIsMetricForLink(nodeModelDelegate, "OsiModel::isIsMetricForLink");
        this.partitionRepair = new PartitionRepair(nodeModelDelegate, "OsiModel::partitionRepair");
        this.createGreTunnel = new CreateGreTunnel(nodeModelDelegate, "OsiModel::createGreTunnel");
        this.hasGreTunnel = new HasGreTunnel(nodeModelDelegate, "OsiModel::hasGreTunnel");
        this.removeGreTunnel = new RemoveGreTunnel(nodeModelDelegate, "OsiModel::removeGreTunnel");
        this.greTunnelList = new GreTunnelList(nodeModelDelegate, "OsiModel::greTunnelList");
        this.validNSELs = new ValidNSELs(nodeModelDelegate, "OsiModel::validNSELs");
    }

    public void registerWithDefaults(NeDefaultsModel neDefaultsModel) {
        neDefaultsModel.addNonCachedValue(this.routingMode);
        neDefaultsModel.addNonCachedValue(this.l1LspBufferSize);
        neDefaultsModel.addNonCachedValue(this.l2LspBufferSize);
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private General getOsiRef() {
        return this.nodeModel.getIorRepository().getOSIRef();
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOsiConfig, 1, (Observer)this);
        }
        this.systemNsap.init();
        this.routingMode.init();
        this.isIsMetricForLink.init();
        this.l1LspBufferSize.init();
        this.l2LspBufferSize.init();
        this.greTunnelList.init();
        this.validNSELs.init();
    }

    public byte[] getValidGreNsels() {
        try {
            return (byte[])this.validNSELs.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    public byte[] getSystemNSAP() {
        try {
            return (byte[])this.systemNsap.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    public int getRoutingMode() {
        eOsiMode eOsiMode2 = this.getRoutingModeEnum();
        return eOsiMode2 == null ? 0 : eOsiMode2.value();
    }

    public void setRoutingMode(int n) throws ConfigError {
        this.setRoutingModeEnum(eOsiMode.from_int(n));
    }

    public eOsiMode getRoutingModeEnum() {
        try {
            return (eOsiMode)this.routingMode.get();
        }
        catch (UserException userException) {
            return eOsiMode.OSI_MODE_ES;
        }
    }

    public void setRoutingModeEnum(eOsiMode eOsiMode2) throws ConfigError {
        try {
            this.routingMode.set(eOsiMode2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError("A configuration error occurred while setting the routing mode.", (UserException)xConfigError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getMaxLsp() {
        return this.getL1LspBufferSize() > this.getL2LspBufferSize() ? this.getL1LspBufferSize() : this.getL2LspBufferSize();
    }

    public short getL1LspBufferSize() {
        try {
            return (Short)this.l1LspBufferSize.get();
        }
        catch (UserException userException) {
            return 0;
        }
    }

    public void setL1LspBufferSize(short s) throws InvalidRange, LspSizeExceedsMtu {
        try {
            this.l1LspBufferSize.set(new Short(s));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (xLspSizeExceedsMtu xLspSizeExceedsMtu2) {
            throw new LspSizeExceedsMtu((UserException)xLspSizeExceedsMtu2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getL2LspBufferSize() {
        try {
            return (Short)this.l2LspBufferSize.get();
        }
        catch (UserException userException) {
            return 0;
        }
    }

    public void setL2LspBufferSize(short s) throws InvalidRange, LspSizeExceedsMtu, UnsupportedOperation {
        try {
            this.l2LspBufferSize.set(new Short(s));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (xLspSizeExceedsMtu xLspSizeExceedsMtu2) {
            throw new LspSizeExceedsMtu((UserException)xLspSizeExceedsMtu2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setIsIsMetricForLink(Byte[] byteArray) throws InvalidRange, ConfigError {
        try {
            this.isIsMetricForLink.set(byteArray);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public Byte[] getIsIsMetricForLink() {
        try {
            return (Byte[])this.isIsMetricForLink.get();
        }
        catch (UserException userException) {
            return new Byte[0];
        }
    }

    public void setIsIsMetricForLinkEnum(eLinkType eLinkType2, Byte by) throws InvalidRange, ConfigError {
        Byte[] byteArray = this.getIsIsMetricForLink();
        byteArray[eLinkType2.value()] = by;
        this.setIsIsMetricForLink(byteArray);
    }

    public Byte getIsIsMetricForLinkEnum(eLinkType eLinkType2) {
        Byte[] byteArray = this.getIsIsMetricForLink();
        return byteArray[eLinkType2.value()];
    }

    public boolean getPartitionRepair() {
        try {
            return (Boolean)this.partitionRepair.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setPartitionRepair(boolean bl) {
        try {
            this.partitionRepair.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean hasGreTunnel(sIpAddr sIpAddr2, sIpAddr sIpAddr3, byte[] byArray, int n) {
        Object[] objectArray = new Object[]{sIpAddr2, sIpAddr3, byArray, new Integer(n)};
        try {
            return (Boolean)this.hasGreTunnel.get(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void createGreTunnel(sIpAddr sIpAddr2, sIpAddr sIpAddr3, byte[] byArray, int n) throws MaxGRETunnels, DupGRETunnel, ConfigError, xInvalidGreTunnelRouteToSelf, xInvalidGreTunnelRouteToSelfSubnet, xInvalidGreTunnelRouteToAllOnes, xInvalidGreTunnelRouteToLocalNet, xInvalidMask, xInvalidGreTunnelDefaultRouteMask, xInvalidGreTunnelRouteToInternalNet, xInvalidGreTunnelRouteToClassDE, xInvalidGreTunnelRouteToClassA, xInvalidGreTunnelRouteToClassB, xInvalidGreTunnelRouteToClassC, xInvalidGreTunnelRouteToBroadcast, xInvalidStaticRouteOrGateway {
        try {
            Object[] objectArray = new Object[]{sIpAddr2, sIpAddr3, byArray, new Integer(n)};
            this.createGreTunnel.set(objectArray);
        }
        catch (xMaxGreTunnels xMaxGreTunnels2) {
            throw new MaxGRETunnels((UserException)xMaxGreTunnels2);
        }
        catch (xDuplicateGreTunnel xDuplicateGreTunnel2) {
            throw new DupGRETunnel((UserException)xDuplicateGreTunnel2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError("A configuration error occurred while provisioning the GRE tunnel.", (UserException)xConfigError2);
        }
        catch (xInvalidGreTunnelRouteToSelf xInvalidGreTunnelRouteToSelf2) {
            throw xInvalidGreTunnelRouteToSelf2;
        }
        catch (xInvalidGreTunnelRouteToSelfSubnet xInvalidGreTunnelRouteToSelfSubnet2) {
            throw xInvalidGreTunnelRouteToSelfSubnet2;
        }
        catch (xInvalidGreTunnelRouteToAllOnes xInvalidGreTunnelRouteToAllOnes2) {
            throw xInvalidGreTunnelRouteToAllOnes2;
        }
        catch (xInvalidGreTunnelRouteToLocalNet xInvalidGreTunnelRouteToLocalNet2) {
            throw xInvalidGreTunnelRouteToLocalNet2;
        }
        catch (xInvalidMask xInvalidMask2) {
            throw xInvalidMask2;
        }
        catch (xInvalidGreTunnelDefaultRouteMask xInvalidGreTunnelDefaultRouteMask2) {
            throw xInvalidGreTunnelDefaultRouteMask2;
        }
        catch (xInvalidGreTunnelRouteToInternalNet xInvalidGreTunnelRouteToInternalNet2) {
            throw xInvalidGreTunnelRouteToInternalNet2;
        }
        catch (xInvalidGreTunnelRouteToClassDE xInvalidGreTunnelRouteToClassDE2) {
            throw xInvalidGreTunnelRouteToClassDE2;
        }
        catch (xInvalidGreTunnelRouteToClassA xInvalidGreTunnelRouteToClassA2) {
            throw xInvalidGreTunnelRouteToClassA2;
        }
        catch (xInvalidGreTunnelRouteToClassB xInvalidGreTunnelRouteToClassB2) {
            throw xInvalidGreTunnelRouteToClassB2;
        }
        catch (xInvalidGreTunnelRouteToClassC xInvalidGreTunnelRouteToClassC2) {
            throw xInvalidGreTunnelRouteToClassC2;
        }
        catch (xInvalidGreTunnelRouteToBroadcast xInvalidGreTunnelRouteToBroadcast2) {
            throw xInvalidGreTunnelRouteToBroadcast2;
        }
        catch (xInvalidStaticRouteOrGateway xInvalidStaticRouteOrGateway2) {
            throw xInvalidStaticRouteOrGateway2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void removeGreTunnel(sIpAddr sIpAddr2, sIpAddr sIpAddr3, byte[] byArray) throws NoSuchGRETunnel {
        try {
            Object[] objectArray = new Object[]{sIpAddr2, sIpAddr3, byArray};
            this.removeGreTunnel.set(objectArray);
        }
        catch (xNoSuchGreTunnel xNoSuchGreTunnel2) {
            throw new NoSuchGRETunnel((UserException)xNoSuchGreTunnel2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sGreTunnel[] getGreTunnels() {
        try {
            return (sGreTunnel[])this.greTunnelList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOsiConfig, 1, (Observer)this);
        }
        this.systemNsap.dispose();
        this.routingMode.dispose();
        this.isIsMetricForLink.dispose();
        this.l1LspBufferSize.dispose();
        this.l2LspBufferSize.dispose();
        this.greTunnelList.dispose();
        this.validNSELs.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        this.db.fine("update()");
        if (observable instanceof CmsObservable) {
            switch (((ObjectMessageInfo)object).getIndex()) {
                case 1: {
                    this.db.fine("update() updating");
                    this.systemNsap.update();
                    this.routingMode.update();
                    this.isIsMetricForLink.update();
                    this.l1LspBufferSize.update();
                    this.l2LspBufferSize.update();
                    this.greTunnelList.update();
                    this.validNSELs.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                default: {
                    this.db.fine("update() ignoring update");
                }
            }
        }
    }

    class GreTunnelList
    extends CachedValue {
        public GreTunnelList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OsiModel.this.getOsiRef().getGreTunnels();
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class RemoveGreTunnel
    extends NonCachedValue {
        public RemoveGreTunnel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            OsiModel.this.getOsiRef().removeGreTunnel((sIpAddr)objectArray[0], (sIpAddr)objectArray[1], (byte[])objectArray[2]);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class HasGreTunnel
    extends NonCachedValue {
        public HasGreTunnel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[3];
            return OsiModel.this.getOsiRef().hasGreTunnel((sIpAddr)objectArray[0], (sIpAddr)objectArray[1], (byte[])objectArray[2], n) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class CreateGreTunnel
    extends NonCachedValue {
        public CreateGreTunnel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[3];
            OsiModel.this.getOsiRef().createGreTunnel((sIpAddr)objectArray[0], (sIpAddr)objectArray[1], (byte[])objectArray[2], n);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class ValidNSELs
    extends CachedValue {
        public ValidNSELs(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OsiModel.this.getOsiRef().getValidGreNsels();
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class PartitionRepair
    extends NonCachedValue {
        public PartitionRepair(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OsiModel.this.getOsiRef().isPartitionRepairEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            OsiModel.this.getOsiRef().setPartitionRepair((Boolean)object);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class IsIsMetricForLink
    extends CachedValue {
        public IsIsMetricForLink(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            byte[] byArray = OsiModel.this.getOsiRef().getIsIsLinkMetrics();
            Byte[] byteArray = new Byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byteArray[i] = new Byte(byArray[i]);
            }
            return byteArray;
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            byte[] byArray = new byte[objectArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (Byte)objectArray[i];
            }
            OsiModel.this.getOsiRef().setIsIsLinkMetrics(byArray);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class L2LspBufferSize
    extends CachedValue {
        public L2LspBufferSize(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(OsiModel.this.getOsiRef().getL2LspBufSize());
        }

        protected void setValue(Object object) throws UserException {
            OsiModel.this.getOsiRef().setL2LspBufSize((Short)object);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class L1LspBufferSize
    extends CachedValue {
        public L1LspBufferSize(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(OsiModel.this.getOsiRef().getL1LspBufSize());
        }

        protected void setValue(Object object) throws UserException {
            OsiModel.this.getOsiRef().setL1LspBufSize((Short)object);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class RoutingMode
    extends CachedValue {
        public RoutingMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OsiModel.this.getOsiRef().getRoutingMode();
        }

        protected void setValue(Object object) throws UserException {
            OsiModel.this.getOsiRef().setRoutingMode((eOsiMode)object);
        }

        public Object outer() {
            return OsiModel.this;
        }
    }

    class SystemNSAP
    extends CachedValue {
        public SystemNSAP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OsiModel.this.getOsiRef().getSystemNsap();
        }

        public Object outer() {
            return OsiModel.this;
        }
    }
}

