/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.FramingType;
import cerent.cms.model.IFTGMarker;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IPathInfo;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;

public class PathInfo
implements IPathInfo,
IFTGMarker {
    private static HoLoComparator holoComp = HoLoComparator.instance();
    protected short pathWidth;
    protected IHoNum startingHo;
    protected int framingType;

    public PathInfo() {
    }

    public PathInfo(short s, IHoNum iHoNum, int n) {
        this.pathWidth = s;
        this.startingHo = iHoNum;
        this.framingType = n;
    }

    public short getPathWidth() {
        return this.pathWidth;
    }

    public void setPathWidth(short s) {
        this.pathWidth = s;
    }

    public IHoNum getStartingHo() {
        return this.startingHo;
    }

    public IHoNum getEndingHo() {
        return PathInfo.calcEndingHo(this.pathWidth, this.startingHo, this.framingType);
    }

    public IHoNum getStartingHo(int n) {
        return HoLoFactory.idlSts2HoNum(n, this.getStartingSts());
    }

    public IHoNum getEndingHo(int n) {
        return PathInfo.calcEndingHo(this.pathWidth, this.getStartingHo(n), n);
    }

    public static IHoNum calcEndingHo(short s, IHoNum iHoNum, int n) {
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        return HoLoFactory.addOffset(iHoNum, iFramingType.getFramingTypeHoPathWidth((int)s) - 1);
    }

    public boolean contains(IHoNum iHoNum) {
        if (iHoNum == null) {
            return true;
        }
        return PathInfo.contains(iHoNum, this.getStartingHo(iHoNum.getFramingType()), this.getEndingHo(iHoNum.getFramingType()));
    }

    public static boolean contains(IHoNum iHoNum, IHoNum iHoNum2, IHoNum iHoNum3) {
        if (iHoNum == null) {
            return true;
        }
        return holoComp.compare(iHoNum2, iHoNum) <= 0 && holoComp.compare(iHoNum, iHoNum3) <= 0;
    }

    public void setStartingHo(IHoNum iHoNum) {
        this.startingHo = iHoNum;
    }

    public short getStartingSts() {
        return this.startingHo == null ? (short)0 : this.startingHo.getIdlHoNum();
    }

    public short getStartingIdlHo() {
        return this.getStartingSts();
    }

    public void setStartingSts(short s) {
        this.startingHo = HoLoFactory.idlSts2HoNum(this.framingType, s);
    }

    public String toString() {
        return "PathInfo[pathWidth=" + this.pathWidth + ", startingHo=" + this.startingHo + "]";
    }
}

