/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ePST;
import cerent.cms.idl.Common.eSST;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ServiceState;
import cerent.util.SDebug;

public class ServiceStateFactory {
    private static SDebug db = new SDebug("ServiceStateFactory");
    private static final ServiceState UNKNOWN_STATE = new ServiceState(-1, null, null);
    private static final ServiceState NULL_STATE = new ServiceState(-2, null, null);
    private static final ServiceState IS_NR = new ServiceState(0, ePST.PST_IS_NR, eSST.SST_NONE);
    private static final ServiceState OOS_AU_AINS = new ServiceState(1, ePST.PST_OOS_AU, eSST.SST_AINS);
    private static final ServiceState OOS_MA_DSBLD = new ServiceState(2, ePST.PST_OOS_MA, eSST.SST_DSBLD);
    private static final ServiceState OOS_MA_MT = new ServiceState(3, ePST.PST_OOS_MA, eSST.SST_MT);
    private static final ServiceState OOS_MA_LPBK_MT = new ServiceState(4, ePST.PST_OOS_MA, eSST.SST_LPBK, eSST.SST_MT);
    private static final ServiceState OOS_AU_AINS_MEA = new ServiceState(5, ePST.PST_OOS_AU, eSST.SST_AINS, eSST.SST_MEA);
    private static final ServiceState OOS_AU_AINS_SWDL = new ServiceState(6, ePST.PST_OOS_AU, eSST.SST_AINS, eSST.SST_SWDL);
    private static final ServiceState OOS_AU_AINS_UEQ = new ServiceState(7, ePST.PST_OOS_AU, eSST.SST_AINS, eSST.SST_UEQ);
    private static final ServiceState OOS_AU_MEA = new ServiceState(8, ePST.PST_OOS_AU, eSST.SST_MEA);
    private static final ServiceState OOS_AU_SWDL = new ServiceState(9, ePST.PST_OOS_AU, eSST.SST_SWDL);
    private static final ServiceState OOS_AU_UEQ = new ServiceState(10, ePST.PST_OOS_AU, eSST.SST_UEQ);
    private static final ServiceState OOS_AUMA_MEA_MT = new ServiceState(11, ePST.PST_OOS_AUMA, eSST.SST_MEA, eSST.SST_MT);
    private static final ServiceState OOS_AUMA_MEA_UAS = new ServiceState(12, ePST.PST_OOS_MA, eSST.SST_MEA, eSST.SST_UAS);
    private static final ServiceState OOS_AUMA_MT_UEQ = new ServiceState(13, ePST.PST_OOS_MA, eSST.SST_MT, eSST.SST_UEQ);
    private static final ServiceState OOS_AUMA_MT_SWDL = new ServiceState(14, ePST.PST_OOS_MA, eSST.SST_MT, eSST.SST_SWDL);
    private static final ServiceState OOS_AUMA_UAS = new ServiceState(15, ePST.PST_OOS_MA, eSST.SST_UAS);
    private static final ServiceState OOS_AUMA_UAS_UEQ = new ServiceState(16, ePST.PST_OOS_MA, eSST.SST_UAS, eSST.SST_UEQ);
    private static final ServiceState OOS_MA_DSBLD_OOG = new ServiceState(17, ePST.PST_OOS_MA, eSST.SST_DSBLD, eSST.SST_OOG);
    private static final ServiceState OOS_MA_MT_OOG = new ServiceState(18, ePST.PST_OOS_MA, eSST.SST_MT, eSST.SST_OOG);
    private static final ServiceState OOS_MA_LPBK_MT_OOG = new ServiceState(19, ePST.PST_OOS_MA, eSST.SST_LPBK, eSST.SST_MT, eSST.SST_OOG);
    private static final ServiceState OOS_MA_FLT_MT = new ServiceState(20, ePST.PST_OOS_MA, eSST.SST_FLT, eSST.SST_MT);
    private static final ServiceState OOS_MA_FLT_MT_OOG = new ServiceState(30, ePST.PST_OOS_MA, eSST.SST_FLT, eSST.SST_MT, eSST.SST_OOG);
    private static final ServiceState OOS_MA_FLT_LPBK_MT = new ServiceState(21, ePST.PST_OOS_MA, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT);
    private static final ServiceState OOS_AU_FLT = new ServiceState(22, ePST.PST_OOS_AU, eSST.SST_FLT);
    private static final ServiceState OOS_AU_AINS_FLT = new ServiceState(23, ePST.PST_OOS_AU, eSST.SST_AINS, eSST.SST_FLT);
    private static final ServiceState OOS_AU_FLT_OOG = new ServiceState(24, ePST.PST_OOS_AU, eSST.SST_FLT, eSST.SST_OOG);
    private static final ServiceState OOS_AUMA_FLT_MT = new ServiceState(25, ePST.PST_OOS_AUMA, eSST.SST_FLT, eSST.SST_MT);
    private static final ServiceState OOS_AUMA_FLT_LPBK_MT = new ServiceState(26, ePST.PST_OOS_AUMA, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT);
    private static final ServiceState OOS_AUMA_FLT_MT_OOG = new ServiceState(27, ePST.PST_OOS_AUMA, eSST.SST_FLT, eSST.SST_MT, eSST.SST_OOG);
    private static final ServiceState OOS_AUMA_FLT_LPBK_MT_OOG = new ServiceState(28, ePST.PST_OOS_AUMA, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT, eSST.SST_OOG);
    private static final ServiceState OOS_AU = new ServiceState(105, ePST.PST_OOS_AU, eSST.SST_NONE);
    private static final ServiceState OOS_AU_AINS_FLT_OOG = new ServiceState(29, ePST.PST_OOS_AU, eSST.SST_AINS, eSST.SST_FLT, eSST.SST_OOG);

    private ServiceStateFactory() {
    }

    public static IServiceState getServiceState(sServiceState sServiceState2) {
        ServiceState serviceState;
        if (sServiceState2 == null || sServiceState2.sstList == null) {
            return NULL_STATE;
        }
        ePST ePST2 = sServiceState2.pst;
        eSST[] eSSTArray = sServiceState2.sstList;
        if (ServiceState.isIS_NR(ePST2, eSSTArray)) {
            serviceState = IS_NR;
        } else if (ServiceState.isOOS_MA_MT(ePST2, eSSTArray)) {
            serviceState = OOS_MA_MT;
        } else if (ServiceState.isOOS_MA_DSBLD(ePST2, eSSTArray)) {
            serviceState = OOS_MA_DSBLD;
        } else if (ServiceState.isOOS_AU_AINS(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS;
        } else if (ServiceState.isOOS_MA_LPBK_MT(ePST2, eSSTArray)) {
            serviceState = OOS_MA_LPBK_MT;
        } else if (ServiceState.isOOS_AU_AINS_MEA(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS_MEA;
        } else if (ServiceState.isOOS_AU_AINS_SWDL(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS_SWDL;
        } else if (ServiceState.isOOS_AU_AINS_UEQ(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS_UEQ;
        } else if (ServiceState.isOOS_AU_MEA(ePST2, eSSTArray)) {
            serviceState = OOS_AU_MEA;
        } else if (ServiceState.isOOS_AU_SWDL(ePST2, eSSTArray)) {
            serviceState = OOS_AU_SWDL;
        } else if (ServiceState.isOOS_AU_UEQ(ePST2, eSSTArray)) {
            serviceState = OOS_AU_UEQ;
        } else if (ServiceState.isOOS_AUMA_MEA_MT(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_MEA_MT;
        } else if (ServiceState.isOOS_AUMA_MEA_UAS(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_MEA_UAS;
        } else if (ServiceState.isOOS_AUMA_MT_UEQ(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_MT_UEQ;
        } else if (ServiceState.isOOS_AUMA_MT_SWDL(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_MT_SWDL;
        } else if (ServiceState.isOOS_AUMA_UAS(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_UAS;
        } else if (ServiceState.isOOS_AUMA_UAS_UEQ(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_UAS_UEQ;
        } else if (ServiceState.isOOS_MA_DSBLD_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_MA_DSBLD_OOG;
        } else if (ServiceState.isOOS_MA_MT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_MA_MT_OOG;
        } else if (ServiceState.isOOS_MA_LPBK_MT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_MA_LPBK_MT_OOG;
        } else if (ServiceState.isOOS_MA_FLT_MT(ePST2, eSSTArray)) {
            serviceState = OOS_MA_FLT_MT;
        } else if (ServiceState.isOOS_MA_FLT_LPBK_MT(ePST2, eSSTArray)) {
            serviceState = OOS_MA_FLT_LPBK_MT;
        } else if (ServiceState.isOOS_MA_FLT_MT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_MA_FLT_MT_OOG;
        } else if (ServiceState.isOOS_AU_FLT(ePST2, eSSTArray)) {
            serviceState = OOS_AU_FLT;
        } else if (ServiceState.isOOS_AU_AINS_FLT(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS_FLT;
        } else if (ServiceState.isOOS_AU_FLT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_AU_FLT_OOG;
        } else if (ServiceState.isOOS_AU_AINS_FLT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_AU_AINS_FLT_OOG;
        } else if (ServiceState.isOOS_AUMA_FLT_MT(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_FLT_MT;
        } else if (ServiceState.isOOS_AUMA_FLT_LPBK_MT(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_FLT_LPBK_MT;
        } else if (ServiceState.isOOS_AUMA_FLT_MT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_FLT_MT_OOG;
        } else if (ServiceState.isOOS_AUMA_FLT_LPBK_MT_OOG(ePST2, eSSTArray)) {
            serviceState = OOS_AUMA_FLT_LPBK_MT_OOG;
        } else if (ServiceState.isOOS_AU(ePST2, eSSTArray)) {
            serviceState = OOS_AU;
        } else {
            serviceState = UNKNOWN_STATE;
            db.set(true);
            db.fine(ServiceStateFactory.serviceStateToString(sServiceState2));
        }
        return serviceState;
    }

    private static String serviceStateToString(sServiceState sServiceState2) {
        return ServiceStateFactory.getPrimaryStateString(sServiceState2) + ServiceStateFactory.getSecondaryStateString(sServiceState2);
    }

    public static String getPrimaryStateString(sServiceState sServiceState2) {
        String string = null;
        switch (sServiceState2.pst.value()) {
            case 0: {
                string = "PST_IS_NR";
                break;
            }
            case 1: {
                string = "PST_OOS_MA";
                break;
            }
            case 2: {
                string = "PST_OOS_AU";
                break;
            }
            case 3: {
                string = "PST_OOS_AUMA";
                break;
            }
            default: {
                string = "Invalid primary state value: " + new Integer(sServiceState2.pst.value());
            }
        }
        return string;
    }

    public static String getSecondaryStateString(sServiceState sServiceState2) {
        String string = "";
        if (sServiceState2.sstList == null) {
            return ", Null sServiceState.sstList";
        }
        eSST[] eSSTArray = sServiceState2.sstList;
        boolean bl = false;
        block12: for (int i = 0; i < eSSTArray.length && !bl; ++i) {
            switch (eSSTArray[i].value()) {
                case 0: {
                    string = string + "," + "SST_NONE";
                    bl = true;
                    continue block12;
                }
                case 1: {
                    string = string + "," + "SST_AINS";
                    continue block12;
                }
                case 2: {
                    string = string + "," + "SST_DSBLD";
                    continue block12;
                }
                case 3: {
                    string = string + "," + "SST_MEA";
                    continue block12;
                }
                case 4: {
                    string = string + "," + "SST_MT";
                    continue block12;
                }
                case 5: {
                    string = string + "," + "SST_LPBK";
                    continue block12;
                }
                case 6: {
                    string = string + "," + "SST_UAS";
                    continue block12;
                }
                case 7: {
                    string = string + "," + "SST_UEQ";
                    continue block12;
                }
                case 10: {
                    string = string + "," + "SST_FLT";
                    continue block12;
                }
                case 9: {
                    string = string + "," + "SST_OOG";
                    continue block12;
                }
                default: {
                    string = string + "," + "Invalid secondary state value: " + new Integer(eSSTArray[i].value());
                }
            }
        }
        return string;
    }
}

