/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.idl.Equipment.eShelfRole;
import cerent.cms.idl.Equipment.sMultishelfEthConfig;
import cerent.cms.idl.Equipment.sShelfInfo;
import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IShelfViewModel;

public final class ShelfInfo {
    private IShelfViewModel cm;
    private short shelfId;
    private short rackNum;
    private short rackPos;
    private eShelfRole role;
    private sMultishelfEthConfig msEthConfig;
    private sPwrMonVoltage pwrMonValues;
    private boolean isMultishelf;

    public ShelfInfo() {
    }

    public ShelfInfo(sShelfInfo sShelfInfo2, IShelfViewModel iShelfViewModel, boolean bl) {
        this(sShelfInfo2.shelfId, sShelfInfo2.role, sShelfInfo2.position.rackNumber, sShelfInfo2.position.positionInRack, sShelfInfo2.ethConfig, sShelfInfo2.pwrMonValues, iShelfViewModel, bl);
    }

    public ShelfInfo(ShelfInfo shelfInfo) {
        this(shelfInfo.shelfId, shelfInfo.role, shelfInfo.rackNum, shelfInfo.rackPos, shelfInfo.msEthConfig, shelfInfo.pwrMonValues, shelfInfo.cm, shelfInfo.isMultishelf);
    }

    public ShelfInfo(short s, short s2, short s3, IShelfViewModel iShelfViewModel, boolean bl) {
        this(s, eShelfRole.SHELF_ROLE_SC, s2, s3, null, null, iShelfViewModel, bl);
    }

    public ShelfInfo(short s, eShelfRole eShelfRole2, short s2, short s3, sMultishelfEthConfig sMultishelfEthConfig2, sPwrMonVoltage sPwrMonVoltage2, IShelfViewModel iShelfViewModel, boolean bl) {
        this.shelfId = s;
        this.role = eShelfRole2;
        this.rackNum = s2;
        this.rackPos = s3;
        this.msEthConfig = sMultishelfEthConfig2;
        this.pwrMonValues = sPwrMonVoltage2;
        this.cm = iShelfViewModel;
        this.isMultishelf = bl;
    }

    public short getShelfId() {
        return this.shelfId;
    }

    public void setShelfId(short s) {
        this.shelfId = s;
    }

    public IShelfRole getShelfRole() {
        if (!this.isMultishelf) {
            return IShelfRole.SHELF_ROLE_SINGLE;
        }
        switch (this.role.value()) {
            case 0: {
                return IShelfRole.SHELF_ROLE_NC;
            }
            case 1: {
                return IShelfRole.SHELF_ROLE_SC;
            }
        }
        return IShelfRole.SHELF_ROLE_SINGLE;
    }

    public void setShelfRole(IShelfRole iShelfRole) {
        this.role = iShelfRole.getShelfRoleEnum();
    }

    public eEqType getShelfType() {
        return eEqType.from_int(this.cm.getShelfType());
    }

    public void setMsEthConfig(sMultishelfEthConfig sMultishelfEthConfig2) {
        this.msEthConfig = sMultishelfEthConfig2;
    }

    public String getShelfTypeStr() {
        return EntityModel.eqType2Name(this.cm.getTDMTerminology(), this.getShelfType());
    }

    public short getRackNum() {
        return this.rackNum;
    }

    public void setRackNum(short s) {
        this.rackNum = s;
    }

    public short getRackPos() {
        return this.rackPos;
    }

    public void setRackPos(short s) {
        this.rackPos = s;
    }

    public eMultishelfLanConfig getLanConfig() {
        return this.msEthConfig.lanConfig;
    }

    public short getPublicVLANId() {
        return this.msEthConfig.publicVlanId;
    }

    public short getInternalVLANId() {
        return this.msEthConfig.internalVlanId;
    }

    public sPwrMonVoltage getPwrMonVoltage() {
        return this.pwrMonValues;
    }

    public void setPwrMonVoltage(sPwrMonVoltage sPwrMonVoltage2) {
        this.pwrMonValues = sPwrMonVoltage2;
    }

    public boolean equals(Object object) {
        if (object instanceof ShelfInfo) {
            ShelfInfo shelfInfo = (ShelfInfo)object;
            return this.shelfId == shelfInfo.shelfId;
        }
        return false;
    }

    public int hashCode() {
        return this.shelfId;
    }

    public String toString() {
        return "ID=" + this.shelfId + " @ [R" + this.rackNum + ",P" + this.rackPos + "], ROLE=" + this.role.value();
    }

    public static class IShelfRole {
        private final int value;
        public static final int _SHELF_ROLE_NC = 0;
        public static final int _SHELF_ROLE_SC = 1;
        public static final int _SHELF_ROLE_SINGLE = 2;
        public static final IShelfRole SHELF_ROLE_NC = new IShelfRole(0);
        public static final IShelfRole SHELF_ROLE_SC = new IShelfRole(1);
        public static final IShelfRole SHELF_ROLE_SINGLE = new IShelfRole(2);

        private IShelfRole(int n) {
            this.value = n;
        }

        public String toString() {
            return this.value == 0 ? "Node Controller" : (this.value == 1 ? "Shelf Controller" : "Single Shelf Node");
        }

        public int value() {
            return this.value;
        }

        public static IShelfRole from_int(int n) {
            switch (n) {
                case 2: {
                    return SHELF_ROLE_SINGLE;
                }
                case 0: {
                    return SHELF_ROLE_NC;
                }
                case 1: {
                    return SHELF_ROLE_SC;
                }
            }
            throw new IllegalArgumentException("" + n);
        }

        public eShelfRole getShelfRoleEnum() {
            return eShelfRole.from_int(this.value);
        }
    }
}

