/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.Node.xStandbyTccNotReady;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.OpticsTopology.sOscPort;
import cerent.cms.idl.Synchronization.Sync;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eManSwitchType;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eSsmGen;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.eTimingSystem;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sDemandData;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.idl.Synchronization.sRefSwitchStatus;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.idl.Synchronization.xBadQuality;
import cerent.cms.idl.Synchronization.xBadReference;
import cerent.cms.idl.Synchronization.xBusy;
import cerent.cms.idl.Synchronization.xInvalidClockSource;
import cerent.cms.idl.Synchronization.xInvalidQuality;
import cerent.cms.idl.Synchronization.xNoSwitchCommandActive;
import cerent.cms.idl.Synchronization.xSyncProvError;
import cerent.cms.idl.Synchronization.xSyncSourceAlreadyDefinedForSlot;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BadReference;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.HtmlSynchronizationReport;
import cerent.cms.model.IDs1Retiming;
import cerent.cms.model.IDs1Timing;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidClockSource;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.model.SyncEntityModel;
import cerent.cms.model.SyncInvalidAisThreshold;
import cerent.cms.model.SyncInvalidCoding;
import cerent.cms.model.SyncInvalidExternalRefSource;
import cerent.cms.model.SyncInvalidFacility;
import cerent.cms.model.SyncInvalidFormat;
import cerent.cms.model.SyncInvalidProvisioningForMode;
import cerent.cms.model.SyncInvalidRefSource;
import cerent.cms.model.SyncInvalidSabit;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.SyncRefSourceCombinationMaximumExceeded;
import cerent.cms.model.SyncSourceAlreadyDefinedForSlot;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationModel
extends Model {
    private TimingStandard timingStandard;
    private Config config;
    private Status status;
    private SonetSysConfig sonetSysConfig;
    private BitsIndex bitsIndex;
    private BitsConfig bitsConfig;
    private RefIndex refIndex;
    private ActiveRefSource activeRefSource;
    private RefSources refSources;
    private OnDemandReport onDemandReport;
    private SwitchRefSource switchRefSource;
    private ReleaseRefSource releaseRefSource;
    private ManualSwitchStatus manualSwitchStatus;
    private RefCandidates refCandidates;
    private HtmlSynchronizationReport syncReport;
    private SyncEntityModel bits1;
    private SyncEntityModel bits2;
    private SyncEntityModel neRef;
    private SyncEntityModel ext1Ref;
    private SyncEntityModel ext2Ref;
    private SyncEntityModel intClk;
    private SyncEntityModel noSync;
    private EventDispatcher dispatcher;
    private ChassisModel chassis;

    private SyncEntityModel createBitsSyncModel(eBits eBits2, int n, String string) {
        SyncEntityModel syncEntityModel;
        block2: {
            syncEntityModel = null;
            try {
                syncEntityModel = new SyncEntityModel(this.chassis, this.getBitsIndex(eBits2), n, string);
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                this.db.println("Caught unexpected error in createBitsSyncModel!");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
        }
        return syncEntityModel;
    }

    private SyncEntityModel createRefSyncModel(eRef eRef2, int n, String string) {
        SyncEntityModel syncEntityModel;
        block2: {
            syncEntityModel = null;
            try {
                syncEntityModel = new SyncEntityModel(this.chassis, this.getRefIndex(eRef2), n, string);
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                this.db.println("Caught unexpected error in createRefSyncModel!");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
        }
        return syncEntityModel;
    }

    public SynchronizationModel(ChassisModel chassisModel) {
        super(chassisModel.getChildDebug(SynchronizationModel.class));
        this.chassis = chassisModel;
        this.index = chassisModel.eventIndexBase();
        this.config = new Config(chassisModel.getNodeModelDelegate(), "SynchronizationModel::config");
        this.status = new Status(chassisModel.getNodeModelDelegate(), "SynchronizationModel::status");
        this.sonetSysConfig = new SonetSysConfig(chassisModel.getNodeModelDelegate(), "SynchronizationModel::sonetSysConfig");
        this.timingStandard = new TimingStandard(chassisModel.getNodeModelDelegate(), "SynchronizationModel::timingStandard");
        this.bitsIndex = new BitsIndex(chassisModel.getNodeModelDelegate(), "SynchronizationModel::bitsIndex");
        this.bitsConfig = new BitsConfig(chassisModel.getNodeModelDelegate(), "SynchronizationModel::bitsConfig");
        this.refIndex = new RefIndex(chassisModel.getNodeModelDelegate(), "SynchronizationModel::refIndex");
        this.activeRefSource = new ActiveRefSource(chassisModel.getNodeModelDelegate(), "SynchronizationModel::activeRefSource");
        this.refSources = new RefSources(chassisModel.getNodeModelDelegate(), "SynchronizationModel::refSources");
        this.onDemandReport = new OnDemandReport(chassisModel.getNodeModelDelegate(), "SynchronizationModel::onDemandReport");
        this.switchRefSource = new SwitchRefSource(chassisModel.getNodeModelDelegate(), "SynchronizationModel::switchRefSource");
        this.releaseRefSource = new ReleaseRefSource(chassisModel.getNodeModelDelegate(), "SynchronizationModel::releaseRefSource");
        this.manualSwitchStatus = new ManualSwitchStatus(chassisModel.getNodeModelDelegate(), "SynchronizationModel::manualSwitchStatus");
        this.refCandidates = new RefCandidates(chassisModel.getNodeModelDelegate(), "SynchronizationModel::refCandidates");
        this.dispatcher = null;
        this.syncReport = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.chassis.getNodeModel();
    }

    private Sync getSyncRef() {
        return this.chassis.getIorRepository().getSynchronizationRef();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.chassis.getNodeModelDelegate();
    }

    public void init() {
        super.init0();
        this.dispatcher = this.chassis.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSync, this.index, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSync, this.index + 1, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSync, this.index, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSync, this.index + 1, (Observer)this);
        }
        this.dispatcher = null;
        this.syncReport = null;
        super.dispose();
    }

    @Override
    public void destroy() {
        this.db.info("Enter SynchronizationModel destroy()");
        super.destroy();
        if (this.bits1 != null) {
            this.bits1.destroy();
        }
        if (this.bits2 != null) {
            this.bits2.destroy();
        }
        if (this.neRef != null) {
            this.neRef.destroy();
        }
        if (this.ext1Ref != null) {
            this.ext1Ref.destroy();
        }
        if (this.ext2Ref != null) {
            this.ext2Ref.destroy();
        }
        if (this.intClk != null) {
            this.intClk.destroy();
        }
        if (this.noSync != null) {
            this.noSync.destroy();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.db.info("update(): calling notifyObservers(CHANGED)");
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public IEntityModel[] getRefCandidates(eTimingMode eTimingMode2, eRef eRef2) {
        IPlatform iPlatform = this.chassis.getPlatform();
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        if (eTimingMode2 != eTimingMode.EXT_TIME && eTimingMode2 != eTimingMode.LINE_TIME && eTimingMode2 != eTimingMode.MIXED_TIME) {
            throw new IllegalArgumentException("Invalid mode passed to SynchronizationModel.getRefCandidates");
        }
        if (eRef2 == eRef.NE) {
            arrayList.add(this.getInternalClockReference());
            if (eTimingMode2 == eTimingMode.EXT_TIME || eTimingMode2 == eTimingMode.MIXED_TIME) {
                arrayList.add(this.getBits1Reference());
                if (iPlatform.supportsBits2()) {
                    arrayList.add(this.getBits2Reference());
                }
            }
            if (eTimingMode2 == eTimingMode.LINE_TIME || eTimingMode2 == eTimingMode.MIXED_TIME) {
                ElementModelsDelegate elementModelsDelegate = this.chassis.getElementModels();
                arrayList.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
                arrayList.addAll(elementModelsDelegate.getNonProtectStm1eEntities());
                if (iPlatform.supportsDWDM()) {
                    arrayList.addAll(this.getOscPorts());
                }
                if (iPlatform.isDs1TimingSupported()) {
                    arrayList.addAll(this.getDs1RefCandidates());
                }
                if (iPlatform.isE1TimingSupported()) {
                    arrayList.addAll(this.getE1RefCandidates());
                }
            }
        } else if (eRef2 == eRef.EXT_1 || eRef2 == eRef.EXT_2) {
            arrayList.add(this.getNoClockReference());
            if (eTimingMode2 == eTimingMode.LINE_TIME) {
                arrayList.add(this.getNeReference());
            }
            ElementModelsDelegate elementModelsDelegate = this.chassis.getElementModels();
            arrayList.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
            arrayList.addAll(elementModelsDelegate.getNonProtectStm1eEntities());
            if (iPlatform.supportsDWDM()) {
                arrayList.addAll(this.getOscPorts());
            }
        } else {
            throw new IllegalArgumentException("Invalid ref passed to SynchronizationModel.getRefCandidates");
        }
        this.filterByChassis(arrayList);
        this.filterDwdmOpticalEntities(arrayList);
        return arrayList.toArray(new EntityModel[0]);
    }

    public eTimingSystem getTimingStandard() {
        try {
            return (eTimingSystem)this.timingStandard.get();
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (this.db.on()) {
                this.db.println("NE doesn't support getTimingStandard operation");
            }
            if (this.chassis.getNodeModelDelegate().isSdh()) {
                return eTimingSystem.SDH_TIMING;
            }
            return eTimingSystem.SONET_TIMING;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getTimingStandard", userException);
        }
    }

    public void setTimingStandard(eTimingSystem eTimingSystem2) throws ConfigError, ProvisionError {
        try {
            this.timingStandard.set(eTimingSystem2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setConfig", userException);
        }
    }

    public boolean isSonetTimingStandard() {
        return this.getTimingStandard() == eTimingSystem.SONET_TIMING;
    }

    public sSyncConfig getConfig() throws NoSuchEquipment {
        try {
            return (sSyncConfig)this.config.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getConfig", userException);
        }
    }

    public void setConfig(sSyncConfig sSyncConfig2) throws NoSuchEquipment, ConfigError, SyncProvBusy, InvalidQuality {
        try {
            this.config.set(sSyncConfig2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setConfig", userException);
        }
    }

    public int getStatus(int n) throws xNoSuchInterface {
        try {
            return (Integer)this.status.get(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getStatus", userException);
        }
    }

    public sLineSyncConfig getSonetConfig(int n) throws xUnsupportedOperation, xNoSuchInterface {
        try {
            return (sLineSyncConfig)this.sonetSysConfig.get(new Integer(n));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw xUnsupportedOperation2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSonetConfig", userException);
        }
    }

    public void setSonetConfig(int n, sLineSyncConfig sLineSyncConfig2) throws EMCProvisionError, UnsupportedOperation, SyncProvBusy, InvalidQuality, NoSuchInterface {
        try {
            Object[] objectArray = new Object[]{new Integer(n), sLineSyncConfig2};
            this.sonetSysConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.chassis.getPlatform());
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setSonetConfig", userException);
        }
    }

    private int getBitsIndex(eBits eBits2) throws xNoSuchInterface {
        try {
            return (Integer)this.bitsIndex.get(eBits2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getBitsIndex", userException);
        }
    }

    public sBitsConfig getBitsConfig(eBits eBits2) throws xNoSuchInterface {
        try {
            return (sBitsConfig)this.bitsConfig.get(eBits2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getBitsConfig", userException);
        }
    }

    public void setBitsConfig(eBits eBits2, sBitsConfig sBitsConfig2) throws Busy, InvalidClockSource, ConfigError, UnsupportedOperation, InvalidQuality, SyncProvBusy, NoSuchInterface, StandbyTccNotReady, SyncInvalidFormat, SyncInvalidCoding, SyncInvalidAisThreshold, SyncInvalidFacility, SyncInvalidRefSource, SyncInvalidProvisioningForMode, SyncProvError {
        try {
            Object[] objectArray = new Object[]{eBits2, sBitsConfig2};
            this.bitsConfig.set(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw new InvalidClockSource((UserException)xInvalidClockSource2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xSyncProvError xSyncProvError2) {
            throw this.detailedSyncProvError(xSyncProvError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xStandbyTccNotReady xStandbyTccNotReady2) {
            throw new StandbyTccNotReady((UserException)xStandbyTccNotReady2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setBitsConfig", userException);
        }
    }

    private int getRefIndex(eRef eRef2) throws xNoSuchInterface {
        try {
            return (Integer)this.refIndex.get(eRef2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getRefIndex", userException);
        }
    }

    public int getActiveRefSource(eRef eRef2) throws NoSuchInterface {
        try {
            return (Integer)this.activeRefSource.get(eRef2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getActiveRefSource", userException);
        }
    }

    public sInfo[] getRefSources(eRef eRef2) throws NoSuchInterface {
        try {
            return (sInfo[])this.refSources.get(eRef2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getRefSources", userException);
        }
    }

    public sDemandData[] getOnDemandData() throws NoSuchEquipment {
        try {
            this.db.fine("Getting onDemandData");
            return (sDemandData[])this.onDemandReport.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOnDemandData", userException);
        }
    }

    public String getSyncReport() throws NoSuchEquipment {
        if (this.syncReport == null) {
            this.db.fine("creating new HtmlSynchronizationReport");
            this.syncReport = this.getNodeModel().isMultishelf() ? new HtmlSynchronizationReport(this, this.chassis.getShelfId()) : new HtmlSynchronizationReport(this);
        }
        this.db.fine("generating HtmlSynchronizationReport");
        return this.syncReport.generateReport();
    }

    public EntityModel[] getRefEntities(eRef eRef2) throws NoSuchInterface {
        sInfo[] sInfoArray = this.getRefSources(eRef2);
        EntityModel[] entityModelArray = new EntityModel[sInfoArray.length];
        EntityTableModel entityTableModel = this.chassis.getEntityTableModel();
        for (int i = 0; i < sInfoArray.length; ++i) {
            entityModelArray[i] = this.getRefEntity(sInfoArray[i].line);
        }
        return entityModelArray;
    }

    public EntityModel getRefEntity(int n) {
        EntityModel entityModel;
        block4: {
            entityModel = this.getBits1Reference();
            if (n != entityModel.getIndex() && n != (entityModel = this.getBits2Reference()).getIndex() && n != (entityModel = this.getNeReference()).getIndex() && n != (entityModel = this.getInternalClockReference()).getIndex() && n != (entityModel = this.getNoClockReference()).getIndex()) {
                try {
                    entityModel = (EntityModel)this.chassis.getEntityTableModel().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.println("Caught unexpected exception in getRefEntity");
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (entityModel == null) {
            this.db.println("Unexpected error in getRefEntity!");
            this.db.println("index = " + n + ", but refEntity = null");
        }
        return entityModel;
    }

    public SyncEntityModel getBits1Reference() {
        if (this.bits1 == null) {
            this.bits1 = this.createBitsSyncModel(eBits.BITS_1, 1, "BITS-1");
        }
        return this.bits1;
    }

    public SyncEntityModel getBits2Reference() {
        if (this.bits2 == null) {
            this.bits2 = this.createBitsSyncModel(eBits.BITS_2, 2, "BITS-2");
        }
        return this.bits2;
    }

    public SyncEntityModel getNeReference() {
        if (this.neRef == null) {
            this.neRef = this.createRefSyncModel(eRef.NE, 3, "NE Reference");
        }
        return this.neRef;
    }

    public SyncEntityModel getExt1Reference() {
        if (this.ext1Ref == null) {
            this.ext1Ref = this.createRefSyncModel(eRef.EXT_1, 4, "Ext Sync Ref 1");
        }
        return this.ext1Ref;
    }

    public SyncEntityModel getExt2Reference() {
        if (this.ext2Ref == null) {
            this.ext2Ref = this.createRefSyncModel(eRef.EXT_2, 5, "Ext Sync Ref 2");
        }
        return this.ext2Ref;
    }

    public SyncEntityModel getInternalClockReference() {
        if (this.intClk == null) {
            SyncEntityModel syncEntityModel = this.getExt2Reference();
            if (this.ext2Ref != null) {
                this.intClk = new SyncEntityModel(this.chassis, this.ext2Ref.getIndex() + 1, 6, "Internal Clock");
            } else {
                this.db.println("Unexpected error occurred in getInternalClockReference!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return this.intClk;
    }

    public SyncEntityModel getNoClockReference() {
        if (this.noSync == null) {
            SyncEntityModel syncEntityModel = this.getExt2Reference();
            if (this.ext2Ref != null) {
                this.noSync = new SyncEntityModel(this.chassis, this.ext2Ref.getIndex() + 2, 7, "None");
            } else {
                this.db.println("Unexpected error occurred in getNoClockReference!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return this.noSync;
    }

    public void setRefSources(eRef eRef2, int[] nArray) throws BadReference, SyncSourceAlreadyDefinedForSlot, SyncProvBusy, InvalidClockSource, SyncInvalidFormat, SyncInvalidCoding, SyncInvalidAisThreshold, SyncInvalidFacility, SyncInvalidRefSource, SyncInvalidProvisioningForMode, SyncProvError {
        try {
            Object[] objectArray = new Object[]{eRef2, nArray};
            this.refSources.set(objectArray);
        }
        catch (xBadReference xBadReference2) {
            throw new BadReference((UserException)xBadReference2);
        }
        catch (xSyncSourceAlreadyDefinedForSlot xSyncSourceAlreadyDefinedForSlot2) {
            throw new SyncSourceAlreadyDefinedForSlot((UserException)xSyncSourceAlreadyDefinedForSlot2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw new InvalidClockSource((UserException)xInvalidClockSource2);
        }
        catch (xSyncProvError xSyncProvError2) {
            throw this.detailedSyncProvError(xSyncProvError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setRefSources", userException);
        }
    }

    public void switchRefSource(eRef eRef2, int n, eManSwitchType eManSwitchType2) throws xBadReference, xBusy, xInvalidClockSource, xBadQuality {
        try {
            Object[] objectArray = new Object[]{eRef2, new Integer(n), eManSwitchType2};
            this.switchRefSource.set(objectArray);
        }
        catch (xBadReference xBadReference2) {
            throw xBadReference2;
        }
        catch (xBusy xBusy2) {
            throw xBusy2;
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw xInvalidClockSource2;
        }
        catch (xBadQuality xBadQuality2) {
            throw xBadQuality2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "switchRefSource", userException);
        }
    }

    public void releaseRefSource(eRef eRef2) throws xNoSwitchCommandActive {
        try {
            this.releaseRefSource.set(eRef2);
        }
        catch (xNoSwitchCommandActive xNoSwitchCommandActive2) {
            throw xNoSwitchCommandActive2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "releaseRefSource", userException);
        }
    }

    public sRefSwitchStatus getManualSwitchStatus(eRef eRef2) throws NoSuchInterface {
        try {
            return (sRefSwitchStatus)this.manualSwitchStatus.get(eRef2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getManualSwitchStatus", userException);
        }
    }

    private Set getOscPorts() {
        HashSet<TdmPortModel> hashSet = new HashSet<TdmPortModel>();
        sOscPort[] sOscPortArray = null;
        try {
            sOscPortArray = this.chassis.getDwdmOpticalSetupModel().getOscPortList();
        }
        catch (FeatureUnsupported featureUnsupported) {
            this.db.info(featureUnsupported.toString());
        }
        catch (CannotPerform cannotPerform) {
            this.db.severe(cannotPerform.toString());
        }
        if (sOscPortArray != null) {
            IEntityModel iEntityModel = null;
            for (int i = 0; i < sOscPortArray.length; ++i) {
                block7: {
                    try {
                        iEntityModel = this.chassis.getEntityTableModel().getEntityModelByIndex(sOscPortArray[i].oscPort);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!this.db.on()) break block7;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                hashSet.add((TdmPortModel)iEntityModel);
            }
        }
        return hashSet;
    }

    private void filterByChassis(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (entityModel.getChassis() == this.chassis) continue;
            iterator.remove();
        }
    }

    private void filterDwdmOpticalEntities(List<EntityModel> list) {
        Iterator<EntityModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel;
            InterfaceModel interfaceModel2;
            EntityModel entityModel = iterator.next();
            IModuleModel iModuleModel = entityModel.getModuleModel();
            if (iModuleModel != null) {
                switch (iModuleModel.getEqType()) {
                    case 118: 
                    case 120: 
                    case 121: 
                    case 184: {
                        iterator.remove();
                        break;
                    }
                    case 181: {
                        interfaceModel2 = (InterfaceModel)((PortModel)entityModel).getInterfaceModel();
                        interfaceModel = interfaceModel2.getFirstLowerLayerModels();
                        if (interfaceModel instanceof DwdmCliLineModel) break;
                        iterator.remove();
                        break;
                    }
                    case 183: {
                        interfaceModel2 = (InterfaceModel)((PortModel)entityModel).getInterfaceModel();
                        interfaceModel = interfaceModel2.getFirstLowerLayerModels();
                        if (interfaceModel instanceof DwdmTrkLineModel) break;
                        iterator.remove();
                    }
                }
            }
            IElementModel iElementModel = null;
            try {
                InterfaceModel interfaceModel3;
                int n;
                interfaceModel2 = (InterfaceModel)((PortModel)entityModel).getInterfaceModel();
                interfaceModel = interfaceModel2.getFirstLowerLayerModels();
                iElementModel = interfaceModel.getElementModelForInterface();
                if (!(iElementModel instanceof YCableModel) || (n = iElementModel.getProtectEntityIndex()) != (interfaceModel3 = interfaceModel2.getHighestParent()).getIndex()) continue;
                iterator.remove();
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private static boolean getDs1RetimingEnabled(PortModel portModel) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        IInterfaceModel iInterfaceModel;
        boolean bl = false;
        IModuleModel iModuleModel = portModel.getModuleModel();
        if (iModuleModel instanceof IDs1Retiming && ((IDs1Retiming)iModuleModel).supportsDs1Retiming() && (iInterfaceModel = portModel.getInterfaceModel()) instanceof Ds1LineModel) {
            bl = ((Ds1LineModel)iInterfaceModel).getDs1RetimingEnabled();
        }
        return bl;
    }

    private boolean isRefSupported(PortModel portModel) {
        return portModel.getParent().getEqType() != 218 || this.isSonetTimingStandard();
    }

    private List getDs1Ports() {
        ArrayList arrayList = new ArrayList();
        List list = this.chassis.getDescendantsOfClassType(6);
        for (EntityModel entityModel : list) {
            if (!(entityModel instanceof IDs1Timing) || !((IDs1Timing)((Object)entityModel)).supportsDs1Timing()) continue;
            arrayList.addAll(entityModel.getDescendantsOfEqType(34));
        }
        return arrayList;
    }

    private List getE1Ports() {
        return this.chassis.getDescendantsOfEqType(68);
    }

    private boolean isPortOnWorkingCard(PortModel portModel) {
        return !((ModuleModel)portModel.getModuleModel()).isProtectModule();
    }

    private Set getDs1RefCandidates() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        Iterator iterator = this.getDs1Ports().iterator();
        while (iterator.hasNext()) {
            try {
                PortModel portModel = (PortModel)iterator.next();
                if (!this.isPortOnWorkingCard(portModel) || SynchronizationModel.getDs1RetimingEnabled(portModel) || !this.isRefSupported(portModel)) continue;
                hashSet.add(portModel);
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (WrongInterfaceType wrongInterfaceType) {}
        }
        return hashSet;
    }

    private Set getE1RefCandidates() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        Iterator iterator = this.getE1Ports().iterator();
        while (iterator.hasNext()) {
            try {
                PortModel portModel = (PortModel)iterator.next();
                if (SynchronizationModel.getDs1RetimingEnabled(portModel) || !this.isPortOnWorkingCard(portModel)) continue;
                hashSet.add(portModel);
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (WrongInterfaceType wrongInterfaceType) {}
        }
        return hashSet;
    }

    public String toString() {
        return "Sync[]";
    }

    public boolean isTimingSource(int n) throws NoSuchInterface {
        sInfo[] sInfoArray = this.getRefSources(eRef.NE);
        for (int i = 0; i < sInfoArray.length; ++i) {
            if (sInfoArray[i].line != n) continue;
            return true;
        }
        return false;
    }

    public boolean isG1SsmGeneration() {
        boolean bl = false;
        try {
            if (this.getConfig().ssmGeneration == eSsmGen.GENERATION_1) {
                bl = true;
            }
        }
        catch (NoSuchEquipment noSuchEquipment) {
            SDebug.printStackTrace((Throwable)noSuchEquipment);
        }
        return bl;
    }

    private SyncProvError detailedSyncProvError(xSyncProvError xSyncProvError2) {
        Throwable throwable = null;
        switch (xSyncProvError2.reason.value()) {
            case 0: {
                throwable = new SyncInvalidFormat((UserException)xSyncProvError2);
                break;
            }
            case 1: {
                throwable = new SyncInvalidCoding((UserException)xSyncProvError2);
                break;
            }
            case 2: {
                throwable = new SyncInvalidAisThreshold((UserException)xSyncProvError2);
                break;
            }
            case 3: {
                throwable = new SyncInvalidFacility((UserException)xSyncProvError2);
                break;
            }
            case 4: {
                throwable = new SyncInvalidRefSource((UserException)xSyncProvError2);
                break;
            }
            case 5: {
                throwable = new SyncInvalidExternalRefSource((UserException)xSyncProvError2);
                break;
            }
            case 6: {
                throwable = new SyncRefSourceCombinationMaximumExceeded((UserException)xSyncProvError2);
                break;
            }
            case 7: {
                throwable = new SyncSourceAlreadyDefinedForSlot((UserException)xSyncProvError2);
                break;
            }
            case 8: {
                throwable = new SyncInvalidProvisioningForMode((UserException)xSyncProvError2);
                break;
            }
            case 9: {
                throwable = new SyncInvalidSabit((UserException)xSyncProvError2);
                break;
            }
            default: {
                throwable = new SyncProvError((UserException)xSyncProvError2);
            }
        }
        return throwable;
    }

    private class RefCandidates
    extends NonCachedValue {
        public RefCandidates(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) {
            Object[] objectArray = (Object[])object;
            return SynchronizationModel.this.getRefCandidates((eTimingMode)objectArray[0], (eRef)objectArray[1]);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class ManualSwitchStatus
    extends NonCachedValue {
        public ManualSwitchStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xNoSuchEquipment {
            return SynchronizationModel.this.getSyncRef().getManualSwitchStatus(SynchronizationModel.this.chassis.getIndex(), (eRef)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class ReleaseRefSource
    extends NonCachedValue {
        public ReleaseRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xNoSwitchCommandActive, xProvisionError, xNoSuchEquipment {
            SynchronizationModel.this.getSyncRef().releaseRefSource(SynchronizationModel.this.chassis.getIndex(), (eRef)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class SwitchRefSource
    extends NonCachedValue {
        public SwitchRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBadReference, xBusy, xInvalidClockSource, xBadQuality, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSyncRef().switchRefSource(SynchronizationModel.this.chassis.getIndex(), (eRef)objectArray[0], (Integer)objectArray[1], (eManSwitchType)objectArray[2]);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class OnDemandReport
    extends NonCachedValue {
        public OnDemandReport(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchEquipment {
            SynchronizationModel.this.db.fine("Retrieving demand data array");
            sDemandData[] sDemandDataArray = SynchronizationModel.this.getSyncRef().getSyncOnDemandReport(SynchronizationModel.this.chassis.getIndex());
            SynchronizationModel.this.db.fine("Retrieved demand data array " + (sDemandDataArray == null ? "null" : Integer.toString(sDemandDataArray.length)));
            return sDemandDataArray;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class RefSources
    extends NonCachedValue {
        public RefSources(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBadReference, xSyncSourceAlreadyDefinedForSlot, xSyncProvBusy, xInvalidClockSource, xSyncProvError, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSyncRef().setRefSources(SynchronizationModel.this.chassis.getIndex(), (eRef)objectArray[0], (int[])objectArray[1]);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xNoSuchEquipment {
            sInfo[] sInfoArray = SynchronizationModel.this.getSyncRef().getRefSources(SynchronizationModel.this.chassis.getIndex(), (eRef)object);
            if (object.equals(eRef.NE)) {
                sInfo[] sInfoArray2 = new sInfo[sInfoArray.length + 1];
                System.arraycopy(sInfoArray, 0, sInfoArray2, 0, sInfoArray.length);
                SyncEntityModel syncEntityModel = SynchronizationModel.this.getInternalClockReference();
                int n = syncEntityModel != null ? syncEntityModel.getIndex() : 0;
                sInfoArray2[sInfoArray.length] = new sInfo(n, true, eQualityLevel.ST3);
                return sInfoArray2;
            }
            return sInfoArray;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class ActiveRefSource
    extends NonCachedValue {
        public ActiveRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xNoSuchEquipment {
            Integer n = new Integer(SynchronizationModel.this.getSyncRef().getActiveRefSource(SynchronizationModel.this.chassis.getIndex(), (eRef)object));
            if (n == 0) {
                if (object.equals(eRef.NE)) {
                    SyncEntityModel syncEntityModel = SynchronizationModel.this.getInternalClockReference();
                    if (syncEntityModel != null) {
                        n = new Integer(syncEntityModel.getIndex());
                    }
                } else {
                    SyncEntityModel syncEntityModel = SynchronizationModel.this.getNoClockReference();
                    if (syncEntityModel != null) {
                        n = new Integer(syncEntityModel.getIndex());
                    }
                }
            }
            return n;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class RefIndex
    extends NonCachedValue {
        public RefIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xNoSuchEquipment {
            return new Integer(SynchronizationModel.this.getSyncRef().getRefIndex(SynchronizationModel.this.chassis.getIndex(), (eRef)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class BitsConfig
    extends NonCachedValue {
        public BitsConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBusy, xInvalidClockSource, xConfigError, xUnsupportedOperation, xInvalidQuality, xSyncProvBusy, xSyncProvError, xNoSuchInterface, xStandbyTccNotReady, xProvisionError, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSyncRef().setBitsConfig(SynchronizationModel.this.chassis.getIndex(), (eBits)objectArray[0], (sBitsConfig)objectArray[1]);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xProvisionError, xNoSuchEquipment {
            return SynchronizationModel.this.getSyncRef().getBitsConfig(SynchronizationModel.this.chassis.getIndex(), (eBits)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class BitsIndex
    extends NonCachedValue {
        public BitsIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xNoSuchEquipment {
            return new Integer(SynchronizationModel.this.getSyncRef().getBitsIndex(SynchronizationModel.this.chassis.getIndex(), (eBits)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class SonetSysConfig
    extends NonCachedValue {
        public SonetSysConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xProvisionError, xUnsupportedOperation, xSyncProvBusy, xInvalidQuality, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSyncRef().setSonetConfig((Integer)objectArray[0], (sLineSyncConfig)objectArray[1]);
        }

        protected Object getValue(Object object) throws xUnsupportedOperation, xNoSuchInterface {
            return SynchronizationModel.this.getSyncRef().getSonetConfig((Integer)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class Status
    extends NonCachedValue {
        public Status(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return new Integer(SynchronizationModel.this.getSyncRef().getStatus((Integer)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class TimingStandard
    extends NonCachedValue {
        public TimingStandard(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xConfigError, xProvisionError, xNoSuchEquipment {
            SynchronizationModel.this.getSyncRef().setTimingSystem(SynchronizationModel.this.chassis.getIndex(), (eTimingSystem)object);
        }

        protected Object getValue() throws xNoSuchEquipment {
            return SynchronizationModel.this.getSyncRef().getTimingSystem(SynchronizationModel.this.chassis.getIndex());
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    private class Config
    extends NonCachedValue {
        public Config(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xConfigError, xSyncProvBusy, xInvalidQuality, xNoSuchEquipment, xProvisionError {
            SynchronizationModel.this.getSyncRef().setConfig(SynchronizationModel.this.chassis.getIndex(), (sSyncConfig)object);
        }

        protected Object getValue() throws xNoSuchEquipment {
            return SynchronizationModel.this.getSyncRef().getConfig(SynchronizationModel.this.chassis.getIndex());
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }
}

