/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.userInfo;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.IUserInfoModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UserInfoModel
implements IUserInfoModel {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
    private String name;
    private eSecurityLevel securityLevel;
    private boolean lockedOut;
    private int failedLoginCount;
    private Date lastLoginTime;
    private boolean userDisabled;
    private boolean forcePasswordChange;
    private static final SDebug db = new SDebug("UserInfoModel");

    public UserInfoModel(NodeModelDelegate nodeModelDelegate, userInfo userInfo2) {
        this.name = userInfo2.name;
        this.securityLevel = eSecurityLevel.from_int(userInfo2.securityLevel.value());
        this.lockedOut = userInfo2.lockedOut;
        this.failedLoginCount = userInfo2.failedLoginCount;
        this.userDisabled = userInfo2.disabled;
        this.forcePasswordChange = userInfo2.forcePasswordChange;
        if (userInfo2.lastLoginTime.year != 0) {
            CtcTimeZone ctcTimeZone = nodeModelDelegate.getCtcTimeZone();
            String string = "" + userInfo2.lastLoginTime.month + "/" + userInfo2.lastLoginTime.day + "/" + userInfo2.lastLoginTime.year + " " + userInfo2.lastLoginTime.hour + ":" + userInfo2.lastLoginTime.minute + ":" + userInfo2.lastLoginTime.second + " " + (userInfo2.lastLoginTime.dstInEffect ? ctcTimeZone.getDstTzAbbreviation() : ctcTimeZone.getStandTzAbbreviation());
            try {
                this.lastLoginTime = sdf.parse(string);
            }
            catch (ParseException parseException) {
                db.info("failed to parse date(" + string + "): ");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPermissionLevel() {
        return this.securityLevel.value();
    }

    public eSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public boolean getLockedOut() {
        return this.lockedOut;
    }

    public int getFailedLoginCount() {
        return this.failedLoginCount;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public boolean getUserDisabled() {
        return this.userDisabled;
    }

    public boolean getUserForcePasswordChange() {
        return this.forcePasswordChange;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof UserInfoModel) {
            UserInfoModel userInfoModel = (UserInfoModel)object;
            return userInfoModel.getName().equals(this.name) && userInfoModel.getPermissionLevel() == this.getPermissionLevel();
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(Object object) {
        if (object instanceof IUserInfoModel) {
            IUserInfoModel iUserInfoModel = (IUserInfoModel)object;
            return this.name.compareTo(iUserInfoModel.getName());
        }
        return -1;
    }
}

