/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.EtherL2Media.EtherL2Module;
import cerent.cms.idl.EtherL2Media.eCardFrpRole;
import cerent.cms.idl.EtherL2Media.eCardFrpState;
import cerent.cms.idl.EtherL2Media.eMultiGetProtocolStates;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sFrpInfo;
import cerent.cms.idl.EtherL2Media.sMcastInfo;
import cerent.cms.idl.EtherL2Media.sMcastReportInfo;
import cerent.cms.idl.EtherL2Media.sVlanCondReportInfo;
import cerent.cms.idl.EtherL2Media.sVlanFuncItem;
import cerent.cms.idl.EtherL2Media.xBoardBusy;
import cerent.cms.idl.EtherL2Media.xMgetReqExpiredTimeout;
import cerent.cms.idl.EtherL2Media.xMgetReqInProgress;
import cerent.cms.idl.EtherL2Media.xMgetReqProtocolError;
import cerent.cms.idl.EtherL2Media.xWrongParameters;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.BoardBusyError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILearnedAddress;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.LearnedAddress;
import cerent.cms.model.MgetReqExpiredTimeout;
import cerent.cms.model.MgetReqInProgress;
import cerent.cms.model.MgetReqProtocolError;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.VlanInfoFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongParameters;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.xpl2.XPL2QinQProvPane;
import cerent.util.ByteArrayUtil;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPL2ModuleModel
extends DwdmModuleModel
implements IXPL2ModuleModel {
    private FrpInfo frpInfo = new FrpInfo("XPL2ModuleModel.FrpInfo");
    private VlanDb vlanDb = new VlanDb("XPL2ModuleModel.VlanDb");
    private ActualMultiCastInfo actualMultiCastInfo;
    private MvrInfo mvrInfo = new MvrInfo("XPL2ModuleModel.MvrInfo");
    private ActualVlanConditions actualVlanCond;
    private LearnedMacInfo learnedMacInfo;

    public XPL2ModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(XPL2ModuleModel.class));
        this.actualMultiCastInfo = new ActualMultiCastInfo(nodeModelDelegate, "XPL2ModuleModel.ActualMultiCastInfo");
        this.actualVlanCond = new ActualVlanConditions(nodeModelDelegate, "XPL2ModudelModel.ActualVlanConditions");
        this.learnedMacInfo = new LearnedMacInfo("XPL2ModuleModel.LearnedMacInfo");
    }

    @Override
    public String getEqLabel() {
        String string;
        block3: {
            string = super.getEqLabel();
            try {
                String string2;
                int n = this.getSlot();
                ArrayList arrayList = this.getNodeModel().getMfgData(this.getShelfId());
                if (n > 0 && (string2 = (String)arrayList.get(n - 1)) != null && string2.indexOf("XPE") != -1) {
                    string = string + "E";
                }
            }
            catch (Exception exception) {
                this.db.fine("Caught " + exception + " while trying to determine XPE");
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string == null ? " " : string;
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 167: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 168: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 316: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 32: 
                case 34: 
                case 68: 
                case 69: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                default: {
                    portModelArray = super.getPortModels(eEqType2);
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public PortModel[] getXPL2EtherPorts() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2EtherPorts(): entry");
        }
        PortModel[] portModelArray = this.getPortModels(eEqType.FE_PORT);
        PortModel[] portModelArray2 = this.getPortModels(eEqType.ONE_GE_PORT);
        PortModel[] portModelArray3 = this.getPortModels(eEqType.TEN_GE_PORT);
        PortModel[] portModelArray4 = new PortModel[portModelArray.length + portModelArray2.length + portModelArray3.length];
        System.arraycopy(portModelArray, 0, portModelArray4, 0, portModelArray.length);
        System.arraycopy(portModelArray2, 0, portModelArray4, portModelArray.length, portModelArray2.length);
        System.arraycopy(portModelArray3, 0, portModelArray4, portModelArray.length + portModelArray2.length, portModelArray3.length);
        Arrays.sort(portModelArray4, new PortComparator());
        return portModelArray4;
    }

    @Override
    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(null);
        } else {
            if (eEqType2.equals(eEqType.DWDM_TRUNK_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.DWDM_CLIENT_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new DwdmCliLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmCliLineModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.XP_GE_LINE_CARD) || eEqType2.equals(eEqType.XP_10GE_LINE_CARD)) {
                EtherLineModel[] etherLineModelArray = XPL2ModuleModel.getEtherLineModels(this.getDwdmLineModels());
                interfaceModelArray = new XPL2LineModel[etherLineModelArray.length];
                System.arraycopy(etherLineModelArray, 0, interfaceModelArray, 0, etherLineModelArray.length);
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.DS1_VT_MAPPED) || eEqType2.equals(eEqType.E1_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new Ds123LineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            interfaceModelArray = super.getLineModels(eEqType2);
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    public XPL2LineModel[] getXPL2UNILines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2UNILines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.UNI_MODE) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public Pane getQinQPlugin(TabbedView tabbedView, short s, short s2, QinQSettings qinQSettings) {
        return new XPL2QinQProvPane("QinQ", tabbedView, this, s, s2, qinQSettings);
    }

    public XPL2LineModel[] getXPL2NNITrunkLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2NNITrunkLines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.NNI_MODE || !xPL2LineModelArray[i].isTrunk()) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public IVlanInfo[] getVlanDb() {
        try {
            sVlanFuncItem[] sVlanFuncItemArray = (sVlanFuncItem[])this.vlanDb.get();
            IVlanInfo[] iVlanInfoArray = VlanInfoFactory.getIVlanInfoArray(sVlanFuncItemArray);
            if (this.db.on()) {
                this.db.println("vlan db for: " + this);
                for (IVlanInfo iVlanInfo : iVlanInfoArray) {
                    this.db.println("  " + iVlanInfo);
                }
            }
            return iVlanInfoArray;
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureNotSupported(xFeatureUnsupported2.getMessage());
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanDb", userException);
        }
    }

    public sVlanFuncItem[] getVlanDbItems() {
        try {
            sVlanFuncItem[] sVlanFuncItemArray = (sVlanFuncItem[])this.vlanDb.get();
            return sVlanFuncItemArray;
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureNotSupported(xFeatureUnsupported2.getMessage());
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanDbItems", userException);
        }
    }

    public void setVlanDbItems(sVlanFuncItem[] sVlanFuncItemArray) throws EMCProvisionError, FeatureUnsupported, NoSuchEquipment {
        try {
            this.vlanDb.set(sVlanFuncItemArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanDbItems", userException);
        }
    }

    public void setVlanDb(IVlanInfo[] iVlanInfoArray) throws EMCProvisionError, FeatureUnsupported, NoSuchEquipment {
        try {
            if (this.db.on()) {
                this.db.println("set vlan db for: " + this);
                for (IVlanInfo iVlanInfo : iVlanInfoArray) {
                    this.db.println("  " + iVlanInfo);
                }
            }
            this.vlanDb.set(VlanInfoFactory.getSvlanFuncItemArray(iVlanInfoArray));
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanDb", userException);
        }
    }

    public sMcastReportInfo[] getVlanMultiCastInfoList(sVlanRangeInfo[] sVlanRangeInfoArray) throws AbstractCmsIOException, NoSuchInterface, WrongInterfaceType {
        try {
            return (sMcastReportInfo[])this.actualMultiCastInfo.get(sVlanRangeInfoArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanMultiCastInfoList", userException);
        }
    }

    public ILearnedAddress[] getLearnedMacInfo(sVlanRangeInfo[] sVlanRangeInfoArray, eMultiGetProtocolStates eMultiGetProtocolStates2, int n) throws WrongParameters, EMCProvisionError, NotSupportedOnEquipment, MgetReqInProgress, MgetReqExpiredTimeout, MgetReqProtocolError, NoSuchEquipment, BoardBusyError {
        try {
            Object[] objectArray = new Object[]{sVlanRangeInfoArray, eMultiGetProtocolStates2, new Integer(n)};
            byte[] byArray = null;
            byte[] byArray2 = null;
            byArray = (byte[])this.learnedMacInfo.get(objectArray);
            if (this.db.on()) {
                this.db.println("compressedBytes.length = " + byArray.length);
            }
            if (eMultiGetProtocolStates2 == eMultiGetProtocolStates.MGET_GET_STOP) {
                return null;
            }
            try {
                byArray2 = XPL2ModuleModel.uncompressByteArray(byArray);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ILearnedAddress[] iLearnedAddressArray = null;
            boolean bl = true;
            if (byArray2[0] == eMultiGetProtocolStates.MGET_RSP_ERROR.value() || byArray2[0] == eMultiGetProtocolStates.MGET_RSP_END.value()) {
                bl = false;
            }
            if (this.db.on()) {
                this.db.println("continueRequest = " + bl + " - decompressedData[0] = " + byArray2[0]);
            }
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
            if (this.db.on()) {
                this.db.println("decompressedData.length = " + byArray2.length);
            }
            iLearnedAddressArray = XPL2ModuleModel.decode(this.divideArrayInToken(byArray2));
            if (this.db.on()) {
                this.db.println("Number of LearnedAddress found:  " + iLearnedAddressArray.length);
            }
            if (!bl && iLearnedAddressArray.length > 0) {
                iLearnedAddressArray[iLearnedAddressArray.length - 1].setLastAddress(true);
            }
            return iLearnedAddressArray;
        }
        catch (xWrongParameters xWrongParameters2) {
            throw new WrongParameters((UserException)xWrongParameters2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xMgetReqInProgress xMgetReqInProgress2) {
            throw new MgetReqInProgress((UserException)xMgetReqInProgress2);
        }
        catch (xMgetReqExpiredTimeout xMgetReqExpiredTimeout2) {
            throw new MgetReqExpiredTimeout((UserException)xMgetReqExpiredTimeout2);
        }
        catch (xMgetReqProtocolError xMgetReqProtocolError2) {
            throw new MgetReqProtocolError((UserException)xMgetReqProtocolError2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xBoardBusy xBoardBusy2) {
            throw new BoardBusyError((UserException)xBoardBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("EMCProvisionError", userException);
        }
    }

    public void clearLearnedAddress() throws xNoSuchEquipment {
        try {
            this.learnedMacInfo.set(new Integer(this.entityIndex));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "clearLearnedAddress", userException);
        }
    }

    public boolean isInL2Mode() {
        eCardOperMode eCardOperMode2 = this.getCardOperMode();
        return eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH;
    }

    public boolean isInMxpMode() {
        return !this.isInL2Mode() && this.getEqType() == 272;
    }

    public boolean isInTxpMode() {
        return !this.isInL2Mode() && this.getEqType() == 271;
    }

    public XPL2LineModel[] getXPL2NNILines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2NNILines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.NNI_MODE) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public XPL2LineModel[] getXPL2EtherLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2EtherLines(): entry");
        }
        return (XPL2LineModel[])this.getLineModels(this.getEqTypeEnum());
    }

    public XPL2Layer2LineModel[] getXPL2Layer2EtherLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2Layer2EtherLines(): entry");
        }
        ArrayList<XPL2Layer2LineModel> arrayList = new ArrayList<XPL2Layer2LineModel>();
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            xPL2Layer2LineModel = xPL2LineModelArray[i].getLayer2LineModel();
            if (xPL2Layer2LineModel == null) continue;
            arrayList.add(xPL2Layer2LineModel);
        }
        return arrayList.toArray(new XPL2Layer2LineModel[0]);
    }

    public XPL2Layer2LineModel getXPL2Layer2EtherLines(int n) {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2Layer2EtherLines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (xPL2LineModelArray[i].getFirstLowerLayerModels().getIndex() != n) continue;
            return xPL2LineModelArray[i].getLayer2LineModel();
        }
        return null;
    }

    public InterfaceModel[] getXPL2PdhLines(eEqType eEqType2) {
        return this.getLineModels(eEqType2);
    }

    @Override
    public IRmonModel[] getRmonModels() {
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        IRmonModel[] iRmonModelArray = new IRmonModel[xPL2LineModelArray.length];
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            iRmonModelArray[i] = xPL2LineModelArray[i].getRmonModel();
        }
        return iRmonModelArray;
    }

    public sFrpInfo getFrpInfo() {
        try {
            return (sFrpInfo)this.frpInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getFrpInfo", userException);
        }
    }

    public void setFrpInfo(sFrpInfo sFrpInfo2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.frpInfo.set(sFrpInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCardFrpInfo", userException);
        }
    }

    public sMcastInfo getMvrInfo() {
        try {
            return (sMcastInfo)this.mvrInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public void setMvrInfo(sMcastInfo sMcastInfo2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.mvrInfo.set(sMcastInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMvrInfo", userException);
        }
    }

    public sVlanCondReportInfo[] getActualVlanConditions(int n) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sVlanCondReportInfo[])this.actualVlanCond.get(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSide", userException);
        }
    }

    public boolean isInMapperMode() {
        int n = this.getEqType();
        return n == 271 || n == 272;
    }

    @Override
    public String toString() {
        return "XPL2" + super.toString();
    }

    protected General getEtherMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherMediaRef();
    }

    protected cerent.cms.idl.EtherL2Media.General getEtherL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2Ref();
    }

    protected EtherL2Module getEtherL2ModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2ModuleRef();
    }

    @Override
    boolean isPortNumUnique(int n) {
        return false;
    }

    @Override
    public boolean isComboModule() {
        return true;
    }

    @Override
    public boolean supportsClearPM() {
        return true;
    }

    public boolean isL2Switch() {
        return this.getCardOperMode() == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH || this.getCardOperMode() == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH;
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.updateLocal(): entry");
        }
        this.frpInfo.update();
        super.updateLocal();
        this.setChanged();
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.updateLocal(): exit");
        }
    }

    @Override
    public void dispose() {
        this.frpInfo.dispose();
        super.dispose();
    }

    @Override
    protected boolean needNotify() {
        return true;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    public boolean isFrpMasterCard() {
        sFrpInfo sFrpInfo2 = this.getFrpInfo();
        return sFrpInfo2.frpRole == eCardFrpRole.FRP_MASTER_CARD;
    }

    public boolean isFrpEnabled() {
        sFrpInfo sFrpInfo2 = this.getFrpInfo();
        return sFrpInfo2.frpState != eCardFrpState.FRP_DISABLED;
    }

    private ArrayList<byte[]> divideArrayInToken(byte[] byArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray2 = null;
        for (int i = 0; i < byArray.length; i += 12) {
            byArray2 = new byte[12];
            int n = i;
            for (int j = 0; j < 12; ++j) {
                byArray2[j] = byArray[n];
                ++n;
            }
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static LearnedAddress[] decode(ArrayList<byte[]> arrayList) {
        byte[] byArray = new byte[6];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[4];
        int n = 0;
        LearnedAddress[] learnedAddressArray = new LearnedAddress[arrayList.size()];
        for (byte[] byArray4 : arrayList) {
            byArray = new byte[6];
            byArray2 = new byte[2];
            byArray3 = new byte[4];
            System.arraycopy(byArray4, 0, byArray, 0, 6);
            System.arraycopy(byArray4, 6, byArray2, 0, 2);
            System.arraycopy(byArray4, 8, byArray3, 0, 4);
            short s = ByteArrayUtil.toShort(byArray2);
            int n2 = ByteArrayUtil.toInt(byArray3);
            learnedAddressArray[n] = new LearnedAddress();
            learnedAddressArray[n].setMacAddress(byArray);
            learnedAddressArray[n].setVlanId(s);
            learnedAddressArray[n].setIfIndex(n2);
            ++n;
        }
        return learnedAddressArray;
    }

    private static byte[] uncompressByteArray(byte[] byArray) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!inflater.finished()) {
            try {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            catch (DataFormatException dataFormatException) {}
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }

    public boolean hasEthMiTopLines() {
        boolean bl = false;
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (!xPL2LineModelArray[i].isMiTopLine()) continue;
            bl = true;
            return bl;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PortComparator
    implements Comparator<IEntityModel> {
        PortComparator() {
        }

        @Override
        public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            return ComparisonUtil.compare((int)iEntityModel.getEntityIndex(), (int)iEntityModel2.getEntityIndex());
        }
    }

    private class LearnedMacInfo
    extends NonCachedValue {
        public LearnedMacInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        protected Object getValue(Object object) throws xMgetReqInProgress, xMgetReqExpiredTimeout, xMgetReqProtocolError, xWrongParameters, xNotSupportedOnEquipment, xNoSuchEquipment, xBoardBusy {
            Object[] objectArray = (Object[])object;
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getCompressedLearnedMacInfo(XPL2ModuleModel.this.entityIndex, (sVlanRangeInfo[])objectArray[0], (eMultiGetProtocolStates)objectArray[1], (Integer)objectArray[2]);
        }

        protected void setValue(Object object) throws UserException {
            XPL2ModuleModel.this.getEtherL2ModuleRef().clearLearnedMacInfo(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class MvrInfo
    extends NonCachedValue {
        public MvrInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setMCastInfo(XPL2ModuleModel.this.entityIndex, (sMcastInfo)object);
        }

        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getMCastInfo(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class VlanDb
    extends NonCachedValue {
        public VlanDb(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xFeatureUnsupported, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setVlanDb(XPL2ModuleModel.this.entityIndex, (sVlanFuncItem[])object);
        }

        protected Object getValue() throws xFeatureUnsupported, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getVlanDb(XPL2ModuleModel.this.entityIndex);
        }
    }

    public class ActualVlanConditions
    extends NonCachedValue {
        public ActualVlanConditions(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherL2Ref().getActualVlanConditions((Integer)object);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class ActualMultiCastInfo
    extends NonCachedValue {
        public ActualMultiCastInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Object[] objectArray = (Object[])object;
            sVlanRangeInfo[] sVlanRangeInfoArray = (sVlanRangeInfo[])objectArray;
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getActualMcastInfo(XPL2ModuleModel.this.entityIndex, sVlanRangeInfoArray);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class FrpInfo
    extends CachedValue {
        public FrpInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setFrpInfo(XPL2ModuleModel.this.entityIndex, (sFrpInfo)object);
        }

        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getFrpInfo(XPL2ModuleModel.this.entityIndex);
        }
    }
}

