/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.event.IAlarmStatus;

public class AlarmStatus
implements IAlarmStatus {
    private boolean dirty = false;
    private int critical;
    private int major;
    private int minor;

    public AlarmStatus() {
        this.reset();
    }

    public String toString() {
        return "CR=" + this.critical + " MJ=" + this.major + " MN=" + this.minor;
    }

    public void reset() {
        this.critical = 0;
        this.major = 0;
        this.minor = 0;
        this.dirty = true;
    }

    public int getHighestSeverity() {
        if (this.critical > 0) {
            return 3;
        }
        if (this.major > 0) {
            return 2;
        }
        if (this.minor > 0) {
            return 1;
        }
        return 0;
    }

    public void incrementSeverity(int n) {
        switch (n) {
            case 2: {
                ++this.minor;
                this.dirty = true;
                break;
            }
            case 3: {
                ++this.major;
                this.dirty = true;
                break;
            }
            case 4: {
                ++this.critical;
                this.dirty = true;
            }
        }
    }

    public void decrementSeverity(int n) {
        switch (n) {
            case 2: {
                if (this.minor <= 0) break;
                --this.minor;
                this.dirty = true;
                break;
            }
            case 3: {
                if (this.major <= 0) break;
                --this.major;
                this.dirty = true;
                break;
            }
            case 4: {
                if (this.critical <= 0) break;
                --this.critical;
                this.dirty = true;
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public int critical() {
        return this.critical;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }
}

