/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.model.Attribute;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.IAccessor;
import cerent.cms.model.nedefaults.VariableRangeLimit;
import cerent.util.InetUtil;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class DefaultsEdit {
    static final String CLAUSE_SEPARATOR = "; ";
    static final String DELIMITER = ", ";
    static final String ELLIPSIS = " .. ";
    private int defaultsClass;
    private static HashMap edits = new HashMap();
    protected static SDebug db = DefaultsElement.db;

    protected DefaultsEdit(int n) {
        this.defaultsClass = n;
    }

    int getDefaultsEnumClass() {
        return this.defaultsClass;
    }

    boolean hasIndependentValidity() {
        return true;
    }

    long getDivisor() {
        return 1L;
    }

    String checkValue(String string, IAccessor iAccessor) throws ProvisionError {
        String string2 = iAccessor.getFullName();
        boolean bl = iAccessor.neverEditable();
        String string3 = iAccessor.getCurrent();
        db.finest("Universal edit " + string2 + ", isNeverEditable? " + bl + ", new value: " + string + ", preset value: " + iAccessor.getPreset() + ", current value: " + string3);
        if (bl && !string3.equals(string)) {
            throw new ProvisionError("The value of \"" + string2 + "\" must remain " + string3 + ".");
        }
        return string;
    }

    void crossCheckValue(IAccessor iAccessor) throws ProvisionError {
    }

    List getCurrentlyValidEnumValues(IAccessor iAccessor) {
        db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
        return new ArrayList();
    }

    boolean isNumericallyEnumerated(List list) {
        return list != null && !list.isEmpty() && list.get(0) instanceof Attribute;
    }

    boolean isNumericallyEnumerated(IAccessor iAccessor) {
        return this.isNumericallyEnumerated(this.getCurrentlyValidEnumValues(iAccessor));
    }

    Attribute toAttribute(String string, List list) {
        Attribute attribute = null;
        if (this.isNumericallyEnumerated(list)) {
            for (Attribute attribute2 : list) {
                db.fine("Matching >" + string + "< against " + attribute2.getValue() + "=>" + attribute2.getKey() + "<");
                if (!attribute2.getKey().equalsIgnoreCase(string)) continue;
                attribute = attribute2;
                break;
            }
        } else {
            db.severe("No attributes available...");
        }
        return attribute;
    }

    Attribute toAttribute(String string, IAccessor iAccessor) {
        return this.toAttribute(string, this.getCurrentlyValidEnumValues(iAccessor));
    }

    Attribute toAttribute(int n, List list) {
        Attribute attribute = null;
        if (this.isNumericallyEnumerated(list)) {
            for (Attribute attribute2 : list) {
                db.fine("Matching " + n + " against " + attribute2.getValue() + "=>" + attribute2.getKey());
                if (attribute2.getIntValue() != n) continue;
                attribute = attribute2;
                break;
            }
        }
        return attribute;
    }

    Attribute toAttribute(int n, IAccessor iAccessor) {
        return this.toAttribute(n, this.getCurrentlyValidEnumValues(iAccessor));
    }

    void initEnumPass1(IAccessor iAccessor) {
        this.getCurrentlyValidEnumValues(iAccessor);
    }

    String toString(IAccessor iAccessor) {
        return "Free form field";
    }

    private static DefaultsEdit makeInstance(int n, List list) {
        if (n == 0) {
            int n2;
            if (list != null && (n2 = list.size()) >= 2 && n2 % 2 == 0) {
                return new VariableRangeEdit(n, list);
            }
        } else {
            switch (n) {
                case 4: {
                    return new EnumEdit(n, list);
                }
                case 3: {
                    return new IpAddressEdit(n);
                }
                case 9: {
                    return new VariableRangeEnumEdit(n, list);
                }
                case 11: {
                    return new VariableNamedEnumMasterEdit(n, list);
                }
                case 12: {
                    return new VariableNamedEnumOverseerEdit(n, list);
                }
                case 14: 
                case 15: {
                    return new VariableNamedEnumSlaveEdit(n, list);
                }
            }
        }
        return new DefaultsEdit(n);
    }

    private static String getType(Object object) {
        String string = object instanceof Attribute ? "A" : (object instanceof String ? "S" : "?");
        return string;
    }

    static String getKey(int n, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var3_32 = null;
        stringBuffer.append(n);
        for (Object var3_32 : list) {
            stringBuffer.append('|').append((Object)var3_32);
        }
        if (var3_32 != null) {
            stringBuffer.append('|').append(DefaultsEdit.getType(var3_32));
        }
        return stringBuffer.toString();
    }

    static synchronized DefaultsEdit getInstance(String string, int n, List list) {
        String string2 = DefaultsEdit.getKey(n, list);
        DefaultsEdit defaultsEdit = (DefaultsEdit)edits.get(string2);
        if (defaultsEdit == null) {
            defaultsEdit = DefaultsEdit.makeInstance(n, list);
            edits.put(string2, defaultsEdit);
        }
        return defaultsEdit;
    }

    protected static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected static boolean isNumeric(String string) {
        boolean bl = true;
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected static long toScaledLong(Object object, long l) {
        return Math.round(Double.parseDouble((String)object) * (double)l);
    }

    private static class VariableNamedEnumOverseerEdit
    extends VariableNamedEnumSlaveEdit {
        VariableNamedEnumOverseerEdit(int n, List list) {
            super(n, list);
        }

        protected synchronized void maybeInit(IAccessor iAccessor) {
            db.info("maybeInit() : derived");
            if (this.master == null) {
                String[] stringArray = this.getSiblingsByType((String)this.rawEdit.get(0), "Master");
                this.masterRelativePath = stringArray.length == 1 ? stringArray[0] : "nothing";
                this.master = iAccessor.getCousinElement(this.masterRelativePath);
                if (this.master == null) {
                    db.severe(iAccessor.getFullName() + "maybeInit(): no master " + this.masterRelativePath);
                    for (int i = 0; i < stringArray.length; ++i) {
                        db.severe("sibling " + i + " " + stringArray[i]);
                    }
                }
            }
        }

        void crossCheckValue(IAccessor iAccessor) throws ProvisionError {
            String[] stringArray = new String[]{};
            String string = "";
            if (!this.rawEdit.isEmpty()) {
                Object e = this.rawEdit.get(0);
                if (e instanceof String) {
                    stringArray = this.getSiblingsByType((String)e, "Slave");
                    if (stringArray.length == 0) {
                        stringArray = new String[]{(String)e};
                    }
                } else if (e instanceof String[]) {
                    stringArray = (String[])e;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    db.fine("Getting cousin slave for " + iAccessor.getFullName() + " based on " + stringArray[i] + " size is " + this.rawEdit.size());
                    DefaultsElement defaultsElement = iAccessor.getCousinElement(stringArray[i]);
                    if (defaultsElement != null) {
                        try {
                            defaultsElement.checkValue();
                        }
                        catch (ProvisionError provisionError) {
                            db.info("Slave " + defaultsElement.getName() + " " + defaultsElement.getValue() + " failure on " + iAccessor.getFullName());
                            string = string + "The value of the dependent " + defaultsElement.getFullName() + " is no longer valid.\n";
                            defaultsElement.setDirty();
                        }
                        continue;
                    }
                    db.severe("Slave " + stringArray[i] + " does not exist");
                }
            }
        }
    }

    private static class VariableNamedEnumSlaveEdit
    extends EnumEdit {
        protected DefaultsElement master = null;
        protected String masterRelativePath = "nothing";

        protected VariableNamedEnumSlaveEdit(int n, List list) {
            super(n, list);
        }

        protected synchronized void maybeInit(IAccessor iAccessor) {
            if (this.master == null) {
                this.masterRelativePath = (String)this.rawEdit.get(0);
                this.master = iAccessor.getCousinElement(this.masterRelativePath);
            }
        }

        protected String getErrorString(String string, IAccessor iAccessor) {
            List list = this.getCurrentlyValidEnumValues(iAccessor);
            String string2 = this.master == null ? "no master" : this.master.getName();
            String string3 = this.master == null ? "no master" : this.master.getValue();
            int n = list == null ? 1 : list.size();
            return iAccessor.getFullName() + ": \"" + string + "\" is not a valid value given the current value of " + string2 + " (" + string3 + ").\nThe current value is " + iAccessor.getCurrent() + ".\nThe currently valid " + PluralisationUtil.s("value", n) + " " + PluralisationUtil.s("is", n) + " " + this.format(list) + ".";
        }

        boolean hasIndependentValidity() {
            return false;
        }

        private boolean checkEnumValues(String string, List list, IAccessor iAccessor) {
            boolean bl = false;
            if (!list.isEmpty()) {
                if (list.get(0) instanceof String) {
                    db.fine("Checking enumerated value " + string + " as string...");
                    bl = list.indexOf(string) > -1;
                } else {
                    db.fine("Checking enumerated value as attribute...");
                    bl = this.toAttribute(string, list) != null;
                }
            }
            return bl;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            boolean bl = db.isFineEnabled();
            if (bl) {
                db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            }
            List list = new ArrayList();
            this.maybeInit(iAccessor);
            if (this.master != null) {
                String string = this.master.getValue();
                if (db.isInfoEnabled()) {
                    db.info("Getting enumerated values for " + iAccessor.getFullName() + " based on master " + this.master.getName() + " value of " + string + ".");
                }
                for (int i = 1; i < this.rawEdit.size(); ++i) {
                    List[] listArray = (List[])this.rawEdit.get(i);
                    if (!this.checkEnumValues(string, listArray[0], iAccessor)) continue;
                    list = listArray[1];
                    break;
                }
            } else {
                db.severe("Variable named enum master " + this.masterRelativePath + " must exist as a sibling for slave " + iAccessor.getFullName() + " and be an enumeration");
            }
            if (bl) {
                db.fine("Got " + list.size() + " enumerated values for " + iAccessor.getFullName() + " based on " + (this.master == null ? "nothing" : this.master.getName()));
            }
            return list;
        }

        String toString(IAccessor iAccessor) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = this.rawEdit.size();
            for (int i = 1; i < n; ++i) {
                List[] listArray = (List[])this.rawEdit.get(i);
                stringBuffer.append(this.format(listArray[1]));
                stringBuffer.append(" when ").append(this.masterRelativePath).append(" ");
                int n2 = listArray[0].size() - 1;
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append(listArray[0].get(j)).append(DefaultsEdit.DELIMITER);
                }
                stringBuffer.append(listArray[0].get(n2));
                if (i >= n - 1) continue;
                stringBuffer.append(DefaultsEdit.CLAUSE_SEPARATOR);
            }
            return stringBuffer.toString();
        }
    }

    private static class VariableNamedEnumMasterEdit
    extends EnumEdit {
        protected VariableNamedEnumMasterEdit(int n, List list) {
            super(n, list);
        }

        boolean hasIndependentValidity() {
            return false;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            ArrayList arrayList = new ArrayList(this.rawEdit);
            arrayList.remove(0);
            return arrayList;
        }

        void crossCheckValue(IAccessor iAccessor) throws ProvisionError {
            Object object;
            String[] stringArray = new String[]{};
            String string = "";
            if (!this.rawEdit.isEmpty()) {
                object = this.rawEdit.get(0);
                if (object instanceof String) {
                    stringArray = this.getSiblingsByType((String)object, "Slave");
                    if (stringArray.length == 0) {
                        stringArray = new String[]{(String)object};
                    }
                } else if (object instanceof String[]) {
                    stringArray = (String[])object;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    db.fine("Getting cousin slave for " + iAccessor.getFullName() + " based on " + stringArray[i] + " size is " + this.rawEdit.size());
                    DefaultsElement defaultsElement = iAccessor.getCousinElement(stringArray[i]);
                    if (defaultsElement != null) {
                        try {
                            defaultsElement.checkValue();
                        }
                        catch (ProvisionError provisionError) {
                            db.info("Slave " + defaultsElement.getName() + " " + defaultsElement.getValue() + " failure on " + iAccessor.getFullName());
                            string = string + "The value of the dependent " + defaultsElement.getFullName() + " is no longer valid.\n";
                            if (iAccessor.getPreset() == null) continue;
                            defaultsElement.setDirty();
                        }
                        continue;
                    }
                    db.severe("Slave " + stringArray[i] + " does not exist");
                }
            }
            if (stringArray.length == 0 || string.length() > 0) {
                object = new ProvisionError(iAccessor.getFullName() + ": " + string);
                db.info("Throwing " + string + " on " + iAccessor.getFullName());
                SDebug.printStackTrace(object);
                throw object;
            }
        }
    }

    private static class VariableRangeEnumEdit
    extends EnumEdit {
        protected VariableRangeEnumEdit(int n, List list) {
            super(n, list);
        }

        boolean hasIndependentValidity() {
            return false;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            ArrayList arrayList = new ArrayList(this.rawEdit);
            int n = arrayList.size() - 1;
            String string = (String)arrayList.get(0);
            String string2 = (String)arrayList.get(1);
            return arrayList.subList(VariableRangeEnumEdit.getIndex(arrayList, string, 2, iAccessor), VariableRangeEnumEdit.getIndex(arrayList, string2, n, iAccessor) + 1);
        }

        private static int getIndex(List list, String string, int n, IAccessor iAccessor) {
            int n2;
            DefaultsElement defaultsElement;
            int n3 = n;
            if (!VariableRangeEnumEdit.isEmpty(string) && (defaultsElement = iAccessor.getCousinElement(string)) != null && (n2 = list.indexOf(defaultsElement.getValue())) > -1) {
                n3 = n2;
            }
            return n3;
        }
    }

    private static class EnumEdit
    extends DefaultsEdit {
        protected List rawEdit;

        protected EnumEdit(int n, List list) {
            super(n);
            this.rawEdit = list;
        }

        boolean hasIndependentValidity() {
            return true;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            return this.rawEdit;
        }

        String getErrorString(String string, IAccessor iAccessor) {
            return iAccessor.getFullName() + ": \"" + string + "\" is not a valid value.\nValid values are defined as " + this + ".";
        }

        String checkValue(String string, IAccessor iAccessor) throws ProvisionError {
            super.checkValue(string, iAccessor);
            List list = this.getCurrentlyValidEnumValues(iAccessor);
            boolean bl = false;
            Object var5_5 = null;
            if (!list.isEmpty()) {
                if (list.get(0) instanceof String) {
                    db.fine("Checking enumerated value " + string + " as string...");
                    bl = list.indexOf(string) > -1;
                } else {
                    db.fine(iAccessor.getFullName() + ": Checking enumerated value as attribute...");
                    boolean bl2 = bl = this.toAttribute(string, iAccessor) != null;
                }
            }
            if (!bl) {
                throw new ProvisionError(this.getErrorString(string, iAccessor));
            }
            return string;
        }

        private boolean printAllValues(List list) {
            boolean bl;
            int n = list.size();
            boolean bl2 = bl = n < 12;
            if (!bl) {
                try {
                    NumberFormat.getInstance().parse(list.get(0).toString());
                }
                catch (ParseException parseException) {
                    bl = true;
                }
            }
            return bl;
        }

        protected String[] getSiblingsByType(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = string.split(",\\s");
            db.fine("getSiblingsByType(): " + stringArray.length + " tokens in " + string);
            for (int i = 0; i < stringArray.length; ++i) {
                db.fine("token " + stringArray[i]);
                if (stringArray[i].startsWith(string2 + ".")) {
                    db.fine("Utilizing matching type " + string2 + ":  " + stringArray[i]);
                    String string3 = stringArray[i].replaceFirst(string2 + ".", "");
                    arrayList.add(string3);
                    continue;
                }
                db.fine("Bypassing non-matching type " + string2 + ": " + stringArray[i]);
            }
            db.fine("Returning " + arrayList.size() + " type " + string2);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        protected String format(List list) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = list.size();
            if (n > 0) {
                if (this.printAllValues(list)) {
                    int n2 = n - 1;
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer.append(list.get(i).toString()).append(DefaultsEdit.DELIMITER);
                    }
                    stringBuffer.append(list.get(n2).toString());
                } else {
                    int n3 = 2;
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer.append(list.get(i).toString()).append(DefaultsEdit.DELIMITER);
                    }
                    stringBuffer.append(list.get(n3).toString()).append(DefaultsEdit.ELLIPSIS).append(list.get(n - 1).toString());
                }
            }
            return stringBuffer.toString();
        }

        String toString(IAccessor iAccessor) {
            return this.format(this.getCurrentlyValidEnumValues(iAccessor));
        }
    }

    private static class VariableRangeEdit
    extends DefaultsEdit {
        private List rawEdit;
        private VariableRangeLimit low;
        private VariableRangeLimit high;
        private double step;
        private long divisor;

        protected VariableRangeEdit(int n, List list) {
            super(n);
            int n2;
            int n3 = list.size();
            this.rawEdit = list;
            if (n3 == 2) {
                this.step = 1.0;
                this.divisor = 1L;
                n2 = 2;
            } else {
                String string = (String)list.get(2);
                String string2 = (String)list.get(3);
                if (VariableRangeEdit.isNumeric(string) && VariableRangeEdit.isNumeric(string2)) {
                    this.step = Long.parseLong(string);
                    this.divisor = Long.parseLong(string2);
                    n2 = 4;
                } else {
                    this.step = 1.0;
                    this.divisor = 1L;
                    n2 = 2;
                }
            }
            this.low = new VariableRangeLimit(VariableRangeEdit.toScaledLong(list.get(0), 1L), this.divisor);
            this.high = new VariableRangeLimit(VariableRangeEdit.toScaledLong(list.get(1), 1L), this.divisor);
            for (int i = 0; i < n2; ++i) {
                list.remove(0);
            }
        }

        boolean hasIndependentValidity() {
            return false;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            return this.rawEdit;
        }

        long getDivisor() {
            return this.divisor;
        }

        String checkValue(String string, IAccessor iAccessor) throws ProvisionError {
            super.checkValue(string, iAccessor);
            int n = this.rawEdit.size();
            try {
                long l = VariableRangeEdit.toScaledLong(string, this.divisor);
                if (n == 0) {
                    this.low.init(null, null);
                    this.high.init(null, null);
                    this.checkValue(string, l, this.low, this.high, iAccessor);
                } else {
                    int n2 = 0;
                    while (n2 + 1 < n) {
                        this.initBound(this.low, (String)this.rawEdit.get(n2), "low", iAccessor);
                        this.initBound(this.high, (String)this.rawEdit.get(n2 + 1), "high", iAccessor);
                        this.checkValue(string, l, this.low, this.high, iAccessor);
                        n2 += 2;
                    }
                }
                if (this.divisor == 1L) {
                    return Long.toString(l);
                }
                return Double.toString((double)l / (double)this.divisor);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.error(iAccessor, string, "must be a float");
            }
        }

        private void initBound(VariableRangeLimit variableRangeLimit, String string, String string2, IAccessor iAccessor) throws ProvisionError {
            try {
                variableRangeLimit.init(iAccessor, string);
            }
            catch (NumberFormatException numberFormatException) {
                SDebug.printStackTrace((Throwable)numberFormatException);
                throw new ProvisionError(iAccessor.getFullName() + ": Invalid " + string2 + " " + variableRangeLimit);
            }
        }

        private void checkValue(String string, long l, VariableRangeLimit variableRangeLimit, VariableRangeLimit variableRangeLimit2, IAccessor iAccessor) throws ProvisionError {
            long l2;
            long l3 = variableRangeLimit.getValue();
            if (l3 <= (l2 = variableRangeLimit2.getValue()) && (l < l3 || l > l2)) {
                throw this.error(iAccessor, string, "out of range");
            }
        }

        private ProvisionError error(IAccessor iAccessor, String string, String string2) {
            String string3 = "[" + this.low.format() + DefaultsEdit.ELLIPSIS + this.high.format() + "]";
            if (string3.length() > 50) {
                string3 = "\n" + string3;
            }
            return new ProvisionError(iAccessor.getFullName() + ": Value \"" + string + "\" " + string2 + " " + string3);
        }

        private void putStep(StringBuffer stringBuffer, String string, long l, double d, int n) {
            if (VariableRangeEdit.isEmpty(string)) {
                if (this.divisor == 1L) {
                    stringBuffer.append(l + (long)d * (long)n);
                } else {
                    stringBuffer.append((double)(l / this.divisor) + d * (double)n);
                }
            } else {
                stringBuffer.append(string);
                if (n > 0) {
                    stringBuffer.append(" + ");
                    if (this.divisor == 1L) {
                        stringBuffer.append((long)d * (long)n);
                    } else {
                        stringBuffer.append(d * (double)n);
                    }
                }
            }
        }

        String toString(IAccessor iAccessor) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = this.rawEdit.size();
            if (n == 0) {
                stringBuffer.append(this.low.getLimit());
                stringBuffer.append(" - ");
                stringBuffer.append(this.high.getLimit());
            } else {
                String string = "";
                double d = this.step / (double)this.divisor;
                int n2 = 0;
                while (n2 + 1 < n) {
                    String string2 = (String)this.rawEdit.get(n2);
                    String string3 = (String)this.rawEdit.get(n2 + 1);
                    stringBuffer.append(string);
                    string = " and ";
                    this.putStep(stringBuffer, string2, this.low.getLimit(), d, 0);
                    for (int i = 1; i < 3; ++i) {
                        stringBuffer.append(DefaultsEdit.DELIMITER);
                        this.putStep(stringBuffer, string2, this.low.getLimit(), d, i);
                    }
                    stringBuffer.append(DefaultsEdit.ELLIPSIS);
                    this.putStep(stringBuffer, string3, this.high.getLimit(), d, 0);
                    n2 += 2;
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class IpAddressEdit
    extends DefaultsEdit {
        protected IpAddressEdit(int n) {
            super(n);
        }

        boolean hasIndependentValidity() {
            return true;
        }

        protected String getErrorString(String string, IAccessor iAccessor) {
            return iAccessor.getFullName() + ": \"" + string + "\" cannot be interpreted as an IP address.";
        }

        String checkValue(String string, IAccessor iAccessor) throws ProvisionError {
            super.checkValue(string, iAccessor);
            try {
                InetUtil.makeIpAddr(string);
            }
            catch (Exception exception) {
                throw new ProvisionError(this.getErrorString(string, iAccessor));
            }
            return string;
        }

        List getCurrentlyValidEnumValues(IAccessor iAccessor) {
            db.fine("getCurrentlyValidEnumValues(): edit on " + iAccessor.getFullName() + " : " + this.getClass().getName());
            return null;
        }

        String toString(IAccessor iAccessor) {
            return "IP Address";
        }
    }
}

