/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sDataLink;
import cerent.cms.idl.Ucp.sUcpInterface;
import cerent.cms.idl.Ucp.sUcpInterfaceRw;
import cerent.cms.idl.Ucp.xInterfaceInUse;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNoSuchUcpInterface;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceInUse;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchUcpInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.UcpInterfaces;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class UcpInterfaceModel
extends Model {
    private NodeModelDelegate node;
    private UcpInterfaces parent;
    private short neighborIndex;
    private int ccId;
    private sDataLink dataLink;
    private sUcpInterfaceRw rwAttributes;
    private int ifIdx;
    private Attributes attributes;
    private DeleteInterface deleteInterface;
    private InterfaceInfo interfaceInfo;
    private EventDispatcher dispatcher;

    public UcpInterfaceModel(NodeModelDelegate nodeModelDelegate, UcpInterfaces ucpInterfaces, sUcpInterface sUcpInterface2, SDebug sDebug) {
        super(nodeModelDelegate.getChildDebug(UcpInterfaceModel.class));
        this.node = nodeModelDelegate;
        this.parent = ucpInterfaces;
        this.index = sUcpInterface2.index;
        this.ifIdx = sUcpInterface2.index;
        this.neighborIndex = sUcpInterface2.neighborIndex;
        this.dataLink = sUcpInterface2.dataLink;
        this.ccId = sUcpInterface2.ccId;
        this.rwAttributes = sUcpInterface2.rwAttributes;
        this.attributes = new Attributes(nodeModelDelegate, "UcpInterfaces::attributes");
        this.deleteInterface = new DeleteInterface(nodeModelDelegate, "UcpInterfaces::deleteIf");
        this.interfaceInfo = new InterfaceInfo(nodeModelDelegate, "UcpInterface::interfaceInfo");
        this.dispatcher = null;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void setAttributes(sUcpInterfaceRw sUcpInterfaceRw2) throws NoSuchUcpInterface, InvalidParams {
        try {
            Object[] objectArray = new Object[]{new Integer(this.index), sUcpInterfaceRw2};
            this.attributes.set(objectArray);
            this.rwAttributes = sUcpInterfaceRw2;
        }
        catch (xNoSuchUcpInterface xNoSuchUcpInterface2) {
            throw new NoSuchUcpInterface(AnnotatedException.getString((Exception)((Object)xNoSuchUcpInterface2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            this.setChanged();
            this.updateLocal();
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getNeighborIndex() {
        return this.neighborIndex;
    }

    public int getCcId() {
        return this.ccId;
    }

    public int getIndex() {
        return this.index;
    }

    public sDataLink getDataLink() {
        return this.dataLink;
    }

    public sUcpInterfaceRw getUcpInterfaceRw() {
        return this.rwAttributes;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectUcpInterface, this.index, (Observer)this);
        }
    }

    public void delete() throws InterfaceInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(this.index)};
            this.deleteInterface.set(objectArray);
            if (this.parent != null && this.node != null) {
                this.parent.remove(this);
            }
            this.dispose();
        }
        catch (xInterfaceInUse xInterfaceInUse2) {
            throw new InterfaceInUse(AnnotatedException.getString((Exception)((Object)xInterfaceInUse2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void updateLocal() {
        sUcpInterface sUcpInterface2 = null;
        try {
            sUcpInterface2 = (sUcpInterface)this.interfaceInfo.get();
            this.neighborIndex = sUcpInterface2.neighborIndex;
            this.dataLink = sUcpInterface2.dataLink;
            this.ccId = sUcpInterface2.ccId;
            this.rwAttributes = sUcpInterface2.rwAttributes;
        }
        catch (xNoSuchUcpInterface xNoSuchUcpInterface2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchUcpInterface2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update(): DELETED");
                    }
                    if (this.parent != null && this.node != null) {
                        this.parent.remove(this);
                    }
                    this.dispose();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " update(): CHANGED");
                    }
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + " update(): STRUCTURE CHGD");
                    break;
                }
            }
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectUcpInterface, this.index, (Observer)this);
        }
        super.dispose();
    }

    protected void printString(SDebug sDebug) {
        sDebug.println("NeighborIdx: " + this.neighborIndex + " CCId: " + this.ccId + " IfIdx: " + this.ifIdx);
        sDebug.println("DataLink:: Index: " + this.dataLink.index + " LocalIfId: " + this.dataLink.localIfId + " RemoteIfId: " + this.dataLink.remoteIfId);
        sDebug.println("UcpInterfaceRw:: CoreNetworkId: " + this.rwAttributes.coreNetworkId);
        sDebug.print("UcpInterfaceRw:: CoerNetworkId: " + this.rwAttributes.coreNetworkId + " TnaAddr:: ");
        if (this.rwAttributes.tnaAddr.type.value() == 0) {
            sDebug.println("Type: IPV4 IpAddr: " + this.rwAttributes.tnaAddr.ipAddr.addr);
        } else if (this.rwAttributes.tnaAddr.type.value() == 1) {
            sDebug.println("Type: IPV6 IpAddr: " + this.rwAttributes.tnaAddr.ipAddr.addr);
        } else if (this.rwAttributes.tnaAddr.type.value() == 2) {
            sDebug.println("Type: NSAP NsapAddr: " + this.rwAttributes.tnaAddr.nsap.addr);
        } else {
            sDebug.println("Type: UNKNOWN");
        }
    }

    private class InterfaceInfo
    extends NonCachedValue {
        public InterfaceInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpInterfacesRef().get(UcpInterfaceModel.this.ifIdx);
        }

        public Object outer() {
            return UcpInterfaceModel.this;
        }
    }

    private class Attributes
    extends NonCachedValue {
        public Attributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpInterfacesRef().setAttributes((Integer)objectArray[0], (sUcpInterfaceRw)objectArray[1]);
        }

        public Object outer() {
            return UcpInterfaceModel.this;
        }
    }

    private class DeleteInterface
    extends NonCachedValue {
        public DeleteInterface(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpInterfacesRef().delete((Integer)objectArray[0]);
        }

        public Object outer() {
            return UcpInterfaceModel.this;
        }
    }
}

