/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.ui.DwdmSide;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public abstract class AbstractEntitySelectorAttr
extends JPanel
implements ActionListener {
    protected boolean loading = false;
    private static final String OPTICAL_CARD = "Optical Card";
    private static final String PASSIVE_CARD = "Passive Card";
    private static final String TYPE_LABEL = "Type: ";
    private static final String SIDE_LABEL = "Side: ";
    private static final String SHELF_LABEL = "Shelf: ";
    private static final String SLOT_LABEL = "Slot: ";
    private static final String UNIT_LABEL = "Unit: ";
    private static final String MPO_LABEL = "MPO: ";
    protected TypeSelectorAttr selectorCB;
    protected SelectorAttr sideCB;
    protected SelectorAttr shelfCB;
    protected EntitySelectorAttr slotCB;
    protected EntitySelectorAttr portCB;
    protected MPOSelectorAttr mpoCB;
    protected StringBuffer warningMessage = null;
    private INodeModel nm;
    private final DefaultListCellRenderer entityCR;
    private JPanel container;
    private IEntityModel notifiedPort = null;

    protected AbstractEntitySelectorAttr(INodeModel iNodeModel, String string, boolean bl, DefaultListCellRenderer defaultListCellRenderer) {
        this(iNodeModel, string, bl, defaultListCellRenderer, null);
    }

    protected AbstractEntitySelectorAttr(INodeModel iNodeModel, String string, boolean bl, DefaultListCellRenderer defaultListCellRenderer, GridBagConstraints gridBagConstraints) {
        this.nm = iNodeModel;
        this.entityCR = defaultListCellRenderer;
        this.setLayout(new GridBagLayout());
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
        if (!bl) {
            this.initUI(this, gridBagConstraints, false);
        } else {
            this.container = this;
        }
    }

    public AbstractEntitySelectorAttr(INodeModel iNodeModel, String string, DefaultListCellRenderer defaultListCellRenderer) {
        this(iNodeModel, string, false, defaultListCellRenderer, null);
    }

    protected void initUI() {
        this.initUI(this, null, true);
    }

    protected void initUI(JPanel jPanel, GridBagConstraints gridBagConstraints, boolean bl) {
        boolean bl2 = this.isPassiveCardSelected();
        JPanel jPanel2 = this.container = jPanel == null ? this : jPanel;
        if (bl) {
            this.container.removeAll();
        }
        if (gridBagConstraints == null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets.bottom = 15;
        }
        this.selectorCB = new TypeSelectorAttr(gridBagConstraints, this.isCardSelectorNeeded(), bl2);
        this.sideCB = new SelectorAttr(SIDE_LABEL, gridBagConstraints, this.isSideSelectorNeeded());
        this.shelfCB = new SelectorAttr(SHELF_LABEL, gridBagConstraints, !bl2 && this.isShelfSelectorNeeded());
        this.slotCB = new EntitySelectorAttr(bl2 ? UNIT_LABEL : SLOT_LABEL, gridBagConstraints, this.isSlotSelectorNeeded());
        this.portCB = new EntitySelectorAttr(this.getPortLabel() + ": ", gridBagConstraints, this.isPortSelectorNeeded());
        this.mpoCB = new MPOSelectorAttr(gridBagConstraints, this.isMPOSelectorNeeded());
        this.initOtherUIComponent(gridBagConstraints);
        this.setActionListeners(true);
        this.setAllEnabled(false);
    }

    protected void initOtherUIComponent(GridBagConstraints gridBagConstraints) {
    }

    protected void initRO(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        this.loading = true;
        boolean bl = AbstractEntitySelectorAttr.isPassivePort(iEntityModel);
        if (this.isCardSelectorNeeded()) {
            this.selectorCB.setCardSelected(bl);
        }
        if (!bl) {
            if (this.isSideSelectorNeeded()) {
                this.sideCB.loadModel(this.getSideLabel(iEntityModel));
            }
            if (this.isShelfSelectorNeeded()) {
                this.shelfCB.loadModel(new Integer(iEntityModel.getShelfId()));
            }
        } else {
            this.sideCB.setVisible(false);
            this.shelfCB.setVisible(false);
        }
        if (this.isSlotSelectorNeeded()) {
            this.slotCB.loadModel(iEntityModel.getModuleModel());
        }
        if (this.isMPOSelectorNeeded()) {
            this.mpoCB.loadModel(iEntityModel);
        } else if (this.isPortSelectorNeeded()) {
            this.portCB.loadModel(iEntityModel);
        }
        this.loading = false;
    }

    public boolean fullOfInfo() {
        boolean bl = true;
        if (this.isSlotSelectorNeeded()) {
            bl &= this.slotCB.getSize() == 1;
        }
        if (this.isPortSelectorNeeded()) {
            bl &= this.portCB.getSize() == 1;
        }
        if (this.isShelfSelectorNeeded()) {
            bl &= this.shelfCB.getSize() <= 1;
        }
        if (this.isCardSelectorNeeded()) {
            bl &= !this.selectorCB.isEnabled();
        }
        if (this.isSideSelectorNeeded()) {
            bl &= this.sideCB.getSize() <= 1;
        }
        return bl;
    }

    public String getPortLabel() {
        return "Port";
    }

    protected void clearAllModels() {
        boolean bl = this.loading;
        this.loading = true;
        this.notifiedPort = null;
        this.sideCB.clearModel();
        this.shelfCB.clearModel();
        this.slotCB.clearModel();
        this.portCB.clearModel();
        this.mpoCB.clearModel();
        this.loading = bl;
    }

    protected void setNodeModel(INodeModel iNodeModel) {
        this.nm = iNodeModel;
        this.shelfCB.setVisible(this.isMultishelf());
    }

    protected abstract boolean isCardSelectorNeeded();

    protected abstract boolean isSideSelectorNeeded();

    protected boolean isShelfSelectorNeeded() {
        return this.isMultishelf();
    }

    protected boolean isSlotSelectorNeeded() {
        return true;
    }

    protected abstract boolean isPortSelectorNeeded();

    protected abstract boolean isMPOSelectorNeeded();

    protected abstract void loadSelectedSide(String var1);

    protected abstract void loadSelectedShelf(Integer var1);

    protected abstract void loadSelectedCard(IModuleModel var1);

    protected abstract void updateCardModels(boolean var1);

    protected void notifyPortSelected(IEntityModel iEntityModel) {
    }

    protected void notifyMPOSelected(IEntityModel iEntityModel) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.loading) {
            return;
        }
        Object object = actionEvent.getSource();
        if (this.sideCB.getCB() == object) {
            this.loadSelectedSide((String)this.sideCB.getSelectedItem());
        } else if (this.shelfCB.getCB() == object) {
            this.loadSelectedShelf((Integer)this.shelfCB.getSelectedItem());
        } else if (this.slotCB.getCB() == object) {
            this.loadSelectedCard((IModuleModel)this.slotCB.getSelectedEntity());
        } else if (this.portCB.getCB() == object) {
            if (this.portCB.getSelectedEntity() != null && this.portCB.getSelectedEntity() != this.notifiedPort) {
                this.notifiedPort = this.portCB.getSelectedEntity();
                this.notifyPortSelected(this.notifiedPort);
            }
        } else if (this.mpoCB.getCB() == object) {
            this.notifyMPOSelected(this.mpoCB.getSelectedEntity());
        } else if (this.selectorCB.getCB() == object) {
            boolean bl = this.isPassiveCardSelected();
            this.sideCB.setVisible(this.isSideSelectorNeeded() && !bl);
            this.shelfCB.setVisible(this.isShelfSelectorNeeded() && !bl);
            this.slotCB.setLabel(bl ? UNIT_LABEL : SLOT_LABEL);
            this.updateCardModels(bl);
        }
    }

    private void setActionListeners(boolean bl) {
        this.portCB.setListener(bl);
        this.mpoCB.setListener(bl);
        this.slotCB.setListener(bl);
        this.shelfCB.setListener(bl);
        this.sideCB.setListener(bl);
        this.selectorCB.setListener(bl);
    }

    private void setAllEnabled(boolean bl) {
        this.portCB.setEnabled(bl);
        this.mpoCB.setEnabled(bl);
        this.slotCB.setEnabled(bl);
        this.shelfCB.setEnabled(bl);
        this.sideCB.setEnabled(bl);
        this.selectorCB.setEnabled(bl);
    }

    private boolean isMultishelf() {
        return this.nm != null && this.nm.provides(Feature.MULTISHELF) && this.nm.isMultishelf();
    }

    protected static boolean isPassivePort(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IOpticsPortModel) {
            return ((IOpticsPortModel)iEntityModel).isPassivePort();
        }
        return false;
    }

    private String getSideLabel(IEntityModel iEntityModel) {
        return DwdmSide.getSideLabelFromOffset(iEntityModel.getSide());
    }

    protected boolean isPassiveCardSelected() {
        return this.selectorCB != null && this.selectorCB.isPassiveCardSelected();
    }

    class MPOCellRenderer
    extends DefaultListCellRenderer {
        MPOCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object instanceof IOpticsPortModel) {
                string = ((IOpticsPortModel)object).getMPOString();
            } else if (object != null) {
                string = object.toString();
            }
            this.setText(string);
            return this;
        }
    }

    protected class MPOSelectorAttr
    extends EntitySelectorAttr {
        private MPOSelectorAttr(GridBagConstraints gridBagConstraints, boolean bl) {
            super(AbstractEntitySelectorAttr.MPO_LABEL, gridBagConstraints, new MPOCellRenderer(), bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntitySelectorAttr
    extends SelectorAttr {
        private EntitySelectorAttr(String string, GridBagConstraints gridBagConstraints, boolean bl) {
            super(string, gridBagConstraints, AbstractEntitySelectorAttr.this.entityCR, bl);
        }

        private EntitySelectorAttr(String string, GridBagConstraints gridBagConstraints, ListCellRenderer listCellRenderer, boolean bl) {
            super(string, gridBagConstraints, listCellRenderer, bl);
        }

        private EntitySelectorAttr(String string, GridBagConstraints gridBagConstraints) {
            this(string, gridBagConstraints, true);
        }

        public void setSelectedEntity(int n) {
            this.cb.setSelectedIndex(n);
        }

        public IEntityModel getSelectedEntity() {
            return (IEntityModel)this.cb.getSelectedItem();
        }

        public void setSelectedEntity(IEntityModel iEntityModel) {
            this.cb.setSelectedItem(iEntityModel);
        }

        protected void loadModel(LinkedList<IEntityModel> linkedList) {
            super.loadModel(linkedList.toArray(new IEntityModel[0]));
        }
    }

    protected class TypeSelectorAttr
    extends SelectorAttr {
        private TypeSelectorAttr(GridBagConstraints gridBagConstraints, boolean bl, boolean bl2) {
            super(AbstractEntitySelectorAttr.TYPE_LABEL, gridBagConstraints, bl);
            this.model.addElement(AbstractEntitySelectorAttr.OPTICAL_CARD);
            this.model.addElement(AbstractEntitySelectorAttr.PASSIVE_CARD);
            if (bl2) {
                this.model.setSelectedItem(AbstractEntitySelectorAttr.PASSIVE_CARD);
            }
        }

        private boolean isPassiveCardSelected() {
            Object object = this.cb.getSelectedItem();
            return object != null && object.equals(AbstractEntitySelectorAttr.PASSIVE_CARD);
        }

        private void setCardSelected(boolean bl) {
            this.model.setSelectedItem(bl ? AbstractEntitySelectorAttr.PASSIVE_CARD : AbstractEntitySelectorAttr.OPTICAL_CARD);
            this.setEnabled(false);
        }

        public void restoreSelection(boolean bl) {
            this.addItem(AbstractEntitySelectorAttr.OPTICAL_CARD);
            this.addItem(AbstractEntitySelectorAttr.PASSIVE_CARD);
            if (bl) {
                this.model.setSelectedItem(AbstractEntitySelectorAttr.PASSIVE_CARD);
            }
        }

        public void removeSelection(boolean bl) {
            this.model.removeElement(bl ? AbstractEntitySelectorAttr.PASSIVE_CARD : AbstractEntitySelectorAttr.OPTICAL_CARD);
            this.setEnabled(false);
        }
    }

    protected class SelectorAttr {
        protected DefaultComboBoxModel model;
        protected JLabel label;
        protected JComboBox cb;
        private int gridy;

        private SelectorAttr(String string, GridBagConstraints gridBagConstraints, ListCellRenderer listCellRenderer, boolean bl) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.label = new JLabel(string);
            AbstractEntitySelectorAttr.this.container.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.model = new DefaultComboBoxModel();
            this.cb = new JComboBox(this.model){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = 160;
                    return dimension;
                }
            };
            if (listCellRenderer != null) {
                this.cb.setRenderer(listCellRenderer);
            }
            AbstractEntitySelectorAttr.this.container.add((Component)this.cb, gridBagConstraints);
            this.setVisible(bl);
            this.gridy = gridBagConstraints.gridy;
        }

        private SelectorAttr(String string, GridBagConstraints gridBagConstraints, boolean bl) {
            this(string, gridBagConstraints, null, bl);
        }

        protected void setListener(boolean bl) {
            if (bl) {
                this.cb.addActionListener(AbstractEntitySelectorAttr.this);
            } else {
                this.cb.removeActionListener(AbstractEntitySelectorAttr.this);
            }
        }

        protected void setLabel(String string) {
            this.label.setText(string);
        }

        public void clearModel() {
            this.cb.setEnabled(false);
            this.model.removeAllElements();
        }

        public void loadModel(Object[] objectArray) {
            this.model.removeAllElements();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.model.addElement(objectArray[i]);
            }
            this.cb.setEnabled(objectArray.length > 1);
        }

        protected void loadModel(Object object) {
            this.clearModel();
            this.cb.addItem(object);
        }

        protected void addItem(Object object) {
            if (this.model.getIndexOf(object) == -1) {
                this.model.addElement(object);
            }
            this.cb.setEnabled(this.model.getSize() > 1);
        }

        public Object getItemAt(int n) {
            return this.model.getElementAt(n);
        }

        protected int getSize() {
            return this.model.getSize();
        }

        protected Object getSelectedItem() {
            return this.cb.getSelectedItem();
        }

        public void setSelectedItem(Object object) {
            this.cb.setSelectedItem(object);
        }

        protected boolean isEnabled() {
            return this.cb.isEnabled();
        }

        public void setEnabled(boolean bl) {
            this.cb.setEnabled(bl && this.model.getSize() > 1);
        }

        protected void setVisible(boolean bl) {
            this.label.setVisible(bl);
            this.cb.setVisible(bl);
        }

        public JComboBox getCB() {
            return this.cb;
        }

        public int gridy() {
            return this.gridy;
        }
    }
}

