/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCellRenderer
implements IEntityCellRenderer {
    private String prefix;
    private boolean iShowPortAlias = true;
    private boolean useDs1PortNums;
    private DefaultListCellRenderer dlcr;
    private DefaultTableCellRenderer dtcr;
    private static String BLSR_TERM;
    protected static SDebug db;

    public EntityCellRenderer() {
        this("", false);
    }

    public EntityCellRenderer(String string) {
        this(string, false);
    }

    public EntityCellRenderer(boolean bl) {
        this("", bl);
    }

    public EntityCellRenderer(String string, boolean bl) {
        this.prefix = string;
        this.useDs1PortNums = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (this.dlcr == null) {
            this.dlcr = new DefaultListCellRenderer();
        }
        this.dlcr.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof IEntityModel) {
            this.dlcr.setText(this.getString((IEntityModel)object, this.prefix));
        }
        return this.dlcr;
    }

    public String getTruncatedString(String string) {
        String string2;
        block3: {
            string2 = "";
            try {
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = stringBuilder.indexOf("shelf ");
                if (n >= 0) {
                    stringBuilder = stringBuilder.replace(n, "shelf ".length() + 1, "S");
                }
                n = stringBuilder.indexOf("slot ");
                stringBuilder = stringBuilder.replace(n + 1, n + "slot ".length(), "");
                n = stringBuilder.indexOf("port ");
                stringBuilder = stringBuilder.replace(n + 1, n + "port ".length(), "");
                string2 = stringBuilder.toString();
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string2;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.dtcr == null) {
            this.dtcr = new DefaultTableCellRenderer();
        }
        this.dtcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof IEntityModel) {
            this.dtcr.setText(this.getString((IEntityModel)object, this.prefix));
        }
        return this.dtcr;
    }

    public String getString(Object object, String string) {
        String string2 = "<invalid entity>";
        if (object != null && object instanceof IEntityModel) {
            IEntityModel iEntityModel = (IEntityModel)object;
            StringBuffer stringBuffer = new StringBuffer(32);
            try {
                switch (iEntityModel.getGenericClass()) {
                    case 6: {
                        if (iEntityModel instanceof IModuleModel) {
                            if (iEntityModel instanceof PassiveModuleModel) {
                                int n = ((PassiveModuleModel)iEntityModel).getID();
                                if (n == 0) {
                                    stringBuffer.append("<no unit>");
                                } else {
                                    if (string == "slot " || string == "shelf ") {
                                        stringBuffer.append("Unit ");
                                    }
                                    if (n >= 0 && n < 10) {
                                        stringBuffer.append(' ');
                                    }
                                    String string3 = ((PassiveModuleModel)iEntityModel).getIDString();
                                    stringBuffer.append(string3);
                                    stringBuffer.append(" (");
                                    stringBuffer.append(iEntityModel.getEqTypeName().replace("PASSIVE ", ""));
                                    stringBuffer.append(")");
                                }
                            } else {
                                int n;
                                int n2 = iEntityModel.getShelfId();
                                if (!iEntityModel.getNodeModel().isMultishelf()) {
                                    n2 = 0;
                                }
                                if ((n = iEntityModel.getSlot()) == 0) {
                                    stringBuffer.append("<no slot>");
                                } else {
                                    if (n2 > 0 && string == "shelf ") {
                                        stringBuffer.append("shelf ");
                                        if (n2 < 10) {
                                            stringBuffer.append(' ');
                                        }
                                        stringBuffer.append(n2);
                                        stringBuffer.append(", slot ");
                                    } else if (n2 == 0 || string == "slot ") {
                                        stringBuffer.append("slot ");
                                    }
                                    if (n >= 0 && n < 10) {
                                        stringBuffer.append(' ');
                                    }
                                    stringBuffer.append(n);
                                    stringBuffer.append(" (");
                                    stringBuffer.append(iEntityModel.getEqTypeName());
                                    stringBuffer.append(")");
                                }
                            }
                        } else if (iEntityModel instanceof PluggableModel) {
                            stringBuffer.append(PluggableHelper.getHierarchyNumString(((PluggableModel)iEntityModel).getHierarchyNums(), '-'));
                        }
                        string2 = stringBuffer.toString();
                        break;
                    }
                    case 7: {
                        stringBuffer.append(this.getString(iEntityModel.getModuleModel(), string));
                        stringBuffer.append(", ");
                        stringBuffer.append("port ");
                        stringBuffer.append(this.getPortString(iEntityModel, false));
                        stringBuffer.append(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.CommaSeparated));
                        string2 = stringBuffer.toString();
                        break;
                    }
                    default: {
                        string2 = iEntityModel.toString();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                db.finer("Exception in getString. " + exception);
                string2 = "Unknown";
            }
        }
        return string2;
    }

    public int getMediumType(IEntityModel iEntityModel) {
        int n;
        block8: {
            boolean bl = true;
            n = 1;
            switch (iEntityModel.getEqType()) {
                case 28: 
                case 29: 
                case 30: 
                case 61: {
                    try {
                        n = ((TdmLineModel)((TdmPortModel)iEntityModel).getInterfaceModel()).getMediumType();
                        bl = false;
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
            }
            if (bl) {
                try {
                    n = iEntityModel.getNodeModel().getTdmProtocolTypeObj().isSonet() ? 1 : 0;
                }
                catch (Exception exception) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return n;
    }

    public String getMediumTypeStr(TdmLineModel tdmLineModel) {
        return this.getMediumTypeStr(tdmLineModel.getMediumType());
    }

    public String getMediumTypeStr(IEntityModel iEntityModel) {
        return this.getMediumTypeStr(this.getMediumType(iEntityModel));
    }

    private String getMediumTypeStr(int n) {
        return n == 0 ? ElementDefaults.getPortMediumString(n) : "";
    }

    public static String getPayloadTypeStr(InterfaceModel interfaceModel) {
        String string;
        block4: {
            string = "";
            if (interfaceModel instanceof AbstractDwdmLineModel) {
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
                try {
                    ModuleModel moduleModel = abstractDwdmLineModel.getModuleModel();
                    int n = moduleModel.getEqType();
                    String string2 = ElementDefaults.getDataRatePortMapKey(n);
                    int n2 = abstractDwdmLineModel.getEqTypeFromDataRate().value();
                    if (db.isFineEnabled()) {
                        db.fine("Data rate port key is " + string2 + " for " + n + " " + n2 + " (" + abstractDwdmLineModel.getDataRate() + ")");
                    }
                    string = ElementDefaults.getAttributeMap(moduleModel).getAttributeForVal(string2, n2).getKey();
                }
                catch (Exception exception) {
                    if (!db.isSevereEnabled()) break block4;
                    db.severe("Caught exception in getPayloadTypeStr:" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    public static int mapPayloadType(int n) {
        return n == 8 ? 2 : AbstractDwdmLineModel.mapFramingType(n);
    }

    public String getTermMode(InterfaceModel interfaceModel) {
        String string;
        block2: {
            string = "";
            try {
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)abstractDwdmLineModel.getModuleModel();
                string = ElementDefaults.getAttributeMap(dwdmModuleModel).getAttributeForVal(dwdmModuleModel.supportSectionTermMode() ? "declTermModeFullSet" : "declTermModeTransparentSection", abstractDwdmLineModel.getTermMode()).getKey();
            }
            catch (Exception exception) {
                db.println("Caught exception in getTermMode");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public String getPortString(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        String string;
        block6: {
            string = null;
            if (iEntityModel != null) {
                try {
                    String string2;
                    if (iEntityModel instanceof IOpticsPortModel && !bl2) {
                        return ((IOpticsPortModel)iEntityModel).getOptPortTypeString();
                    }
                    StringBuffer stringBuffer = new StringBuffer(this.getFormattedPortNumberFor(iEntityModel, bl2));
                    if (iEntityModel instanceof IPortModel) {
                        stringBuffer.append(this.getFormattedPortAliasFor((IPortModel)iEntityModel));
                    }
                    if (bl && iEntityModel.getNodeModel().getTdmProtocolTypeObj().isSonet() && iEntityModel instanceof TdmPortModel && (string2 = this.getMediumTypeStr(iEntityModel)).length() > 0) {
                        stringBuffer.append(" (");
                        stringBuffer.append(string2);
                        stringBuffer.append(")");
                    }
                    string = stringBuffer.toString();
                }
                catch (Exception exception) {
                    db.info("Caught exception in getPortString");
                    if (!db.on()) break block6;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string == null ? "" : string;
    }

    public String getPortString(IEntityModel iEntityModel, boolean bl) {
        return this.getPortString(iEntityModel, bl, false);
    }

    public String getFullPortString(IEntityModel iEntityModel, boolean bl) {
        List<String> list = this.getFullPortStringPath(iEntityModel, false, bl);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size() - 1; ++i) {
            stringBuilder.append(list.get(i));
            stringBuilder.append(",");
        }
        stringBuilder.append(list.get(list.size() - 1));
        return stringBuilder.toString();
    }

    public List<String> getFullPortStringPath(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iEntityModel instanceof IOpticsPortModel && ((IOpticsPortModel)iEntityModel).isPassivePort()) {
            object = ((PassiveModuleModel)iEntityModel.getModuleModel()).getIDString();
            arrayList.add("Unit " + (String)object + " (" + iEntityModel.getModuleModel().getEqTypeName() + ")");
        } else {
            int n;
            if (bl && (n = iEntityModel.getSide()) != 0) {
                arrayList.add("Side " + DwdmSide.getSideFromOffset(n));
            }
            if (iEntityModel.getNodeModel().isMultishelf()) {
                arrayList.add("Shelf " + iEntityModel.getShelfId());
            }
            arrayList.add("Slot " + iEntityModel.getSlot() + " (" + iEntityModel.getModuleModel().getEqTypeName() + ")");
        }
        object = new EntityCellRenderer();
        arrayList.add("Port " + ((EntityCellRenderer)object).getPortString(iEntityModel, false, bl2));
        return arrayList;
    }

    public String getSonetLineProtectionDescription(TdmLineModel tdmLineModel, boolean bl) {
        String string;
        block20: {
            ElementModel elementModel;
            String string2;
            block18: {
                string = string2 = bl ? ", Unprotected" : ":Unprotected";
                elementModel = null;
                try {
                    elementModel = tdmLineModel.getElementModel();
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.on()) break block18;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
            if (elementModel != null) {
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                block19: {
                    string9 = "";
                    if (BLSR_TERM == null) {
                        try {
                            BLSR_TERM = Model.getTDMTerminology((IModel)tdmLineModel.getNodeModel()).getRingTerms(1);
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block19;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                String string10 = string8 = BLSR_TERM != null ? BLSR_TERM : "BLSR/MS-SPRing";
                if (bl) {
                    string7 = ": Active";
                    string6 = ": Standby";
                    string5 = ", One plus one";
                    string4 = ", " + string8 + " 2 fiber";
                    string3 = ", " + string8 + " 4 fiber";
                } else {
                    string7 = ":Act";
                    string6 = ":Sby";
                    string5 = ":1+1";
                    string4 = ":" + string8 + " 2F";
                    string3 = ":" + string8 + " 4F";
                }
                try {
                    int n = tdmLineModel.getAdminState();
                    if (n != -1) {
                        string9 = string6;
                        if (tdmLineModel.isCurrentlyActive()) {
                            string9 = string7;
                        }
                    }
                    switch (elementModel.getType()) {
                        case 1: {
                            string = string5 + string9;
                            break;
                        }
                        case 2: {
                            string = string4 + string9;
                            break;
                        }
                        case 3: {
                            string = string3 + string9;
                            break;
                        }
                        default: {
                            string = string2;
                            if (string9.equals(string6)) {
                                db.severe("Standby status on unprotected line " + tdmLineModel.getIndex() + " detected!");
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    db.info("TdmLineModel or elementModel.getType() threw an exception - accepting default");
                    if (!db.on()) break block20;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    public String getDwdmLineProtectionDescription(InterfaceModel interfaceModel, boolean bl) {
        ElementModel elementModel;
        String string;
        block20: {
            block19: {
                string = "";
                elementModel = null;
                try {
                    elementModel = interfaceModel.getElementModel();
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.on()) break block19;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
            if (!(elementModel != null && elementModel.getType() != 0 || interfaceModel instanceof AbstractDwdmLineModel)) {
                interfaceModel = interfaceModel.getHighestParent();
                try {
                    if (interfaceModel != null) {
                        elementModel = interfaceModel.getElementModel();
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.on()) break block20;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
        }
        if (elementModel != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            block21: {
                String string9;
                string8 = "";
                if (bl) {
                    string9 = ": Active";
                    string7 = ": Standby";
                    string6 = ", Y Cable";
                    string5 = ", Splitter";
                    string4 = ", Unprotected";
                    string3 = ", One plus one";
                    string2 = ", L2 One plus One";
                } else {
                    string9 = ":Act";
                    string7 = ":Sby";
                    string6 = ":Ycbl";
                    string5 = ":Spltr";
                    string4 = ":Unprot";
                    string3 = ":1+1";
                    string2 = ":L2 1+1";
                }
                try {
                    int n = interfaceModel.getAdminState();
                    if (n != 1 && n != -1) {
                        string8 = string7;
                        if (interfaceModel.isCurrentlyActive()) {
                            string8 = string9;
                        }
                    }
                }
                catch (Exception exception) {
                    db.info("Caught exception in getDwdmLineProtectionDescription");
                    if (!db.on()) break block21;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            switch (elementModel.getType()) {
                case 1: {
                    string = string3 + string8;
                    break;
                }
                case 4: {
                    string = string6 + string8;
                    break;
                }
                case 5: {
                    string = string5 + string8;
                    break;
                }
                case 6: {
                    string = string2 + string8;
                    break;
                }
                default: {
                    string = string4;
                    if (!string8.equals(string7)) break;
                    db.severe("Standby status on unprotected line " + interfaceModel.getIndex() + " detected!");
                }
            }
        }
        return string;
    }

    public void showPortAlias(boolean bl) {
        this.iShowPortAlias = bl;
    }

    public boolean isShowingPortAlias() {
        return this.iShowPortAlias;
    }

    protected String getFormattedPortAliasFor(IPortModel iPortModel) {
        return this.iShowPortAlias ? PortHelper.getFormattedPortAlias((IPortModel)iPortModel) : "";
    }

    protected String getFormattedPortNumberFor(IEntityModel iEntityModel, boolean bl) {
        return iEntityModel instanceof IPortModel ? PortHelper.getPortNumAndTypeString((IPortModel)((IPortModel)iEntityModel), (boolean)bl, (boolean)this.useDs1PortNums) : Integer.toString(iEntityModel.getPort());
    }

    static {
        db = new SDebug("EntityCellRenderer");
    }
}

