/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.HashSet;

public class OpticsProvExtHelper {
    private static final int ALL_LINE_REACH = 1;
    private static final int LINE_REACH = 2;
    private static final int ALL_LINE_WAVE = 3;
    private static final int LINE_WAVE = 4;

    private OpticsProvExtHelper() {
    }

    public static Attribute[][] getWavelengths(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        return OpticsProvExtHelper.getWavelengths(moduleModel, iOpticsProvExtModelArray, "declAllWavelength", 4, sDebug);
    }

    private static Attribute[][] getWavelengths(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, String string, int n, SDebug sDebug) {
        return OpticsProvExtHelper.getAllRowAttributes(moduleModel, iOpticsProvExtModelArray, string, n, sDebug);
    }

    public static Attribute[][] getAllWavelengths(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, String string, int n, SDebug sDebug) {
        return OpticsProvExtHelper.getAllRowAttributes(moduleModel, iOpticsProvExtModelArray, string, n, sDebug);
    }

    public static Attribute[][] getAllWavelengths(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        return OpticsProvExtHelper.getAllWavelengths(moduleModel, iOpticsProvExtModelArray, "declAllWavelength", 3, sDebug);
    }

    public static Attribute[][] getCombinedWavelengths(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        Attribute[][] attributeArray = null;
        Attribute[][] attributeArray2 = null;
        if (moduleModel.getEqType() == 251) {
            attributeArray = OpticsProvExtHelper.getAllWavelengths(moduleModel, iOpticsProvExtModelArray, "declDwdmCWl", 4, sDebug);
            attributeArray2 = OpticsProvExtHelper.getWavelengths(moduleModel, iOpticsProvExtModelArray, "declDwdmCWl", 4, sDebug);
        } else {
            attributeArray = OpticsProvExtHelper.getAllWavelengths(moduleModel, iOpticsProvExtModelArray, sDebug);
            attributeArray2 = OpticsProvExtHelper.getWavelengths(moduleModel, iOpticsProvExtModelArray, sDebug);
        }
        if (attributeArray != null && attributeArray2 != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                if (i >= attributeArray2.length) continue;
                OpticsProvExtHelper.markValidSelections(attributeArray[i], attributeArray2[i]);
            }
        }
        return attributeArray;
    }

    public static Attribute[][] getReaches(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        return OpticsProvExtHelper.getAllRowAttributes(moduleModel, iOpticsProvExtModelArray, "declDwdmReach", 2, sDebug);
    }

    public static Attribute[][] getAllReaches(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        return OpticsProvExtHelper.getAllRowAttributes(moduleModel, iOpticsProvExtModelArray, "declDwdmReach", 1, sDebug);
    }

    public static Attribute[][] getCombinedReaches(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        Attribute[][] attributeArray = OpticsProvExtHelper.getAllReaches(moduleModel, iOpticsProvExtModelArray, sDebug);
        Attribute[][] attributeArray2 = OpticsProvExtHelper.getReaches(moduleModel, iOpticsProvExtModelArray, sDebug);
        if (attributeArray != null && attributeArray2 != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                if (i >= attributeArray2.length) continue;
                OpticsProvExtHelper.markValidSelections(attributeArray[i], attributeArray2[i]);
            }
        }
        return attributeArray;
    }

    private static Attribute[] markValidSelections(Attribute[] attributeArray, Attribute[] attributeArray2) {
        int n;
        if (attributeArray2 == null) {
            return attributeArray;
        }
        HashSet<Attribute> hashSet = new HashSet<Attribute>(attributeArray2.length);
        for (n = 0; n < attributeArray2.length; ++n) {
            hashSet.add(attributeArray2[n]);
        }
        for (n = 0; n < attributeArray.length; ++n) {
            Attribute attribute = attributeArray[n];
            if (attribute == null || !hashSet.contains(attribute)) continue;
            attributeArray[n] = new Attribute(attribute.getKey() + " **", attribute.getValue());
        }
        return attributeArray;
    }

    private static Attribute[][] getAllRowAttributes(ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, String string, int n, SDebug sDebug) {
        int n2;
        ElAttributeMaps elAttributeMaps = ElementDefaults.getAttributeMap(moduleModel);
        int n3 = 0;
        Attribute[][] attributeArray = new Attribute[iOpticsProvExtModelArray.length][];
        for (n2 = 0; n2 < iOpticsProvExtModelArray.length; ++n2) {
            int n4;
            int[] nArray = new int[]{};
            try {
                switch (n) {
                    case 1: {
                        nArray = new int[]{0};
                        eReach[] eReachArray = iOpticsProvExtModelArray[n2].getAllLineReaches();
                        nArray = OpticsProvExtHelper.eReachToInt(eReachArray);
                        break;
                    }
                    case 2: {
                        eReach[] eReachArray = iOpticsProvExtModelArray[n2].getLineReaches();
                        nArray = OpticsProvExtHelper.eReachToInt(eReachArray);
                        if (nArray != null && nArray.length != 0) break;
                        nArray = new int[]{0};
                        break;
                    }
                    case 3: {
                        nArray = new int[]{174};
                        eWavelength[] eWavelengthArray = iOpticsProvExtModelArray[n2].getAllLineWavelengths();
                        if (sDebug.on()) {
                            sDebug.severe("The Length of the Array From CORBA: " + eWavelengthArray.length);
                        }
                        nArray = OpticsProvExtHelper.eWavelengthToInt(eWavelengthArray);
                        if (!sDebug.on()) break;
                        sDebug.severe("The Length of the Converted Array From CTC: " + nArray.length);
                        break;
                    }
                    case 4: {
                        eWavelength[] eWavelengthArray = iOpticsProvExtModelArray[n2].getLineWavelengths();
                        if (sDebug.on()) {
                            sDebug.severe("The Length of the Array From CORBA: " + eWavelengthArray.length);
                        }
                        nArray = OpticsProvExtHelper.eWavelengthToInt(eWavelengthArray);
                        if (!sDebug.on()) break;
                        sDebug.severe("The Length of the Converted Array From CTC: " + nArray.length);
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (sDebug.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                sDebug.severe("OpticsProvExtHelper: " + (Object)((Object)noSuchInterface));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (sDebug.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                sDebug.severe("OpticsProvExtHelper: " + (Object)((Object)wrongInterfaceType));
            }
            catch (UnsupportedOperation unsupportedOperation) {
                sDebug.severe("OpticsProvExtHelper: " + (Object)((Object)unsupportedOperation));
            }
            attributeArray[n2] = new Attribute[nArray.length];
            if (nArray.length <= 0) continue;
            ++n3;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if (!sDebug.on()) continue;
                sDebug.severe("The Value of eNums is : " + nArray[n4]);
            }
            for (n4 = 0; n4 < nArray.length; ++n4) {
                attributeArray[n2][n4] = elAttributeMaps.getAttributeForVal(string, nArray[n4]);
            }
        }
        if (sDebug.isSevereEnabled()) {
            if (n3 == iOpticsProvExtModelArray.length) {
                sDebug.severe("Not all rows found");
            }
            for (n2 = 0; n2 < attributeArray.length; ++n2) {
                if (attributeArray[n2].length == 0) {
                    sDebug.severe("Row " + n2 + " not found");
                    continue;
                }
                for (int i = 0; i < attributeArray[n2].length; ++i) {
                    sDebug.info("allRowAttributes [" + n2 + "][" + i + "] is " + attributeArray[n2][i].getKey());
                }
            }
        }
        return attributeArray;
    }

    public static int[] eReachToInt(eReach[] eReachArray) {
        int[] nArray = new int[eReachArray.length];
        for (int i = 0; i < eReachArray.length; ++i) {
            nArray[i] = eReachArray[i].value();
        }
        return nArray;
    }

    public static int[] eWavelengthToInt(eWavelength[] eWavelengthArray) {
        int[] nArray = new int[eWavelengthArray.length];
        for (int i = 0; i < eWavelengthArray.length; ++i) {
            nArray[i] = eWavelengthArray[i].value();
        }
        return nArray;
    }
}

