/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PathTraceTable;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ILineModelUpdater;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewHexDialog;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.PathTraceUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PathTraceMaintenancePane
extends AbstractShelfTablePane
implements ActionListener {
    private static final SDebug db = new SDebug("PathTraceMaintenancePane");
    private static final int PORT = 0;
    private static final int HOLO_NAME = 1;
    private static final int EXPECTED = 2;
    private static final int RECEIVED = 3;
    private static final int MODE = 4;
    private static final int C2 = 5;
    private static final int MEMNUM = 6;
    private static final String MemColName = "VCAT Member #";
    private ViewHexDialog viewHexDialog = null;
    private ILineModelUpdater updater;
    private int framingTypeToDisplay;
    private boolean memColPresent;
    private TableColumn membersCol;
    JButton refreshButton = new JButton("Retrieve");
    JButton viewHexButton = new JButton("View Hex");
    JLabel refreshLabel = new JLabel("");
    protected PathTraceTable pathTraceTable = null;

    protected void initButtonPanel() {
        this.viewHexButton.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(this.viewHexButton);
        jPanel2.add(this.refreshButton);
        jPanel3.add(this.refreshLabel);
        jPanel3.add(new CSHelpButton(CSHelpConst.PathTraceMaintenancePane));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.add(jPanel, "South");
    }

    private void refreshPathTrace() {
        this.refreshLabel.setText(this.getTimeStampString());
        this.repopulateTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refreshPathTrace();
        } else if (object == this.viewHexButton && this.table != null) {
            int n = this.table.getSelectedRow();
            if (n >= 0 && n < this.model.getRowCount()) {
                PathTraceInfo pathTraceInfo = (PathTraceInfo)this.model.getValueAt(n, 0);
                String string = "Port " + this.getStringValue(pathTraceInfo, 0, 1) + ", " + this.getHoLoString(pathTraceInfo);
                String string2 = this.getStringValue(pathTraceInfo, 2, 1);
                String string3 = this.getStringValue(pathTraceInfo, 3, 1);
                this.viewHexDialog = ViewHexDialog.instance(true, this, string);
                this.viewHexDialog.setExpectedReceived(string2, string3);
                this.viewHexDialog.show();
            } else if (db.on()) {
                db.println("clicked view hex but no selected row!");
            }
        }
    }

    public PathTraceMaintenancePane(String string, TabbedView tabbedView, ModuleModel moduleModel, InterfaceModel[] interfaceModelArray, ILineModelUpdater iLineModelUpdater) {
        super(string, tabbedView);
        int n = 0;
        if (moduleModel.getNodeModel().getTdmProtocolTypeObj().isSdh()) {
            n = 1;
        }
        this.basicInit(moduleModel, interfaceModelArray, iLineModelUpdater, n);
    }

    public PathTraceMaintenancePane(String string, TabbedView tabbedView, ModuleModel moduleModel, InterfaceModel[] interfaceModelArray, ILineModelUpdater iLineModelUpdater, int n) {
        super(string, tabbedView);
        this.basicInit(moduleModel, interfaceModelArray, iLineModelUpdater, n);
    }

    private void basicInit(ModuleModel moduleModel, InterfaceModel[] interfaceModelArray, ILineModelUpdater iLineModelUpdater, int n) {
        this.updater = iLineModelUpdater;
        this.framingTypeToDisplay = n;
        this.ENTRY_TYPE = "Path Trace";
        this.memColPresent = true;
        this.pathTraceTable = new PathTraceTable(moduleModel, interfaceModelArray, n);
        this.registerWithModel();
        if (db.on()) {
            db.println("<init> There are " + interfaceModelArray.length + " lineModels for path trace");
            db.println("lineModels = " + interfaceModelArray);
        }
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.initButtonPanel();
        this.refreshButton.addActionListener(this);
        this.viewHexButton.addActionListener(this);
        this.toggleMemCol(false);
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new PortColumnRenderer(), new HoLoColumnRenderer(), new ExpectedColumnRenderer(), new ReceivedColumnRenderer(), new ModeColumnRenderer(), new C2ColumnRenderer(), new MemberColumnRenderer()};
        PathTraceRowSource pathTraceRowSource = new PathTraceRowSource();
        this.model = new SortableRowTableModel((RowDataSource)pathTraceRowSource, columnRendererArray);
        this.registerWithModel();
    }

    protected void populateTableData() {
        block2: {
            try {
                this.tableData = this.pathTraceTable.getJ1PathTraceInfoList();
                this.toggleMemCol(this.pathTraceTable.containsVcatCkts());
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Caught Exception in populateTableData: " + exception);
            }
        }
    }

    private synchronized void toggleMemCol(boolean bl) {
        if (!this.memColPresent && bl) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            tableColumnModel.addColumn(this.membersCol);
            tableColumnModel.moveColumn(tableColumnModel.getColumnIndex(MemColName), 1);
            this.memColPresent = true;
        } else if (this.memColPresent && !bl) {
            this.membersCol = this.table.getColumn(MemColName);
            this.table.removeColumn(this.membersCol);
            this.memColPresent = false;
        }
    }

    protected String getStringValue(PathTraceInfo pathTraceInfo, int n, int n2) {
        String string = "???";
        if (pathTraceInfo != null) {
            switch (n) {
                case 0: {
                    string = PortHelper.getPortNumAndTypeString((IPortModel)pathTraceInfo.getPort(), (boolean)false, (boolean)false);
                    break;
                }
                case 2: {
                    string = PathTraceUtil.bytesToString(pathTraceInfo.getExpectedString(), n2);
                    break;
                }
                case 3: {
                    string = PathTraceUtil.bytesToString(pathTraceInfo.getReceivedString(), n2);
                    break;
                }
                case 4: {
                    string = PathTraceMaintenancePane.getPathTraceModeString(pathTraceInfo.getPathTraceMode());
                    break;
                }
                case 5: {
                    string = "0x" + String.valueOf(PathTraceUtil.hexFromByte(pathTraceInfo.getC2Byte()));
                    break;
                }
                case 1: {
                    string = this.getHoLoString(pathTraceInfo);
                    if (!pathTraceInfo.isBlsrSwitched()) break;
                    string = string + " (switched)";
                    break;
                }
                case 6: {
                    string = pathTraceInfo.getVcatMemberNum() == 0 ? "N/A" : String.valueOf(pathTraceInfo.getVcatMemberNum());
                }
            }
        }
        return string;
    }

    public static String getPathTraceModeString(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "Off";
                break;
            }
            case 1: {
                string = "Auto";
                break;
            }
            case 2: {
                string = "Manual";
                break;
            }
            case 3: {
                string = "Auto, No AIS";
                break;
            }
            case 4: {
                string = "Manual, NO AIS";
            }
        }
        return string;
    }

    public void destroy() {
        if (this.model != null) {
            ((SortableRowTableModel)((Object)this.model)).release();
        }
        super.destroy();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.viewHexButton.setEnabled(!listSelectionModel.isSelectionEmpty() && this.isUserAuthorized());
    }

    private String getHoLoColumnName() {
        IModel iModel = this.getUiModel();
        TDMTerminology tDMTerminology = iModel.getNodeModel().getTDMTerminology();
        if (iModel instanceof L2scModuleModel || iModel instanceof ML2ModuleModel || iModel instanceof FcmrModuleModel) {
            return "Circuit Type";
        }
        return tDMTerminology.getTdmHoTerm(this.framingTypeToDisplay);
    }

    private String getHoLoString(PathTraceInfo pathTraceInfo) {
        boolean bl;
        IModel iModel = this.getUiModel();
        INodeModel iNodeModel = iModel.getNodeModel();
        StringBuffer stringBuffer = new StringBuffer();
        if (pathTraceInfo.getCircuitTypeCategory() == 0) {
            TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
            stringBuffer.append(tDMTerminology.getTdmHoTerm(this.framingTypeToDisplay));
        } else {
            stringBuffer.append(iNodeModel.getTDMTerminology().getGeneralTerms(1));
        }
        int n = pathTraceInfo.getStartingNum();
        boolean bl2 = bl = iModel instanceof L2scModuleModel || iModel instanceof ML2ModuleModel || iModel instanceof FcmrModuleModel;
        if (!bl && n != -1) {
            stringBuffer.append(" #" + n);
        }
        return stringBuffer.toString();
    }

    protected void refreshMyLines(Object object) {
        ModuleModelUpdate moduleModelUpdate;
        if (object instanceof ModuleModelUpdate && this.updater.updateIsForMe(moduleModelUpdate = (ModuleModelUpdate)object)) {
            if (db.on()) {
                db.println("Calling refreshMyLines on PathTraceTable");
            }
            this.pathTraceTable.refreshMyLines((InterfaceModel[])moduleModelUpdate.getModels());
        }
    }

    class MemberColumnRenderer
    extends BaseColumnRenderer {
        MemberColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public String getName() {
            return PathTraceMaintenancePane.MemColName;
        }
    }

    class HoLoColumnRenderer
    extends BaseColumnRenderer {
        HoLoColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public String getName() {
            return PathTraceMaintenancePane.this.getHoLoColumnName();
        }
    }

    class C2ColumnRenderer
    extends BaseColumnRenderer {
        C2ColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "C2";
        }
    }

    class ModeColumnRenderer
    extends BaseColumnRenderer {
        ModeColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "Mode";
        }
    }

    class ReceivedColumnRenderer
    extends BaseColumnRenderer {
        ReceivedColumnRenderer() {
        }

        public String getName() {
            return "Received String";
        }
    }

    class ExpectedColumnRenderer
    extends BaseColumnRenderer {
        ExpectedColumnRenderer() {
        }

        public String getName() {
            return "Expected String";
        }
    }

    class PortColumnRenderer
    extends BaseColumnRenderer {
        PortColumnRenderer() {
        }

        public int getWidth() {
            return 30;
        }

        public String getName() {
            return "Port";
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 150;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            PathTraceInfo pathTraceInfo = (PathTraceInfo)jTable.getValueAt(n, 0);
            String string = PathTraceMaintenancePane.this.getStringValue(pathTraceInfo, n2, 0);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setForeground(Color.black);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = PathTraceMaintenancePane.this.getStringValue((PathTraceInfo)object, n, 0);
            String string2 = PathTraceMaintenancePane.this.getStringValue((PathTraceInfo)object2, n, 0);
            return string.compareTo(string2);
        }
    }

    class PathTraceRowSource
    extends AbstractRowDataSource {
        PathTraceRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = PathTraceMaintenancePane.this.tableData;
            synchronized (list) {
                var2_2 = PathTraceMaintenancePane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = PathTraceMaintenancePane.this.tableData;
            synchronized (list) {
                n = PathTraceMaintenancePane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = PathTraceMaintenancePane.this.tableData;
            synchronized (list) {
                return PathTraceMaintenancePane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return PathTraceInfo.class;
        }
    }
}

