/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class PmThresholdButtonPanel
extends JPanel {
    public static final String RESET_BUTTON_NAME = "Reset to Default";
    public static final String SHOW_BUTTON_NAME = "Show Thresholds";
    public JButton resetToDefaultButton;
    public JButton showButton;
    private static final SDebug db = new SDebug("PmThresholdButtonPanel");

    public void addResetToDefaultButton() {
        this.resetToDefaultButton = new JButton(RESET_BUTTON_NAME);
        this.resetToDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PmThresholdButtonPanel.this.resetToDefaultAction();
            }
        });
        this.add(this.resetToDefaultButton);
    }

    public void addShowButton() {
        this.showButton = new JButton(SHOW_BUTTON_NAME);
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PmThresholdButtonPanel.this.refreshAction();
            }
        });
        this.add(this.showButton);
    }

    public void resetToDefaultAction() {
        if (CerentDialog.yesNoDialog((Component)this, (String)"Do you really want to reset the thresholds to the default threshold values?", (String)"Reset to default")) {
            if (db.on()) {
                db.println("Current class: " + this.getClass());
            }
            this.resetWithDefaultPmThresholds();
            return;
        }
    }

    protected abstract int getUserRadioButtonChoiceMask();

    protected abstract GeneralPmThresholdsPane getPanel(int var1);

    protected abstract void displayPanel(int var1);

    protected void refreshAction() {
        int n = this.getUserRadioButtonChoiceMask();
        this.displayPanel(n);
    }

    protected void resetWithDefaultPmThresholds() {
        block2: {
            int n = this.getUserRadioButtonChoiceMask();
            GeneralPmThresholdsPane generalPmThresholdsPane = this.getPanel(n);
            try {
                generalPmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

