/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.ui.AbstractPane;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.TimePeriodPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SecurityPolicyPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private PropertyChangeListener parent;
    private TimePeriodPropertyEditor[] idleTimeouts;
    private SpinPropertyEditor lockoutThreshold;
    private TimePeriodPropertyEditor lockoutDuration;
    private SpinPropertyEditor passwordReuseThreshold;
    private JCheckBox singleSessionCB;
    private JCheckBox forcePasswordChangeCB;
    private JCheckBox passwordFlippingCB;
    private SpinPropertyEditor passwordFlippingDuration;
    private JCheckBox disableInactiveUserPolicyCB;
    private JCheckBox preventSuperUserDisablePolicyCB;
    private SpinPropertyEditor maxInactiveDuration;
    private JCheckBox passwordExprPolicyCB;
    private SpinPropertyEditor minChangedCharsInPwdEdit;
    private SpinPropertyEditor[] passwordExprPeriod;
    private SpinPropertyEditor[] passwordWarningPeriod;
    private JRadioButton manualUnlockRB;
    private JRadioButton autoUnlockRB;
    private JCheckBox passwordComplexityReverseUserIdAllowedCB;
    private JComboBox identicalConsecutiveCharactersAllowedCB;
    private JComboBox passowrdMinLengthCB;
    private JComboBox passowrdMaxLengthCB;
    private JComboBox passwordMinCharsRequiredCB;
    private JPanel passwordComplexityPanel;
    private boolean isDirty;
    private INodeModel nodeModel;
    private static final short ONE_EACH_OF_LETTER_NUM_TL1SPECIAL = 0;
    private static final short ONE_EACH_OF_LETTER_NUM_SPECIAL = 1;
    private static final short TWO_EACH_OF_TWO_OF_UPPER_LOWER_NUM_TL1SPECIAL = 2;
    private static final short TWO_EACH_OF_TWO_OF_UPPER_LOWER_NUM_SPECIAL = 3;
    private static final String[] security = EnumStrings.getStrings(SecurityLevel.class);

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            if (dimension != null) {
                jLabel.setPreferredSize(dimension);
            }
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        jPanel.add(new JLabel(string2));
        return jPanel;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private synchronized void notifyParent() {
        if (this.parent != null) {
            this.parent.propertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
    }

    private JPanel createPasswordAgingPanel() {
        JPanel jPanel = AbstractPane.createVerticalPanel("Password Aging");
        this.passwordExprPolicyCB = new JCheckBox("Enforce Password Aging");
        this.passwordExprPolicyCB.setAlignmentX(0.0f);
        this.passwordExprPolicyCB.addActionListener(this);
        jPanel.add(this.passwordExprPolicyCB);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel(""));
        jPanel2.add(new JLabel("Aging Period"));
        jPanel2.add(new JLabel("Warning Period"));
        this.passwordExprPeriod = new SpinPropertyEditor[security.length];
        this.passwordWarningPeriod = new SpinPropertyEditor[security.length];
        for (int i = 0; i < security.length; ++i) {
            jPanel2.add(new JLabel("     " + security[i] + ":"));
            this.passwordExprPeriod[i] = new SpinPropertyEditor("", 1, 20, 90);
            jPanel2.add(SecurityPolicyPanel.createAttributePanel(null, " Days", null, this.passwordExprPeriod[i]));
            this.passwordWarningPeriod[i] = new SpinPropertyEditor("", 1, 2, 20);
            jPanel2.add(SecurityPolicyPanel.createAttributePanel(null, " Days", null, this.passwordWarningPeriod[i]));
            this.passwordExprPeriod[i].addPropertyChangeListener(this);
            this.passwordWarningPeriod[i].addPropertyChangeListener(this);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createPasswordComplexityPanel() {
        Dimension dimension = new Dimension(250, 20);
        JPanel jPanel = SecurityPolicyPanel.createVerticalPanel("Password Complexity");
        this.passwordComplexityReverseUserIdAllowedCB = new JCheckBox("Reverse User ID Allowed");
        jPanel.add(SecurityPolicyPanel.createAttributePanel(null, null, null, this.passwordComplexityReverseUserIdAllowedCB));
        this.passwordComplexityReverseUserIdAllowedCB.addActionListener(this);
        Attribute[] attributeArray = new Attribute[]{new Attribute("3 or more", 3), new Attribute("0-2", 2)};
        this.identicalConsecutiveCharactersAllowedCB = new JComboBox<Attribute>(attributeArray);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Identical Consecutive Characters Allowed:", null, dimension, this.identicalConsecutiveCharactersAllowedCB));
        this.identicalConsecutiveCharactersAllowedCB.addActionListener(this);
        this.passowrdMinLengthCB = new JComboBox<String>(new String[]{"6", "8", "10", "12"});
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Minimum Length:", null, dimension, this.passowrdMinLengthCB));
        this.passowrdMinLengthCB.addActionListener(this);
        this.passowrdMaxLengthCB = new JComboBox<String>(new String[]{"20", "80"});
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Maximum Length:", null, dimension, this.passowrdMaxLengthCB));
        this.passowrdMaxLengthCB.addActionListener(this);
        Attribute[] attributeArray2 = new Attribute[]{this.getMinCharsRequiredAttribute((short)0), this.getMinCharsRequiredAttribute((short)1), this.getMinCharsRequiredAttribute((short)2), this.getMinCharsRequiredAttribute((short)3)};
        this.passwordMinCharsRequiredCB = new JComboBox<Attribute>(attributeArray2);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Minimum Required Characters:", null, dimension, this.passwordMinCharsRequiredCB));
        this.passwordMinCharsRequiredCB.addActionListener(this);
        return jPanel;
    }

    private Attribute getIdenticalConsecChars(short s) {
        switch (s) {
            case 2: {
                return new Attribute("0-2", 2);
            }
            case 3: {
                return new Attribute("3 or more", 3);
            }
        }
        return new Attribute("???", -1);
    }

    private Attribute getMinCharsRequiredAttribute(short s) {
        switch (s) {
            case 0: {
                return new Attribute("1 num, 1 letter & 1 TL1 special", 0);
            }
            case 1: {
                return new Attribute("1 num, 1 letter & 1 special", 1);
            }
            case 2: {
                return new Attribute("2 each of any 2 of num, upper, lower & TL1 special", 2);
            }
            case 3: {
                return new Attribute("2 each of any 2 of num, upper, lower & special", 3);
            }
        }
        return new Attribute("???", -1);
    }

    private static void putAttribute(TreeMap treeMap, int n, String string) {
        Integer n2 = new Integer(n);
        treeMap.put(n2, new Attribute(string, n2));
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public SecurityPolicyPanel(PropertyChangeListener propertyChangeListener) {
        this.parent = propertyChangeListener;
        this.setLayout(new GridLayout(3, 2));
        JPanel jPanel = AbstractPane.createVerticalPanel("Idle User Timeout");
        Dimension dimension = new Dimension(150, 20);
        this.idleTimeouts = new TimePeriodPropertyEditor[security.length];
        for (int i = 0; i < security.length; ++i) {
            this.idleTimeouts[i] = new TimePeriodPropertyEditor(security[i] + ":", dimension, TimePeriodPropertyEditor.DEFAULT_HIGH_ORDER, 60, 0, 59940);
            jPanel.add(this.idleTimeouts[i]);
            this.idleTimeouts[i].addPropertyChangeListener(this);
        }
        this.add(jPanel);
        jPanel = AbstractPane.createVerticalPanel("User Lockout");
        dimension = new Dimension(220, 20);
        this.lockoutThreshold = new SpinPropertyEditor("", 1, 0, 10);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Failed Logins Allowed Before Lockout:", " (Times)", dimension, this.lockoutThreshold));
        JPanel jPanel2 = AbstractPane.createVerticalPanel("Lockout Duration");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.manualUnlockRB = new JRadioButton("Manual Unlock by SUPERUSER");
        this.manualUnlockRB.addActionListener(this);
        this.autoUnlockRB = new JRadioButton("Automatic Unlock After");
        this.autoUnlockRB.addActionListener(this);
        dimension = new Dimension(40, 20);
        this.lockoutDuration = new TimePeriodPropertyEditor(" ", dimension, TimePeriodPropertyEditor.DEFAULT_HIGH_ORDER, 5, 0, 600);
        buttonGroup.add(this.manualUnlockRB);
        buttonGroup.add(this.autoUnlockRB);
        jPanel3.add(this.manualUnlockRB);
        jPanel3.add(new JLabel(""));
        jPanel3.add(this.autoUnlockRB);
        jPanel3.add(this.lockoutDuration);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        this.lockoutDuration.addPropertyChangeListener(this);
        this.lockoutThreshold.addPropertyChangeListener(this);
        this.add(jPanel);
        jPanel = AbstractPane.createVerticalPanel("Password Change");
        this.passwordReuseThreshold = new SpinPropertyEditor("", 1, 1, 10);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Prevent Reusing Last ", " Password(s)", null, this.passwordReuseThreshold));
        this.passwordReuseThreshold.addPropertyChangeListener(this);
        this.minChangedCharsInPwdEdit = new SpinPropertyEditor("", 1, 1, 5);
        jPanel2 = SecurityPolicyPanel.createAttributePanel("New Password must Differ from the Old Password by ", " Characters", null, this.minChangedCharsInPwdEdit);
        this.minChangedCharsInPwdEdit.addPropertyChangeListener(this);
        jPanel.add(jPanel2);
        this.passwordFlippingDuration = new SpinPropertyEditor("", 1, 20, 95);
        jPanel2 = SecurityPolicyPanel.createAttributePanel("Cannot Change New Password for ", " Days", null, this.passwordFlippingDuration);
        this.passwordFlippingCB = new JCheckBox("");
        jPanel2.add((Component)this.passwordFlippingCB, 0);
        this.passwordFlippingCB.addActionListener(this);
        this.passwordFlippingDuration.addPropertyChangeListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.forcePasswordChangeCB = new JCheckBox("Require Password Change on First Login to New Account");
        jPanel2.add(this.forcePasswordChangeCB);
        this.forcePasswordChangeCB.addActionListener(this);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.add(this.createPasswordAgingPanel());
        this.passwordComplexityPanel = this.createPasswordComplexityPanel();
        this.add(this.passwordComplexityPanel);
        jPanel = AbstractPane.createVerticalPanel("Other");
        this.singleSessionCB = new JCheckBox("Single Session per User");
        jPanel.add(this.singleSessionCB);
        this.singleSessionCB.setAlignmentX(0.0f);
        this.singleSessionCB.addActionListener(this);
        this.preventSuperUserDisablePolicyCB = new JCheckBox("Prevent Super User Disable");
        jPanel.add(this.preventSuperUserDisablePolicyCB);
        this.preventSuperUserDisablePolicyCB.setAlignmentX(0.0f);
        this.preventSuperUserDisablePolicyCB.addActionListener(this);
        this.disableInactiveUserPolicyCB = new JCheckBox("Disable Inactive User");
        jPanel.add(this.disableInactiveUserPolicyCB);
        this.disableInactiveUserPolicyCB.setAlignmentX(0.0f);
        this.disableInactiveUserPolicyCB.addActionListener(this);
        this.maxInactiveDuration = new SpinPropertyEditor("", 1, 1, 99);
        JPanel jPanel4 = SecurityPolicyPanel.createAttributePanel("    Inactive Duration: ", " Days", null, this.maxInactiveDuration);
        jPanel4.setAlignmentX(0.0f);
        this.maxInactiveDuration.addPropertyChangeListener(this);
        jPanel.add(jPanel4);
        this.add(jPanel);
        this.isDirty = false;
    }

    public void setSecurityPolicy(ISecurityPolicy iSecurityPolicy) {
        for (int i = 0; i < security.length; ++i) {
            this.idleTimeouts[i].setValue(iSecurityPolicy.getIdleTimeout(i) * 60);
            this.passwordExprPeriod[i].setValue(Integer.toString(iSecurityPolicy.getPasswordExprPeriod(i)));
            this.passwordWarningPeriod[i].setValue(Integer.toString(iSecurityPolicy.getPasswordExprWarningPeriod(i)));
        }
        this.lockoutThreshold.setValue(Integer.toString(iSecurityPolicy.getLockoutThreshold()));
        this.lockoutDuration.setValue(iSecurityPolicy.getLockoutDuration());
        if (iSecurityPolicy.isManualUnlock()) {
            this.manualUnlockRB.setSelected(true);
        } else {
            this.autoUnlockRB.setSelected(true);
        }
        this.passwordReuseThreshold.setValue(Integer.toString(iSecurityPolicy.getPasswordReuseThreshold()));
        this.singleSessionCB.setSelected(iSecurityPolicy.isSingleSessionPerUser());
        this.forcePasswordChangeCB.setSelected(iSecurityPolicy.getForcePasswordChange());
        this.passwordFlippingDuration.setValue(Integer.toString(iSecurityPolicy.getPasswordFlippingPolicyThreshold()));
        this.passwordFlippingCB.setSelected(iSecurityPolicy.getPasswordFlippingPolicyEnabled());
        this.disableInactiveUserPolicyCB.setSelected(iSecurityPolicy.getDisableInactiveUserPolicyEnabled());
        if (this.nodeModel.provides(Feature.SEC_PREVENT_SUPER_USER_DISABLE)) {
            this.preventSuperUserDisablePolicyCB.setSelected(iSecurityPolicy.getPreventSuperUserDisabledPolicy());
        }
        this.maxInactiveDuration.setValue(Integer.toString(iSecurityPolicy.getMaxInactiveDaysBeforeDisable()));
        this.passwordExprPolicyCB.setSelected(iSecurityPolicy.isPasswordExprPolicyEnabled());
        this.minChangedCharsInPwdEdit.setValue(Integer.toString(iSecurityPolicy.getMinChangedCharsInPwd() > 0 ? iSecurityPolicy.getMinChangedCharsInPwd() : (short)1));
        if (this.nodeModel.provides(Feature.PASSWORD_COMPLEXITY)) {
            this.passwordComplexityReverseUserIdAllowedCB.setSelected(iSecurityPolicy.getReverseUserIdAllowed());
            this.passowrdMinLengthCB.setSelectedItem(String.valueOf(iSecurityPolicy.getMinimumLength()));
            this.passowrdMaxLengthCB.setSelectedItem(String.valueOf(iSecurityPolicy.getMaximumLength()));
            this.identicalConsecutiveCharactersAllowedCB.setSelectedItem(this.getIdenticalConsecChars(iSecurityPolicy.getIdenticalConsecutiveCharactersAllowed()));
            this.passwordMinCharsRequiredCB.setSelectedItem(this.getMinCharsRequiredAttribute((short)iSecurityPolicy.getMinimumRequiredCharacters()));
        } else {
            this.passwordComplexityPanel.setVisible(false);
        }
        this.updateControls();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.nodeModel.provides(Feature.PASSWORD_COMPLEXITY)) {
            int n;
            int n2;
            short s = this.nodeModel.getSecurityModel().getSecurityPolicy().getMinimumLength();
            if (object == this.passowrdMinLengthCB) {
                short s2 = Short.parseShort((String)this.passowrdMinLengthCB.getSelectedItem());
                if (s2 != s && s2 > 10) {
                    this.passowrdMinLengthCB.hidePopup();
                    if (!CerentDialog.yesNoWarningDialog((Component)this, (String)"Passwords exceeding 10 characters do not conform to TL1 standards.\nAs a result, the new user may not be able to log in from TL1.\nDo you want to continue?", (String)"Password Complexity Invalid for TL1")) {
                        this.passowrdMinLengthCB.setSelectedItem(String.valueOf(s));
                    }
                }
            } else if (object == this.passwordMinCharsRequiredCB && (n2 = this.nodeModel.getSecurityModel().getSecurityPolicy().getMinimumRequiredCharacters()) != (n = ((Attribute)this.passwordMinCharsRequiredCB.getSelectedItem()).getIntValue()) && (n == 1 || n == 3)) {
                this.passwordMinCharsRequiredCB.hidePopup();
                if (!CerentDialog.yesNoWarningDialog((Component)this, (String)"This 'Minimum Required Characters'option might allow\nthe user to create a password with non-TL1 special characters.\nAs a result, the new user may not be able to log in from TL1\nDo you want to continue?", (String)"Password Complexity Invalid for TL1")) {
                    this.passwordMinCharsRequiredCB.setSelectedItem(this.getMinCharsRequiredAttribute((short)n2));
                }
            }
        }
        if (object == this.autoUnlockRB || object == this.manualUnlockRB || object == this.passwordFlippingCB || object == this.disableInactiveUserPolicyCB || object == this.passwordExprPolicyCB) {
            this.updateControls();
        }
        this.notifyParent();
        this.isDirty = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyParent();
        this.isDirty = true;
    }

    public boolean isMinChangedCharsInPwdDirty() {
        return this.minChangedCharsInPwdEdit.isDirty();
    }

    public ISecurityPolicy getSecurityPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        for (int i = 0; i < this.idleTimeouts.length; ++i) {
            securityPolicy.setIdleTimeout(i, TimePeriodPropertyEditor.toIntValue((String)this.idleTimeouts[i].getValue()) / 60);
            securityPolicy.setPasswordExprPolicy(i, this.getIntValue((String)this.passwordExprPeriod[i].getValue()), this.getIntValue((String)this.passwordWarningPeriod[i].getValue()));
        }
        securityPolicy.setLockoutThreshold(this.getIntValue((String)this.lockoutThreshold.getValue()));
        securityPolicy.setManualUnlock(this.manualUnlockRB.isSelected());
        securityPolicy.setLockoutDuration(TimePeriodPropertyEditor.toIntValue((String)this.lockoutDuration.getValue()));
        securityPolicy.setPasswordReuseThreshold(this.getIntValue((String)this.passwordReuseThreshold.getValue()));
        securityPolicy.setSingleSessionPerUser(this.singleSessionCB.isSelected());
        securityPolicy.setForcePasswordChange(this.forcePasswordChangeCB.isSelected());
        securityPolicy.setPasswordFlippingPolicyEnabled(this.passwordFlippingCB.isSelected());
        securityPolicy.setPasswordFlippingPolicyThreshold(this.getIntValue((String)this.passwordFlippingDuration.getValue()));
        securityPolicy.setDisableInactiveUserPolicyEnabled(this.disableInactiveUserPolicyCB.isSelected());
        securityPolicy.setMaxInactiveDaysBeforeDisable(this.getIntValue((String)this.maxInactiveDuration.getValue()));
        securityPolicy.setPasswordExprPolicyEnabled(this.passwordExprPolicyCB.isSelected());
        securityPolicy.setPreventSuperUserDisabledPolicy(this.preventSuperUserDisablePolicyCB.isSelected());
        securityPolicy.setMinChangedCharsInPwd((short)this.getIntValue((String)this.minChangedCharsInPwdEdit.getValue()));
        if (this.nodeModel.provides(Feature.PASSWORD_COMPLEXITY) && this.passwordComplexityPanel.isVisible()) {
            securityPolicy.setReverseUserIdAllowed(this.passwordComplexityReverseUserIdAllowedCB.isSelected());
            securityPolicy.setMinimumLength(Short.parseShort((String)this.passowrdMinLengthCB.getSelectedItem()));
            securityPolicy.setMaximumLength(Short.parseShort((String)this.passowrdMaxLengthCB.getSelectedItem()));
            securityPolicy.setIdenticalConsecutiveCharactersAllowed((short)((Attribute)this.identicalConsecutiveCharactersAllowedCB.getSelectedItem()).getIntValue());
            securityPolicy.setMinimumRequiredCharacters(((Attribute)this.passwordMinCharsRequiredCB.getSelectedItem()).getIntValue());
        }
        return securityPolicy;
    }

    private int getIntValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            SDebug.printStackTrace((Throwable)numberFormatException);
            return 0;
        }
    }

    private void updateControls() {
        this.lockoutDuration.setEnabled(this.autoUnlockRB.isSelected());
        this.passwordFlippingDuration.setEnabled(this.passwordFlippingCB.isSelected());
        this.maxInactiveDuration.setEnabled(this.disableInactiveUserPolicyCB.isSelected());
        boolean bl = this.passwordExprPolicyCB.isSelected();
        for (int i = 0; i < security.length; ++i) {
            this.passwordExprPeriod[i].setEnabled(bl);
            this.passwordWarningPeriod[i].setEnabled(bl);
        }
    }
}

