/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CircuitNameException;
import cerent.cms.ui.WizardDriver;
import cerent.cms.ui.WizardPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class WizardDialog
extends JDialog
implements ActionListener {
    public static final int MARGIN = 5;
    public static final String BACK = "<Back";
    public static final String NEXT = "Next>";
    public static final String FINISH = "Finish";
    public static final String CANCEL = "Cancel";
    public static final String HELP = "Help";
    protected static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String POINTER = "/images/icons/start16.gif";
    private static final String CHECKED = "/images/icons/file16_checked.gif";
    private static final String UNCHECKED = "/images/icons/file16.gif";
    private static final String ERRORED = "/images/icons/file16_error.gif";
    private static final Font NORMAL_FONT = new JLabel().getFont();
    private static final Font BOLD_FONT = NORMAL_FONT.deriveFont(1);
    public static final ImageIcon CHECKED_ICON = new ImageIcon(WizardDialog.class.getResource("/images/icons/file16_checked.gif"));
    public static final ImageIcon UNCHECKED_ICON = new ImageIcon(WizardDialog.class.getResource("/images/icons/file16.gif"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WizardDialog.class.getResource("/images/icons/file16_error.gif"));
    private JPanel wizardPanel;
    private JLabel cardLabel;
    private JPanel cards;
    private CardLayout cardLayout;
    private JPanel buttons;
    private WizardPane first;
    private WizardPane last;
    private WizardPane current;
    private StatusPanel statusPanel;
    private JPanel leftpanel;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private CSHelpButton helpButton;
    private int pageCount;
    private WizardDriver driver;
    protected boolean alwaysEnableBack = false;
    private boolean enableCSH = false;
    private static String IMAGE = "image";
    private static String TEXT = "text";
    private static final SDebug db = new SDebug("WizardDialog");

    protected WizardDialog(Frame frame, String string) {
        this(frame, string, true, false);
    }

    protected WizardDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, false);
    }

    protected WizardDialog(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, string, bl);
        this.enableCSH = bl2;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (db.on) {
                    db.println("windowClosing: calling handleCancel()");
                }
                WizardDialog.this.cancel(true);
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (db.on) {
                    db.println("windowClosed: recycling dialog");
                }
            }
        });
        this.setLocationRelativeTo(frame);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)this.getCardLabel(), "North");
        this.cardLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlDkShadow));
        jPanel.add((Component)this.getCardPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.wizardPanel = jPanel;
        this.getContentPane().add(jPanel);
    }

    public void setCursor(Cursor cursor) {
        this.wizardPanel.setCursor(cursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backButton) {
            this.back();
        } else if (object == this.nextButton) {
            this.next();
        } else if (object == this.finishButton) {
            this.finish();
        } else if (object == this.cancelButton) {
            this.cancel(true);
        } else if (object == this.helpButton) {
            this.helpButton.launchHelp(this.current.getHelpID());
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public final void setNextEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
        if (bl) {
            this.nextButton.requestFocus();
        }
    }

    public final void setCancelEnabled(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public final void setBackEnabled(boolean bl) {
        this.backButton.setEnabled(bl);
    }

    public final void setFinishEnabled(boolean bl) {
        this.finishButton.setEnabled(bl);
        if (bl) {
            this.finishButton.requestFocus();
        }
    }

    public void back() {
        this.setFinishEnabled(false);
        this.handleBack(this.current.getName());
        this.clearStatusText(this.current);
        --this.pageCount;
    }

    protected void handleBack(String string) {
        this.cardLayout.previous(this.cards);
        this.updateWizard();
    }

    public void pressNext() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        }
    }

    public void next() {
        String string = "";
        try {
            if (WizardDialog.db.on) {
                db.println("next: validating page " + this.current.getName());
            }
            this.setNextEnabled(false);
            string = this.current.getName();
            this.current.validatePage();
            WizardPane wizardPane = this.current;
            this.setFinishEnabled(false);
            this.handleNext(this.current.getName());
            this.setStatusText(wizardPane);
            ++this.pageCount;
            if (WizardDialog.db.on) {
                db.println("next: refreshing page " + this.current.getName());
            }
            this.current.refresh();
        }
        catch (Exception exception) {
            if (this.driver != null) {
                this.driver.stop(exception);
            } else {
                SDebug.printStackTrace((Throwable)exception);
                String string2 = exception.getMessage();
                if (null == string2) {
                    string2 = "Unable to proceed.  A validation failure was encountered.";
                }
                if (!(exception instanceof CircuitNameException)) {
                    ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1, (Object)string2);
                }
            }
            this.setNextEnabled(true);
        }
    }

    protected void handleNext(String string) throws Exception {
        this.cardLayout.next(this.cards);
        this.updateWizard();
    }

    public void finish() {
        block6: {
            try {
                if (WizardDialog.db.on) {
                    db.println("finish: validating page " + this.current.getName());
                }
                this.current.validatePage();
                this.apply();
                this.handleFinish();
            }
            catch (Exception exception) {
                char c;
                if (this.driver != null) {
                    this.driver.stop(exception);
                }
                if (this.handleFinishException(exception)) break block6;
                SDebug.printStackTrace((Throwable)exception);
                String string = exception.getMessage();
                if (string == null) {
                    string = "Unable to finish.\nA validation failure was encountered.\n" + exception.toString();
                }
                if (Character.isLetterOrDigit(c = string.charAt(string.length() - 1))) {
                    string = string + ".";
                }
                ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1, (Object)string);
            }
        }
    }

    public boolean handleFinishException(Exception exception) {
        return false;
    }

    protected abstract void apply() throws Exception;

    protected void handleFinish() {
        this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
        this.dispose();
    }

    protected String getCancelMessage() {
        return "Really cancel " + this.getTitle() + "?";
    }

    public void cancel(boolean bl) {
        if (!bl || this.cards.getComponentCount() == 1 || CerentDialog.yesNoDialog((Component)this, (String)this.getCancelMessage(), (String)"Confirm Cancel")) {
            this.handleCancel();
            this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
            this.dispose();
        }
    }

    protected void handleCancel() {
        this.current.handleCancel();
    }

    private void doRefresh(WizardPane wizardPane) {
        try {
            wizardPane.refresh();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
    }

    protected void addPage(WizardPane wizardPane) {
        if (WizardDialog.db.on) {
            db.println("adding page " + wizardPane.getName());
        }
        if (wizardPane == null) {
            return;
        }
        this.cards.add((Component)((Object)wizardPane), wizardPane.getName());
        this.updateWizard();
        if (this.first == null) {
            this.first = this.current;
            if (WizardDialog.db.on) {
                db.println("addPage: refreshing first page " + this.current.getName());
            }
            this.doRefresh(this.current);
            ++this.pageCount;
        }
        this.last = wizardPane;
    }

    protected void removePage(WizardPane wizardPane) {
        if (WizardDialog.db.on) {
            db.println("removing page " + wizardPane.getName());
        }
        if (wizardPane == null) {
            return;
        }
        this.cards.remove((Component)((Object)wizardPane));
    }

    public void showPage(String string, boolean bl) {
        this.cardLayout.show(this.cards, string);
        this.updateWizard();
        if (bl && this.current != null) {
            this.doRefresh(this.current);
        }
    }

    public final String getPageName() {
        if (this.current != null) {
            return this.current.getName();
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateWizard() {
        WizardPane wizardPane = this.current;
        Object object = this.cards.getTreeLock();
        synchronized (object) {
            int n = this.cards.getComponentCount();
            if (!this.alwaysEnableBack) {
                this.backButton.setEnabled(n > 1 && !this.cards.getComponent(0).isVisible());
            }
            this.nextButton.setEnabled(n > 1 && !this.cards.getComponent(n - 1).isVisible());
            for (int i = 0; i < n; ++i) {
                Component component = this.cards.getComponent(i);
                if (!component.isVisible()) continue;
                this.current = (WizardPane)((Object)component);
                break;
            }
            if (this.enableCSH) {
                if (this.current.getHelpID() == null) {
                    this.helpButton.setEnabled(false);
                } else {
                    this.helpButton.setEnabled(true);
                }
            }
        }
        if (wizardPane != this.current) {
            if (wizardPane != null) {
                if (WizardDialog.db.on) {
                    db.println("leaving page " + wizardPane.getName());
                }
                try {
                    wizardPane.leavingPage();
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)this, (EID)CEMC.EID_NAV_LEAVE_PAGE_ERROR_PARAM_1, (Object)this.current.getName());
                }
                if (this.statusPanel != null) {
                    this.statusPanel.setCurrent(wizardPane, false);
                }
            }
            if (this.current != null) {
                if (WizardDialog.db.on) {
                    db.println("entering page " + this.current.getName());
                }
                this.cardLabel.setText(this.getPageName(this.current));
                try {
                    this.current.enteringPage();
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)this, (EID)CEMC.EID_NAV_ENTER_PAGE_ERROR_PARAM_1, (Object)this.current.getName());
                }
                if (this.statusPanel != null) {
                    this.statusPanel.setCurrent(this.current, true);
                }
            }
        }
    }

    public void setStatus(WizardPane wizardPane, Icon icon, String string) {
        if (this.statusPanel != null) {
            this.statusPanel.setStatus(wizardPane, icon, string);
        }
    }

    protected int getPageCount() {
        return this.pageCount;
    }

    public String getResultString(Exception exception) {
        return exception != null ? "Failed" : "Completed";
    }

    protected void setDriver(WizardDriver wizardDriver) {
        this.driver = wizardDriver;
    }

    protected WizardDriver getDriver() {
        return this.driver;
    }

    protected void reset() {
        this.pageCount = 0;
        if (this.first != null) {
            this.showPage(this.first.getName(), true);
            ++this.pageCount;
        }
    }

    protected String getPageName(WizardPane wizardPane) {
        if (wizardPane != null) {
            return wizardPane.getName();
        }
        return "Unknown";
    }

    private JPanel getCardPanel() {
        this.cards = new JPanel();
        this.cardLayout = new CardLayout();
        this.cards.setLayout(this.cardLayout);
        return this.cards;
    }

    private JLabel getCardLabel() {
        this.cardLabel = new JLabel();
        return this.cardLabel;
    }

    private JPanel getButtonPanel() {
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 0));
        this.buttons.add(Box.createHorizontalGlue());
        this.backButton = this.makeActionButton(BACK);
        this.buttons.add(this.backButton);
        this.nextButton = this.makeActionButton(NEXT);
        this.buttons.add(this.nextButton);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.buttons.add(Box.createHorizontalStrut(5));
        this.finishButton = this.makeActionButton(FINISH);
        this.buttons.add(this.finishButton);
        this.setFinishEnabled(false);
        this.buttons.add(Box.createHorizontalStrut(5));
        this.cancelButton = this.makeActionButton(CANCEL);
        this.buttons.add(this.cancelButton);
        if (this.enableCSH) {
            this.buttons.add(Box.createHorizontalStrut(5));
            this.helpButton = new CSHelpButton();
            this.helpButton.addActionListener(this);
            this.buttons.add(this.helpButton);
        }
        return this.buttons;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected List getWizardPanes() {
        LinkedList<Component> linkedList = new LinkedList<Component>();
        int n = this.cards.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.cards.getComponent(i);
            if (!(component instanceof WizardPane)) continue;
            linkedList.add(component);
        }
        return linkedList;
    }

    protected WizardPane getCurrent() {
        return this.current;
    }

    protected synchronized void addStatusPanel(StatusPanel statusPanel) {
        if (this.statusPanel == null) {
            this.statusPanel = statusPanel;
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.fillVertical();
            gridBagPanel.add(this.statusPanel, 0, 0, 1, 1);
            gridBagPanel.fillBoth();
            gridBagPanel.add(this.wizardPanel, 1, 0, 2, 1);
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.removeAll();
            jPanel.add(gridBagPanel);
        }
    }

    public void addToStatusPanel(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.leftpanel.add(jComponent);
    }

    public void removeFromStatusPanel(JComponent jComponent) {
        this.leftpanel.remove(jComponent);
    }

    protected StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    protected void setStatusText(WizardPane wizardPane) {
        if (this.statusPanel != null && wizardPane != null) {
            this.statusPanel.setText((Object)wizardPane, wizardPane.getStatusText());
        }
    }

    protected void clearStatusText(WizardPane wizardPane) {
        if (this.statusPanel != null) {
            this.statusPanel.clearText((Object)wizardPane);
        }
    }

    public void dispose() {
        this.last = null;
        this.first = null;
        this.current = null;
        if (this.statusPanel != null) {
            this.statusPanel.dispose();
            this.statusPanel = null;
        }
        this.cards.removeAll();
        super.dispose();
    }

    protected class StatusPanel
    extends JPanel {
        private CardLayout cardLayout;
        private Document textDoc;
        private Map chunks;
        private Map pointers;
        private Map labels;

        public StatusPanel(String string, Dimension dimension) {
            this.chunks = new HashMap();
            this.cardLayout = new CardLayout();
            this.setLayout(this.cardLayout);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(string));
            this.add((Component)new JLabel(imageIcon), IMAGE);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setOpaque(false);
            UScrollPane uScrollPane = new UScrollPane((Component)jTextArea);
            uScrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            WizardDialog.this.leftpanel = new JPanel();
            WizardDialog.this.leftpanel.setLayout(new BoxLayout(WizardDialog.this.leftpanel, 1));
            WizardDialog.this.leftpanel.add((Component)uScrollPane);
            this.add((Component)WizardDialog.this.leftpanel, TEXT);
            this.textDoc = jTextArea.getDocument();
        }

        public StatusPanel(List list, Dimension dimension, Icon icon, String string) {
            super(new BorderLayout());
            this.chunks = new HashMap();
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 3, 3, 3), 0, 0);
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(WizardDialog.POINTER));
            this.pointers = new HashMap();
            this.labels = new HashMap();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(3, 1, 3, 1);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WizardPane wizardPane = (WizardPane)((Object)iterator.next());
                JLabel jLabel = new JLabel(imageIcon);
                jLabel.setVisible(false);
                JLabel jLabel2 = new JLabel(wizardPane.getName(), icon, 10);
                jLabel2.setToolTipText(string);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 12;
                jPanel.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 18;
                if (!iterator.hasNext()) {
                    gridBagConstraints.weighty = 1.0;
                }
                jPanel.add((Component)jLabel2, gridBagConstraints);
                this.pointers.put(wizardPane, jLabel);
                this.labels.put(wizardPane, jLabel2);
                ++gridBagConstraints.gridy;
            }
            this.add((Component)new UScrollPane((Component)jPanel));
            if (!list.isEmpty()) {
                this.setCurrent((WizardPane)((Object)list.get(0)), true);
            }
        }

        public void reset() {
            block5: {
                if (db.on) {
                    db.println("StatusPanel.reset");
                }
                if (this.cardLayout != null) {
                    this.cardLayout.show(this, IMAGE);
                }
                if (this.textDoc != null) {
                    try {
                        this.textDoc.remove(0, this.textDoc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        if (!db.on) break block5;
                        db.println("StatusPanel.reset: BadLocationException");
                    }
                }
            }
            this.chunks.clear();
        }

        public void setText(Object object, String string) {
            block4: {
                if (string == null || string.length() == 0 || this.cardLayout == null) {
                    return;
                }
                if (db.on) {
                    db.println("StatusPanel.setText(" + Integer.toHexString(object.hashCode()) + ",\"" + string + "\")");
                }
                this.clearText(object);
                try {
                    int n = this.textDoc.getLength();
                    this.textDoc.insertString(n, string, null);
                    this.chunks.put(object, new Chunk(n, string.length()));
                    this.cardLayout.show(this, TEXT);
                }
                catch (BadLocationException badLocationException) {
                    if (!db.on) break block4;
                    db.println("StatusPanel.setText: BadLocationException");
                }
            }
        }

        public void clearText(Object object) {
            block5: {
                Chunk chunk = (Chunk)this.chunks.get(object);
                if (chunk != null) {
                    if (db.on) {
                        db.println("StatusPanel.clearText(" + object + "), chunk = (" + chunk.offset + "," + chunk.length + ")");
                    }
                    try {
                        this.textDoc.remove(chunk.offset, chunk.length);
                        this.chunks.remove(object);
                    }
                    catch (BadLocationException badLocationException) {
                        if (!db.on) break block5;
                        db.println("StatusPanel.clearText: BadLocationException");
                    }
                }
            }
            if (this.cardLayout != null && this.textDoc.getLength() == 0) {
                this.cardLayout.show(this, IMAGE);
            }
        }

        public void setStatus(WizardPane wizardPane, Icon icon, String string) {
            if (this.labels != null && wizardPane != null) {
                JLabel jLabel;
                if (db.on) {
                    db.println("Status Panel setIcon for " + wizardPane.getName());
                }
                if ((jLabel = (JLabel)this.labels.get((Object)wizardPane)) != null) {
                    jLabel.setIcon(icon);
                    jLabel.setToolTipText(string);
                    jLabel.revalidate();
                }
            }
        }

        public void setCurrent(WizardPane wizardPane, boolean bl) {
            if (this.pointers != null && wizardPane != null) {
                JLabel jLabel;
                JLabel jLabel2;
                if (db.on) {
                    db.println("Status Panel setCurrent " + wizardPane.getName() + "=" + bl);
                }
                if ((jLabel2 = (JLabel)this.pointers.get((Object)wizardPane)) != null) {
                    jLabel2.setVisible(bl);
                    jLabel2.revalidate();
                }
                if ((jLabel = (JLabel)this.labels.get((Object)wizardPane)) != null) {
                    jLabel.setBorder(bl ? BorderFactory.createEtchedBorder() : null);
                    jLabel.revalidate();
                }
            }
        }

        void dispose() {
            this.chunks.clear();
        }
    }

    private static class Chunk {
        public int offset;
        public int length;

        public Chunk(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }
    }
}

