/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.APCCorrectionPane;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.ObflPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.AmpliAlsPane;
import cerent.cms.ui.ampli.OchncMaintenancePane;
import cerent.cms.ui.ampli.WlPowerPane;
import java.awt.Component;
import java.awt.GridLayout;

public class AmpliMaintenancePane
extends AbstractPane
implements ITabName {
    private AbstractOpticsLineModel[] aolm;

    public AmpliMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, String string2) {
        super(string, tabbedView);
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("ALS", (Component)this.getAmpliAlsTab(opticsModuleModel));
        this.subTabs.addTab(string2, (Component)((Object)this.getAPCSkippingPane("APC", this.subTabs, opticsModuleModel)));
        if (CommonHelper.isChannelPowerSupported(opticsModuleModel)) {
            this.aolm = opticsModuleModel.getLinesSupportingChanelPower();
            this.subTabs.addTab("Wavelength Power", (Component)this.getWlPowerTab(this.aolm));
            AbstractOpticsLineModel[] abstractOpticsLineModelArray = opticsModuleModel.getAllOpticsInterfaces();
            this.subTabs.addTab("OCHNC", (Component)this.getOchnc(abstractOpticsLineModelArray));
        }
        if (opticsModuleModel.isOFBLSupported()) {
            this.subTabs.addTab("OBFL", (Component)this.getOBFLTab(opticsModuleModel));
        }
        this.subTabs.setTabPlacement(2);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected Pane getWlPowerTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new WlPowerPane("Wavelength Power", this.getParentView(), abstractOpticsLineModelArray);
    }

    protected Pane getOBFLTab(OpticsModuleModel opticsModuleModel) {
        return new ObflPane("OBFL", this.getParentView(), opticsModuleModel);
    }

    protected Pane getAmpliAlsTab(OpticsModuleModel opticsModuleModel) {
        return new AmpliAlsPane("ALS", this.getParentView(), opticsModuleModel);
    }

    protected APCCorrectionPane getAPCSkippingPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        return new APCCorrectionPane(string, tabbedView, opticsModuleModel);
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void refresh() {
    }

    public void enteringPage() throws Exception {
    }

    public void leavingPage() throws Exception {
    }

    private Pane getOchnc(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new OchncMaintenancePane("OCHNC", this.getParentView(), this, abstractOpticsLineModelArray);
    }
}

