/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ampli.AmpliParametersTableModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class RamanParametersTableModel
extends AmpliParametersTableModel {
    private static final int RAMAN_START_INDEX = 25;
    private static final int RAMAN_RATIO_INDEX = 25;
    private static final int RAMAN_EXPPWR_INDEX = 26;
    private static String[] ramanColumnNames = new String[]{"Ratio", "Power Set-point (mW)"};

    public RamanParametersTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(abstractOpticsLineModelArray);
    }

    public Object getValueAt(int n, int n2) {
        Object object = super.getValueAt(n, n2);
        switch (n2) {
            case 26: {
                return this.getExptPower(n);
            }
            case 25: {
                return this.getRatio(n);
            }
        }
        return object;
    }

    protected String getActPower(int n) {
        String string;
        try {
            string = new Integer(this.model[n].getActualPower()).toString();
        }
        catch (Exception exception) {
            return "N/A";
        }
        return string;
    }

    public int getColumnCount() {
        return super.getColumnCount() + ramanColumnNames.length;
    }

    public String getColumnName(int n) {
        String string;
        if (n < 25) {
            string = super.getColumnName(n);
            if (n == 5) {
                string = string + " (mW)";
            }
        } else {
            string = ramanColumnNames[n - 25];
        }
        return string;
    }

    public String getExptPower(int n) {
        try {
            return ((RamanOpticsLineModel)this.model[n]).getTotPower();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }

    private Object getRatio(int n) {
        try {
            return ((RamanOpticsLineModel)this.model[n]).getRatio();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }
}

