/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.sOChPowerAttributes;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.HashMap;

public class WlPowerDataSource
extends AbstractRowDataSource {
    protected HashMap ochInfoMap = new HashMap();
    private String currStatusPort = null;
    private static final String NOTUPDATED = "Not Updated";
    private static final String UPDATED = "Updated";
    protected sOChPowerAttributes[] currOchPwr = null;
    protected OchInfo[] currOchInfo = null;
    protected int numLines = -1;

    public void refreshFromModel(sOChPowerAttributes[] sOChPowerAttributesArray, String string) {
        this.currStatusPort = string;
        this.currOchPwr = sOChPowerAttributesArray;
        if (this.ochInfoMap.get(string) == null) {
            this.currOchInfo = new OchInfo[sOChPowerAttributesArray.length];
            for (int i = 0; i < sOChPowerAttributesArray.length; ++i) {
                this.currOchInfo[i] = new OchInfo(sOChPowerAttributesArray[i], UPDATED);
            }
            this.ochInfoMap.put(string, this.currOchInfo);
        } else {
            this.currOchInfo = (OchInfo[])this.ochInfoMap.get(string);
            for (int i = 0; i < this.currOchInfo.length; ++i) {
                if (this.currOchInfo[i].timeStamp < sOChPowerAttributesArray[i].timeStamp) {
                    this.currOchInfo[i].timeStamp = sOChPowerAttributesArray[i].timeStamp;
                    this.currOchInfo[i].power = sOChPowerAttributesArray[i].power;
                    this.currOchInfo[i].ochStatus = UPDATED;
                    continue;
                }
                this.currOchInfo[i].ochStatus = NOTUPDATED;
            }
            this.ochInfoMap.put(string, this.currOchInfo);
        }
        this.numLines = this.currOchInfo.length;
        this.fireDataSourceChanged();
    }

    public Object getObjectAtRow(int n) {
        if (this.currStatusPort != null && this.ochInfoMap.get(this.currStatusPort) != null) {
            return ((OchInfo[])this.ochInfoMap.get(this.currStatusPort))[n];
        }
        return null;
    }

    public void dispose() {
        this.ochInfoMap.clear();
        this.currOchPwr = null;
        this.currOchInfo = null;
        this.currStatusPort = null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    protected class OchInfo {
        protected eWavelength lambda;
        protected int power;
        protected String ochStatus;
        protected int timeStamp;

        public OchInfo(sOChPowerAttributes sOChPowerAttributes2, String string) {
            this.lambda = sOChPowerAttributes2.lambdaId;
            this.power = sOChPowerAttributes2.power;
            this.ochStatus = string;
            this.timeStamp = sOChPowerAttributes2.timeStamp;
        }
    }
}

