/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.InterfaceModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmLineMaintenancePane
extends NodeProvPane
implements TableModelListener {
    private boolean _inited;
    private ObservableManager _obsMgr;
    private boolean bNonTdmPayload;
    private DwdmLineMaintTableModel dataModel = null;
    private AbstractDwdmLineModel[] lineModels;
    private InterfaceModel[] payloadModels;
    private DwdmModuleModel eqpmtModel = (DwdmModuleModel)this.getUiModel();
    protected Runnable updateThread = null;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("DwdmLineMaintenancePane");

    public DwdmLineMaintenancePane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.setLineModels(abstractDwdmLineModelArray, null);
        this.registerWithModel();
    }

    private void init() {
        this.numLines = this.lineModels.length;
        this.dataModel = new DwdmLineMaintTableModel(this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTableExt(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        TableColumn tableColumn = null;
        tableColumn = this.table.getColumn(DwdmLineMaintTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        Object[] objectArray = this.getAttributeList(eLoopback.class).toArray();
        tableColumn = this.table.getColumn(DwdmLineMaintTableModel.columnNames[3]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
        tableColumn.sizeWidthToFit();
        this.getObsMgr().addObservable((Observable[])this.lineModels);
        this.getObsMgr().addObservable((Observable[])this.payloadModels);
        this.add((Component)uScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this._inited = true;
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected List getAttributeList(Class clazz) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeList("DWDM." + clazz.getName());
    }

    protected Attribute getAttribute(Class clazz, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + clazz.getName(), n);
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        for (n = 0; n < this.numLines; ++n) {
            if (!this.dataModel.isRowDirty(n)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(n), this.lineModels[n].getAdminStateEnum())) {
                bl = true;
                if (bl3 && bl2) break;
            }
            if (this.dataModel.getLoopbackValFor(n) == eLoopback.LINE_LOOPBACK) {
                if (this.lineModels[n].getLoopback() != eLoopback.LINE_LOOPBACK) {
                    bl3 = true;
                    if (bl && bl2) {
                        break;
                    }
                }
            } else if (this.dataModel.getLoopbackValFor(n) != eLoopback.NO_LOOPBACK && this.lineModels[n].getLoopback().equals(eLoopback.NO_LOOPBACK)) {
                bl2 = true;
                if (bl && bl3) break;
            }
            if (!(this.lineModels[n] instanceof DwdmTrkLineModel) || this.dataModel.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK || !this.lineModels[n].isSplitterProtectedLine()) continue;
            bl4 = true;
        }
        n = 0;
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            n = 1;
        }
        if (bl || bl3 || bl2 || n != 0) {
            String string = AdminState.getBaseOosWarning(this.terms);
            String string2 = "Some lines are being placed in Facility (Line) loopback.\nChanging to Facility (Line) loopback may cause a timing loop\nif line is used as timing reference by far-end node\n";
            String string3 = "Some lines are being placed in Terminal (Inward) loopback.\n";
            String string4 = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false, true) + "\n\n";
            bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)((bl ? string : "") + (bl3 ? string2 : "") + (bl2 ? string3 : "") + (n != 0 ? "Some lines will be removed from loopback since their new state does not allow loopback." : "") + string4 + this.getApplyString(false)), (String)"Confirmation Dialog");
        }
        if (bl5 && bl4) {
            bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)("Locking out this operation can lead to traffic loss\n" + this.getApplyString()), (String)"Confirmation Dialog");
        }
        return bl5;
    }

    public void applyChangesToModel() throws Exception {
        if (this.verifyApplyChangesToModel()) {
            try {
                this.dataModel.applyToModel();
                this.setDirty(false);
            }
            catch (DetailedConfigError detailedConfigError) {
                throw new ConfigError(detailedConfigError.getMessage());
            }
            catch (Exception exception) {
                throw new AnnotatedException("", exception);
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void enteringPage() throws Exception {
        if (!this._inited) {
            this.init();
        } else {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        super.enteringPage();
        this.getObsMgr().setActive(true);
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setActive(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void dispose() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lineModels);
        }
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmLineMaintenancePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n == -1) {
            n = Arrays.asList(this.payloadModels).indexOf(observable);
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.lineModels != null) {
            this.dataModel.refreshFromModel();
            this.resetDirty();
        }
    }

    public void setLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray, InterfaceModel[] interfaceModelArray) {
        this.lineModels = abstractDwdmLineModelArray;
        this.numLines = this.lineModels.length;
        this.payloadModels = interfaceModelArray;
        if (this.payloadModels == null) {
            this.payloadModels = new InterfaceModel[abstractDwdmLineModelArray.length];
            for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
                this.payloadModels[i] = abstractDwdmLineModelArray[i].getPayloadModel();
            }
        }
        if (this._inited) {
            this.getObsMgr().setObservable((Observable[])this.lineModels);
            this.getObsMgr().addObservable((Observable[])this.payloadModels);
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            if (db.on()) {
                db.println("Received DwdmLineUpdate...");
            }
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
            this.setLineModels(dwdmModuleModel.removeIlkTrkLineModels(((DwdmLineUpdate)object).getDwdmLineModels()), ((DwdmLineUpdate)object).getPayloadLineModels());
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmLineMaintenancePane;
    }

    private class UTableExt
    extends UTable {
        private DefaultCellEditor tdmStateEditor;
        private DefaultCellEditor nonTdmStateEditor;

        public UTableExt(DwdmLineMaintTableModel dwdmLineMaintTableModel) {
            super((TableModel)dwdmLineMaintTableModel);
            boolean bl = AdminState.isANSI(this.getTdmProtocolType());
            this.tdmStateEditor = new DefaultCellEditor(DwdmLineMaintenancePane.this.getComboBoxFor(AdminState.getDefaultAdminStates(bl)));
            this.nonTdmStateEditor = new DefaultCellEditor(DwdmLineMaintenancePane.this.getComboBoxFor(AdminState.getAdminStatesNoAINS(bl)));
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (this.convertColumnIndexToModel(n2) != 1) {
                return super.getCellEditor(n, n2);
            }
            return DwdmLineMaintenancePane.this.lineModels[n] != null && DwdmLineMaintenancePane.this.lineModels[n].supportsAINS() ? this.tdmStateEditor : this.nonTdmStateEditor;
        }

        private int getTdmProtocolType() {
            return DwdmLineMaintenancePane.this.eqpmtModel.getNodeModel().getTdmProtocolType();
        }
    }
}

