/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import javax.swing.table.AbstractTableModel;

public class E13LineTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    protected Ds123LineModel[] model = null;
    protected int protocolType;
    protected TDMTerminology terms;
    protected boolean[][] isDirty = null;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    protected Attribute[] clockSource;
    protected Attribute[] lineType;
    protected Attribute[] detectedLineType;
    protected Attribute[] lineCoding;
    protected Attribute[] signalMode;
    protected Attribute[] lineLength;
    protected Attribute[] sfBerLevel;
    protected Attribute[] sdBerLevel;
    private int[] fdlModeMask;
    private int[] soakTime;
    protected int numLines = 0;
    private sConfig[] configStructures;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int SFBERLEVEL_INDEX = 4;
    public static final int SDBERLEVEL_INDEX = 5;
    public static final int CLOCKSOURCE_INDEX = 6;
    public static final int LINETYPE_INDEX = 7;
    public static final int DETECTED_LINETYPE_INDEX = 8;
    public static final int LINECODING_INDEX = 9;
    public static final int SIGNALMODE_INDEX = 10;
    public static final int LINELENGTH_INDEX = 11;
    public static final int SOAK_TIME_INDEX = 12;
    public static final int E13_LAST_COLUMN = 12;
    public static final String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "SF BER", "SD BER", "Clock Source", "Line Type", "Detected Line Type", "Line Coding", "Signal Mode", "Line Length", "AINS Soak"};
    private String[] portNames;
    protected String sdString;
    protected String sfString;
    private static final SDebug db = new SDebug("E13LineTable");

    public E13LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.protocolType = iNodeModel.getTdmProtocolType();
        this.terms = iNodeModel.getTDMTerminology();
        if (ds123LineModelArray != null) {
            this.numLines = ds123LineModelArray.length;
        }
        this.init();
    }

    protected void init() {
        if (this.model != null) {
            this.numLines = this.model.length;
        }
        this.portNames = new String[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.clockSource = new Attribute[this.numLines];
        this.lineType = new Attribute[this.numLines];
        this.detectedLineType = new Attribute[this.numLines];
        this.lineCoding = new Attribute[this.numLines];
        this.signalMode = new Attribute[this.numLines];
        this.lineLength = new Attribute[this.numLines];
        this.fdlModeMask = new int[this.numLines];
        this.configStructures = new sConfig[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.soakTime = new int[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
            this.fdlModeMask[i] = -1;
        }
        this.resetDirtyBits();
    }

    public int getNumberOfLines() {
        return this.numLines;
    }

    protected ElAttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.protocolType, this.terms);
    }

    protected Attribute getAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS123." + object.getClass().getName(), n);
    }

    protected Attribute getDetectedAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS123." + object.getClass().getName() + ".detected", n);
    }

    protected Attribute getLineLengthAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS123.Line Length", n);
    }

    private Attribute getClockSource(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.clockSource[n] == null) {
            eClockSource eClockSource2 = this.getConfigStructure((int)n).clockSource;
            this.clockSource[n] = this.getAttributeFor(eClockSource2, eClockSource2.value());
        }
        return this.clockSource[n];
    }

    private Attribute getLineType(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineType[n] == null) {
            eLineType eLineType2 = this.getConfigStructure((int)n).lineType;
            this.lineType[n] = this.getAttributeFor(eLineType2, eLineType2.value());
        }
        return this.lineType[n];
    }

    private Attribute getDetectedLineType(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.detectedLineType[n] == null) {
            eLineType eLineType2 = this.model[n].getReceivedFrameFormat();
            this.detectedLineType[n] = this.getDetectedAttributeFor(eLineType2, eLineType2.value());
        }
        return this.detectedLineType[n];
    }

    private Attribute getLineCoding(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineCoding[n] == null) {
            eLineCoding eLineCoding2 = this.getConfigStructure((int)n).lineCoding;
            this.lineCoding[n] = this.getAttributeFor(eLineCoding2, eLineCoding2.value());
        }
        return this.lineCoding[n];
    }

    private Attribute getSignalMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.signalMode[n] == null) {
            eSignalMode eSignalMode2 = this.getConfigStructure((int)n).signalMode;
            this.signalMode[n] = this.getAttributeFor(eSignalMode2, eSignalMode2.value());
        }
        return this.signalMode[n];
    }

    private String getSoakTimeFromModel(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    private Attribute getLineLength(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineLength[n] == null) {
            int n2 = this.getRangeFor(this.getConfigStructure((int)n).lineLength);
            if (db.on()) {
                db.println("line Length from switch for " + n + " is : " + this.getConfigStructure((int)n).lineLength);
            }
            this.lineLength[n] = this.getLineLengthAttributeFor(n2);
        }
        return this.lineLength[n];
    }

    private int getFdlModeMask(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.fdlModeMask[n] == 0) {
            this.fdlModeMask[n] = this.getConfigStructure((int)n).fdlModeMask;
        }
        return this.fdlModeMask[n];
    }

    private sConfig getConfigStructure(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.configStructures[n] == null) {
            this.configStructures[n] = this.model[n].getConfig();
        }
        return this.configStructures[n];
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 4: {
                this.sfBerLevel[n] = (Attribute)object;
                break;
            }
            case 5: {
                this.sdBerLevel[n] = (Attribute)object;
                break;
            }
            case 7: {
                this.lineType[n] = (Attribute)object;
                break;
            }
            case 9: {
                this.lineCoding[n] = (Attribute)object;
                break;
            }
            case 11: {
                try {
                    this.lineLength[n] = (Attribute)object;
                }
                catch (Exception exception) {
                    db.println("Error in typecasting line length");
                    SDebug.printStackTrace((Throwable)exception);
                }
                break;
            }
            case 12: {
                try {
                    this.soakTime[n] = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getPortNum(int n) {
        String string = "";
        try {
            string = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)false, (boolean)true);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return string;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && n2 != 3) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && n2 != 8;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public static boolean between(int n, int n2, int n3) {
        return n3 > n && n3 <= n2;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.terms);
                }
                case 3: {
                    return this.getServiceState(n).toString(this.terms);
                }
                case 4: {
                    return this.getSfBerLevelIndex(n);
                }
                case 5: {
                    return this.getSdBerLevelIndex(n);
                }
                case 7: {
                    return this.getLineType(n);
                }
                case 8: {
                    return this.getDetectedLineType(n);
                }
                case 9: {
                    return this.getLineCoding(n);
                }
                case 11: {
                    return this.getLineLength(n);
                }
                case 12: {
                    return this.getSoakTimeFromModel(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt in E13LineTableModel " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, (int)this.model[n].getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, (int)this.model[n].getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNames[i] = null;
            this.sfBerLevel[i] = null;
            this.sdBerLevel[i] = null;
            this.signalMode[i] = null;
            this.clockSource[i] = null;
            this.lineType[i] = null;
            this.detectedLineType[i] = null;
            this.lineCoding[i] = null;
            this.lineLength[i] = null;
            this.fdlModeMask[i] = 0;
            this.configStructures[i] = null;
            this.adminState[i] = null;
            this.soakTime[i] = -1;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        this.portNames[n] = null;
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        this.signalMode[n] = null;
        this.clockSource[n] = null;
        this.lineType[n] = null;
        this.detectedLineType[n] = null;
        this.lineCoding[n] = null;
        this.lineLength[n] = null;
        this.fdlModeMask[n] = 0;
        this.configStructures[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.soakTime[n] = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        this.fireTableDataChanged();
        if (db.on()) {
            db.println("Refreshing the table lines...");
            db.println("New models = " + this.model);
        }
    }

    public sConfig getConfig(int n) throws NoSuchInterface, WrongInterfaceType {
        eClockSource eClockSource2 = eClockSource.LOCAL_TIMING;
        if (this.lineType[n] == null) {
            this.getLineType(n);
        }
        eLineType eLineType2 = eLineType.from_int(this.lineType[n].getIntValue());
        eSignalMode eSignalMode2 = eSignalMode.NO_SIGNALING;
        if (this.lineCoding[n] == null) {
            this.getLineCoding(n);
        }
        eLineCoding eLineCoding2 = eLineCoding.from_int(this.lineCoding[n].getIntValue());
        if (this.lineLength[n] == null) {
            this.getLineLength(n);
        }
        int n2 = this.lineLength[n].getIntValue();
        if (db.on()) {
            db.println("Value for line length for row " + n + " is " + n2);
        }
        return new sConfig(eClockSource2, eLineType2, eLineCoding2, eSignalMode2, n2, 0);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    protected int getRangeFor(int n) {
        if (E13LineTableModel.between(0, 225, n)) {
            return 225;
        }
        return 450;
    }

    protected eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isAdminStateDirty(int n) {
        boolean bl = false;
        try {
            bl = this.isRowDirty(n) && this.getAdminStateFor(n) != this.model[n].getAdminStateEnum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

