/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.event.EventFilter;
import cerent.cms.ui.event.AbstractFilterPropertyPane;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.AbstractPropertySheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class FilterDualListPane
extends AbstractFilterPropertyPane {
    protected ListPropertyEditor availList = null;
    protected ListPropertyEditor suppressList = null;

    public FilterDualListPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences, EventFilter eventFilter) {
        super(string, abstractPropertySheet, preferences, eventFilter);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.createCriteriaLists(), "Center");
        this.notifyAllPropertyEditors(this);
        this.load();
    }

    private JPanel createCriteriaLists() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.createAvailableList(), "West");
        jPanel.add((Component)this.createCommandPane(), "Center");
        jPanel.add((Component)this.createSuppressList(), "East");
        return jPanel;
    }

    private JPanel createAvailableList() {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        jPanel.setPreferredSize(new Dimension(200, 150));
        this.availList = new ListPropertyEditor("Show");
        jPanel.add(this.availList);
        this.availList.getEditor().addMouseListener(this);
        return jPanel;
    }

    private JPanel createSuppressList() {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        jPanel.setPreferredSize(new Dimension(200, 150));
        this.suppressList = new ListPropertyEditor("Hide");
        jPanel.add(this.suppressList);
        this.suppressList.getEditor().addMouseListener(this);
        return jPanel;
    }

    private JPanel createCommandPane() {
        Dimension dimension = new Dimension(50, 25);
        JPanel jPanel = new JPanel(new FlowLayout(1, 30, 10));
        jPanel.add(this.createButton(">"));
        jPanel.add(this.createButton("<"));
        jPanel.add(this.createButton(">>"));
        jPanel.add(this.createButton("<<"));
        return jPanel;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setPreferredSize(new Dimension(50, 25));
        jButton.setActionCommand(string);
        jButton.setMargin(new Insets(5, 1, 5, 1));
        return jButton;
    }

    public void store(String string, String string2, String string3) {
        try {
            this.prefs.setPropertyArray(string, string3, (String[])this.suppressList.getValue());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.prefs.firePropertyChange(string2);
        this.prefs.firePropertyChange(string3);
    }

    public void load(String string, String string2, String string3) {
        try {
            String[] stringArray = null;
            Vector<String> vector = new Vector<String>();
            stringArray = this.prefs.getPropertyArray(string, string3, null);
            if (stringArray != null) {
                this.loadData(stringArray, (DefaultListModel)this.suppressList.getEditor().getModel());
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.addElement(stringArray[i]);
                }
            }
            String[] stringArray2 = new String[this.eventFilter.getConditions().size()];
            this.eventFilter.getConditions().toArray(stringArray2);
            Vector<String> vector2 = new Vector<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (vector.contains(stringArray2[i]) || stringArray2[i].equals("???")) continue;
                vector2.addElement(stringArray2[i]);
            }
            Object[] objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            this.loadData((String[])objectArray, (DefaultListModel)this.availList.getEditor().getModel());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void moveItem(ListPropertyEditor listPropertyEditor, ListPropertyEditor listPropertyEditor2) {
        try {
            DefaultListModel defaultListModel = (DefaultListModel)listPropertyEditor.getEditor().getModel();
            DefaultListModel defaultListModel2 = (DefaultListModel)listPropertyEditor2.getEditor().getModel();
            Object[] objectArray = listPropertyEditor.getEditor().getSelectedValues();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!defaultListModel2.contains(objectArray[i])) {
                    defaultListModel2.insertElementAt(objectArray[i], 0);
                }
                defaultListModel.removeElement(objectArray[i]);
            }
            Object[] objectArray2 = defaultListModel2.toArray();
            String[] stringArray = new String[objectArray2.length];
            System.arraycopy(objectArray2, 0, stringArray, 0, objectArray2.length);
            defaultListModel2.removeAllElements();
            this.loadData(stringArray, defaultListModel2);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void moveAllItems(ListPropertyEditor listPropertyEditor, ListPropertyEditor listPropertyEditor2) {
        try {
            Object object;
            DefaultListModel defaultListModel = (DefaultListModel)listPropertyEditor.getEditor().getModel();
            DefaultListModel defaultListModel2 = (DefaultListModel)listPropertyEditor2.getEditor().getModel();
            int n = defaultListModel.size();
            for (int i = 0; i < n; ++i) {
                object = defaultListModel.getElementAt(i);
                if (defaultListModel2.contains(object)) continue;
                defaultListModel2.addElement(object);
            }
            defaultListModel.removeAllElements();
            Object[] objectArray = defaultListModel2.toArray();
            object = new String[objectArray.length];
            System.arraycopy(objectArray, 0, object, 0, objectArray.length);
            defaultListModel2.removeAllElements();
            this.loadData((String[])object, defaultListModel2);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void loadData(String[] stringArray, DefaultListModel defaultListModel) {
        ArrayList arrayList = this.doSort(stringArray);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (defaultListModel.contains(e)) continue;
            defaultListModel.addElement(e);
        }
    }

    public Object[] getSourceElements() {
        DefaultListModel defaultListModel = (DefaultListModel)this.availList.getEditor().getModel();
        return defaultListModel.toArray();
    }

    public Object[] getDestinationElements() {
        DefaultListModel defaultListModel = (DefaultListModel)this.suppressList.getEditor().getModel();
        return defaultListModel.toArray();
    }

    private ArrayList doSort(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton.getActionCommand().equals(">")) {
                this.moveItem(this.availList, this.suppressList);
            } else if (jButton.getActionCommand().equals("<")) {
                this.moveItem(this.suppressList, this.availList);
            } else if (jButton.getActionCommand().equals(">>")) {
                this.moveAllItems(this.availList, this.suppressList);
            } else if (jButton.getActionCommand().equals("<<")) {
                this.moveAllItems(this.suppressList, this.availList);
            }
            this.availList.setDirty(true);
            this.suppressList.setDirty(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Object object = mouseEvent.getSource();
            if (object == this.availList.getEditor()) {
                this.moveItem(this.availList, this.suppressList);
            } else if (object == this.suppressList.getEditor()) {
                this.moveItem(this.suppressList, this.availList);
            }
            this.availList.setDirty(true);
            this.suppressList.setDirty(true);
        }
    }

    public void dispose() {
        this.availList.getEditor().removeMouseListener(this);
        this.suppressList.getEditor().removeMouseListener(this);
        this.availList = null;
        this.suppressList = null;
        this.removeAll();
    }

    public class ListPropertyEditor
    extends AbstractPropertyEditor {
        private JList list = null;

        public ListPropertyEditor(String string) {
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(new TitledBorder(new EtchedBorder(1), string, 1, 2));
            this.add((Component)this.createList(string), "Center");
        }

        private JScrollPane createList(String string) {
            this.list = new JList(new DefaultListModel());
            return new JScrollPane(this.list);
        }

        public JList getEditor() {
            return this.list;
        }

        public Object getValue() {
            String[] stringArray = new String[this.list.getModel().getSize()];
            for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                stringArray[i] = (String)this.list.getModel().getElementAt(i);
            }
            return stringArray;
        }

        public void setValue(Object object) {
            if (object == null) {
                return;
            }
            try {
                String string = (String)object;
                String[] stringArray = (String[])object;
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultListModel.addElement(stringArray[i]);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

