/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.helper.DefaultAlarms;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class FunctBandDomainAlarm {
    private FunctBandDomainGrapher parent;
    private HashMap<String, PortState> existingPorts;
    private HashMap<String, CardState> existingTxp;
    private Color portColor;
    private Color cardColor;
    private static final Color[] severityColor = new Color[]{DefaultAlarms.IS_COLOR, DefaultAlarms.MINOR_ALARM_COLOR, DefaultAlarms.MAJOR_ALARM_COLOR, DefaultAlarms.CRITICAL_ALARM_COLOR};

    public FunctBandDomainAlarm(FunctBandDomainGrapher functBandDomainGrapher) {
        this.parent = functBandDomainGrapher;
        this.existingPorts = new HashMap();
        this.existingTxp = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPort(String string) {
        HashMap<String, PortState> hashMap = this.existingPorts;
        synchronized (hashMap) {
            if (!this.existingPorts.containsKey(string)) {
                this.existingPorts.put(string, new PortState());
            }
        }
    }

    public void registerCard(String string) {
        if (!this.existingTxp.containsKey(string)) {
            this.existingTxp.put(string, new CardState());
        }
    }

    public void updatePortAlarm(String string, int n, int n2) {
        try {
            this.updatePort(string, n, n2);
            PortState portState = this.summarizePortColor();
            if (portState != null) {
                this.portColor = FunctBandDomainAlarm.getPortColorByAdminStateAndSeverity(portState.getCurrentAdminStatus(), portState.getCurrentSeverity());
                this.updateMpoColor();
            }
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
    }

    public static Color getPortColorByAdminStateAndSeverity(int n, int n2) {
        Color color;
        switch (n) {
            case 0: {
                color = severityColor[n2];
                break;
            }
            case 3: {
                color = DefaultAlarms.IS_AINS_COLOR;
                break;
            }
            case 2: {
                color = DefaultAlarms.OOS_MT_COLOR;
                break;
            }
            default: {
                color = DefaultAlarms.OOS_DSBLD_COLOR;
            }
        }
        return color;
    }

    public void updateCardAlarm(String string, Color color, int n) {
        if (this.existingTxp.containsKey(string)) {
            CardState cardState = this.existingTxp.get(string);
            cardState.setCurrentColor(color);
            this.cardColor = this.summarizeCardColor().getSeverityColor();
            this.updateMpoColor();
        }
    }

    private void updateMpoColor() {
        if (this.portColor == DefaultAlarms.CRITICAL_ALARM_COLOR) {
            this.parent.setAlarmColor(this.portColor);
        } else if (this.portColor == DefaultAlarms.MAJOR_ALARM_COLOR) {
            if (this.cardColor == DefaultAlarms.CRITICAL_ALARM_COLOR) {
                this.parent.setAlarmColor(this.cardColor);
            } else {
                this.parent.setAlarmColor(this.portColor);
            }
        } else if (this.portColor == DefaultAlarms.MINOR_ALARM_COLOR) {
            if (this.cardColor != DefaultAlarms.PROVISIONED_COLOR) {
                this.parent.setAlarmColor(this.cardColor);
            } else {
                this.parent.setAlarmColor(this.portColor);
            }
        } else if (this.cardColor != DefaultAlarms.PROVISIONED_COLOR && this.cardColor != null) {
            this.parent.setAlarmColor(this.cardColor);
        }
    }

    private void updatePort(String string, int n, int n2) throws FunctException {
        if (!this.existingPorts.containsKey(string)) {
            throw new FunctException("no Port");
        }
        PortState portState = this.existingPorts.get(string);
        portState.setCurrentAdminStatus(n);
        portState.setCurrentSeverity(n2);
    }

    private synchronized PortState summarizePortColor() {
        PortState portState = new PortState();
        Collection<PortState> collection = this.existingPorts.values();
        Iterator<PortState> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                PortState portState2 = iterator.next();
                portState = portState2.isMajorOf(portState);
            }
            catch (RuntimeException runtimeException) {
                return portState;
            }
        }
        return portState;
    }

    private CardState summarizeCardColor() {
        CardState cardState = new CardState();
        Collection<CardState> collection = this.existingTxp.values();
        Iterator<CardState> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                CardState cardState2 = iterator.next();
                cardState = cardState2.isMajorOf(cardState);
            }
            catch (RuntimeException runtimeException) {}
        }
        return cardState;
    }

    public FunctBandDomainGrapher getParent() {
        return this.parent;
    }

    private class PortState {
        private int currentSeverity = 0;
        private int currentAdminStatus = -1;

        private PortState() {
        }

        public int getCurrentAdminStatus() {
            return this.currentAdminStatus;
        }

        public void setCurrentAdminStatus(int n) {
            this.currentAdminStatus = n;
        }

        public int getCurrentSeverity() {
            return this.currentSeverity;
        }

        public void setCurrentSeverity(int n) {
            this.currentSeverity = n;
        }

        public PortState isMajorOf(PortState portState) {
            switch (this.currentAdminStatus) {
                case 0: 
                case 3: {
                    switch (portState.getCurrentAdminStatus()) {
                        default: {
                            return this;
                        }
                        case 0: 
                        case 3: 
                    }
                    if (this.currentSeverity > portState.getCurrentSeverity()) {
                        return this;
                    }
                    return portState;
                }
            }
            switch (portState.getCurrentAdminStatus()) {
                default: {
                    if (this.currentSeverity > portState.getCurrentSeverity()) {
                        return this;
                    }
                    return portState;
                }
                case 0: 
                case 3: 
            }
            return portState;
        }
    }

    private class CardState {
        private int severity = 0;

        private CardState() {
        }

        public int getSeverity() {
            return this.severity;
        }

        private void setCurrentColor(Color color) {
            if (color == DefaultAlarms.MINOR_ALARM_COLOR) {
                this.severity = 1;
            }
            if (color == DefaultAlarms.MAJOR_ALARM_COLOR) {
                this.severity = 2;
            }
            if (color == DefaultAlarms.CRITICAL_ALARM_COLOR) {
                this.severity = 3;
            }
        }

        public CardState isMajorOf(CardState cardState) {
            if (cardState.getSeverity() > this.severity) {
                return cardState;
            }
            return this;
        }

        public Color getSeverityColor() {
            switch (this.severity) {
                case 1: {
                    return DefaultAlarms.MINOR_ALARM_COLOR;
                }
                case 2: {
                    return DefaultAlarms.MAJOR_ALARM_COLOR;
                }
                case 3: {
                    return DefaultAlarms.CRITICAL_ALARM_COLOR;
                }
            }
            return DefaultAlarms.PROVISIONED_COLOR;
        }
    }
}

