/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.functional.FunctPassiveCardGrapher;
import cerent.cms.ui.functional.FunctPortGraphic;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.IFvDebug;
import cerent.util.view.fv.AbstractView;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import ilog.views.IlvPoint;
import ilog.views.graphic.IlvZoomableLabel;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctPPmashGrapher
extends FunctPassiveCardGrapher
implements Observer {
    protected HashMap<String, IViewGraph> graphlabels = new HashMap();
    private IFvDebug db = FunctDebug.instance().addChild("FunctPPmashGrapher", "Dump the info related to PPMash grapher");
    int[] sidePosition;

    public FunctPPmashGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super(svgParams, viewGraphicSet);
        this.setName("FunctPPmashGrapher");
        this.initShapeinfo();
        this.sidePosition = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.sidePosition[i] = i + 1;
        }
    }

    protected IViewSvg.IViewSvgEnum getGeneralType() {
        return IViewSvg.SvgGenericShape.DEGREE_8;
    }

    public void initShapeinfo() {
        this.info = new ViewShapeInfo((Rectangle2D)this.boundingBox(), "FunctPPmashGrapher".hashCode());
    }

    @Override
    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
        this.info.setX(this.boundingBox().getX());
        this.info.setY(this.boundingBox().getY());
    }

    @Override
    public IViewShapeInfo getInfo() {
        return this.info;
    }

    @Override
    protected IViewGraph createMpoPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgPPmashPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)SvgParamsHelper.getSvgPortModel(viewAttribute)));
    }

    @Override
    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (this.db.on()) {
            this.db.println("FunctPPmashGrapher initcardinfo todo");
        }
        this.info = new ViewShapeInfo(viewAttribute, 2);
    }

    protected boolean addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
        if (iViewGraph != null) {
            IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)((FunctPortGraphic)iViewGraph).getPortModel();
            if (iViewSvgParamInfo.getSvgDir() == ViewSvgDecoderHelper.SvgTypeDirEnum.TX) {
                try {
                    if (!this.children.containsKey(String.valueOf(iFvOpticsPortModel.getMPO()))) {
                        this.children.put(String.valueOf(iFvOpticsPortModel.getMPO()), (ViewPortGraphic)iViewGraph);
                        return true;
                    }
                    if (!this.children.containsKey(iViewGraph.getGraphKey())) {
                        this.children.put(String.valueOf(iViewGraph.getGraphKey()), (ViewPortGraphic)iViewGraph);
                        return false;
                    }
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
            } else if (iViewSvgParamInfo.getSvgDir() == ViewSvgDecoderHelper.SvgTypeDirEnum.RX) {
                super.addPort(iViewGraph, iViewSvgParamInfo);
                try {
                    if (iFvOpticsPortModel.getMPO() == 0) {
                        return true;
                    }
                    if (iViewSvgParamInfo.getSvgNumId() == 1 && iFvOpticsPortModel.getMPO() == 1 || iViewSvgParamInfo.getSvgNumId() == 5 && iFvOpticsPortModel.getMPO() == 2 || iViewSvgParamInfo.getSvgNumId() == 9 && iFvOpticsPortModel.getMPO() == 3 || iViewSvgParamInfo.getSvgNumId() == 13 && iFvOpticsPortModel.getMPO() == 4) {
                        return true;
                    }
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
            }
        }
        return false;
    }

    public void setCoordinates(double d, double d2, double d3, boolean bl) {
        ViewManagerToolKit viewManagerToolKit = this.getTk();
        this.info.setX(viewManagerToolKit.clipWorldX(d));
        this.info.setY(viewManagerToolKit.clipWorldY(d2));
        if (!(bl || this.info.getCenterX() != 0.0 && this.info.getCenterX() != (double)AbstractView.getCanvasWidth() && this.info.getCenterY() != 0.0 && this.info.getCenterY() != (double)AbstractView.getCanvasHeight())) {
            this.info.setCenterX((double)AbstractView.getCanvasCenterX());
            this.info.setCenterY((double)AbstractView.getCanvasCenterY());
        }
        this.move((float)this.info.getX(), (float)this.info.getY());
    }

    public void initDefaultPos() {
        if (this.info == null) {
            return;
        }
    }

    public void updateCoordinates() {
        this.move((float)this.info.getX(), (float)this.info.getY());
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    private String sideToPortKey(int n, boolean bl) {
        int n2 = n + (n - 1) * 8;
        if (bl) {
            ++n2;
        }
        return "FunctMpoPortGraphicMPO_PORT-SIDE-" + n2 + (bl ? "-TX" : "-RX");
    }

    public IViewGraph getPortTxBySide(int n) {
        return (IViewGraph)this.getGraphChildren().get(this.sideToPortKey(n, true));
    }

    public IViewGraph getPortRxBySide(int n) {
        return (IViewGraph)this.getGraphChildren().get(this.sideToPortKey(n, false));
    }

    @Override
    public void dispose() {
        this.info = null;
        this.graphlabels.clear();
        super.dispose();
    }

    public void switchSide(int n, int n2, int n3) {
        this.switchSideLabels(n, n2);
        this.switchSidePins(this.sidePosition[n - 1], this.sidePosition[n2 - 1], n3, n, n2);
        int n4 = this.sidePosition[n2 - 1];
        this.sidePosition[n2 - 1] = this.sidePosition[n - 1];
        this.sidePosition[n - 1] = n4;
    }

    public void switchSideLabels(int n, int n2) {
        String string = ((IlvZoomableLabel)this.getObject("SIDE_LABEL-SIDE-" + n)).getLabel();
        this.setLabel("SIDE_LABEL-SIDE-" + n, ((IlvZoomableLabel)this.getObject("SIDE_LABEL-SIDE-" + n2)).getLabel());
        this.setLabel("SIDE_LABEL-SIDE-" + n2, string);
    }

    public void switchSidePins(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n3 == 5) {
            if (n > 4) {
                n6 = 18;
            }
            if (n2 > 4) {
                n7 = 18;
            }
            if (n4 > 4) {
                n8 = 18;
            }
            if (n5 > 4) {
                n9 = 18;
            }
        }
        if (n3 == 4) {
            if (n > 4) {
                n6 = 14;
            }
            if (n2 > 4) {
                n7 = 14;
            }
            if (n4 > 4) {
                n8 = 14;
            }
            if (n5 > 4) {
                n9 = 14;
            }
        }
        int n10 = 1 + n3 * (n - 1) - n6;
        int n11 = 2 + n3 * (n - 1) - n6;
        int n12 = 1 + n3 * (n2 - 1) - n7;
        int n13 = 2 + n3 * (n2 - 1) - n7;
        int n14 = 1 + n3 * (n4 - 1) - n8;
        int n15 = 2 + n3 * (n4 - 1) - n8;
        int n16 = 1 + n3 * (n5 - 1) - n9;
        int n17 = 2 + n3 * (n5 - 1) - n9;
        IlvPoint ilvPoint = ((ViewPin)this.pins.get("0-" + this.getSlotId() + "-SIDE-" + n10 + "-RX")).getPosition(null);
        IlvPoint ilvPoint2 = ((ViewPin)this.pins.get("0-" + this.getSlotId() + "-SIDE-" + n11 + "-TX")).getPosition(null);
        this.setPinPosition("0-" + this.getSlotId() + "-SIDE-" + n10 + "-RX", ((ViewPin)this.pins.get("0-" + this.getSlotId() + "-SIDE-" + n12 + "-RX")).getPosition(null));
        this.setPinPosition("0-" + this.getSlotId() + "-SIDE-" + n11 + "-TX", ((ViewPin)this.pins.get("0-" + this.getSlotId() + "-SIDE-" + n13 + "-TX")).getPosition(null));
        this.setPinPosition("0-" + this.getSlotId() + "-SIDE-" + n12 + "-RX", ilvPoint);
        this.setPinPosition("0-" + this.getSlotId() + "-SIDE-" + n13 + "-TX", ilvPoint2);
        boolean bl = this.getObject("MPO_PORT-SIDE-" + n14 + "-RX").isVisible();
        boolean bl2 = this.getObject("MPO_PORT-SIDE-" + n15 + "-TX").isVisible();
        boolean bl3 = this.getObject("MPO_PORT-SIDE-" + n16 + "-RX").isVisible();
        boolean bl4 = this.getObject("MPO_PORT-SIDE-" + n17 + "-TX").isVisible();
        this.getObject("MPO_PORT-SIDE-" + n16 + "-RX").setVisible(bl);
        this.getObject("MPO_PORT-SIDE-" + n17 + "-TX").setVisible(bl2);
        this.getObject("MPO_PORT-SIDE-" + n14 + "-RX").setVisible(bl3);
        this.getObject("MPO_PORT-SIDE-" + n15 + "-TX").setVisible(bl4);
    }

    protected void setIsSideCard() {
        this.sideCard = false;
    }
}

