/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmPortModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.functional.FunctTxpViewLink;
import cerent.cms.ui.functional.FunctViewPureGraphicalLink;
import cerent.util.view.fv.IViewLink;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerInfoComposerHelper {
    public static final String POUT = "POUT";
    public static final String PIN = "PIN";
    public static final String IDX = "IDX";
    public static final String NAME = "NAME";

    public static HashMap<String, String> addThisLink(IFvOptLinkModel iFvOptLinkModel, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, int n, int n2, IFvNodeModel iFvNodeModel) throws NoSuchInterface, WrongInterfaceType {
        return PowerInfoComposerHelper.addLink(iFvOptLinkModel.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, new String[2]);
    }

    public static HashMap<String, String> addThisCircuitLink(IViewLink iViewLink, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2, int n, int n2, IFvNodeModel iFvNodeModel, String[] stringArray) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (iViewLink instanceof FunctTxpViewLink) {
            return PowerInfoComposerHelper.addThisTXPLink((FunctTxpViewLink)iViewLink, iFvEntityModel, iFvEntityModel2);
        }
        if (iViewLink instanceof FunctViewPureGraphicalLink) {
            if (stringArray != null) {
                String string = stringArray[0];
                stringArray[0] = stringArray[1];
                stringArray[1] = string;
            }
            return PowerInfoComposerHelper.addLink(iViewLink.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, stringArray);
        }
        return PowerInfoComposerHelper.addLink(iViewLink.getIndex(), iFvPortModel, iFvPortModel2, n, n2, iFvNodeModel, stringArray);
    }

    public static HashMap<String, String> addThisPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel) {
        return PowerInfoComposerHelper.addPort(iFvPortModel, n, bl, iFvNodeModel, null);
    }

    public static HashMap<String, String> addThisPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel, String string) {
        return PowerInfoComposerHelper.addPort(iFvPortModel, n, bl, iFvNodeModel, string);
    }

    private static HashMap<String, String> addPort(IFvPortModel iFvPortModel, int n, boolean bl, IFvNodeModel iFvNodeModel, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IDX, String.valueOf(iFvPortModel.getIndex()));
        String string2 = PowerInfoComposerHelper.cardName(n, iFvPortModel);
        String string3 = "";
        if (bl) {
            PowerInfoComposerHelper.portName(string2, iFvPortModel, POUT, hashMap, string);
        } else {
            PowerInfoComposerHelper.portName(string2, iFvPortModel, PIN, hashMap, string);
        }
        PowerInfoComposerHelper.setName(iFvNodeModel, string3, string2, hashMap);
        return hashMap;
    }

    private static HashMap<String, String> addLink(int n, IFvPortModel iFvPortModel, IFvPortModel iFvPortModel2, int n2, int n3, IFvNodeModel iFvNodeModel, String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IDX, new Integer(n).toString());
        String string = PowerInfoComposerHelper.cardName(n2, iFvPortModel);
        PowerInfoComposerHelper.portName(string, iFvPortModel, POUT, hashMap, stringArray[1]);
        String string2 = PowerInfoComposerHelper.cardName(n3, iFvPortModel2);
        PowerInfoComposerHelper.portName(string2, iFvPortModel2, PIN, hashMap, stringArray[0]);
        PowerInfoComposerHelper.setName(iFvNodeModel, string2, string, hashMap);
        return hashMap;
    }

    private static void setName(IFvNodeModel iFvNodeModel, String string, String string2, HashMap<String, String> hashMap) {
        String string3 = null;
        String string4 = iFvNodeModel.getName() + "\n   ";
        string3 = string4 + string2 + "\n   " + string;
        hashMap.put(NAME, string3);
    }

    private static String portName(String string, IFvPortModel iFvPortModel, String string2, HashMap<String, String> hashMap, String string3) {
        try {
            if (iFvPortModel instanceof IFvOpticsPortModel) {
                String string4 = ((IFvOpticsPortModel)iFvPortModel).getOptPortTypeString();
                string = string + "/" + string4;
                IFvOpticsLineModel iFvOpticsLineModel = (IFvOpticsLineModel)iFvPortModel.getIFvInterfaceModel();
                if (iFvPortModel.getCardModel().getEqType() == 295 && iFvOpticsLineModel.getOptPortTypeString().contains("EXP-RX") && string3 == null) {
                    IFvOpticsCardModel iFvOpticsCardModel = (IFvOpticsCardModel)iFvPortModel.getCardModel();
                    string3 = "";
                    List list = iFvOpticsCardModel.getListOfPorts();
                    String string5 = "";
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((IFvPortModel)list.get(i)).getPortString().contains("EXP-RX")) continue;
                        string3 = string3 + string5;
                        string3 = string3 + ConvertPwrToDb.convertPwrToDb(new Integer(((IFvOpticsLineModel)((IFvPortModel)list.get(i)).getIFvInterfaceModel()).getActualPower()));
                        string5 = ", ";
                    }
                }
                if (string3 == null && (string3 = PowerInfoComposerHelper.portHasNIM(string4, iFvPortModel.getCardModel(), iFvOpticsLineModel)) == null) {
                    string3 = ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getActualPower()));
                }
            } else if (iFvPortModel instanceof IFvDwdmPortModel) {
                string = string + "/Trunk-TX";
                string3 = PowerInfoComposerHelper.getTxpPower(string2, (IFvDwdmTrkLineModel)iFvPortModel.getIFvInterfaceModel());
            } else {
                string3 = "N/A";
            }
        }
        catch (Exception exception) {
            string3 = "N/A";
        }
        hashMap.put(string2, string3);
        return string;
    }

    public static String getTxpPower(String string, IFvDwdmTrkLineModel iFvDwdmTrkLineModel) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        String string2 = "N/A";
        int n = -1;
        if (string.equals(PIN)) {
            n = 0;
        } else if (string.equals(POUT)) {
            n = 1;
        }
        if (n != -1) {
            string2 = ConvertPwrToDb.converPmValue(iFvDwdmTrkLineModel.getActualPower()[n], 0);
        }
        return string2;
    }

    private static String portHasNIM(String string, IFvCardModel iFvCardModel, IFvOpticsLineModel iFvOpticsLineModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (string.contains("OSC")) {
            return ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getOSCPower()));
        }
        if (iFvCardModel.getEqType() == 128 && string.contains("LINE")) {
            int n = iFvCardModel.getSide();
            IFvSideModel[] iFvSideModelArray = iFvCardModel.getIFVNodeModel().getIfvSideModels();
            for (int i = 0; i < iFvSideModelArray.length; ++i) {
                IFvSideModel iFvSideModel = iFvSideModelArray[i];
                if (iFvSideModel.getId() != n) continue;
                IFvEntityModel iFvEntityModel = iFvCardModel.getIFVNodeModel().getEntityModelByIndex(iFvSideModel.getLineIn()).getParentModel();
                if (iFvEntityModel == iFvCardModel) {
                    return null;
                }
                return ConvertPwrToDb.convertPwrToDb(new Integer(iFvOpticsLineModel.getOSCPower()));
            }
        }
        return null;
    }

    private static String cardName(int n, IFvPortModel iFvPortModel) {
        String string = " (" + DwdmSide.getSideFromOffset(DwdmSide.getSideLabelFromId(n)) + ") ";
        if (string.contains("Unknown")) {
            string = "";
        }
        String string2 = string + iFvPortModel.getCardModel().getEqLabel() + " " + iFvPortModel.getPortString() + ": ";
        if (iFvPortModel.getIFVNodeModel().isMultishelf()) {
            string2 = string2 + iFvPortModel.getShelfId() + "-";
        }
        string2 = string2 + iFvPortModel.getSlot() + "-" + iFvPortModel.getPort();
        return string2;
    }

    public static HashMap<String, String> addThisTXPLink(FunctTxpViewLink functTxpViewLink, IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(IDX, new Integer(functTxpViewLink.getIndex()).toString());
        String string = !(iFvEntityModel instanceof IFvOpticsCardModel) ? iFvEntityModel.getEqLabel() : iFvEntityModel2.getEqLabel();
        hashMap.put(NAME, string);
        hashMap.put(PIN, PowerInfoComposerHelper.getTxpPower(PIN, functTxpViewLink.getTrnk()));
        hashMap.put(POUT, PowerInfoComposerHelper.getTxpPower(POUT, functTxpViewLink.getTrnk()));
        return hashMap;
    }
}

