/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.ui.functional.FunctBandPortGraphic;
import cerent.cms.ui.functional.FunctChannelPortGraphic;
import cerent.cms.ui.functional.FunctFiberPortGraphic;
import cerent.cms.ui.functional.FunctMpoPortGraphic;
import cerent.cms.ui.functional.FunctPPmashPortGraphic;
import cerent.cms.ui.functional.FunctPassiveCardGrapher;
import cerent.cms.ui.functional.FunctPassivePortGraphic;
import cerent.cms.ui.functional.FunctPortGraphic;
import cerent.cms.ui.functional.FunctTrunkPortGraphic;
import cerent.util.view.fv.AbstractSvgFactory;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.ViewSvgParamInfo;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SvgPortFactory
extends AbstractSvgFactory {
    public SvgPortFactory(IFvNodeModel iFvNodeModel) {
        super(iFvNodeModel);
    }

    public IViewGraph getViewElem(SvgParams svgParams) throws SAXException, IOException, ParserConfigurationException, FunctException {
        switch (IViewSvg.SvgPortShape.getFromInt((int)svgParams.getSvgType())) {
            case BAND: {
                return new FunctBandPortGraphic((ISvgParams)svgParams);
            }
            case MPO: {
                return new FunctMpoPortGraphic(svgParams);
            }
            case PPMASH: {
                return new FunctPPmashPortGraphic((ISvgParams)svgParams);
            }
            case FIBER: {
                return new FunctFiberPortGraphic(svgParams);
            }
            case CH: {
                boolean bl = false;
                if (svgParams.getPortModel() != null) {
                    bl = svgParams.getPortModel().getCardModel().isPassiveModule();
                }
                if (bl) {
                    return new FunctPassivePortGraphic((ISvgParams)svgParams);
                }
                return new FunctChannelPortGraphic(svgParams);
            }
            case COM: 
            case EXP: 
            case OSC: 
            case DROP: 
            case SIDE: 
            case ADD: 
            case DC: {
                return new FunctPortGraphic((ISvgParams)svgParams);
            }
            case LINE: {
                return this.trunkorLine(svgParams);
            }
        }
        throw new FunctException("Error in port Creation");
    }

    private IViewGraph trunkorLine(SvgParams svgParams) {
        switch (((ViewSvgParamInfo)svgParams.getParamBag()).getSvgPortTyp()) {
            case TRNK_PORT_PROT: 
            case TRNK_PORT: {
                return new FunctTrunkPortGraphic(svgParams);
            }
        }
        if (svgParams.owner instanceof FunctPassiveCardGrapher) {
            return new FunctPassivePortGraphic((ISvgParams)svgParams);
        }
        return new FunctPortGraphic((ISvgParams)svgParams);
    }

    protected void initSvgHash() {
    }
}

