/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.hdge;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.eFcsType;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.eGigEtherOptics;
import cerent.cms.idl.EtherMedia.eTransponderMode;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo_4_01;
import cerent.cms.idl.EtherMedia.sGmacLineInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.hdge.HdGeTxpMode;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class HdGePortTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private ModuleModel eqpmtModel = null;
    private EtherLineModel[] lineModels = null;
    private int baseIndex = 0;
    protected boolean[][] isDirty = null;
    protected int numLines = 0;
    private sGmacLineAdminInfo[] lineAdminInfo = null;
    private Map transponders = new HashMap();
    private sGmacLineInfo[] lineInfo = null;
    private boolean liCheckDirty = false;
    public static final String[] hdgeColumnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "AINS Soak", "Media Type", "Flow Control", "Auto Negotiation", "Negotiation Status", "Max. Size", "Payload Type", "TXP Port", "TXP Mode", "Water Marks", "Flow Ctrl Lo", "Flow Ctrl Hi", "Link Integrity Disable", "Link Integrity Timer"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int SOAK_TIME_INDEX = 4;
    public static final int MEDIA_TYPE_INDEX = 5;
    public static final int FLOW_CTRL_INDEX = 6;
    public static final int AUTO_NEGOTIATION_INDEX = 7;
    public static final int NEGOTIATION_INDEX = 8;
    public static final int FRAME_SIZE_INDEX = 9;
    public static final int PAYLOAD_TYPE_INDEX = 10;
    public static final int TRANSPONDER_SELECTION_INDEX = 11;
    public static final int TRANSPONDER_MODE_INDEX = 12;
    public static final int WATER_MARKS_INDEX = 13;
    public static final int LOW_WATER_MARK_INDEX = 14;
    public static final int HIGH_WATER_MARK_INDEX = 15;
    protected static final int LI_TIMER_INDEX = 17;
    protected static final int LI_CHECK = 16;
    protected static final int HDGE_NUM_COLUMN = 17;
    protected String[] portNames;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    private sGmacLineAdminInfo_4_01[] lineAdminInfo_4_01 = null;
    private Attribute[] transponderModes = null;
    private Attribute[] transponderPorts = null;
    private Attribute[] waterMarks = null;
    private int[] soakTime;
    private int[] liTimer;
    private boolean[] liCheck;
    private GBICCopperChangeObserver gbicObserver;
    protected String[] columnNames = hdgeColumnNames;
    private static final SDebug db = new SDebug("HdGePortTableModel");

    public HdGePortTableModel(ModuleModel moduleModel, EtherLineModel[] etherLineModelArray) {
        int n;
        this.lineModels = etherLineModelArray;
        this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        this.baseIndex = etherLineModelArray != null && etherLineModelArray.length > 0 ? etherLineModelArray[0].getIndex() : 0;
        this.eqpmtModel = moduleModel;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.portNames = new String[this.numLines];
        this.lineInfo = new sGmacLineInfo[this.numLines];
        this.lineAdminInfo = new sGmacLineAdminInfo[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.transponderModes = new Attribute[this.numLines];
        this.transponderPorts = new Attribute[this.numLines];
        this.waterMarks = new Attribute[this.numLines];
        this.lineAdminInfo_4_01 = new sGmacLineAdminInfo_4_01[this.numLines];
        this.soakTime = new int[this.numLines];
        this.liTimer = new int[this.numLines];
        this.liCheck = new boolean[this.numLines];
        for (n = 0; n < this.numLines; ++n) {
            this.soakTime[n] = -1;
        }
        n = 0;
        if (moduleModel instanceof HdGeModuleModel) {
            this.gbicObserver = new GBICCopperChangeObserver(((HdGeModuleModel)moduleModel).getGBICChangeNotifier());
            n = 1;
        } else {
            this.gbicObserver = null;
        }
        this.resetDirty();
        if (n != 0) {
            this.copperCheck(this.gbicObserver.getCurrentGBICs());
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            boolean bl = false;
            if (!this.liCheck[n] && n2 == 17) {
                return true;
            }
            if (n2 == 16) {
                return true;
            }
            if (n2 == 14 || n2 == 15) {
                bl = this.getWaterMarkSetting(n).getIntValue() == 2;
            }
            return (n2 == 2 || n2 == 6 || n2 == 9 || n2 == 1 || n2 == 10 || n2 == 12 || n2 == 7 || n2 == 4 || n2 == 11 || n2 == 13 || bl) && !this.portSettingsConflict(n, n2);
        }
        return false;
    }

    private boolean getLICheckDirty() {
        return this.liCheckDirty;
    }

    private void setLICheckDirty(boolean bl) {
        this.liCheckDirty = bl;
    }

    private boolean portSettingsConflict(int n, int n2) {
        boolean bl = false;
        if (n2 == 14 || n2 == 15 || n2 == 13 || n2 == 9) {
            Attribute attribute = this.getTransponderPort(n);
            bl = attribute.getIntValue() != 0;
        }
        return bl;
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.lineModels[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    public boolean adminStateChangedToFormOfOOS() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][2] || !AdminState.isTransitionToOOS(this.getAdminStateAsEnum(i), this.getAdminStateFromModel(i))) continue;
            return true;
        }
        return false;
    }

    public boolean needRemoveLoopback() {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.isDirty[i][2] || !this.getLineAdminInfo((int)i).loopback || AdminState.admitsLoopback(this.getAdminStateAsEnum(i))) continue;
                return true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                db.println("Error in getAdminState" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean autoNegotiationChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.isDirty[i][7] || !AdminState.isFormOfIS(this.getAdminStateAsEnum(i))) continue;
                return true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                db.println("Error in getAdminState" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean flowControlChanged() {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.isDirty[i][6] || !AdminState.isFormOfIS(this.getAdminStateAsEnum(i))) continue;
                return true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                db.println("Error in getAdminState" + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sGmacLineInfo getLineInfo(int n) {
        if (this.lineInfo[n] == null) {
            try {
                this.lineInfo[n] = this.lineModels[n].getGmacLineInfo();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.lineInfo[n];
    }

    private sGmacLineAdminInfo getLineAdminInfo(int n) {
        if (this.lineAdminInfo[n] == null) {
            try {
                this.lineAdminInfo[n] = this.lineModels[n].getGmacLineAdminInfo();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.lineAdminInfo[n];
    }

    private sGmacLineAdminInfo_4_01 getLineAdminInfo_4_01(int n) {
        if (this.lineAdminInfo_4_01[n] == null) {
            try {
                this.lineAdminInfo_4_01[n] = this.lineModels[n].getGmacLineAdminInfo_4_01();
                Integer n2 = new Integer(n + 1);
                Integer n3 = new Integer(this.lineAdminInfo_4_01[n].transpondingInterface - this.baseIndex + 1);
                if (this.lineAdminInfo_4_01[n].mode != eTransponderMode.TRANSPONDER_NONE) {
                    this.transponders.put(n2, n3);
                    this.transponders.put(n3, n2);
                } else {
                    this.transponders.remove(n2);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return this.lineAdminInfo_4_01[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    public eAdminState getAdminStateAsEnum(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.getAdminStateFromModel(n);
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    public Attribute getPayloadType(int n) {
        if (this.getLineAdminInfo_4_01(n) != null) {
            return this.getAttributeFor("G1000 Payload Type", this.lineAdminInfo_4_01[n].fcsType.value());
        }
        if (db.on()) {
            db.println("getPayloadType: GmacLineAdminInfo is null " + n);
        }
        return null;
    }

    public IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.lineModels[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    public Attribute getTransponderMode(int n) {
        if (this.transponderModes[n] == null) {
            this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", this.getTransponderModeFromModel(n));
        }
        return this.transponderModes[n];
    }

    public Attribute getTransponderPort(int n) {
        if (this.transponderPorts[n] == null) {
            this.transponderPorts[n] = this.getAttributeFor("G1000 Transponder Port", this.getTransponderPortFromModel(n));
        }
        return this.transponderPorts[n];
    }

    public Attribute getWaterMarkSetting(int n) {
        if (this.waterMarks[n] == null) {
            short s = this.getFlowControlLowWaterMark(n);
            short s2 = this.getFlowControlHighWaterMark(n);
            this.waterMarks[n] = s == 25 && s2 == 485 ? this.getAttributeFor("G1000 Water Marks Setting", 0) : (s == 5 && s2 == 10 ? this.getAttributeFor("G1000 Water Marks Setting", 1) : this.getAttributeFor("G1000 Water Marks Setting", 2));
        }
        return this.waterMarks[n];
    }

    public Short getFlowControlLowWaterMark(int n) {
        return new Short(this.getLineAdminInfo_4_01((int)n).flowControlLowWatermark);
    }

    public Short getFlowControlHighWaterMark(int n) {
        return new Short(this.getLineAdminInfo_4_01((int)n).flowControlHighWatermark);
    }

    private Boolean getAutoNegotiationEnabledFor(int n) {
        if (this.lineAdminInfo[n] == null) {
            this.getLineAdminInfo(n);
        }
        if (this.lineAdminInfo[n] != null) {
            return new Boolean(this.lineAdminInfo[n].negotiate);
        }
        if (db.on()) {
            db.println("GmacLineAdminInfo is null " + n);
        }
        return null;
    }

    private Boolean getFlowControlEnabledFor(int n) {
        if (this.lineAdminInfo_4_01[n] == null) {
            this.getLineAdminInfo_4_01(n);
        }
        if (this.lineAdminInfo_4_01[n] != null) {
            return new Boolean(this.lineAdminInfo_4_01[n].flowControl);
        }
        if (db.on()) {
            db.println("GmacLineAdminInfo is null " + n);
        }
        return null;
    }

    public Attribute getMediaTypeFor(int n) {
        if (this.lineInfo[n] == null) {
            this.getLineInfo(n);
        }
        if (this.lineInfo[n] != null) {
            return this.getAttributeFor(eGigEtherOptics.class.getName(), this.lineInfo[n].opticsType.value());
        }
        if (db.on()) {
            db.println("GmacLineInfo is null " + n);
        }
        return null;
    }

    public Attribute getNegStatusFor(int n) {
        if (this.lineInfo[n] == null) {
            this.getLineInfo(n);
        }
        if (this.lineInfo[n] != null) {
            return this.getAttributeFor(eFlowControlNegotiated.class.getName(), this.lineInfo[n].flowControlNegotiated.value());
        }
        if (db.on()) {
            db.println("GmacLineInfo is null " + n);
        }
        return null;
    }

    private Attribute getPortMaxSizeFor(int n) {
        if (this.lineAdminInfo[n] == null) {
            this.getLineAdminInfo(n);
        }
        if (this.lineAdminInfo[n] != null) {
            return this.getAttributeFor("G1000 Port Max Size", this.lineAdminInfo[n].maxFrame);
        }
        if (db.on()) {
            db.println("GmacLineAdminInfo is null " + n);
        }
        return null;
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.lineModels[n].getAlias();
        }
        return this.portNames[n];
    }

    protected Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 7: {
                return Boolean.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 17: {
                return Integer.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block23: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 3: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                    case 5: {
                        return this.getMediaTypeFor(n);
                    }
                    case 6: {
                        return this.getFlowControlEnabledFor(n);
                    }
                    case 7: {
                        return this.getAutoNegotiationEnabledFor(n);
                    }
                    case 8: {
                        return this.getNegStatusFor(n);
                    }
                    case 4: {
                        return this.getSoakTimeAsHHMM(n);
                    }
                    case 9: {
                        return this.getPortMaxSizeFor(n);
                    }
                    case 12: {
                        return this.getTransponderMode(n);
                    }
                    case 11: {
                        return this.getTransponderPort(n);
                    }
                    case 13: {
                        return this.getWaterMarkSetting(n);
                    }
                    case 14: {
                        return this.getFlowControlLowWaterMark(n);
                    }
                    case 15: {
                        return this.getFlowControlHighWaterMark(n);
                    }
                    case 10: {
                        return this.getPayloadType(n);
                    }
                    case 17: {
                        if (this.liCheck[n]) {
                            return null;
                        }
                        return this.liTimer[n];
                    }
                    case 16: {
                        return this.liCheck[n];
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block23;
                db.println("Error in getValueAt in HdGePortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (this.portNames[n] == (String)object) {
                    return;
                }
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                if (this.adminState[n] == (AdminState)object) {
                    return;
                }
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 7: {
                if (!(object instanceof Boolean)) break;
                if (this.lineAdminInfo[n].negotiate == (Boolean)object) {
                    return;
                }
                this.lineAdminInfo[n].negotiate = (Boolean)object;
                this.getLineAdminInfo_4_01((int)n).negotiate = (Boolean)object;
                this.copperCheck(n);
                break;
            }
            case 6: {
                if (!(object instanceof Boolean)) break;
                if (this.lineAdminInfo_4_01[n].flowControl == (Boolean)object) {
                    return;
                }
                this.lineAdminInfo_4_01[n].flowControl = (Boolean)object;
                break;
            }
            case 4: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 9: {
                if (!(object instanceof Attribute)) break;
                if (this.lineAdminInfo[n].maxFrame == ((Attribute)object).getIntValue()) {
                    return;
                }
                this.lineAdminInfo[n].maxFrame = ((Attribute)object).getIntValue();
                break;
            }
            case 12: {
                this.clearModeAccomplices(n, (Attribute)object);
                this.setTransponderMode(n, (Attribute)object);
                break;
            }
            case 11: {
                Integer n4 = new Integer(n + 1);
                boolean bl = false;
                if (this.transponders.containsKey(n4)) {
                    bl = true;
                    if (this.transponders.get(n4).equals(n4) && ((Attribute)object).getIntValue() == 0) {
                        bl = false;
                    }
                } else {
                    Integer n5 = new Integer(((Attribute)object).getIntValue());
                    if (this.transponders.containsKey(n5)) {
                        n4 = n5;
                        bl = true;
                    }
                }
                if (bl) {
                    IgnorableDialog.warningDialog(null, (String)("Port " + n4 + " is transponding with Port " + this.transponders.get(n4) + ".\n" + "Changing Port " + n4 + "'s transponder port setting will also\n" + "clear Port " + this.transponders.get(n4) + "'s settings.\n" + "Click Reset to undo this change."), (String)"Clear TXP Port", (String)"Clear TXP", (String)"Warning dialog that informs a user other ports will be cleared of their transponder setting.");
                }
                this.clearPortAccomplices(n, (Attribute)object);
                this.setTransponderPort(n, (Attribute)object);
                break;
            }
            case 13: {
                Attribute attribute = (Attribute)object;
                if (this.waterMarks[n] == attribute) {
                    return;
                }
                this.waterMarks[n] = attribute;
                if (attribute.getIntValue() == 0) {
                    this.setWaterMark(14, n, String.valueOf(25));
                    this.setWaterMark(15, n, String.valueOf(485));
                    break;
                }
                if (attribute.getIntValue() != 1) break;
                this.setWaterMark(14, n, String.valueOf(5));
                this.setWaterMark(15, n, String.valueOf(10));
                break;
            }
            case 14: {
                this.setWaterMark(14, n, (String)object);
                break;
            }
            case 15: {
                this.setWaterMark(15, n, (String)object);
                break;
            }
            case 10: {
                if (!(object instanceof Attribute)) break;
                int n6 = ((Attribute)object).getIntValue();
                if (this.lineAdminInfo_4_01[n].fcsType == eFcsType.from_int(n6)) {
                    return;
                }
                this.lineAdminInfo_4_01[n].fcsType = eFcsType.from_int(n6);
                break;
            }
            case 17: {
                if (this.liTimer[n] == (Integer)object) {
                    return;
                }
                this.liTimer[n] = (Integer)object;
                break;
            }
            case 16: {
                Boolean bl = (Boolean)object;
                if (this.liCheck[n] == bl) {
                    return;
                }
                this.liCheck[n] = bl;
                if (!bl.booleanValue()) {
                    this.liTimer[n] = 200;
                    break;
                }
                this.liTimer[n] = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void setWaterMark(int n, int n2, String string) {
        short s = 1;
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            SDebug.printStackTrace((Throwable)numberFormatException);
            return;
        }
        if (s < 1 || s > 511) {
            ErrorMsg.displayError(null, EMC.EID_WATERMARK_LIMITS_PARAM_2, Integer.toString(1), Integer.toString(511));
            return;
        }
        switch (n) {
            case 14: {
                this.lineAdminInfo_4_01[n2].flowControlLowWatermark = s;
                this.isDirty[n2][14] = true;
                this.fireTableCellUpdated(n2, 14);
                break;
            }
            case 15: {
                this.lineAdminInfo_4_01[n2].flowControlHighWatermark = s;
                this.isDirty[n2][15] = true;
                this.fireTableCellUpdated(n2, 15);
            }
        }
    }

    private Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    private void clearPortAccomplices(int n, Attribute attribute) {
        int n2 = n;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        n2 = this.lineAdminInfo_4_01[n2].transpondingInterface - this.baseIndex;
        if (n2 != n && this.lineAdminInfo_4_01[n2].transpondingInterface != this.lineModels[n2].getIndex()) {
            hashSet.add(new Integer(n2));
        }
        if ((n2 = attribute.getIntValue() - 1) >= 0 && n2 != n && this.lineAdminInfo_4_01[n2].transpondingInterface != this.lineModels[n2].getIndex()) {
            hashSet.add(new Integer(this.lineAdminInfo_4_01[n2].transpondingInterface - this.baseIndex));
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            this.transponderModes[n2] = this.getAttributeFor("G1000 Transponder Mode", 0);
            this.transponderPorts[n2] = this.getAttributeFor("G1000 Transponder Port", 0);
            this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_NONE;
            this.lineAdminInfo_4_01[n2].transpondingInterface = this.lineModels[n2].getIndex();
            this.fireTableCellUpdated(n2, 11);
            this.fireTableCellUpdated(n2, 12);
        }
    }

    private void clearModeAccomplices(int n, Attribute attribute) {
        int n2 = this.lineAdminInfo_4_01[n].transpondingInterface - this.baseIndex;
        if (attribute.getIntValue() == 0) {
            this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_NONE;
            this.transponderModes[n2] = attribute;
            this.fireTableCellUpdated(n2, 12);
        }
    }

    private void setTransponderMode(int n, Attribute attribute) {
        String string = null;
        this.transponderModes[n] = attribute;
        int n2 = this.lineAdminInfo_4_01[n].transpondingInterface - this.baseIndex;
        switch (this.transponderModes[n].getIntValue()) {
            case 0: {
                this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
                break;
            }
            case 1: {
                if (this.transponderPorts[n].getIntValue() == 0) {
                    this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 0);
                    string = "- The transponder port is set to none.";
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
                    break;
                }
                if (this.lineAdminInfo_4_01[n].transpondingInterface == this.lineModels[n].getIndex()) {
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL;
                    break;
                }
                this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_TWO_PORT_BIDIRECTIONAL;
                this.transponderModes[n2] = this.transponderModes[n];
                this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_TWO_PORT_BIDIRECTIONAL;
                break;
            }
            case 2: {
                if (this.transponderPorts[n].getIntValue() == 0) {
                    this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 0);
                    string = "- The transponder port is set to none.";
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
                } else if (this.lineAdminInfo_4_01[n].transpondingInterface == this.lineModels[n].getIndex()) {
                    string = "- The transponder port is set to this interface.";
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL;
                    this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 1);
                } else {
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY;
                    this.transponderModes[n2] = this.getAttributeFor("G1000 Transponder Mode", 3);
                    this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY;
                }
                this.copperCheck(n);
                break;
            }
            case 3: {
                if (this.transponderPorts[n].getIntValue() == 0) {
                    this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 0);
                    string = "- The transponder port is set to none.";
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
                } else if (this.lineAdminInfo_4_01[n].transpondingInterface == this.lineModels[n].getIndex()) {
                    string = "- The transponder port is set to this interface.";
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL;
                    this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 1);
                } else {
                    this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY;
                    this.transponderModes[n2] = this.getAttributeFor("G1000 Transponder Mode", 2);
                    this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY;
                }
                this.copperCheck(n);
            }
        }
        if (HdGeTxpMode.eTransponderModeToHdGeTxpMode(this.lineAdminInfo_4_01[n].mode) != attribute.getIntValue()) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_G1000_TXP_MODE_CANNOT_BE_PROVISIONED, string);
        }
        if (this.lineAdminInfo_4_01[n].transpondingInterface != this.lineModels[n].getIndex()) {
            this.transponderPorts[n2] = this.getAttributeFor("G1000 Transponder Port", n + 1);
            this.fireTableCellUpdated(n2, 11);
            this.fireTableCellUpdated(n2, 12);
        }
    }

    private void setTransponderPort(int n, Attribute attribute) {
        this.transponderPorts[n] = attribute;
        int n2 = attribute.getIntValue() - 1;
        if (n2 == -1) {
            this.lineAdminInfo_4_01[n].transpondingInterface = this.lineModels[n].getIndex();
            this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
            this.transponderModes[n] = this.getAttributeFor("G1000 Transponder Mode", 0);
            this.fireTableCellUpdated(n, 12);
        } else if (n2 == n) {
            this.lineAdminInfo_4_01[n].transpondingInterface = this.lineModels[n].getIndex();
            this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL;
            this.transponderModes[n2] = this.getAttributeFor("G1000 Transponder Mode", 1);
            this.fireTableCellUpdated(n2, 12);
        } else {
            this.lineAdminInfo_4_01[n].transpondingInterface = this.baseIndex + n2;
            this.lineAdminInfo_4_01[n2].transpondingInterface = this.baseIndex + n;
            this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
            this.lineAdminInfo_4_01[n2].mode = eTransponderMode.TRANSPONDER_NONE;
            this.transponderPorts[n2] = this.getAttributeFor("G1000 Transponder Port", n + 1);
            this.fireTableCellUpdated(n2, 11);
            this.setTransponderMode(n, this.getAttributeFor("G1000 Transponder Mode", 1));
            this.fireTableCellUpdated(n, 12);
            this.fireTableCellUpdated(n2, 12);
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            int n = this.getColumnCount();
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][2];
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void destroy() {
        int n;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.isDirty = null;
        for (n = 0; n < this.portNames.length; ++n) {
            this.portNames[n] = null;
            this.adminState[n] = null;
            this.serviceState[n] = null;
        }
        for (n = 0; n < this.lineAdminInfo.length; ++n) {
            this.lineAdminInfo[n] = null;
            this.lineAdminInfo_4_01[n] = null;
        }
        this.lineAdminInfo = null;
        for (n = 0; n < this.lineInfo.length; ++n) {
            this.lineInfo[n] = null;
        }
        this.lineInfo = null;
    }

    public Vector applyToModel() throws Exception {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.numLines; ++i) {
            if (this.validateChanges(i)) continue;
            vector.add(new Integer(i));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.numLines; ++i) {
            sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_012;
            if (this.isDirty[i][1]) {
                this.lineModels[i].setAlias(this.getPortName(i));
            }
            if (this.isDirty[i][2]) {
                this.lineModels[i].setAdminStateNoLpbk(this.getAdminStateAsEnum(i));
            }
            if (this.isDirty[i][4]) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.getSoakTime(i));
                }
                this.lineModels[i].setSoakTime(this.getSoakTime(i));
            }
            if (!this.liCheck[i] && this.liTimer[i] == 0) {
                throw new ProvisionError(EMC.EID_WRONG_INPUT, null);
            }
            boolean bl = false;
            if (this.isDirty[i][17]) {
                sGmacLineAdminInfo_4_012 = this.getLineAdminInfo_4_01(i);
                sGmacLineAdminInfo_4_012.liTimer = this.liTimer[i];
                this.lineModels[i].setGmacLineAdminInfo_4_01(sGmacLineAdminInfo_4_012);
                bl = true;
            }
            if (this.isDirty[i][16] && !bl) {
                sGmacLineAdminInfo_4_012 = this.getLineAdminInfo_4_01(i);
                sGmacLineAdminInfo_4_012.liTimer = this.liTimer[i];
                this.lineModels[i].setGmacLineAdminInfo_4_01(sGmacLineAdminInfo_4_012);
            }
            if (!vector.contains(new Integer(i))) {
                if (this.isDirty[i][7] || this.isDirty[i][9]) {
                    this.lineModels[i].setGmacLineAdminInfo(this.getLineAdminInfo(i));
                }
                if (this.isDirty[i][6]) {
                    this.lineModels[i].setGmacLineAdminInfo_4_01(this.getLineAdminInfo_4_01(i));
                }
                if (this.isDirty[i][10]) {
                    this.lineModels[i].setGmacLineAdminInfo_4_01(this.getLineAdminInfo_4_01(i));
                }
                if (this.isDirty[i][12] || this.isDirty[i][11] || this.isDirty[i][14] || this.isDirty[i][15]) {
                    arrayList.add(new Integer(i));
                }
            }
            if (!this.isDirty[i][13] || this.waterMarks[i].getIntValue() != 2) continue;
            short s = this.getFlowControlLowWaterMark(i);
            n = this.getFlowControlHighWaterMark(i).shortValue();
            if (s == 25 && n == 485) {
                ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_CUSTOM_WATER_MARKS, (Object)"Default");
                this.refreshLineFromModel(i);
                continue;
            }
            if (s != 5 || n != 10) continue;
            ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_CUSTOM_WATER_MARKS, (Object)"Low Latency");
            this.refreshLineFromModel(i);
        }
        if (!arrayList.isEmpty()) {
            HashMap<Integer, sGmacLineAdminInfo_4_01> hashMap = new HashMap<Integer, sGmacLineAdminInfo_4_01>();
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                hashMap.put(new Integer(n2), new sGmacLineAdminInfo_4_01(this.lineAdminInfo_4_01[n2].maxFrame, this.lineAdminInfo_4_01[n2].negotiate, this.lineAdminInfo_4_01[n2].loopback, this.lineAdminInfo_4_01[n2].mode, this.lineAdminInfo_4_01[n2].transpondingInterface, this.lineAdminInfo_4_01[n2].flowControlLowWatermark, this.lineAdminInfo_4_01[n2].flowControlHighWatermark, this.lineAdminInfo_4_01[n2].bufferSize, this.lineAdminInfo_4_01[n2].flowControl, this.lineAdminInfo_4_01[n2].fcsType, this.lineAdminInfo_4_01[n2].liTimer));
                n = this.lineAdminInfo_4_01[n2].transpondingInterface - this.baseIndex;
                if (n == n2 || this.lineAdminInfo_4_01[n2].mode == eTransponderMode.TRANSPONDER_NONE) continue;
                this.lineAdminInfo_4_01[n].mode = eTransponderMode.TRANSPONDER_NONE;
                this.lineModels[n].setGmacLineAdminInfo_4_01(this.lineAdminInfo_4_01[n]);
            }
            for (Integer n3 : hashMap.keySet()) {
                this.lineModels[n3].setGmacLineAdminInfo_4_01((sGmacLineAdminInfo_4_01)hashMap.get(n3));
                Integer n4 = new Integer(n3 + 1);
                Integer n5 = new Integer(this.lineAdminInfo_4_01[n3.intValue()].transpondingInterface - this.baseIndex + 1);
                this.transponders.remove(this.transponders.get(n4));
                this.transponders.remove(this.transponders.get(n5));
                if (this.lineAdminInfo_4_01[n3.intValue()].mode == eTransponderMode.TRANSPONDER_NONE) continue;
                this.transponders.put(n4, n5);
                this.transponders.put(n5, n4);
            }
        }
        this.resetDirty();
        return vector;
    }

    private boolean validateChanges(int n) throws Exception {
        return this.getAdminStateFromModel(n) != eAdminState.ADMIN_IS || !this.isDirty[n][7] && !this.isDirty[n][9] && !this.isDirty[n][6] && !this.isDirty[n][10] && !this.isDirty[n][12] && !this.isDirty[n][11] && !this.isDirty[n][14] && !this.isDirty[n][15];
    }

    public boolean isTransponderValid() {
        boolean bl = false;
        for (int i = 0; i < this.numLines && !bl; ++i) {
            bl = this.getLineAdminInfo_4_01((int)i).mode != eTransponderMode.TRANSPONDER_NONE;
        }
        return !bl || !this.isCircuitPresent();
    }

    private boolean isCircuitPresent() {
        boolean bl = false;
        for (int i = 0; i < this.numLines && !bl; ++i) {
            bl = !this.lineModels[i].getConnectionsList().isEmpty();
        }
        return bl;
    }

    public boolean isWaterMarkValid() {
        boolean bl = true;
        for (int i = 0; i < this.numLines && bl; ++i) {
            bl = this.lineAdminInfo_4_01[i].flowControlLowWatermark < this.lineAdminInfo_4_01[i].flowControlHighWatermark;
        }
        return bl;
    }

    public boolean isAutonegotiationValid() {
        boolean bl = true;
        for (int i = 0; i < this.numLines && bl; ++i) {
            if (this.lineAdminInfo_4_01[i].mode != eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY && this.lineAdminInfo_4_01[i].mode != eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY) continue;
            bl = !this.lineAdminInfo_4_01[i].negotiate;
        }
        return bl;
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        block3: {
            this.lineInfo[n] = null;
            this.lineAdminInfo[n] = null;
            this.portNames[n] = null;
            this.adminState[n] = null;
            this.serviceState[n] = null;
            this.transponderModes[n] = null;
            this.transponderPorts[n] = null;
            this.waterMarks[n] = null;
            this.soakTime[n] = -1;
            try {
                this.liTimer[n] = this.lineModels[n].getGmacLineAdminInfo_4_01().liTimer;
                this.liCheck[n] = this.liTimer[n] == 0;
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.lineAdminInfo_4_01[n] = null;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    private int getTransponderModeFromModel(int n) {
        int n2 = 0;
        switch (this.getLineAdminInfo_4_01((int)n).mode.value()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: 
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        return n2;
    }

    private void copperCheck(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMediaTypeFor(n).getKey().equals("CX")) {
            if (this.getLineAdminInfo_4_01((int)n).mode == eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY || this.getLineAdminInfo_4_01((int)n).mode == eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY) {
                stringBuffer.append("Some copper GBICs might not work in unidirectional mode.\n");
            }
            if (!this.getLineAdminInfo_4_01((int)n).negotiate) {
                stringBuffer.append("Some copper GBICs might need flow control negotiation enabled.\nHowever, PAUSE flow control will not work even after negotiation is complete.");
            }
        }
        if (stringBuffer.length() > 0) {
            IgnorableDialog.warningDialog((String)stringBuffer.toString(), (String)"G1000 copper GBIC", (String)"Warning dialog that tells user about possible limitations of the copper GBIC.");
        }
    }

    private void copperCheck(Map map) {
        if (db.on()) {
            db.println("In copper check");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        for (Integer n : map.keySet()) {
            if (map.get(n) != eGigEtherOptics.O_1000_BASE_CX) continue;
            if (db.on()) {
                db.println("found a copper gbic on port " + n);
            }
            if (!this.getLineAdminInfo_4_01((int)n.intValue()).negotiate) {
                bl = false;
            }
            if (this.getLineAdminInfo_4_01((int)n.intValue()).mode != eTransponderMode.TRANSPONDER_TWO_PORT_RX_ONLY && this.getLineAdminInfo_4_01((int)n.intValue()).mode != eTransponderMode.TRANSPONDER_TWO_PORT_TX_ONLY) continue;
            bl2 = true;
            if (!db.on()) continue;
            db.println("uni mode true");
        }
        if (bl2) {
            stringBuffer.append("Some copper GBICs might not work in unidirectional mode.\n");
        }
        if (!bl) {
            stringBuffer.append("Some copper GBICs might need flow control negotiation enabled.\nHowever, PAUSE flow control will not work even after negotiation is complete.");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("Check the transponder settings in the provisioning tab.\n");
            IgnorableDialog.warningDialog((String)stringBuffer.toString(), (String)"HellCat copper GBIC", (String)"Warning dialog that tells user about possible limitations of the copper GBIC.");
        }
    }

    private int getTransponderPortFromModel(int n) {
        if (this.getTransponderModeFromModel(n) == 0) {
            return 0;
        }
        return this.getLineAdminInfo_4_01((int)n).transpondingInterface - this.baseIndex + 1;
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    private class GBICCopperChangeObserver
    implements Observer {
        Map currentGBICs;

        GBICCopperChangeObserver(HdGeModuleModel.GBICChangeNotifier gBICChangeNotifier) {
            gBICChangeNotifier.addObserver(this);
            this.currentGBICs = gBICChangeNotifier.getCurrentGBICs();
        }

        Map getCurrentGBICs() {
            return new HashMap(this.currentGBICs);
        }

        public void update(Observable observable, Object object) {
            if (db.on()) {
                db.println("CopperObserver received an update");
            }
            if (observable instanceof HdGeModuleModel.GBICChangeNotifier) {
                Map map = (Map)object;
                if (map.containsValue(eGigEtherOptics.O_1000_BASE_CX)) {
                    Iterator iterator = map.keySet().iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        if (map.get(n) != eGigEtherOptics.O_1000_BASE_CX || this.currentGBICs.get(n) == eGigEtherOptics.O_1000_BASE_CX) continue;
                        bl = true;
                        HdGePortTableModel.this.refreshLineFromModel(n);
                    }
                    if (bl) {
                        HdGePortTableModel.this.copperCheck(map);
                        if (db.on()) {
                            db.println("New copper port found.");
                        }
                    }
                }
                this.currentGBICs = map;
            }
        }
    }
}

